/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.gui.util.Resources;
import de.cni.common.core.LicenseHandler;

public enum Horoskop {
    Radix("Radix", Resources.ICON.RADIX, true, true, 1, false, "Radix:\nDarstellung: Eine Person\nParameter: Geburtsdatum, Geburtsort", LicenseHandler.LicenseType.ORO),
    Solar("Solar", Resources.ICON.SOLAR, false, true, 1, false, "Solar:\nDarstellung: Ein Horoskop\nParameter: Solardatum, Wohnort\n\nSolardatum:  Datum/Uhrzeit in einem anderen Jahr (Vorgabe: aktuelles Jahr),\nan dem die Sonne am Geburtsort den gleichen Stand wie zum Geburtszeitpunkt hat"),
    Septar("Septar", Resources.ICON.SEPTAR, false, true, 1, false, "Septar:\nDarstellung: Ein Horoskop\nParameter: Septardatum, Geburtsort\n\nDas Septardatum berechnet sich wie folgt:\n{Differenz} = {aktuelles Jahr} \u0096 {Geburtsjahr}\n{Berechnungsjahr}  = 12 - {Differenz} / 7 (Beginnend bei Haus 12 und dann R\u00fcckw\u00e4rts)\nDas {Berechnungsjahr}  wird zum Geburtsjahr hinzugez\u00e4hlt und daraus das Solardatum errechnet.\nDieser Zeitpunkt ist in der Berechnung das {Septardatum}, f\u00fcr dessen Zeitpunkt das Horoskop berechnet wird.\n"),
    Komposit("Komposit", Resources.ICON.KOMPOSIT, false, false, 1, false, "Komposit:\nDarstellung: Mittelwert von zwei Personen\nParameter Person1: Geburtsdatum, Geburtsort\nParameter Person2: Geburtsdatum, Geburtsort"),
    Temposit("Temposit", Resources.ICON.TEMPOSIT, false, true, 1, false, "Temposit:\nDarstellung: Mittelwert von Geburts- und aktuellen Daten einer Personen\nParameter1: Geburtsdatum, Geburtsort\nParameter2: Solardatum, Wohnort\n\nSolardatum:  Datum/Uhrzeit in einem anderen Jahr (Vorgabe: aktuelles Jahr),\nan dem die Sonne am Geburtsort den gleichen Stand wie zum Geburtszeitpunkt hat"),
    Septosit("Septosit", Resources.ICON.SEPTOSIT, false, true, 1, false, "Septosit:\nDarstellung: Mittelwert von Geburts- und aktuellen Daten einer Personen\nParameter1: Geburtsdatum, Geburtsort\nParameter2: Septardatum, Geburtsort\nDas Septardatum berechnet sich wie folgt:\n{Differenz} = {aktuelles Jahr} \u0096 {Geburtsjahr}\n{Berechnungsjahr}  = 12 - {Differenz} / 7 (Beginnend bei Haus 12 und dann R\u00fcckw\u00e4rts)\nDas {Berechnungsjahr}  wird zum Geburtsjahr hinzugez\u00e4hlt und daraus das Solardatum errechnet.\nDieser Zeitpunkt ist in der Berechnung das {Septardatum}, f\u00fcr dessen Zeitpunkt das Horoskop berechnet wird.\n"),
    Transit("Transit", Resources.ICON.TRANSIT, true, true, 2, false, "Transit:\nDarstellung: Gegen\u00fcberstellung von Geburts- und aktuellen Daten einer Person\nParameter 1: Geburtsdatum, Geburtsort\nParameter 2: aktuelles Datum, Wohnort"),
    Synastrie("Synastrie", Resources.ICON.SYNASTRIE, true, true, 2, true, "Synastrie:\nDarstellung: Gegen\u00fcberstellung von 2 Personen\nPerson 1: Geburtsdatum, Geburtsort\nPerson 2: Geburtsdatum, Geburtsort"),
    Aktualitaet("Aktualit\u00e4t", Resources.ICON.AKTUALITAET, true, true, 1, false, "Aktualit\u00e4t:\nRadix:\nDarstellung: Eine Person\nParameter: aktuelles Datum, aktueller Ort"),
    KompositSeptar("KompositSeptar", Resources.ICON.KOMPOSITSEPTAR, false, false, 1, false, "KompositSeptar:\nDarstellung: Mittelwert von zwei Personen\nParameter Person1: Geburtsdatum, Geburtsort\nParameter Person2: Geburtsdatum, Geburtsort\nParameter: Haus\nWenn kein Haus angegeben wird, erfolgt die Berechung jeweils f\u00fcr den aktuellen Lebensabschnitts, ansonsten werden beide Sepatare f\u00fcr das vorgebenen Haus berechnet."),
    MultiKomposit("MultiKomposit", Resources.ICON.MULTIKOMPOSIT, false, false, 1, false, "MultiKomposit:\nDarstellung: Mittelwert von mehreren Personen\nParameter:  Name der Gruppe"),
    KompositTransit("KompositTransit", Resources.ICON.KOMPOTRANSIT, true, true, 2, true, "KompositTransit:\nDarstellung: Mittelwert von zwei Kompositen\nKomposit1: Geburtsdatum, Geburtsort der Personen\nKomposit2: aktuelles Datum, aktueller Wohnort der Personen", LicenseHandler.LicenseType.ORO);

    public String name;
    public Resources.ICON icon;
    public boolean dayChangeAllowed;
    public boolean yearChangeAllowed;
    public int planetenSaetze;
    public boolean zweiterAcMc;
    public String toolTip;
    public LicenseHandler.LicenseType minLicenseType;

    private Horoskop(String name, Resources.ICON icon, boolean dayChangeAllowed, boolean yearChangeAllowed, int planetenSaetze, boolean zweiterAcMc, String toolTip) {
        this.name = name;
        this.icon = icon;
        this.dayChangeAllowed = dayChangeAllowed;
        this.yearChangeAllowed = yearChangeAllowed;
        this.planetenSaetze = planetenSaetze;
        this.zweiterAcMc = zweiterAcMc;
        this.toolTip = toolTip;
    }

    private Horoskop(String name, Resources.ICON icon, boolean dayChangeAllowed, boolean yearChangeAllowed, int planetenSaetze, boolean zweiterAcMc, String toolTip, LicenseHandler.LicenseType minLicenseType) {
        this.name = name;
        this.icon = icon;
        this.dayChangeAllowed = dayChangeAllowed;
        this.yearChangeAllowed = yearChangeAllowed;
        this.planetenSaetze = planetenSaetze;
        this.zweiterAcMc = zweiterAcMc;
        this.toolTip = toolTip;
        this.minLicenseType = minLicenseType;
    }

    public static Horoskop fromString(String str) throws IllegalArgumentException {
        try {
            return Horoskop.valueOf(str);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Ung\u00fcltiger Enum-Wert: " + str);
        }
    }

    public static String[] getAllNames() {
        String[] names = new String[Horoskop.values().length];
        int i = 0;
        for (Horoskop h : Horoskop.values()) {
            names[i++] = h.getName();
        }
        return names;
    }

    public String getName() {
        return this.name;
    }

    public Resources.ICON getIcon() {
        return this.icon;
    }

    public boolean isTransit() {
        return this.getPlanetenSaetze() > 1;
    }

    public String getTransitSign() {
        return this.isTransit() ? " (t)" : "";
    }

    public boolean isDayChangeAllowed() {
        if (this.minLicenseType == null || LicenseHandler.getInstance().isAllowed(this.minLicenseType)) {
            return this.dayChangeAllowed;
        }
        return false;
    }

    public boolean isYearChangeAllowed() {
        if (this.minLicenseType == null || LicenseHandler.getInstance().isAllowed(this.minLicenseType)) {
            return this.yearChangeAllowed;
        }
        return false;
    }

    public int getPlanetenSaetze() {
        return this.planetenSaetze;
    }

    public boolean isZweiterAcMc() {
        return this.zweiterAcMc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(Resources.ICON icon) {
        this.icon = icon;
    }

    public void setDayChangeAllowed(boolean dayChangeAllowed) {
        this.dayChangeAllowed = dayChangeAllowed;
    }

    public void setYearChangeAllowed(boolean yearChangeAllowed) {
        this.yearChangeAllowed = yearChangeAllowed;
    }

    public void setPlanetenSaetze(int planetenSaetze) {
        this.planetenSaetze = planetenSaetze;
    }

    public void setZweiterAcMc(boolean zweiterAcMc) {
        this.zweiterAcMc = zweiterAcMc;
    }
}

