/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.gui.popup.filter.ExchangeParameter;
import de.cni.client.paint.Controlpanel;
import de.cni.common.astrologie.AspektTyp;
import de.cni.common.calculation.BaseCalculator;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.OrbisCache;
import de.cni.common.core.DateUtil;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import java.util.Date;

public class NextPlanetMatch {
    BaseCalculator baseCalculator = new BaseCalculator();
    HoroskopCalculator horoskopCalculator;
    Controlpanel controlpanel;
    Horoskop horoskop;
    OrbisCache myOrbisCache;
    public static final int anzPlaneten = 10;
    public static final int size = 14;
    public static int ID_AC = 10;
    public static int ID_DC = 11;
    public static int ID_MC = 12;
    public static int ID_IC = 13;
    public int counter = 0;
    Date lastDate = null;
    AspektTyp lastAspekt = null;
    int lastPlanet1 = -1;
    int lastPlanet2 = -1;
    Date minDate = null;
    Date maxDate = null;
    double minDiff = 360.0;
    double delta = 0.1;
    int schrittgroesseInitial = 1000;
    int schrittgroessenRedukionsfaktor = 10;
    int relativeIntervallbreite = 5;
    int offsetNachFehlversuch = 10;

    public NextPlanetMatch(HoroskopCalculator horoskopCalculator) {
        this.horoskopCalculator = horoskopCalculator;
    }

    public RetVal calculateNextMatch(Date ausgangsdatum, AspektTyp aspektTyp, int planet1, int planet2) {
        RetVal nextRetVal = new RetVal();
        if (planet2 == 5) {
            this.schrittgroesseInitial = 2000;
            this.schrittgroessenRedukionsfaktor = 2;
            this.relativeIntervallbreite = 5;
            this.offsetNachFehlversuch = 10;
        } else if (planet2 == 6) {
            this.schrittgroesseInitial = 2000;
            this.schrittgroessenRedukionsfaktor = 100;
            this.relativeIntervallbreite = 10;
            this.offsetNachFehlversuch = 5;
        } else if (planet2 != 7 && planet2 != 8 && planet2 == 9) {
            this.schrittgroesseInitial = 1000;
            this.schrittgroessenRedukionsfaktor = 10;
            this.relativeIntervallbreite = 5;
            this.offsetNachFehlversuch = 10;
        }
        if (aspektTyp != null) {
            return this.calculateNextMatchWorker(ausgangsdatum, aspektTyp, planet1, planet2);
        }
        for (AspektTyp typ : AspektTyp.getAll()) {
            RetVal retVal = this.calculateNextMatchWorker(ausgangsdatum, typ, planet1, planet2);
            if (Util.compare(retVal.date, nextRetVal.date) >= 0) continue;
            nextRetVal = retVal;
        }
        return nextRetVal;
    }

    public RetVal calculateNextMatchWorker(Date ausgangsdatum, AspektTyp aspektTyp, int planet1, int planet2) {
        RetVal retVal = new RetVal();
        long startTime = new Date().getTime();
        int fehlversuche = 0;
        Date date = ausgangsdatum;
        do {
            this.minDate = date;
            double grad1 = 0.0;
            double grad2 = 0.0;
            double diff = 0.0;
            int schrittgroesse = NextPlanetMatch.getUmlaufzeitInStunden(planet2) / this.schrittgroesseInitial;
            double winkelbeziehung = aspektTyp.winkelbeziehung;
            if (winkelbeziehung == 0.0) {
                winkelbeziehung = 360.0;
            }
            double limit = (double)NextPlanetMatch.getUmlaufzeitInStunden(planet2) * winkelbeziehung / 360.0;
            int stundenOffset = 0;
            int iCnt = 1;
            this.minDiff = 360.0;
            this.horoskopCalculator.setNewDate(date);
            date = this.minDate;
            while (schrittgroesse > 0) {
                ++iCnt;
                stundenOffset = 0;
                this.horoskopCalculator.setNewDate(date);
                while (this.minDiff > this.delta && (double)stundenOffset < limit) {
                    stundenOffset += schrittgroesse;
                    date = DateUtil.dateAddHours(date, schrittgroesse);
                    this.horoskopCalculator.setNewDate(date);
                    grad1 = this.horoskopCalculator.getAstrodaten1().getPlanetAbs(planet1);
                    diff = Math.abs(Math.abs(Trigo.alphaDiff(grad1, grad2 = this.horoskopCalculator.getHoroskop().getPlanetenSaetze() == 1 ? Trigo.grad(this.horoskopCalculator.getAstrodaten1().getPlanetAbs(planet2)) : Trigo.grad(this.horoskopCalculator.getAstrodaten2().getPlanetAbs(planet2) + this.horoskopCalculator.getOffsetSatz2()))) - aspektTyp.winkelbeziehung);
                    if (!(this.minDiff > diff)) continue;
                    this.minDiff = diff;
                    this.minDate = date;
                }
                int intervallbreite = this.relativeIntervallbreite * schrittgroesse;
                date = DateUtil.dateAddHours(this.minDate, -intervallbreite);
                if (Util.compare(date, ausgangsdatum) < 0) {
                    date = ausgangsdatum;
                }
                limit = 2 * intervallbreite;
                schrittgroesse /= this.schrittgroessenRedukionsfaktor;
            }
            if (!(this.minDiff > this.delta)) continue;
            ++fehlversuche;
            int offset = NextPlanetMatch.getUmlaufzeitInTage(planet2) * this.offsetNachFehlversuch / 360;
            date = DateUtil.dateAddDays(date, offset);
        } while (this.minDiff > this.delta && fehlversuche < 50);
        retVal.date = this.minDate;
        retVal.aspektTyp = aspektTyp;
        long endTime = new Date().getTime();
        return retVal;
    }

    public static int getUmlaufzeitInStunden(int planet) {
        return NextPlanetMatch.getUmlaufzeitInJahren(planet) * 365 * 24;
    }

    public static int getUmlaufzeitInTage(int planet) {
        return NextPlanetMatch.getUmlaufzeitInJahren(planet) * 365;
    }

    public static int getUmlaufzeitInJahren(int planet) {
        switch (planet) {
            case 5: {
                return 12;
            }
            case 6: {
                return 29;
            }
            case 7: {
                return 84;
            }
            case 8: {
                return 165;
            }
            case 9: {
                return 248;
            }
        }
        return 0;
    }

    public void gotoNextPosition(ExchangeParameter exchangeParameter) {
        if (exchangeParameter.aspektTyp == GlobalData.getInstance().getPlanetenzyklus_aspektTyp() && exchangeParameter.planet1 == GlobalData.getInstance().getPlanetenzyklus_planet1() && exchangeParameter.planet2 == GlobalData.getInstance().getPlanetenzyklus_planet2() && Util.equals(exchangeParameter.date, GlobalData.getInstance().getPlanetenzyklus_date())) {
            int schrittgroesse = NextPlanetMatch.getUmlaufzeitInJahren(exchangeParameter.planet2) * 10 / 360;
            exchangeParameter.date = DateUtil.dateAddYears(exchangeParameter.date, schrittgroesse);
        }
        this.lastDate = exchangeParameter.date;
        RetVal retVal = null;
        NextPlanetMatch npm = new NextPlanetMatch(this.horoskopCalculator);
        retVal = npm.calculateNextMatch(exchangeParameter.date, exchangeParameter.aspektTyp, exchangeParameter.planet1, exchangeParameter.planet2);
        GlobalData.getInstance().setPlanetenzyklus_planet1(exchangeParameter.planet1);
        GlobalData.getInstance().setPlanetenzyklus_planet2(exchangeParameter.planet2);
        GlobalData.getInstance().setPlanetenzyklus_aspektTyp(exchangeParameter.aspektTyp);
        GlobalData.getInstance().setPlanetenzyklus_date(retVal.date);
        this.lastDate = retVal.date;
        this.lastAspekt = retVal.aspektTyp;
        this.lastPlanet1 = exchangeParameter.planet1;
        this.lastPlanet2 = exchangeParameter.planet1;
        this.horoskopCalculator.setNewDate(retVal.date);
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public AspektTyp getLastAspekt() {
        return this.lastAspekt;
    }

    public class RetVal {
        public Date date;
        public AspektTyp aspektTyp;
    }
}

