/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.calculation.Horoskop;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;

public class OrbisCache {
    public static final int anzHoroskope = Horoskop.values().length;
    public static final int anzAspekte = Constants.aspekt.length;
    public static final int anzPlaneten = Constants.planeten.length;
    private int[][][] orbisArray = new int[anzHoroskope][anzAspekte][anzPlaneten];

    public OrbisCache() {
    }

    public OrbisCache(String dbString) {
        this.string2object(dbString);
    }

    public int getValue(int horoskopId, int aspektId, int planetId) {
        return this.orbisArray[horoskopId][aspektId][planetId];
    }

    public void setValue(int horoskopId, int aspektId, int planetId, int value) {
        this.orbisArray[horoskopId][aspektId][planetId] = value;
    }

    public String object2string() {
        StringBuilder sb = new StringBuilder();
        for (int horoskopId = 0; horoskopId < anzHoroskope; ++horoskopId) {
            for (int aspektId = 0; aspektId < anzAspekte; ++aspektId) {
                for (int planetId = 0; planetId < anzPlaneten; ++planetId) {
                    sb.append(this.orbisArray[horoskopId][aspektId][planetId]);
                    sb.append(":");
                }
            }
        }
        return sb.toString();
    }

    public void string2object(String s) {
        String[] stringArray = s.split(":");
        int index = 0;
        for (int horoskopId = 0; horoskopId < anzHoroskope; ++horoskopId) {
            for (int aspektId = 0; aspektId < anzAspekte; ++aspektId) {
                for (int planetId = 0; planetId < anzPlaneten; ++planetId) {
                    this.orbisArray[horoskopId][aspektId][planetId] = stringArray != null && stringArray.length > index ? Converter.stringToInt(stringArray[index++]) : 0;
                }
            }
        }
    }

    public void copyOrben(Horoskop quelle, Horoskop ziel) {
        for (int aspektId = 0; aspektId < anzAspekte; ++aspektId) {
            for (int planetId = 0; planetId < anzPlaneten; ++planetId) {
                int value = this.getValue(quelle.ordinal(), aspektId, planetId);
                this.setValue(ziel.ordinal(), aspektId, planetId, value);
            }
        }
    }

    public void copyOrben(Horoskop quelleHoroskop, OrbisCache orbisQuelle, Horoskop zielHoroskop) {
        for (int aspektId = 0; aspektId < anzAspekte; ++aspektId) {
            for (int planetId = 0; planetId < anzPlaneten; ++planetId) {
                int value = orbisQuelle.getValue(quelleHoroskop.ordinal(), aspektId, planetId);
                this.setValue(zielHoroskop.ordinal(), aspektId, planetId, value);
            }
        }
    }

    public void replace(Horoskop quelle, int von, int nach) {
        for (int aspektId = 0; aspektId < anzAspekte; ++aspektId) {
            for (int planetId = 0; planetId < anzPlaneten; ++planetId) {
                int value = this.getValue(quelle.ordinal(), aspektId, planetId);
                if (value != von && von >= 0) continue;
                this.setValue(quelle.ordinal(), aspektId, planetId, nach);
            }
        }
    }

    public void add(Horoskop quelle, int offset) {
        for (int aspektId = 0; aspektId < anzAspekte; ++aspektId) {
            for (int planetId = 0; planetId < anzPlaneten; ++planetId) {
                int value = this.getValue(quelle.ordinal(), aspektId, planetId) + offset;
                if (value > 9) {
                    value = 9;
                }
                if (value < 0) {
                    value = 0;
                }
                this.setValue(quelle.ordinal(), aspektId, planetId, value);
            }
        }
    }
}

