/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.astrologie.AspektTyp;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.OrbisCache;
import de.cni.common.core.Util;

public class OrbisPresettings {
    public static OrbisCache getGeneratedDefaultOrben() {
        return OrbisPresettings.getGeneratedDefaultOrben(null);
    }

    public static OrbisCache getGeneratedDefaultOrben(Horoskop h) {
        OrbisCache o = new OrbisCache();
        OrbisPresettings.setOrben(o, h);
        return o;
    }

    public static OrbisCache getGeneratedDefaultInterOrben() {
        return OrbisPresettings.getGeneratedDefaultInterOrben(null);
    }

    public static OrbisCache getGeneratedDefaultInterOrben(Horoskop h) {
        OrbisCache o = new OrbisCache();
        OrbisPresettings.setInterOrben(o, h);
        return o;
    }

    public static void setOrben(OrbisCache orbisCache) {
        OrbisPresettings.setOrben(orbisCache, null);
    }

    public static void setOrben(OrbisCache orbisCache, Horoskop h) {
        for (int horoskopId = 0; horoskopId < OrbisCache.anzHoroskope; ++horoskopId) {
            for (int aspektId = 0; aspektId < OrbisCache.anzAspekte; ++aspektId) {
                for (int planetId = 0; planetId < OrbisCache.anzPlaneten; ++planetId) {
                    if (h != null && horoskopId != h.ordinal()) continue;
                    OrbisPresettings.setValue(horoskopId, aspektId, planetId, orbisCache);
                }
            }
        }
    }

    public static String generateTestOrben(OrbisCache orbisCache, Horoskop h, int value) {
        for (int horoskopId = 0; horoskopId < OrbisCache.anzHoroskope; ++horoskopId) {
            for (int aspektId = 0; aspektId < OrbisCache.anzAspekte; ++aspektId) {
                for (int planetId = 0; planetId < OrbisCache.anzPlaneten; ++planetId) {
                    if (h != null && horoskopId != h.ordinal()) continue;
                    orbisCache.setValue(horoskopId, aspektId, planetId, value);
                }
            }
        }
        return orbisCache.object2string();
    }

    public static void setInterOrben(OrbisCache orbisCache) {
        OrbisPresettings.setInterOrben(orbisCache, null);
    }

    public static void setInterOrben(OrbisCache orbisCache, Horoskop h) {
        for (int horoskopId = 0; horoskopId < OrbisCache.anzHoroskope; ++horoskopId) {
            for (int aspektId = 0; aspektId < OrbisCache.anzAspekte; ++aspektId) {
                for (int planetId = 0; planetId < OrbisCache.anzPlaneten; ++planetId) {
                    if (h != null && horoskopId != h.ordinal()) continue;
                    OrbisPresettings.setInterValue(horoskopId, aspektId, planetId, orbisCache);
                }
            }
        }
    }

    private static void setValue(int horoskopId, int aspektId, int planetId, OrbisCache orbisCache) {
        if (Util.equals(horoskopId, new int[]{Horoskop.Radix.ordinal(), Horoskop.Solar.ordinal(), Horoskop.Septar.ordinal(), Horoskop.Komposit.ordinal(), Horoskop.Temposit.ordinal(), Horoskop.Septosit.ordinal(), Horoskop.KompositTransit.ordinal(), Horoskop.KompositSeptar.ordinal(), Horoskop.MultiKomposit.ordinal()})) {
            if (aspektId == AspektTyp.konjunktion.ordinal()) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 6);
            } else if (aspektId == AspektTyp.sextil.ordinal()) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 5);
            } else if (aspektId == AspektTyp.quadrat.ordinal()) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 7);
            } else if (aspektId == AspektTyp.trigon.ordinal()) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 6);
            } else if (aspektId == AspektTyp.opposition.ordinal()) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 6);
            } else {
                orbisCache.setValue(horoskopId, aspektId, planetId, 0);
            }
        }
        if (Util.equals(horoskopId, new int[]{Horoskop.Synastrie.ordinal(), Horoskop.Transit.ordinal(), Horoskop.Aktualitaet.ordinal()})) {
            if (aspektId == AspektTyp.konjunktion.ordinal()) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 6);
            } else if (aspektId == AspektTyp.sextil.ordinal()) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 5);
            } else if (aspektId == AspektTyp.quadrat.ordinal()) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 7);
            } else if (aspektId == AspektTyp.trigon.ordinal()) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 6);
            } else if (aspektId == AspektTyp.opposition.ordinal()) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 6);
            } else {
                orbisCache.setValue(horoskopId, aspektId, planetId, 0);
            }
        }
    }

    private static void setInterValue(int horoskopId, int aspektId, int planetId, OrbisCache orbisCache) {
        if (Util.equals(horoskopId, new int[]{Horoskop.Synastrie.ordinal()})) {
            orbisCache.setValue(horoskopId, aspektId, planetId, 5);
        }
        if (Util.equals(horoskopId, new int[]{Horoskop.Transit.ordinal()})) {
            orbisCache.setValue(horoskopId, aspektId, planetId, 3);
        }
        if (Util.equals(horoskopId, new int[]{Horoskop.KompositTransit.ordinal()})) {
            orbisCache.setValue(horoskopId, aspektId, planetId, 3);
        }
    }
}

