/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.astrologie.AspektTyp;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.core.DateUtil;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanetReturn {
    private static Log log = LogFactory.getLog(PlanetReturn.class);

    public Date nextPLanetReturnDate(Personendaten pd1, Personendaten pd2, Date currentDate, int planet1, int planet2, AspektTyp aspekt) {
        return null;
    }

    public Date decreaseSolarDate(Personendaten pd, Date currentDate) {
        Date newDate = DateUtil.dateAddYears(currentDate, -1);
        newDate = DateUtil.dateReplaceYear(pd.getGeburtsdatum(), DateUtil.getYear(newDate));
        if (DateUtil.getDiffInDays(newDate, currentDate) < 180L) {
            newDate = DateUtil.dateAddYears(currentDate, -2);
            newDate = DateUtil.dateReplaceYear(pd.getGeburtsdatum(), DateUtil.getYear(newDate));
        } else if (DateUtil.getDiffInDays(newDate, currentDate) > 540L) {
            newDate = currentDate;
            newDate = DateUtil.dateReplaceYear(pd.getGeburtsdatum(), DateUtil.getYear(newDate));
        }
        return this.getCurrentSolarDate(pd, DateUtil.getYear(newDate));
    }

    public Date getCurrentSolarDate(Personendaten personendaten, int jahr) {
        Date date = DateUtil.dateReplaceYear(personendaten.getGeburtsdatum(), jahr);
        Date dateMin = DateUtil.dateAddHours(date, -48);
        Date dateMax = DateUtil.dateAddHours(date, 48);
        Astrodaten adGeburt = new Astrodaten(personendaten.getLongitude(), personendaten.getLatitude(), personendaten.getGeburtsdatum());
        Astrodaten adMin = new Astrodaten(personendaten.getLongitude(), personendaten.getLatitude(), dateMin);
        Astrodaten adMax = new Astrodaten(personendaten.getLongitude(), personendaten.getLatitude(), dateMax);
        double longGeburt = adGeburt.sun.getLongitude();
        double longMin = adMin.sun.getLongitude();
        double longMax = adMax.sun.getLongitude();
        PlanetReturnResult res = this.nextRecSolarDate(personendaten, adMin, adMax, longMin, longMax, dateMin, dateMax, longGeburt);
        return res.date;
    }

    private PlanetReturnResult nextRecSolarDate(Personendaten personendaten, Astrodaten adMin, Astrodaten adMax, double longMin, double longMax, Date min, Date max, double longGeburt) {
        Date middle = DateUtil.getMiddleDate(min, max);
        Astrodaten adMiddle = new Astrodaten(personendaten.getLongitude(), personendaten.getLatitude(), middle);
        double longMiddle = adMiddle.sun.getLongitude();
        double l1 = Math.abs(longGeburt - longMin);
        double l2 = Math.abs(longGeburt - longMax);
        long diff = DateUtil.getDiffInMillis(min, max);
        if (diff < 2000L) {
            PlanetReturnResult res = new PlanetReturnResult();
            res.date = middle;
            res.longitude = longMiddle;
            return res;
        }
        PlanetReturnResult res = l1 < l2 ? this.nextRecSolarDate(personendaten, adMin, adMiddle, longMin, longMiddle, min, middle, longGeburt) : this.nextRecSolarDate(personendaten, adMiddle, adMax, longMiddle, longMax, middle, max, longGeburt);
        return res;
    }

    private class PlanetReturnResult {
        Date date;
        double longitude;

        private PlanetReturnResult() {
        }
    }
}

