/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.paint.Controlpanel;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.RadixHelper;
import de.cni.common.calculation.TransitHausRange;
import de.cni.common.core.Constants;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TransitHausCalculator<HausRangeList> {
    private HoroskopCalculator horoskopCalculator;
    private Controlpanel controlpanel;
    public static final int anzPlaneten = 10;
    public static final int size = 14;
    public static int ID_AC = 10;
    public static int ID_DC = 11;
    public static int ID_MC = 12;
    public static int ID_IC = 13;
    private boolean usePanel = false;
    List<TransitHausRange> transitHausRangeList = new ArrayList<TransitHausRange>();

    public TransitHausCalculator(HoroskopCalculator horoskopCalculator, Controlpanel controlpanel) {
        this.horoskopCalculator = horoskopCalculator;
        this.controlpanel = controlpanel;
    }

    private boolean hasMissingBisDate(List<TransitHausRange> transitHausRangeList) {
        for (TransitHausRange obj : transitHausRangeList) {
            if (obj.getTransitBis() != null) continue;
            return true;
        }
        return false;
    }

    private void fillMissingBisDate(List<TransitHausRange> transitHausRangeList, TransitHausRange element) {
        for (TransitHausRange current : transitHausRangeList) {
            if (current.getTransitBis() != null || current.getPlanetnr() != element.planetnr || current.getHaus() == element.getHaus()) continue;
            current.transitBis = element.getTransitVon();
        }
    }

    private boolean resetVonDate(List<TransitHausRange> transitHausRangeList, Date vonDate) {
        for (TransitHausRange obj : transitHausRangeList) {
            if (!Util.equals(obj.getTransitVon(), vonDate)) continue;
            obj.setTransitVon(null);
        }
        return false;
    }

    private boolean hasMissingVonDate(List<TransitHausRange> transitHausRangeList) {
        for (TransitHausRange obj : transitHausRangeList) {
            if (obj.getTransitVon() != null) continue;
            return true;
        }
        return false;
    }

    private void fillMissingVonDate(List<TransitHausRange> transitHausRangeList, TransitHausRange element) {
        for (TransitHausRange current : transitHausRangeList) {
            if (current.getTransitVon() != null || current.getPlanetnr() != element.planetnr || current.getHaus() == element.getHaus()) continue;
            current.transitVon = element.getTransitVon();
        }
    }

    public void add(List<TransitHausRange> list, TransitHausRange element) {
        int idx = list.size() - 1;
        if (idx < 0) {
            list.add(element);
            return;
        }
        while (idx >= 0) {
            TransitHausRange current;
            if ((current = list.get(idx--)).getPlanetnr() != element.planetnr) continue;
            if (current.getHaus() != element.getHaus()) {
                current.transitBis = element.getTransitVon();
                list.add(element);
            }
            return;
        }
        list.add(element);
    }

    public List<TransitHausRange> calculate(Date minDate, Date maxDate, int satz, boolean interAspekte) {
        List<TransitHausRange> list = null;
        Date currentDate = minDate;
        while (currentDate.getTime() < maxDate.getTime()) {
            this.horoskopCalculator.setNewDate(currentDate);
            currentDate = !interAspekte ? DateUtil.dateAddMinutes(currentDate, 30) : DateUtil.dateAddDays(currentDate, 1);
            list = this.calculate(satz, interAspekte);
            for (TransitHausRange obj : list) {
                this.add(this.transitHausRangeList, obj);
            }
        }
        while (this.hasMissingBisDate(this.transitHausRangeList)) {
            currentDate = !interAspekte ? DateUtil.dateAddMinutes(currentDate, 30) : DateUtil.dateAddDays(currentDate, 1);
            this.horoskopCalculator.setNewDate(currentDate);
            list = this.calculate(satz, interAspekte);
            for (TransitHausRange obj : list) {
                this.fillMissingBisDate(this.transitHausRangeList, obj);
            }
        }
        this.resetVonDate(this.transitHausRangeList, minDate);
        currentDate = minDate;
        while (this.hasMissingVonDate(this.transitHausRangeList)) {
            currentDate = !interAspekte ? DateUtil.dateAddMinutes(currentDate, -30) : DateUtil.dateAddDays(currentDate, -1);
            this.horoskopCalculator.setNewDate(currentDate);
            list = this.calculate(satz, interAspekte);
            for (TransitHausRange obj : list) {
                this.fillMissingVonDate(this.transitHausRangeList, obj);
            }
        }
        return this.transitHausRangeList;
    }

    private List<TransitHausRange> calculate(int satz, boolean interAspekte) {
        ArrayList<TransitHausRange> list = new ArrayList<TransitHausRange>();
        RadixHelper radixHelper = new RadixHelper(satz == 1 || interAspekte ? this.horoskopCalculator.getAstrodaten1() : this.horoskopCalculator.getAstrodaten2());
        for (int i = 0; i < Constants.planeten.length; ++i) {
            if ((satz != 2 && !interAspekte || !this.controlpanel.getPlaneten2()[i]) && (satz != 1 || interAspekte || !this.controlpanel.getPlaneten1()[i])) continue;
            double offset2 = this.horoskopCalculator.getAstrodaten2().getOffset();
            offset2 = this.horoskopCalculator.getOffsetSatz2();
            double planetWinkelAbs = satz == 1 && !interAspekte ? this.horoskopCalculator.getAstrodaten1().getPlanetAbs(i) : Trigo.grad(offset2 + this.horoskopCalculator.getAstrodaten2().getPlanetAbs(i));
            int haus = radixHelper.getIntFirstHausByWinkel(planetWinkelAbs, 0);
            TransitHausRange transitHausRange = new TransitHausRange();
            transitHausRange.setPlanetnr(i);
            transitHausRange.setHaus(haus);
            transitHausRange.setTransitVon(this.horoskopCalculator.getRelevantDate());
            transitHausRange.setTransitBis(null);
            list.add(transitHausRange);
        }
        return list;
    }

    public boolean isUsePanel() {
        return this.usePanel;
    }

    public void setUsePanel(boolean usePanel) {
        this.usePanel = usePanel;
    }
}

