/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.astrologie.AspektTyp;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import java.util.Date;

public class TransitRange
implements Comparable<TransitRange> {
    int planetnr1;
    int planetnr2;
    AspektTyp aspekttyp;
    Date transitVon;
    Date transitBis;
    int calculations;
    String planetNr1Haus;
    String planetNr1Tkz;
    String planetNr2Haus;
    String planetNr2Tkz;

    public boolean equals(Object object) {
        if (!(object instanceof TransitRange)) {
            return false;
        }
        TransitRange obj = (TransitRange)object;
        return this.planetnr1 == obj.planetnr1 && this.planetnr2 == obj.planetnr2 && this.aspekttyp == obj.aspekttyp && Util.equals(this.transitVon, obj.getTransitVon());
    }

    @Override
    public int compareTo(TransitRange object) {
        if (this == object) {
            return 0;
        }
        TransitRange obj = object;
        int ret = Util.compare(this.transitVon, obj.getTransitVon());
        if (ret == 0) {
            ret = Util.compare(this.planetnr1, obj.planetnr1);
        }
        if (ret == 0) {
            ret = Util.compare(this.planetnr2, obj.planetnr2);
        }
        if (ret == 0) {
            ret = Util.compare(this.aspekttyp.ordinal(), obj.aspekttyp.ordinal());
        }
        return ret;
    }

    public String toString() {
        String s = Constants.planeten[this.planetnr1] + "-" + Constants.planeten[this.planetnr2] + ":" + this.aspekttyp.name + ", " + Converter.timeToString(this.transitVon) + " - " + Converter.timeToString(this.transitBis);
        return s;
    }

    public String toString(String timezoneString) {
        String s = Constants.planeten[this.planetnr1] + "-" + Constants.planeten[this.planetnr2] + ":" + this.aspekttyp.name + ", " + Converter.datetimeToString(this.transitVon, timezoneString) + " - " + Converter.datetimeToString(this.transitBis, timezoneString);
        return s;
    }

    public int getPlanetnr1() {
        return this.planetnr1;
    }

    public int getPlanetnr2() {
        return this.planetnr2;
    }

    public AspektTyp getAspekttyp() {
        return this.aspekttyp;
    }

    public Date getTransitVon() {
        return this.transitVon;
    }

    public Date getTransitBis() {
        return this.transitBis;
    }

    public void setPlanetnr1(int planetnr1) {
        this.planetnr1 = planetnr1;
    }

    public void setPlanetnr2(int planetnr2) {
        this.planetnr2 = planetnr2;
    }

    public void setAspekttyp(AspektTyp aspekttyp) {
        this.aspekttyp = aspekttyp;
    }

    public void setTransitVon(Date transitVon) {
        this.transitVon = transitVon;
    }

    public void setTransitBis(Date transitBis) {
        this.transitBis = transitBis;
    }

    public int getCalculations() {
        return this.calculations;
    }

    public void setCalculations(int calculations) {
        this.calculations = calculations;
    }

    public String getPlanetNr1Haus() {
        return this.planetNr1Haus;
    }

    public String getPlanetNr1Tkz() {
        return this.planetNr1Tkz;
    }

    public void setPlanetNr1Haus(String planetNr1Haus) {
        this.planetNr1Haus = planetNr1Haus;
    }

    public void setPlanetNr1Tkz(String planetNr1Tkz) {
        this.planetNr1Tkz = planetNr1Tkz;
    }

    public String getPlanetNr2Haus() {
        return this.planetNr2Haus;
    }

    public String getPlanetNr2Tkz() {
        return this.planetNr2Tkz;
    }

    public void setPlanetNr2Haus(String planetNr2Haus) {
        this.planetNr2Haus = planetNr2Haus;
    }

    public void setPlanetNr2Tkz(String planetNr2Tkz) {
        this.planetNr2Tkz = planetNr2Tkz;
    }
}

