/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.paint.Controlpanel;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.TextanalyseCalculator;
import de.cni.common.core.GlobalData;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Analyse;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZusatzfilterCalculator {
    private static Log log = LogFactory.getLog(ZusatzfilterCalculator.class);
    List<IBusinessObject> listAnalysedaten = new ArrayList<IBusinessObject>();
    List<IBusinessObject> listNewPersonendaten = new ArrayList<IBusinessObject>();
    SqLiteDatabase db = new SqLiteDatabase();
    boolean core = true;

    public ZusatzfilterCalculator(List<Analyse> list, boolean core) {
        this.core = core;
        int lineNumber = 0;
        for (Analyse a : list) {
            a.setLineNumber(++lineNumber);
            this.listAnalysedaten.add(a);
            if (Util.isEmpty(a.getText1())) continue;
            this.addFromDb(lineNumber, a.getText1());
        }
    }

    private void addFromDb(int lineNumber, String text) {
        try {
            Analyse filter = Analyse.newInstance(this.core);
            filter.setText1(text);
            List<IBusinessObject> list = this.db.select(filter);
            if (list != null) {
                for (IBusinessObject a : list) {
                    ((Analyse)a).setLineNumber(lineNumber);
                    this.listAnalysedaten.add((Analyse)a);
                }
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public List<IBusinessObject> getFilteredPersonendatenList(List<IBusinessObject> personendatenList) {
        for (IBusinessObject pd : personendatenList) {
            if (!this.matches((Personendaten)pd)) continue;
            this.listNewPersonendaten.add(pd);
        }
        return this.listNewPersonendaten;
    }

    private boolean matches(Personendaten pd) {
        Controlpanel controlpanel = new Controlpanel(GlobalData.getInstance().getSettings());
        if (pd.getGeburtsdatum() == null) {
            return false;
        }
        Astrodaten ad = new Astrodaten(pd.getLongitude(), pd.getLatitude(), pd.getGeburtsdatum());
        TextanalyseCalculator ac = new TextanalyseCalculator(controlpanel, ad, this.listAnalysedaten);
        return ac.doesAnalyseListMatch();
    }
}

