/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import de.cni.common.core.Introspection;
import de.cni.common.core.Util;
import de.cni.common.exceptions.TechnicalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveXInterface {
    private static Log log = LogFactory.getLog(ActiveXInterface.class);
    private static String FORMATTED_MASK_SIGN = "_";
    static final int PROTECTION_TYPE_NONE = -1;
    static final int PROTECTION_TYPE_REVISION = 0;
    static final int PROTECTION_TYPE_COMMENTS = 1;
    static final int PROTECTION_TYPE_FORMFIELDS = 2;
    static final int PROTECTION_TYPE_READONLY = 3;

    public static void sendMailViaOutlook(String to, String titel, String text, String attachmentFilename) throws Exception {
        try {
            log.debug((Object)"sendMail gestartet");
            ActiveXComponent axcOutlook = new ActiveXComponent("Outlook.Application");
            Dispatch myMail = Dispatch.invoke((Dispatch)axcOutlook.getObject(), (String)"CreateItem", (int)2, (Object[])new Object[]{"0"}, (int[])new int[0]).toDispatch();
            Dispatch.put((Dispatch)myMail, (String)"To", (Object)to);
            Dispatch.put((Dispatch)myMail, (String)"Subject", (Object)titel);
            Dispatch.put((Dispatch)myMail, (String)"Body", (Object)text);
            Dispatch.put((Dispatch)myMail, (String)"ReadReceiptRequested", (Object)"false");
            Dispatch attachs = Dispatch.get((Dispatch)myMail, (String)"Attachments").toDispatch();
            if (!Util.isEmpty(attachmentFilename)) {
                Dispatch.call((Dispatch)attachs, (String)"Add", (Object[])new Object[]{attachmentFilename});
            }
            Dispatch.call((Dispatch)myMail, (String)"Display");
            log.debug((Object)"sendMail beendet");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TechnicalException("Fehler beim Senden der Mail.", e);
        }
        finally {
            log.debug((Object)"sendMail finally");
        }
    }

    public static void OpenMicrosoftWord(String templatename, Object dataObject, boolean editable) throws TechnicalException {
        try {
            ActiveXComponent oWord = new ActiveXComponent("Word.Application");
            oWord.setProperty("Visible", new Variant(true));
            Dispatch oDocuments = oWord.getProperty("Documents").toDispatch();
            Dispatch oDocument = Dispatch.call((Dispatch)oDocuments, (String)"Add", (Object[])new Object[]{templatename}).toDispatch();
            if (editable) {
                ActiveXInterface.protectWordDocument(oDocument);
                ActiveXInterface.setFormFields(oDocument, dataObject);
            } else {
                ActiveXInterface.unprotectWordDocument(oDocument);
                ActiveXInterface.replaceFormFields(oDocument, dataObject);
                ActiveXInterface.protectWordDocument(oDocument);
            }
        }
        catch (TechnicalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnicalException("Fehler beim Aufruf von Microsoft-Word.", e);
        }
    }

    private static void unprotectWordDocument(Object oDocument) {
        Variant protectionMode = Dispatch.get((Dispatch)((Dispatch)oDocument), (String)"ProtectionType");
        log.debug((Object)("ProtectionType=" + protectionMode));
        if (protectionMode.getInt() != -1) {
            log.debug((Object)"Der Dokumentschutz wird aufgehoben");
            Dispatch.call((Dispatch)((Dispatch)oDocument), (String)"Unprotect");
        }
    }

    private static void protectWordDocument(Object oDocument) {
        Variant protectionMode = Dispatch.get((Dispatch)((Dispatch)oDocument), (String)"ProtectionType");
        log.debug((Object)("ProtectionType=" + protectionMode));
        if (protectionMode.getInt() != 2) {
            if (protectionMode.getInt() != -1) {
                ActiveXInterface.unprotectWordDocument(oDocument);
            }
            log.debug((Object)"Das Dokument wird gesch\u00fctzt");
            Dispatch.call((Dispatch)((Dispatch)oDocument), (String)"Protect", (Object[])new Object[]{new Variant(2)});
        }
    }

    private static void replaceFormFields(Object oDocument, Object dataObject) throws TechnicalException {
        if (dataObject == null || oDocument == null) {
            return;
        }
        boolean terminate = false;
        block0: while (!terminate) {
            terminate = true;
            Dispatch formFields = Dispatch.get((Dispatch)((Dispatch)oDocument), (String)"FormFields").toDispatch();
            int numberOfFormFields = Dispatch.get((Dispatch)formFields, (String)"Count").getInt();
            for (int i = 0; i < numberOfFormFields; ++i) {
                Dispatch com_field = Dispatch.call((Dispatch)formFields, (String)"Item", (Object[])new Object[]{new Variant(i + 1)}).toDispatch();
                Variant com_FieldName = Dispatch.get((Dispatch)com_field, (String)"Name");
                String fieldname = com_FieldName.toString();
                String newValue = null;
                if (fieldname.startsWith(FORMATTED_MASK_SIGN) && fieldname.endsWith(FORMATTED_MASK_SIGN)) {
                    fieldname = Util.strip(fieldname, FORMATTED_MASK_SIGN);
                    newValue = Introspection.getMsWordStringValue(dataObject, fieldname, true);
                } else {
                    newValue = Introspection.getMsWordStringValue(dataObject, fieldname, false);
                }
                if (newValue == null) continue;
                Dispatch.put((Dispatch)com_field, (String)"Range", (Object)new Variant((Object)newValue));
                terminate = false;
                continue block0;
            }
        }
    }

    private static void setFormFields(Object oDocument, Object dataObject) throws TechnicalException {
        if (dataObject == null || oDocument == null) {
            return;
        }
        Dispatch formFields = Dispatch.get((Dispatch)((Dispatch)oDocument), (String)"FormFields").toDispatch();
        int numberOfFormFields = Dispatch.get((Dispatch)formFields, (String)"Count").getInt();
        for (int i = 0; i < numberOfFormFields; ++i) {
            Dispatch com_field = Dispatch.call((Dispatch)formFields, (String)"Item", (Object[])new Object[]{new Variant(i + 1)}).toDispatch();
            Variant com_FieldName = Dispatch.get((Dispatch)com_field, (String)"Name");
            String fieldname = com_FieldName.toString();
            String newValue = null;
            if (fieldname.startsWith(FORMATTED_MASK_SIGN) && fieldname.endsWith(FORMATTED_MASK_SIGN)) {
                fieldname = Util.strip(fieldname, FORMATTED_MASK_SIGN);
                newValue = Introspection.getMsWordStringValue(dataObject, fieldname, true);
            } else {
                newValue = Introspection.getMsWordStringValue(dataObject, fieldname, false);
            }
            if (newValue == null) continue;
            Dispatch.put((Dispatch)com_field, (String)"Result", (Object)new Variant((Object)newValue));
        }
    }
}

