/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Converter;
import de.cni.common.core.FormattedStringBuffer;
import de.cni.common.core.LicenseHandler;
import de.cni.common.core.Util;
import de.cni.common.datamodel.RangeElement;
import de.cni.common.datamodel.admin.User;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class Formatter {
    public static String int2blz(int blz) {
        if (blz == 0) {
            return "";
        }
        String s = new DecimalFormat("00000000").format(blz);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (char c : s.toCharArray()) {
            sb.append(c);
            if (++i != 3 && i != 6) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String string2blz(String blz) {
        int x = Converter.stringToInt(blz);
        return Formatter.int2blz(x);
    }

    public static String long2kto(long kto) {
        if (kto == 0L) {
            return "";
        }
        DecimalFormat f = new DecimalFormat("#,###,###,###");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(' ');
        f.setDecimalFormatSymbols(dfs);
        String s = f.format(kto);
        return s;
    }

    public static String string2kto(String kto) {
        long x = Converter.stringToLong(kto);
        return Formatter.long2kto(x);
    }

    public static String string2iban(String iban) {
        StringBuffer sb = new StringBuffer();
        if (Util.isEmpty(iban)) {
            return "";
        }
        for (int i = 0; i < iban.length(); ++i) {
            if (i > 0 && i % 4 == 0) {
                sb.append(" ");
            }
            sb.append(iban.charAt(i));
        }
        return sb.toString().trim();
    }

    public static String string2AnonymIban(String iban) {
        String s = Converter.stringReplaceMiddle(iban, 5, "XXXXXXXXXXXXXX");
        s = Formatter.string2iban(s);
        return s;
    }

    public static String kontodatenToString(String kto, String blz, String bankname, String kontoinhaber) {
        if (!Util.isEmpty(kto)) {
            StringBuffer sb = new StringBuffer();
            if (!Util.isEmpty(kontoinhaber)) {
                sb.append("Kontoinhaber:\t");
                sb.append(Formatter.crTrailingString(kontoinhaber, true));
            }
            sb.append("Bank:\t");
            sb.append(Formatter.crTrailingString(bankname, true));
            sb.append("KTO:\t");
            sb.append(Formatter.crTrailingString(Formatter.string2kto(kto), true));
            sb.append("BLZ:\t");
            sb.append(Formatter.crTrailingString(Formatter.string2blz(blz), true));
            return sb.toString();
        }
        return "";
    }

    public static String userToString(User user) {
        if (user == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Formatter.blankTrailingString(user.getUsername()));
        sb.append("( ");
        sb.append(Formatter.blankTrailingString(user.getVorname()));
        sb.append(Formatter.blankTrailingString(user.getNachname()));
        sb.append(")");
        return sb.toString();
    }

    public static String blankTrailingString(String string) {
        String value = Util.NotNull(string);
        StringBuffer sb = new StringBuffer(value);
        if (!Util.isEmpty(value)) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String trailingString(String string, String separator) {
        String value = Util.NotNull(string);
        StringBuffer sb = new StringBuffer(value);
        if (!Util.isEmpty(value)) {
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String append(String a, String b, String separator) {
        if (Util.isEmpty(a)) {
            return b;
        }
        if (Util.isEmpty(b)) {
            return a;
        }
        return a + separator + b;
    }

    public static String append(String ... s) {
        if (s.length == 0) {
            return null;
        }
        if (s.length == 1) {
            return s[0];
        }
        if (s.length == 2) {
            if (s[1] == null) {
                return s[0];
            }
            if (s[0] == null) {
                return s[1];
            }
            return s[0] + s[1];
        }
        String ret = "";
        String separator = s[s.length - 1];
        boolean n = false;
        for (int pos = 0; pos < s.length - 1; ++pos) {
            if (!Util.isEmpty(ret) && !Util.isEmpty(s[pos])) {
                ret = ret + separator + s[pos];
                continue;
            }
            if (Util.isEmpty(s[pos])) continue;
            ret = s[pos];
        }
        return ret;
    }

    public static String crTrailingString(String string, boolean force) {
        String value = Util.NotNull(string);
        StringBuffer sb = new StringBuffer(value.trim());
        if (force || !Util.isEmpty(value)) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String crKeyValueString(String key, String value) {
        if (!Util.isEmpty(value)) {
            StringBuffer sb = new StringBuffer(key);
            sb.append(":\t");
            sb.append(value);
            sb.append("\n");
            return sb.toString();
        }
        return "";
    }

    public static String dependingOnFirstString(String value1, String value2) {
        if (!Util.isEmpty(value1)) {
            StringBuffer sb = new StringBuffer(value1);
            sb.append(value2);
            return sb.toString();
        }
        return "";
    }

    public static String dependingOnMiddleString(String value1, String value2, String value3) {
        if (!Util.isEmpty(value2)) {
            StringBuffer sb = new StringBuffer(value1);
            sb.append(value2);
            sb.append(value3);
            return sb.toString();
        }
        return "";
    }

    public static String dependingOnSecondString(String value1, String value2) {
        if (!Util.isEmpty(value2)) {
            StringBuffer sb = new StringBuffer(value1);
            sb.append(value2);
            return sb.toString();
        }
        return "";
    }

    public static String aboutString(String applicationName, String clientVersion, String clientBuild, String clientBranding, String serverVersion, String serverBuild, String serverHostname, String serverBranding, String jbossVersion, String dbVersion) {
        try {
            String name = LicenseHandler.getInstance().getLicensWrapper().getName();
            String eigentuemer = LicenseHandler.getInstance().getLicensWrapper().getEmail();
            String erzeugt = LicenseHandler.getInstance().getLicensWrapper().getErzeugt();
            String licenseArt = LicenseHandler.getInstance().getLicensWrapper().getArt();
            Date gueltigBis = LicenseHandler.getInstance().getLicensWrapper().getGueltigBis();
            String gueltigkeit = Util.isEmpty(gueltigBis) ? "unbegrenzt g\u00fcltig" : "g\u00fcltig bis " + Converter.dateToString(gueltigBis);
            FormattedStringBuffer sb = new FormattedStringBuffer();
            sb.println(applicationName);
            sb.lprint("Version:", 12);
            sb.lprint(clientVersion, 60);
            sb.newLine();
            sb.lprint("Build:", 12);
            sb.lprint(clientBuild, 60);
            sb.newLine();
            sb.lprint("DB:", 12);
            sb.lprint(dbVersion, 60);
            sb.newLine();
            sb.lprint("Branding:", 12);
            sb.lprint(clientBranding, 60);
            sb.newLine();
            sb.lprint("Lizenz:", 12);
            sb.lprint(licenseArt + ", " + gueltigkeit, 60);
            sb.newLine();
            sb.lprint("erzeugt:", 12);
            sb.lprint(erzeugt, 60);
            sb.newLine();
            sb.lprint("Eigent\u00fcmer:", 12);
            sb.lprint(name, 60);
            sb.newLine();
            sb.lprint("E-Mail:", 12);
            sb.lprint(eigentuemer, 60);
            sb.newLine();
            sb.newLine();
            sb.println("Speicherverwaltung");
            sb.lprint("Verwendet:", 12);
            sb.rprint(Formatter.reportNumber((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L) + " MB", 10);
            sb.newLine();
            sb.lprint("Reserviert:", 12);
            sb.rprint(Formatter.reportNumber(Runtime.getRuntime().totalMemory() / 1024L / 1024L) + " MB", 10);
            sb.newLine();
            sb.lprint("Verf\u00fcgbar:", 12);
            sb.rprint(Formatter.reportNumber(Runtime.getRuntime().maxMemory() / 1024L / 1024L) + " MB", 10);
            sb.newLine();
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String timeDuration2String(long duration) {
        long sekunden = duration / 1000L % 60L;
        long minuten = duration / 60000L % 60L;
        long stunden = duration / 3600000L % 24L;
        long tage = duration / 86400000L;
        return String.format("%3d Tage %2d Stunden %2d Minuten %2d Sekunden", tage, stunden, minuten, sekunden);
    }

    public static String getAktenzeichen(String t1, String t2, String t3, String t4) {
        StringBuffer sb = new StringBuffer();
        sb.append(Util.NotNull(t1));
        sb.append("/");
        sb.append(Util.NotNull(t2));
        sb.append("/");
        sb.append(Util.NotNull(t3));
        sb.append("/");
        sb.append(Util.NotNull(t4));
        return sb.toString();
    }

    public static String ansprechpartnerToString(String anrede, String namenszusatz, String ansprechpartner) {
        StringBuffer name = new StringBuffer();
        name.append(Formatter.blankTrailingString(anrede));
        name.append(Formatter.blankTrailingString(namenszusatz));
        name.append(ansprechpartner);
        return name.toString();
    }

    public static String pReportNumber(Integer value) {
        if (value == null) {
            return "";
        }
        DecimalFormat newValue = new DecimalFormat("###,###,###,##0");
        return newValue.format(value);
    }

    public static String pReportNumber(Long value) {
        if (value == null) {
            return "";
        }
        DecimalFormat newValue = new DecimalFormat("###,###,###,##0");
        return newValue.format(value);
    }

    public static String pReportNumber(Double value) {
        if (value == null) {
            return "";
        }
        DecimalFormat newValue = new DecimalFormat("###,###,###,##0.00");
        return newValue.format(value);
    }

    public static String reportNumberNotNull(Integer value) {
        if (value == null || value == 0) {
            return "";
        }
        return Formatter.reportNumber(value);
    }

    public static String reportNumber(Integer value) {
        if (value == null) {
            return "";
        }
        DecimalFormat newValue = new DecimalFormat(" ###,###,###,##0;-###,###,###,##0");
        return newValue.format(value);
    }

    public static String reportNumber(Long value) {
        if (value == null) {
            return "";
        }
        DecimalFormat newValue = new DecimalFormat(" ###,###,###,##0;-###,###,###,##0");
        return newValue.format(value);
    }

    public static String reportNumber(Double value) {
        if (value == null) {
            return "";
        }
        DecimalFormat currency = new DecimalFormat(" ###,###,###,##0.00;-###,###,###,##0.00");
        return currency.format(Util.euro(value));
    }

    public static String reportUnformattedNumber(Double value) {
        if (value == null) {
            return "";
        }
        DecimalFormat currency = new DecimalFormat("0.##");
        return currency.format(Util.euro(value));
    }

    public static String reportNumber(double value, String format) {
        DecimalFormat currency = new DecimalFormat(format);
        return currency.format(Util.euro(value));
    }

    public static String mapToString(Map<String, Object> map) {
        StringBuffer result = new StringBuffer();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            Object object = map.get(key);
            if (object instanceof String) {
                result.append(key);
                result.append(": ");
                result.append((String)object);
                result.append("\n");
                continue;
            }
            if (object instanceof Date) {
                result.append(key);
                result.append(": ");
                result.append(Converter.dateToString((Date)object));
                result.append("\n");
                continue;
            }
            if (object instanceof Integer) {
                result.append(key);
                result.append(": ");
                result.append(Integer.toString((Integer)object));
                result.append("\n");
                continue;
            }
            if (object instanceof Double) {
                result.append(key);
                result.append(": ");
                result.append(Double.toString((Double)object));
                result.append("\n");
                continue;
            }
            if (object instanceof Boolean) {
                result.append(key);
                result.append(": ");
                result.append(Converter.booleanToGuiString((Boolean)object));
                result.append("\n");
                continue;
            }
            if (!(object instanceof RangeElement)) continue;
            result.append(key);
            result.append(": ");
            result.append(((RangeElement)object).toString());
            result.append("\n");
        }
        String ret = result.toString();
        if (Util.isEmpty(ret)) {
            ret = "keine";
        }
        return ret;
    }

    public static String twoToOne(String a, String b) {
        if (!Util.isEmpty(a)) {
            return Util.NotNull(a);
        }
        return Util.NotNull(b);
    }

    public static String getWohnort(String lkz, String plz, String ort) {
        StringBuffer sb = new StringBuffer();
        if (!Util.isEmpty(lkz) && !Util.equals(lkz, "D")) {
            sb.append(Util.NotNull(lkz));
            sb.append(" ");
        }
        if (!Util.isEmpty(plz)) {
            sb.append(Util.NotNull(plz));
            sb.append(" ");
        }
        sb.append(Util.NotNull(ort));
        return sb.toString();
    }

    public static String getWohnortWithLkz(String lkz, String plz, String ort) {
        StringBuffer sb = new StringBuffer();
        if (!Util.isEmpty(lkz)) {
            sb.append(Util.NotNull(lkz));
            sb.append(" ");
        }
        if (!Util.isEmpty(plz)) {
            sb.append(Util.NotNull(plz));
            sb.append(" ");
        }
        sb.append(Util.NotNull(ort));
        return sb.toString();
    }

    public static boolean isNamensvorsatzSonderbehandlung(String namensvorsatz) {
        return Util.equals(namensvorsatz, "Freiherr") || Util.equals(namensvorsatz, "Freifrau") || Util.equals(namensvorsatz, "Freiin");
    }

    public static double getQuote(int a, int b) {
        if (b != 0) {
            return (double)a / ((double)b * 100.0);
        }
        return 0.0;
    }

    public static double getQuote(double a, double b) {
        if (b != 0.0) {
            return Util.euro(Util.euro(a) / Util.euro(b) * 100.0);
        }
        return 0.0;
    }

    public static double getRelQuote(double a, double b) {
        if (b != 0.0) {
            return Formatter.getQuote(Util.euro(a) - Util.euro(b), Util.euro(b));
        }
        return 0.0;
    }

    public static String getToken(String s, String separator, int pos) {
        String[] a = s.split(separator);
        if (pos >= a.length) {
            return null;
        }
        return a[pos];
    }

    public String string2latLong(String s) {
        if (Util.isEmpty(s)) {
            return "00.0000";
        }
        String[] a = s.split(".");
        String r = Converter.stringToLeading0String(a[0], 2) + "." + Converter.stringToLeading0String(a[1], 2);
        return r;
    }
}

