/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.client.gui.popup.filter.PopupFileDialog;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.Converter;
import de.cni.common.core.Datensicherung;
import de.cni.common.core.Formatter;
import de.cni.common.core.LicenseWrapper;
import de.cni.common.core.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LicenseHandler {
    private static Log log = LogFactory.getLog(LicenseHandler.class);
    private static LicenseHandler instance = new LicenseHandler();
    private LicenseWrapper licenseWrapper = null;
    LicenseType licenseType;

    public boolean isAllowed(LicenseType minLicenseType) {
        if (this.licenseType == null) {
            return false;
        }
        return this.licenseType.getId() >= minLicenseType.getId();
    }

    private LicenseHandler() {
    }

    private void setCurrentLicense(String art) {
        if (Util.equals(art, "Bronzo")) {
            this.licenseType = LicenseType.BRONZO;
        }
        if (Util.equals(art, "Argento")) {
            this.licenseType = LicenseType.ARGENTO;
        }
        if (Util.equals(art, "Oro")) {
            this.licenseType = LicenseType.ORO;
        }
        if (Util.equals(art, "Demo")) {
            this.licenseType = LicenseType.DEMO;
        }
        if (Util.equals(art, "Deb\u00fct")) {
            this.licenseType = LicenseType.DEMO;
        }
        if (Util.equals(art, "Admin1")) {
            this.licenseType = LicenseType.ADMIN;
        }
    }

    public boolean checkLicense() {
        try {
            this.licenseWrapper = new LicenseWrapper();
            this.licenseWrapper.readLicenseFromDB();
            if (this.licenseWrapper.isLegal()) {
                this.setCurrentLicense(this.licenseWrapper.getArt());
                return true;
            }
            Display d = Display.getDefault();
            Shell shell = new Shell(d);
            if (this.licenseWrapper.isValid() && this.licenseWrapper.isExpired()) {
                this.popupError(shell, "Ihre Lizenz ist am " + Converter.dateToString(this.licenseWrapper.getGueltigBis()) + " abgelaufen.");
            }
            this.popupInfo(shell, "Bitte spielen Sie zun\u00e4chst Ihre Lizenz Datei oder Ihre Backup-Datenbank ein.");
            String filename = "";
            filename = PopupFileDialog.openFileDialog(shell, "Bitte w\u00e4hlen Sie Ihre Lizenz-Datei oder ein Datenbank-Backup aus.", "", new String[]{"*.lic;*.db", "*.lic", "*.db"}, new String[]{"Alle", "Lizenz-Datei", "Datenbank-Backup"});
            if (Util.isEmpty(filename)) {
                return false;
            }
            if (filename.endsWith(".lic")) {
                return this.insertNewLicense(filename);
            }
            if (filename.endsWith(".db")) {
                try {
                    Datensicherung.datenruecksicherung(filename);
                    this.popupInfo(shell, "Die Datenbank wurde erfolreich r\u00fcckgesichert");
                    return this.checkLicense();
                }
                catch (Exception e) {
                    this.popupInfo(shell, "Bei der R\u00fccksicherung ist ein Fehler aufgetreten.\n" + Formatter.append(e.getClass().toString(), e.getMessage(), ", "));
                }
            } else {
                this.popupInfo(shell, "Dieser Dateityp ist nicht zul\u00e4ssig.");
            }
            return false;
        }
        catch (Exception e) {
            Display d = Display.getDefault();
            Shell shell = new Shell(d);
            this.popupInfo(shell, "Beim Auswerten der Lizenz ist ein Fehler aufgetreten.\n" + Formatter.append(e.getClass().toString(), e.getMessage(), ", "));
            return false;
        }
    }

    private boolean insertNewLicense(String filename) {
        try {
            Display d = Display.getDefault();
            Shell shell = new Shell(d);
            try {
                this.licenseWrapper.readLicenseFromFile(filename);
                if (!this.licenseWrapper.isLegal()) {
                    this.popupError(shell, "Die Lizenz ist leider nicht g\u00fcltig.");
                    return false;
                }
            }
            catch (Exception e) {
                this.popupError(shell, "Dies ist leider keine g\u00fcltige Lizenz-Datei: '" + filename + "'");
                return false;
            }
            this.licenseWrapper.writeLicenseToDb();
            if (!this.licenseWrapper.isLegal()) {
                this.popupInfo(shell, "Ihre Lizenz ist leider nicht g\u00fcltig.");
                return false;
            }
            this.setCurrentLicense(this.licenseWrapper.getArt());
            return true;
        }
        catch (Exception e) {
            Display d = Display.getDefault();
            Shell shell = new Shell(d);
            this.popupInfo(shell, "Beim Auswerten der Lizenz ist ein Fehler aufgetreten.\n" + Formatter.append(e.getClass().toString(), e.getMessage(), ", "));
            return false;
        }
    }

    public boolean newLicense() {
        try {
            this.licenseWrapper = new LicenseWrapper();
            String filename = "";
            try {
                filename = PopupFileDialog.openFileDialog("Bitte w\u00e4hlen Sie Ihre Lizenz-Datei aus.", "signum.lic", new String[]{"*.lic"}, new String[]{"Lizenz-Datei"});
                if (Util.isEmpty(filename)) {
                    return false;
                }
                this.licenseWrapper.readLicenseFromFile(filename);
                if (!this.licenseWrapper.isLegal()) {
                    Popup.error("Die Lizenz ist leider nicht g\u00fcltig.");
                    return false;
                }
            }
            catch (Exception e) {
                Popup.error("Dies ist leider keine g\u00fcltige Lizenz-Datei: '" + filename + "'.");
                return false;
            }
            this.licenseWrapper.writeLicenseToDb();
            if (!this.licenseWrapper.isLegal()) {
                Popup.error("Ihre Lizenz ist leider nicht g\u00fcltig.");
                return false;
            }
            this.setCurrentLicense(this.licenseWrapper.getArt());
            return true;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, "Beim Auswerten der Lizenz ist ein Fehler aufgetreten.\n" + Formatter.append(e.getClass().toString(), e.getMessage(), ", "));
            return false;
        }
    }

    public LicenseWrapper getLicensWrapper() {
        return this.licenseWrapper;
    }

    public static LicenseHandler getInstance() {
        return instance;
    }

    public void popupInfo(Shell shell, String text) {
        MessageDialog.openInformation((Shell)shell, (String)"Hinweis", (String)text);
    }

    public void popupError(Shell shell, String text) {
        MessageDialog.openError((Shell)shell, (String)"Fehler", (String)text);
    }

    public static enum LicenseType {
        BRONZO(100),
        ARGENTO(200),
        ORO(300),
        DEMO(400),
        ADMIN(900);

        int id;

        private LicenseType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

