/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Domain;
import de.cni.common.core.DomainItems;
import de.cni.common.core.ServerConnection;
import de.cni.common.datamodel.admin.DropdownText;
import de.cni.common.ejb.IDropdownTextVerwaltung;
import de.cni.common.exceptions.DatabaseException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MappingsFromDB {
    private static Log log = LogFactory.getLog(MappingsFromDB.class);

    public static void fillDomainMap(HashMap<Domain, DomainItems> domains) throws DatabaseException {
        IDropdownTextVerwaltung dropdownTextVerwaltung = ServerConnection.getInstance().getDropdownTextVerwaltung();
        for (Domain domain : Domain.values()) {
            log.debug((Object)("Lese Mappings f\u00fcr Domain " + domain.toString()));
            List<DropdownText> dropdownTextList = dropdownTextVerwaltung.select(domain.toString());
            int[] id = new int[dropdownTextList.size() + 1];
            String[] langtext = new String[dropdownTextList.size() + 1];
            String[] kurztext = new String[dropdownTextList.size() + 1];
            int defaultValue = 0;
            id[0] = 0;
            langtext[0] = "";
            kurztext[0] = "";
            for (int i = 0; i < dropdownTextList.size(); ++i) {
                DropdownText element = dropdownTextList.get(i);
                id[i + 1] = element.getDomainkey();
                kurztext[i + 1] = element.getKurztext();
                langtext[i + 1] = element.getLangtext();
                if (!element.isDefaultValue()) continue;
                defaultValue = element.getDomainkey();
            }
            DomainItems domainItems = new DomainItems(true, defaultValue, id, kurztext, langtext);
            domains.put(domain, domainItems);
        }
    }
}

