/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.client.calculation.PersonendatenCalculator;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.OrbisCache;
import de.cni.common.calculation.OrbisPresettings;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Analyse;
import de.cni.common.datamodel.admin.AnalyseHerrscher;
import de.cni.common.datamodel.admin.AnalyseSchluesselThema;
import de.cni.common.datamodel.admin.CoreAnalyse;
import de.cni.common.datamodel.admin.CoreAnalyseHerrscher;
import de.cni.common.datamodel.admin.CoreAnalyseSchluesselThema;
import de.cni.common.datamodel.admin.CoreTexte;
import de.cni.common.datamodel.admin.DbVersion;
import de.cni.common.datamodel.admin.Geodaten;
import de.cni.common.datamodel.admin.Gruppe;
import de.cni.common.datamodel.admin.PersonBefund;
import de.cni.common.datamodel.admin.PersonGruppe;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.datamodel.admin.Settings;
import de.cni.common.datamodel.admin.Texte;
import de.cni.common.exceptions.CalculationException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqLiteDatabase {
    private static Log log = LogFactory.getLog(SqLiteDatabase.class);
    private final String customDbName = "db/signum.db";
    private final String coreDbName = "db/core.db";
    Connection connection = null;
    Statement statement;
    int timeout = 30;
    PreparedStatement geoDatenPstmt;
    private String key;
    private int stufe;
    private String klasse;
    private String text;

    public void openCustomConnection() throws ClassNotFoundException, SQLException {
        this.openConnection("db/signum.db");
    }

    public void openCoreConnection() throws ClassNotFoundException, SQLException {
        this.openConnection("db/core.db");
    }

    private void openConnection(String dbName) throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbName);
        this.statement = this.connection.createStatement();
        this.statement.setQueryTimeout(this.timeout);
    }

    private void closeConnection() {
        try {
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
            }
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getInsertOrReplace(IBusinessObject obj, String table) {
        String s = obj == null || obj.getId() == 0 ? "insert" : "insert or replace";
        s = s + " into " + table + " (";
        if (obj != null && obj.getId() != 0) {
            s = s + "id, ";
        }
        return s;
    }

    public void recreateGeodaten() throws SQLException, ClassNotFoundException {
        try {
            this.openCoreConnection();
            this.statement.executeUpdate("drop table if exists geodaten");
            this.statement.executeUpdate("create table if not exists geodaten (id  INTEGER PRIMARY KEY AUTOINCREMENT, created Date,changed Date,lkz TEXT,plz TEXT,ort TEXT,land TEXT,kreis TEXT,name1 TEXT,code1 TEXT,name2 TEXT,code2 TEXT,name3 TEXT,code3 TEXT,latitude TEXT,longitude TEXT,timezoneId TEXT)");
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmptyDatabaseIfNotExists() throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("create table if not exists license (licensekey Bytes)");
            this.statement.executeUpdate("create table if not exists dbVersion (id  INTEGER PRIMARY KEY AUTOINCREMENT, created Date, changed Date, dbVersion Integer)");
            this.statement.executeUpdate("create table if not exists personendaten (id  INTEGER PRIMARY KEY AUTOINCREMENT, created Date,changed Date,vorname TEXT,nachname TEXT,geburtsdatumLocal TEXT,geburtsdatumUtc TEXT,geburtszeitLocal TEXT,geburtszeitUtc TEXT,geburtsdatum Date,timezoneId TEXT,gmtOffsetInMinutes TEXT,gmtOffsetManuell Integer,geburtsortKontinent TEXT,geburtsortLkz TEXT,geburtsortPlz TEXT,geburtsort TEXT,geburtsortManuell Integer,latitude TEXT,longitude TEXT,wohnortKontinent TEXT,wohnortLkz TEXT,wohnortPlz TEXT,wohnort TEXT,wohnortManuell Integer,wohnortLatitude TEXT,wohnortLongitude TEXT,aktuellKontinent TEXT,aktuellLkz TEXT,aktuellPlz TEXT,aktuellOrt TEXT,aktuellManuell Integer,aktuellLatitude TEXT,aktuellLongitude TEXT,anschrift TEXT,anrede TEXT,telefon TEXT,handy TEXT,internet TEXT,email TEXT,symptome TEXT,notiz TEXT,url1 TEXT,url2 TEXT,url3 TEXT,kontaktDurch TEXT,anonymeBezeichnung TEXT)");
            this.statement.executeUpdate("create table if not exists settings (id  INTEGER PRIMARY KEY AUTOINCREMENT, created   Date,changed   Date,name      TEXT,adresse1  TEXT,adresse2  TEXT,adresse3  TEXT,adresse4  TEXT,email  TEXT,kopfzeile TEXT,kopfzeileKurz TEXT,fusszeile TEXT,haussystem TEXT,kontinent TEXT,lkz       TEXT,webservice  INTEGER,gradzahlen INTEGER, zwischenskala INTEGER,jahresring INTEGER, zeiger INTEGER, zweiterAcMc INTEGER, reporttypId INTEGER, lineWidth INTEGER,orbisArrayString TEXT,interOrbisArrayString TEXT,konjunktion INTEGER,sextil INTEGER,quadrat INTEGER,trigon INTEGER,opposition INTEGER,horoskop1 INTEGER,horoskop2 INTEGER,aspekte1 INTEGER,aspekte2 INTEGER,interAspekte INTEGER,iconTypeId INTEGER,iconSizeId INTEGER,backupDir TEXT, texteDir TEXT, workingDir TEXT, logoFile TEXT, automatischeSicherung INTEGER, sicherungTage INTEGER, letzteSicherung DATE, stufe1 INTEGER, stufe2 INTEGER, eigeneAnalysetexte INTEGER, steuersatz INTEGER, header1 TEXT, header2 TEXT, header3 TEXT, absender TEXT, betreff TEXT, rechnungsdaten TEXT, rechnungsnummer TEXT, text1 TEXT, text2 TEXT, text3 TEXT, footer1 TEXT, footer2 TEXT, footer3 TEXT, rand1 TEXT, rand2 TEXT, rand3 TEXT)");
            this.statement.executeUpdate("INSERT INTO personendaten VALUES (1,'2021-01-01 12:00:00','2021-01-01 12:00:00','Maxima','Mustermann','01.01.1980','01.01.1980','12:00','11:00','1980-01-01 12:00:00','Europe/Berlin','60',0,'','DE','','Frankfurt am Main',0,'50.11552','8.68417','EU','DE','','M\u00fcnchen',0,'48.13743','11.57549','','','','','','','','','','','','')");
            OrbisCache oc = OrbisPresettings.getGeneratedDefaultOrben();
            OrbisCache ioc = OrbisPresettings.getGeneratedDefaultInterOrben();
            Settings s = new Settings();
            s.setOrbisArrayString(oc.object2string());
            s.setInterOrbisArrayString(ioc.object2string());
            this.save(s);
            this.statement.executeUpdate("create table if not exists gruppe (id  INTEGER PRIMARY KEY AUTOINCREMENT, created Date,changed Date,name TEXT, beschreibung TEXT)");
            this.statement.executeUpdate("create table if not exists personGruppe (id  INTEGER PRIMARY KEY AUTOINCREMENT, created Date,changed Date,personId INTEGER, gruppeId INTEGER)");
            this.statement.executeUpdate("create table if not exists personBefund (id  INTEGER PRIMARY KEY AUTOINCREMENT, created Date,changed Date,personId INTEGER,datum Date,ueberschrift TEXT,text TEXT");
            this.createBothDatabasesTables();
        }
        finally {
            this.closeConnection();
        }
    }

    public void createEmptyCoreDatabaseIfNotExists() throws SQLException, ClassNotFoundException {
        try {
            this.openCoreConnection();
            this.statement.executeUpdate("create table if not exists geodaten (id  INTEGER PRIMARY KEY AUTOINCREMENT, created Date,changed Date,lkz TEXT,plz TEXT,ort TEXT,land TEXT,kreis TEXT,name1 TEXT,code1 TEXT,name2 TEXT,code2 TEXT,name3 TEXT,code3 TEXT,latitude TEXT,longitude TEXT,timezoneId TEXT)");
            this.createBothDatabasesTables();
        }
        finally {
            this.closeConnection();
        }
    }

    private void createBothDatabasesTables() throws SQLException {
        this.statement.executeUpdate("create table if not exists Analyse (id  INTEGER PRIMARY KEY AUTOINCREMENT,  created Date,changed Date, horoskop TEXT, sort1 Integer, sort2 Integer,stufe1 INTEGER, stufe2 INTEGER, planet1 TEXT,planet2 TEXT,tkz1    TEXT, tkz2    TEXT,aspekt  TEXT,haus    TEXT,text1 TEXT,text2 TEXT, textkey TEXT)");
        this.statement.executeUpdate("create table if not exists AnalyseHerrscher (id  INTEGER PRIMARY KEY AUTOINCREMENT,  created Date,changed Date, horoskop TEXT,  herrscher TEXT, tkz TEXT, haus TEXT, textkey TEXT)");
        this.statement.executeUpdate("create table if not exists AnalyseSchluesselThema (id  INTEGER PRIMARY KEY AUTOINCREMENT,  created Date,changed Date, haus TEXT, sort INTEGER, doppelzeichen INTEGER, anzeigen INTEGER, ueberschrift INTEGER, frage TEXT, antwort TEXT, planeten TEXT, haeuser TEXT, tkzs TEXT, aspekte TEXT, herrscher TEXT)");
        this.statement.executeUpdate("create table if not exists Texte (id  INTEGER PRIMARY KEY AUTOINCREMENT,  created Date,changed Date, key TEXT, klasse TEXT, stufe Integer,url, TEXT, text TEXT)");
        this.statement.executeUpdate("create unique index Texte_Index1 on Texte(key, Klasse, Stufe)");
    }

    public IBusinessObject save(IBusinessObject bo) throws SQLException, ClassNotFoundException {
        if (bo instanceof Personendaten) {
            return this.save((Personendaten)bo);
        }
        if (bo instanceof Geodaten) {
            return this.save((Geodaten)bo);
        }
        if (bo instanceof Analyse) {
            return this.save((Analyse)bo, bo instanceof CoreAnalyse);
        }
        if (bo instanceof AnalyseHerrscher) {
            return this.save((AnalyseHerrscher)bo, bo instanceof CoreAnalyseHerrscher);
        }
        if (bo instanceof AnalyseSchluesselThema) {
            return this.save((AnalyseSchluesselThema)bo, bo instanceof CoreAnalyseSchluesselThema);
        }
        if (bo instanceof Texte) {
            return this.save((Texte)bo, bo instanceof CoreTexte);
        }
        if (bo instanceof Settings) {
            return this.save((Settings)bo);
        }
        if (bo instanceof Gruppe) {
            return this.save((Gruppe)bo);
        }
        if (bo instanceof PersonGruppe) {
            return this.save((PersonGruppe)bo);
        }
        if (bo instanceof PersonBefund) {
            return this.save((PersonBefund)bo);
        }
        return null;
    }

    public IBusinessObject update(IBusinessObject bo) throws SQLException, ClassNotFoundException {
        return this.save(bo);
    }

    public List<IBusinessObject> select(IBusinessObject bo) throws SQLException, ClassNotFoundException {
        if (bo instanceof Personendaten) {
            return this.select((Personendaten)bo);
        }
        if (bo instanceof Geodaten) {
            return this.select((Geodaten)bo);
        }
        if (bo instanceof Analyse) {
            return this.select((Analyse)bo, bo instanceof CoreAnalyse);
        }
        if (bo instanceof AnalyseHerrscher) {
            return this.select((AnalyseHerrscher)bo, bo instanceof CoreAnalyseHerrscher);
        }
        if (bo instanceof AnalyseSchluesselThema) {
            return this.select((AnalyseSchluesselThema)bo, bo instanceof CoreAnalyseSchluesselThema);
        }
        if (bo instanceof Texte) {
            return this.select((Texte)bo, bo instanceof CoreTexte);
        }
        if (bo instanceof Settings) {
            return this.select((Settings)bo);
        }
        if (bo instanceof Gruppe) {
            return this.select((Gruppe)bo);
        }
        if (bo instanceof PersonGruppe) {
            return this.select((PersonGruppe)bo);
        }
        return null;
    }

    public void delete(IBusinessObject bo) throws SQLException, ClassNotFoundException {
        if (bo instanceof Personendaten) {
            this.delete((Personendaten)bo);
        }
        if (bo instanceof Geodaten) {
            this.delete((Geodaten)bo);
        }
        if (bo instanceof Analyse) {
            this.delete((Analyse)bo, bo instanceof CoreAnalyse);
        }
        if (bo instanceof AnalyseHerrscher) {
            this.delete((AnalyseHerrscher)bo, bo instanceof CoreAnalyseHerrscher);
        }
        if (bo instanceof AnalyseSchluesselThema) {
            this.delete((AnalyseSchluesselThema)bo, bo instanceof CoreAnalyseSchluesselThema);
        }
        if (bo instanceof Texte) {
            this.delete((Texte)bo, bo instanceof Texte);
        }
        if (bo instanceof Settings) {
            this.delete((Settings)bo);
        }
        if (bo instanceof Gruppe) {
            this.delete((Gruppe)bo);
        }
        if (bo instanceof PersonGruppe) {
            this.delete((PersonGruppe)bo);
        }
        if (bo instanceof PersonBefund) {
            this.delete((PersonBefund)bo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLicense(byte[] bytearray) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("delete from License");
            int i = 1;
            String sql = "insert into license (licensekey) values(?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            pstmt.setBytes(i++, bytearray);
            pstmt.executeUpdate();
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] selectLicense() throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            ResultSet rs = this.statement.executeQuery("select * from License");
            if (rs.next()) {
                byte[] bytearray;
                int i = 1;
                byte[] byArray = bytearray = rs.getBytes(i++);
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.closeConnection();
        }
    }

    private void prepareSave(IBusinessObject obj) {
        Date d = new Date();
        obj.setChanged(d);
        if (obj.getCreated() == null) {
            obj.setCreated(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessObject save(Personendaten bo) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            this.openCustomConnection();
            Personendaten obj = bo;
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "Personendaten");
            sql = sql + "created, changed, vorname, nachname, geburtsdatumLocal, geburtszeitLocal, geburtsdatumUtc, geburtszeitUtc, geburtsdatum, timezoneId, gmtOffsetInMinutes,gmtOffsetManuell,geburtsortKontinent, geburtsortLkz, geburtsortPlz, geburtsort, geburtsortManuell, latitude,longitude,wohnortKontinent, wohnortLkz, wohnortPlz, wohnort,    wohnortManuell,wohnortLatitude,wohnortLongitude,aktuellKontinent, aktuellLkz, aktuellPlz, aktuellOrt, aktuellManuell,aktuellLatitude,aktuellLongitude,notiz, symptome, anschrift, anrede, telefon, handy, internet, email, url1, url2, url3, kontaktDurch, anonymeBezeichnung,vorgeschichte, empfehlung) values (";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?), ?,?,?,?,?,?, datetime(?),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setString(i++, obj.getVorname());
            pstmt.setString(i++, obj.getNachname());
            pstmt.setString(i++, obj.getGeburtsdatumLocal());
            pstmt.setString(i++, obj.getGeburtszeitLocal());
            pstmt.setString(i++, obj.getGeburtsdatumUtc());
            pstmt.setString(i++, obj.getGeburtszeitUtc());
            pstmt.setString(i++, Converter.timeToUtcSqlString(obj.getGeburtsdatum()));
            pstmt.setString(i++, obj.getTimezoneId());
            pstmt.setInt(i++, obj.getGmtOffsetInMinutes());
            pstmt.setBoolean(i++, obj.isGmtOffsetManuell());
            pstmt.setString(i++, obj.getGeburtsortKontinent());
            pstmt.setString(i++, obj.getGeburtsortLkz());
            pstmt.setString(i++, obj.getGeburtsortPlz());
            pstmt.setString(i++, obj.getGeburtsort());
            pstmt.setBoolean(i++, obj.isGeburtsortManuell());
            pstmt.setString(i++, obj.getLatitude());
            pstmt.setString(i++, obj.getLongitude());
            pstmt.setString(i++, obj.getWohnortKontinent());
            pstmt.setString(i++, obj.getWohnortLkz());
            pstmt.setString(i++, obj.getWohnortPlz());
            pstmt.setString(i++, obj.getWohnort());
            pstmt.setBoolean(i++, obj.isWohnortManuell());
            pstmt.setString(i++, obj.getWohnortLatitude());
            pstmt.setString(i++, obj.getWohnortLongitude());
            pstmt.setString(i++, obj.getAktuellKontinent());
            pstmt.setString(i++, obj.getAktuellLkz());
            pstmt.setString(i++, obj.getAktuellPlz());
            pstmt.setString(i++, obj.getAktuellOrt());
            pstmt.setBoolean(i++, obj.isAktuellManuell());
            pstmt.setString(i++, obj.getAktuellLatitude());
            pstmt.setString(i++, obj.getAktuellLongitude());
            pstmt.setString(i++, obj.getNotiz());
            pstmt.setString(i++, obj.getSymptome());
            pstmt.setString(i++, obj.getAnschrift());
            pstmt.setString(i++, obj.getAnrede());
            pstmt.setString(i++, obj.getTelefon());
            pstmt.setString(i++, obj.getHandy());
            pstmt.setString(i++, obj.getInternet());
            pstmt.setString(i++, obj.getEmail());
            pstmt.setString(i++, obj.getUrl1());
            pstmt.setString(i++, obj.getUrl2());
            pstmt.setString(i++, obj.getUrl3());
            pstmt.setString(i++, obj.getKontaktDurch());
            pstmt.setString(i++, obj.getAnonymeBezeichnung());
            pstmt.setString(i++, obj.getVorgeschichte());
            pstmt.setString(i++, obj.getEmpfehlung());
            pstmt.executeUpdate();
            if (obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from personendaten")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            Personendaten personendaten = bo;
            return personendaten;
        }
        finally {
            this.closeConnection();
        }
    }

    public void setDbSicherung() throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("update settings set letzteSicherung = datetime('now','localtime')");
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbVersion saveDbVersion(DbVersion obj) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            this.openCustomConnection();
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "dbVersion");
            sql = sql + "created, changed, dbVersion) values (";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?), ?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setInt(i++, obj.getDbVersion());
            pstmt.executeUpdate();
            if (obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from dbVersion")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            DbVersion dbVersion = obj;
            return dbVersion;
        }
        finally {
            this.closeConnection();
        }
    }

    public IBusinessObject save(Geodaten bo) throws SQLException, ClassNotFoundException {
        return this.save(bo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessObject save(Geodaten bo, boolean fast) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            this.openCoreConnection();
            Geodaten obj = bo;
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "Geodaten");
            sql = sql + "created, changed, lkz, plz, ort, land, kreis, name1, code1, name2, code2, name3, code3, latitude, longitude,timezoneId) values(";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?), ?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setString(i++, obj.getLkz());
            pstmt.setString(i++, obj.getPlz());
            pstmt.setString(i++, obj.getOrt());
            pstmt.setString(i++, obj.getLand());
            pstmt.setString(i++, obj.getKreis());
            pstmt.setString(i++, obj.getName1());
            pstmt.setString(i++, obj.getCode1());
            pstmt.setString(i++, obj.getName2());
            pstmt.setString(i++, obj.getCode2());
            pstmt.setString(i++, obj.getName3());
            pstmt.setString(i++, obj.getCode3());
            pstmt.setString(i++, obj.getLatitude());
            pstmt.setString(i++, obj.getLongitude());
            pstmt.setString(i++, obj.getTimezoneId());
            pstmt.setInt(i++, obj.getGmtOffsetInMinutes());
            pstmt.executeUpdate();
            if (!fast && obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from Geodaten")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            Geodaten geodaten = bo;
            return geodaten;
        }
        finally {
            this.closeConnection();
        }
    }

    public void preBulkSaveGeodaten() throws SQLException, ClassNotFoundException {
        this.openCoreConnection();
        String sql = this.getInsertOrReplace(null, "Geodaten");
        sql = sql + "id, created, changed, lkz, plz, ort, land, kreis, name1, code1, name2, code2, name3, code3, latitude, longitude,timezoneId) values(";
        sql = sql + "?,datetime(?), datetime(?), ?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        this.geoDatenPstmt = this.connection.prepareStatement(sql);
    }

    public void bulkSaveGeodaten(Geodaten obj) throws SQLException, ClassNotFoundException {
        this.prepareSave(obj);
        int i = 1;
        this.geoDatenPstmt.setInt(i++, obj.getId());
        this.geoDatenPstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
        this.geoDatenPstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
        this.geoDatenPstmt.setString(i++, obj.getLkz());
        this.geoDatenPstmt.setString(i++, obj.getPlz());
        this.geoDatenPstmt.setString(i++, obj.getOrt());
        this.geoDatenPstmt.setString(i++, obj.getLand());
        this.geoDatenPstmt.setString(i++, obj.getKreis());
        this.geoDatenPstmt.setString(i++, obj.getName1());
        this.geoDatenPstmt.setString(i++, obj.getCode1());
        this.geoDatenPstmt.setString(i++, obj.getName2());
        this.geoDatenPstmt.setString(i++, obj.getCode2());
        this.geoDatenPstmt.setString(i++, obj.getName3());
        this.geoDatenPstmt.setString(i++, obj.getCode3());
        this.geoDatenPstmt.setString(i++, obj.getLatitude());
        this.geoDatenPstmt.setString(i++, obj.getLongitude());
        this.geoDatenPstmt.setString(i++, obj.getTimezoneId());
        this.geoDatenPstmt.executeUpdate();
    }

    public void postBulkSaveGeodaten() {
        this.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessObject save(Analyse bo, boolean core) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            Analyse obj = bo;
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "Analyse");
            sql = sql + "created, changed, horoskop, sort1,sort2, stufe1, stufe2,planet1, planet2, tkz1, tkz2, aspekt, haus, text1, text2, textkey) values(";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?), ?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setString(i++, obj.getHoroskop());
            pstmt.setInt(i++, obj.getSort1());
            pstmt.setInt(i++, obj.getSort2());
            pstmt.setInt(i++, obj.getStufe1());
            pstmt.setInt(i++, obj.getStufe2());
            pstmt.setString(i++, obj.getPlanet1());
            pstmt.setString(i++, obj.getPlanet2());
            pstmt.setString(i++, obj.getTkz1());
            pstmt.setString(i++, obj.getTkz2());
            pstmt.setString(i++, obj.getAspekt());
            pstmt.setString(i++, obj.getHaus());
            pstmt.setString(i++, obj.getText1());
            pstmt.setString(i++, obj.getText2());
            pstmt.setString(i++, obj.getTextkey());
            pstmt.executeUpdate();
            if (obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from analyse")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            Analyse analyse = bo;
            return analyse;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessObject save(AnalyseHerrscher bo, boolean core) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            AnalyseHerrscher obj = bo;
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "AnalyseHerrscher");
            sql = sql + "created, changed, horoskop, herrscher, tkz, haus, textkey) values(";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?), ?,?,?,?,?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setString(i++, obj.getHoroskop());
            pstmt.setString(i++, obj.getHerrscher());
            pstmt.setString(i++, obj.getTkz());
            pstmt.setString(i++, obj.getHaus());
            pstmt.setString(i++, obj.getTextkey());
            pstmt.executeUpdate();
            if (obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from analyseHerrscher")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            AnalyseHerrscher analyseHerrscher = bo;
            return analyseHerrscher;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessObject save(AnalyseSchluesselThema bo, boolean core) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            AnalyseSchluesselThema obj = bo;
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "AnalyseSchluesselThema");
            sql = sql + " created, changed, haus, sort, doppelzeichen, anzeigen, ueberschrift, frage, antwort, planeten, haeuser, tkzs, aspekte, herrscher) values (";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?),?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setString(i++, obj.getHaus());
            pstmt.setInt(i++, obj.getSort());
            pstmt.setInt(i++, obj.getDoppelzeichen());
            pstmt.setBoolean(i++, obj.isAnzeigen());
            pstmt.setBoolean(i++, obj.isUeberschrift());
            pstmt.setString(i++, obj.getFrage());
            pstmt.setString(i++, obj.getAntwort());
            pstmt.setString(i++, obj.getPlaneten());
            pstmt.setString(i++, obj.getHaeuser());
            pstmt.setString(i++, obj.getTkzs());
            pstmt.setString(i++, obj.getAspekte());
            pstmt.setString(i++, obj.getHerrscher());
            pstmt.executeUpdate();
            if (obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from AnalyseSchluesselThema")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            AnalyseSchluesselThema analyseSchluesselThema = bo;
            return analyseSchluesselThema;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessObject save(Texte bo, boolean core) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            Texte obj = bo;
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "Texte");
            sql = sql + " created, changed, key, stufe, klasse, url, text) values (";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?),?,?,?,?,?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setString(i++, obj.getKey());
            pstmt.setInt(i++, obj.getStufe());
            pstmt.setString(i++, obj.getKlasse());
            pstmt.setString(i++, obj.getUrl());
            pstmt.setString(i++, obj.getText());
            int n = pstmt.executeUpdate();
            if (obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from Texte")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            Texte texte = bo;
            return texte;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessObject save(Gruppe bo) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            this.openCustomConnection();
            Gruppe obj = bo;
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "Gruppe");
            sql = sql + "created, changed, name, beschreibung) values(";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?), ?,?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setString(i++, obj.getName());
            pstmt.setString(i++, obj.getBeschreibung());
            pstmt.executeUpdate();
            if (obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from Gruppe")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            Gruppe gruppe = bo;
            return gruppe;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessObject save(PersonGruppe bo) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            this.openCustomConnection();
            PersonGruppe obj = bo;
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "PersonGruppe");
            sql = sql + "created, changed, personId, gruppeId) values(";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?), ?,?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setInt(i++, obj.getPersonId());
            pstmt.setInt(i++, obj.getGruppeId());
            pstmt.executeUpdate();
            if (obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from PersonGruppe")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            PersonGruppe personGruppe = bo;
            return personGruppe;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessObject save(PersonBefund bo) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            this.openCustomConnection();
            PersonBefund obj = bo;
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "PersonBefund");
            sql = sql + "created, changed, personId, datum, ueberschrift, text) values(";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?), ?, ?,?,?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setInt(i++, obj.getPersonId());
            pstmt.setString(i++, Converter.timeToSqlString(obj.getDatum()));
            pstmt.setString(i++, obj.getUeberschrift());
            pstmt.setString(i++, obj.getText());
            pstmt.executeUpdate();
            if (obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from PersonBefund")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            PersonBefund personBefund = bo;
            return personBefund;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBusinessObject save(Settings bo) throws SQLException, ClassNotFoundException {
        try {
            ResultSet rs;
            this.openCustomConnection();
            Settings obj = bo;
            this.prepareSave(obj);
            String sql = this.getInsertOrReplace(obj, "Settings");
            sql = sql + "created, changed, name, adresse1, adresse2, adresse3, adresse4, email, kopfzeile, kopfzeileKurz, fusszeile, kontinent, lkz, webservice,haussystem, gradzahlen, zwischenskala, jahresring, zeiger,zweiterAcMc,reporttypId,lineWidth,orbisArrayString, interOrbisArrayString,konjunktion,sextil,quadrat,trigon,opposition,horoskop1, horoskop2, aspekte1, aspekte2, interAspekte,iconTypeId, iconSizeId, backupDir, texteDir, workingDir, logoFile,automatischeSicherung, sicherungTage,letzteSicherung,stufe1, stufe2, eigeneAnalysetexte,steuersatz,header1,header2,header3,absender,betreff,rechnungsdaten,rechnungsnummer,text1,text2,text3,footer1,footer2,footer3,rand1,rand2,rand3) values(";
            if (obj.getId() != 0) {
                sql = sql + "?,";
            }
            sql = sql + "datetime(?), datetime(?), ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            int i = 1;
            if (obj.getId() != 0) {
                pstmt.setInt(i++, obj.getId());
            }
            pstmt.setString(i++, Converter.timeToSqlString(obj.getCreated()));
            pstmt.setString(i++, Converter.timeToSqlString(obj.getChanged()));
            pstmt.setString(i++, obj.getName());
            pstmt.setString(i++, obj.getAdresse1());
            pstmt.setString(i++, obj.getAdresse2());
            pstmt.setString(i++, obj.getAdresse3());
            pstmt.setString(i++, obj.getAdresse4());
            pstmt.setString(i++, obj.getEmail());
            pstmt.setString(i++, obj.getKopfzeile());
            pstmt.setString(i++, obj.getKopfzeileKurz());
            pstmt.setString(i++, obj.getFusszeile());
            pstmt.setString(i++, obj.getKontinent());
            pstmt.setString(i++, obj.getLkz());
            pstmt.setBoolean(i++, obj.isWebservice());
            pstmt.setString(i++, obj.getHaussystem());
            pstmt.setBoolean(i++, obj.isGradzahlen());
            pstmt.setBoolean(i++, obj.isZwischenskala());
            pstmt.setBoolean(i++, obj.isJahresring());
            pstmt.setBoolean(i++, obj.isZeiger());
            pstmt.setBoolean(i++, obj.isZweiterAcMc());
            pstmt.setInt(i++, obj.getReporttypId());
            pstmt.setInt(i++, obj.getLineWidth());
            pstmt.setString(i++, obj.getOrbisArrayString());
            pstmt.setString(i++, obj.getInterOrbisArrayString());
            pstmt.setBoolean(i++, obj.isKonjunktion());
            pstmt.setBoolean(i++, obj.isSextil());
            pstmt.setBoolean(i++, obj.isQuadrat());
            pstmt.setBoolean(i++, obj.isTrigon());
            pstmt.setBoolean(i++, obj.isOpposition());
            pstmt.setBoolean(i++, obj.isHoroskop1());
            pstmt.setBoolean(i++, obj.isHoroskop2());
            pstmt.setBoolean(i++, obj.isAspekte1());
            pstmt.setBoolean(i++, obj.isAspekte2());
            pstmt.setBoolean(i++, obj.isInterAspekte());
            pstmt.setInt(i++, obj.getIconTypeId());
            pstmt.setInt(i++, obj.getIconSizeId());
            pstmt.setString(i++, obj.getBackupDir());
            pstmt.setString(i++, obj.getTexteDir());
            pstmt.setString(i++, obj.getWorkingDir());
            pstmt.setString(i++, obj.getLogoFile());
            pstmt.setBoolean(i++, obj.isAutomatischeSicherung());
            pstmt.setInt(i++, obj.getSicherungTage());
            pstmt.setString(i++, Converter.dateToSqlString(obj.getLetzteSicherung()));
            pstmt.setInt(i++, obj.getStufe1());
            pstmt.setInt(i++, obj.getStufe2());
            pstmt.setBoolean(i++, obj.isEigeneAnalysetexte());
            pstmt.setInt(i++, obj.getSteuersatz());
            pstmt.setString(i++, obj.getHeader1());
            pstmt.setString(i++, obj.getHeader2());
            pstmt.setString(i++, obj.getHeader3());
            pstmt.setString(i++, obj.getAbsender());
            pstmt.setString(i++, obj.getBetreff());
            pstmt.setString(i++, obj.getRechnungsdaten());
            pstmt.setString(i++, obj.getRechnungsnummer());
            pstmt.setString(i++, obj.getText1());
            pstmt.setString(i++, obj.getText2());
            pstmt.setString(i++, obj.getText3());
            pstmt.setString(i++, obj.getFooter1());
            pstmt.setString(i++, obj.getFooter2());
            pstmt.setString(i++, obj.getFooter3());
            pstmt.setString(i++, obj.getRand1());
            pstmt.setString(i++, obj.getRand2());
            pstmt.setString(i++, obj.getRand3());
            pstmt.executeUpdate();
            if (obj.getId() == 0 && (rs = (pstmt = this.connection.prepareStatement(sql = "select max(id) as anz from Settings")).executeQuery()).next()) {
                int id = rs.getInt("anz");
                obj.setId(id);
            }
            Settings settings = bo;
            return settings;
        }
        finally {
            this.closeConnection();
        }
    }

    public void update(Personendaten obj) throws SQLException, ClassNotFoundException {
        this.save(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> selectDbVersion() throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            ResultSet rs = this.statement.executeQuery("select * from DbVersion");
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                DbVersion p = new DbVersion();
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setDbVersion(rs.getInt("dbVersion"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> selectOld(Personendaten bo) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            Personendaten filter = bo;
            String where = "";
            where = Util.addFilter(where, "vorname", "like", Formatter.dependingOnSecondString("%", filter.getVorname()));
            where = Util.addFilter(where, "nachname", "like", Formatter.dependingOnSecondString("%", filter.getNachname()));
            where = Util.addOrFilter(where, "geburtsort", "wohnort", "aktuellOrt", "", "like", Formatter.dependingOnSecondString("%", filter.getGeburtsort()));
            where = Util.addFilter(where, "notiz", "like", Formatter.dependingOnSecondString("%", filter.getNotiz()));
            where = Util.addFilter(where, "symptome", "like", Formatter.dependingOnSecondString("%", filter.getSymptome()));
            where = Util.addFilter(where, "anschrift", "like", Formatter.dependingOnSecondString("%", filter.getAnschrift()));
            where = Util.addFilter(where, "anrede", "like", Formatter.dependingOnSecondString("%", filter.getAnrede()));
            where = Util.addFilter(where, "telefon", "like", Formatter.dependingOnSecondString("%", filter.getTelefon()));
            where = Util.addFilter(where, "handy", "like", Formatter.dependingOnSecondString("%", filter.getHandy()));
            where = Util.addFilter(where, "internet", "like", Formatter.dependingOnSecondString("%", filter.getInternet()));
            where = Util.addFilter(where, "email", "like", Formatter.dependingOnSecondString("%", filter.getEmail()));
            where = Util.addFilter(where, "timezoneId", "like", Formatter.dependingOnSecondString("%", filter.getTimezoneId()));
            String sql = "select distinct p.* from personendaten p ";
            if (!Util.isEmpty(filter.getFilterGruppe())) {
                sql = sql + "join personGruppe pg on pg.personId = p.id join Gruppe g on pg.gruppeId = g.id and g.name='" + filter.getFilterGruppe() + "'";
            }
            ResultSet rs = this.statement.executeQuery(sql + " " + where + " order by p.nachname, p.id desc");
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                Personendaten p = new Personendaten();
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setVorname(rs.getString("vorname"));
                p.setNachname(rs.getString("nachname"));
                p.setGeburtsdatumLocal(rs.getString("geburtsdatumLocal"));
                p.setGeburtszeitLocal(rs.getString("geburtszeitLocal"));
                p.setGeburtsdatumUtc(rs.getString("geburtsdatumUtc"));
                p.setGeburtszeitUtc(rs.getString("geburtszeitUtc"));
                String geburtsdatum = rs.getString("geburtsdatum");
                p.setGeburtsdatum(Converter.stringToDate(rs.getString("geburtsdatum")));
                p.setTimezoneId(rs.getString("timezoneId"));
                Date gd = Converter.stringToUtcDate(geburtsdatum);
                p.setGeburtsdatum(gd);
                p.setGmtOffsetInMinutes(rs.getInt("gmtOffsetInMinutes"));
                p.setGmtOffsetManuell(rs.getBoolean("gmtOffsetManuell"));
                p.setGeburtsortKontinent(rs.getString("geburtsortKontinent"));
                p.setGeburtsortLkz(rs.getString("geburtsortLkz"));
                p.setGeburtsortPlz(rs.getString("geburtsortPlz"));
                p.setGeburtsort(rs.getString("geburtsort"));
                p.setGeburtsortManuell(rs.getBoolean("geburtsortManuell"));
                p.setLongitude(rs.getString("longitude"));
                p.setLatitude(rs.getString("latitude"));
                p.setWohnortKontinent(rs.getString("wohnortKontinent"));
                p.setWohnortLkz(rs.getString("wohnortLkz"));
                p.setWohnortPlz(rs.getString("wohnortPlz"));
                p.setWohnort(rs.getString("wohnort"));
                p.setWohnortManuell(rs.getBoolean("wohnortManuell"));
                p.setWohnortLongitude(rs.getString("wohnortLongitude"));
                p.setWohnortLatitude(rs.getString("wohnortLatitude"));
                p.setAktuellKontinent(rs.getString("aktuellKontinent"));
                p.setAktuellLkz(rs.getString("aktuellLkz"));
                p.setAktuellPlz(rs.getString("aktuellPlz"));
                p.setAktuellOrt(rs.getString("aktuellOrt"));
                p.setAktuellManuell(rs.getBoolean("aktuellManuell"));
                p.setAktuellLongitude(rs.getString("aktuellLongitude"));
                p.setAktuellLatitude(rs.getString("aktuellLatitude"));
                p.setNotiz(rs.getString("notiz"));
                p.setSymptome(rs.getString("symptome"));
                p.setAnschrift(rs.getString("anschrift"));
                p.setTelefon(rs.getString("telefon"));
                p.setHandy(rs.getString("handy"));
                p.setInternet(rs.getString("internet"));
                p.setEmail(rs.getString("email"));
                p.setUrl1(rs.getString("url1"));
                p.setUrl2(rs.getString("url2"));
                p.setUrl3(rs.getString("url3"));
                p.setKontaktDurch(rs.getString("kontaktDurch"));
                p.setAnonymeBezeichnung(rs.getString("anonymeBezeichnung"));
                p.setVorgeschichte(rs.getString("vorgeschichte"));
                p.setEmpfehlung(rs.getString("empfehlung"));
                List<PersonGruppe> lg = this.selectPersonGruppe(p);
                p.setPersonGruppeList(lg);
                PersonBefund pb = new PersonBefund();
                pb.setPersonId(p.getId());
                List<PersonBefund> lb = this.select(pb);
                p.setPersonBefundList(lb);
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> select(Personendaten bo) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            Personendaten filter = bo;
            String where = "";
            where = Util.addFilter(where, "id", "=", filter.getId());
            where = Util.addFilter(where, "vorname", "like", Formatter.dependingOnSecondString("%", filter.getVorname()));
            where = Util.addFilter(where, "nachname", "like", Formatter.dependingOnSecondString("%", filter.getNachname()));
            where = Util.addOrFilter(where, "geburtsort", "wohnort", "aktuellOrt", "", "like", Formatter.dependingOnSecondString("%", filter.getGeburtsort()));
            where = Util.addFilter(where, "notiz", "like", Formatter.dependingOnSecondString("%", filter.getNotiz()));
            where = Util.addFilter(where, "symptome", "like", Formatter.dependingOnSecondString("%", filter.getSymptome()));
            where = Util.addFilter(where, "anschrift", "like", Formatter.dependingOnSecondString("%", filter.getAnschrift()));
            where = Util.addFilter(where, "telefon", "like", Formatter.dependingOnSecondString("%", filter.getTelefon()));
            where = Util.addFilter(where, "handy", "like", Formatter.dependingOnSecondString("%", filter.getHandy()));
            where = Util.addFilter(where, "internet", "like", Formatter.dependingOnSecondString("%", filter.getInternet()));
            where = Util.addFilter(where, "email", "like", Formatter.dependingOnSecondString("%", filter.getEmail()));
            where = Util.addFilter(where, "timezoneId", "like", Formatter.dependingOnSecondString("%", filter.getTimezoneId()));
            String sql = "select distinct p.* from personendaten p ";
            if (!Util.isEmpty(filter.getFilterGruppe())) {
                sql = sql + "join personGruppe pg on pg.personId = p.id join Gruppe g on pg.gruppeId = g.id and g.name='" + filter.getFilterGruppe() + "'";
            }
            ResultSet rs = this.statement.executeQuery(sql + " " + where + " order by p.nachname, p.id desc");
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                Personendaten p = new Personendaten();
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setVorname(rs.getString("vorname"));
                p.setNachname(rs.getString("nachname"));
                p.setGeburtsdatumLocal(rs.getString("geburtsdatumLocal"));
                p.setGeburtszeitLocal(rs.getString("geburtszeitLocal"));
                p.setGeburtsdatumUtc(rs.getString("geburtsdatumUtc"));
                p.setGeburtszeitUtc(rs.getString("geburtszeitUtc"));
                String geburtsdatum = rs.getString("geburtsdatum");
                p.setGeburtsdatum(Converter.stringToDate(rs.getString("geburtsdatum")));
                p.setTimezoneId(rs.getString("timezoneId"));
                Date gd = Converter.stringToUtcDate(geburtsdatum);
                p.setGeburtsdatum(gd);
                p.setGmtOffsetInMinutes(rs.getInt("gmtOffsetInMinutes"));
                p.setGmtOffsetManuell(rs.getBoolean("gmtOffsetManuell"));
                p.setGeburtsortKontinent(rs.getString("geburtsortKontinent"));
                p.setGeburtsortLkz(rs.getString("geburtsortLkz"));
                p.setGeburtsortPlz(rs.getString("geburtsortPlz"));
                p.setGeburtsort(rs.getString("geburtsort"));
                p.setGeburtsortManuell(rs.getBoolean("geburtsortManuell"));
                p.setLongitude(rs.getString("longitude"));
                p.setLatitude(rs.getString("latitude"));
                p.setWohnortKontinent(rs.getString("wohnortKontinent"));
                p.setWohnortLkz(rs.getString("wohnortLkz"));
                p.setWohnortPlz(rs.getString("wohnortPlz"));
                p.setWohnort(rs.getString("wohnort"));
                p.setWohnortManuell(rs.getBoolean("wohnortManuell"));
                p.setWohnortLongitude(rs.getString("wohnortLongitude"));
                p.setWohnortLatitude(rs.getString("wohnortLatitude"));
                p.setAktuellKontinent(rs.getString("aktuellKontinent"));
                p.setAktuellLkz(rs.getString("aktuellLkz"));
                p.setAktuellPlz(rs.getString("aktuellPlz"));
                p.setAktuellOrt(rs.getString("aktuellOrt"));
                p.setAktuellManuell(rs.getBoolean("aktuellManuell"));
                p.setAktuellLongitude(rs.getString("aktuellLongitude"));
                p.setAktuellLatitude(rs.getString("aktuellLatitude"));
                p.setNotiz(rs.getString("notiz"));
                p.setSymptome(rs.getString("symptome"));
                p.setAnschrift(rs.getString("anschrift"));
                p.setAnrede(rs.getString("anrede"));
                p.setTelefon(rs.getString("telefon"));
                p.setHandy(rs.getString("handy"));
                p.setInternet(rs.getString("internet"));
                p.setEmail(rs.getString("email"));
                p.setUrl1(rs.getString("url1"));
                p.setUrl2(rs.getString("url2"));
                p.setUrl3(rs.getString("url3"));
                p.setKontaktDurch(rs.getString("kontaktDurch"));
                p.setAnonymeBezeichnung(rs.getString("anonymeBezeichnung"));
                p.setVorgeschichte(rs.getString("vorgeschichte"));
                p.setEmpfehlung(rs.getString("empfehlung"));
                List<PersonGruppe> lg = this.selectPersonGruppe(p);
                p.setPersonGruppeList(lg);
                PersonBefund pb = new PersonBefund();
                pb.setPersonId(p.getId());
                List<PersonBefund> lb = this.select(pb);
                p.setPersonBefundList(lb);
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> select(Geodaten bo) throws SQLException, ClassNotFoundException {
        try {
            this.openCoreConnection();
            Geodaten filter = bo;
            String where = "";
            where = Util.addFilter(where, "lkz", "like", filter.getLkz());
            where = Util.addFilter(where, "plz", "like", filter.getPlz());
            where = Util.addFilter(where, "ort", "like", filter.getOrt());
            where = Util.addFilter(where, "land", "like", filter.getLand());
            where = Util.addFilter(where, "kreis", "like", filter.getKreis());
            where = Util.addFilter(where, "name1", "like", filter.getName1());
            where = Util.addFilter(where, "code1", "like", filter.getCode1());
            where = Util.addFilter(where, "name2", "like", filter.getName2());
            where = Util.addFilter(where, "code2", "like", filter.getCode2());
            where = Util.addFilter(where, "name3", "like", filter.getName3());
            where = Util.addFilter(where, "code3", "like", filter.getCode3());
            where = Util.addFilter(where, "latitude", "like", filter.getLatitude());
            where = Util.addFilter(where, "longitude", "like", filter.getLongitude());
            where = Util.addFilter(where, "timezoneId", "like", filter.getTimezoneId());
            ResultSet rs = this.statement.executeQuery("select * from geodaten " + where + " limit 1000");
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                Geodaten p = new Geodaten();
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setLkz(rs.getString("lkz"));
                p.setPlz(rs.getString("plz"));
                p.setOrt(rs.getString("ort"));
                p.setLand(rs.getString("land"));
                p.setKreis(rs.getString("kreis"));
                p.setName1(rs.getString("name1"));
                p.setCode1(rs.getString("code1"));
                p.setName2(rs.getString("name2"));
                p.setCode2(rs.getString("code2"));
                p.setName3(rs.getString("name3"));
                p.setCode3(rs.getString("code3"));
                p.setLongitude(rs.getString("longitude"));
                p.setLatitude(rs.getString("latitude"));
                p.setTimezoneId(rs.getString("timezoneId"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxGeodatenId() throws SQLException, ClassNotFoundException {
        try {
            int maxId = 0;
            this.openCoreConnection();
            ResultSet rs = this.statement.executeQuery("select max(id) as max from geodaten");
            ArrayList list = new ArrayList();
            while (rs.next()) {
                Geodaten p = new Geodaten();
                maxId = rs.getInt("max");
            }
            this.statement.close();
            this.connection.close();
            int n = maxId;
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> select(Analyse bo, boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            Analyse filter = bo;
            String where = "";
            where = Util.addFilter(where, "horoskop", "like", filter.getHoroskop());
            where = Util.addFilter(where, "sort1", "=", filter.getSort1());
            where = Util.addFilter(where, "sort2", "=", filter.getSort2());
            where = Util.addFilter(where, "stufe1", "<=", filter.getStufe1());
            where = Util.addFilter(where, "stufe2", "<=", filter.getStufe2());
            where = Util.addFilter(where, "planet1", "like", filter.getPlanet1());
            where = Util.addFilter(where, "planet2", "like", filter.getPlanet2());
            where = Util.addFilter(where, "tkz1", "like", filter.getTkz1());
            where = Util.addFilter(where, "tkz2", "like", filter.getTkz2());
            where = Util.addFilter(where, "aspekt", "like", filter.getAspekt());
            where = Util.addFilter(where, "haus", "=", filter.getHaus());
            where = Util.addFilter(where, "text1", "like", Formatter.dependingOnSecondString("%", filter.getText1()));
            where = Util.addFilter(where, "text2", "like", Formatter.dependingOnSecondString("%", filter.getText2()));
            where = Util.addFilter(where, "textkey", "=", filter.getTextkey());
            ResultSet rs = this.statement.executeQuery("select * from analyse " + where + " order by text1,sort1,sort2");
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                Analyse p = Analyse.newInstance(core);
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setHoroskop(rs.getString("horoskop"));
                p.setSort1(rs.getInt("sort1"));
                p.setSort2(rs.getInt("sort2"));
                p.setStufe1(rs.getInt("stufe1"));
                p.setStufe2(rs.getInt("stufe2"));
                p.setPlanet1(rs.getString("planet1"));
                p.setPlanet2(rs.getString("planet2"));
                p.setTkz1(rs.getString("tkz1"));
                p.setTkz2(rs.getString("tkz2"));
                p.setAspekt(rs.getString("aspekt"));
                p.setHaus(rs.getString("haus"));
                p.setText1(rs.getString("text1"));
                p.setText2(rs.getString("text2"));
                p.setTextkey(rs.getString("textkey"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> select(AnalyseHerrscher bo, boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            AnalyseHerrscher filter = bo;
            String where = "";
            where = Util.addFilter(where, "horoskop", "like", filter.getHoroskop());
            where = Util.addFilter(where, "herrscher", "like", filter.getHerrscher());
            where = Util.addFilter(where, "tkz", "like", filter.getTkz());
            where = Util.addFilter(where, "haus", "=", filter.getHaus());
            where = Util.addFilter(where, "textkey", "=", filter.getTextkey());
            ResultSet rs = this.statement.executeQuery("select * from analyseHerrscher " + where + " order by horoskop,herrscher");
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                AnalyseHerrscher p = AnalyseHerrscher.newInstance(core);
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setHoroskop(rs.getString("horoskop"));
                p.setHerrscher(rs.getString("herrscher"));
                p.setTkz(rs.getString("tkz"));
                p.setHaus(rs.getString("haus"));
                p.setTextkey(rs.getString("textkey"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTextkey(Analyse bo, boolean core) throws SQLException, ClassNotFoundException {
        try {
            String string;
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            Analyse filter = bo;
            String where = "";
            String p1 = filter.getPlanet1();
            String p2 = filter.getPlanet2();
            where = Util.addForceFilter(where, "horoskop", "=", filter.getHoroskop());
            where = Util.addForceFilter(where, "tkz1", "=", filter.getTkz1());
            where = Util.addForceFilter(where, "tkz2", "=", filter.getTkz2());
            where = Util.addForceFilter(where, "aspekt", "=", filter.getAspekt());
            where = Util.addForceFilter(where, "haus", "=", filter.getHaus());
            where = Util.addFilterCondition(where, "((planet1 = '" + p1 + "' and planet2 = '" + p2 + "') or (planet1 = '" + p2 + "' and planet2 = '" + p1 + "'))");
            where = Util.addForceFilter(where, "text1", "=", filter.getText1());
            String sql = "select * from analyse " + where + " order by stufe1 desc, stufe2 desc";
            ResultSet rs = this.statement.executeQuery(sql);
            ArrayList<Analyse> list = new ArrayList<Analyse>();
            if (rs.next()) {
                Analyse p = Analyse.newInstance(core);
                p.setId(rs.getInt("id"));
                p.setSort1(rs.getInt("sort1"));
                p.setSort2(rs.getInt("sort2"));
                p.setStufe1(rs.getInt("stufe1"));
                p.setStufe2(rs.getInt("stufe2"));
                p.setTextkey(rs.getString("textkey"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            if (list != null && list.size() > 0) {
                string = ((Analyse)list.get(0)).getTextkey();
                return string;
            }
            string = null;
            return string;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTextkey(AnalyseHerrscher bo, boolean core) throws SQLException, ClassNotFoundException {
        try {
            String string;
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            AnalyseHerrscher filter = bo;
            String where = "";
            where = Util.addForceFilter(where, "horoskop", "=", bo.getHoroskop());
            where = Util.addForceFilter(where, "herrscher", "=", filter.getHerrscher());
            where = Util.addForceFilter(where, "tkz", "=", filter.getTkz());
            where = Util.addForceFilter(where, "haus", "=", filter.getHaus());
            String sql = "select * from analyseHerrscher " + where;
            ResultSet rs = this.statement.executeQuery(sql);
            ArrayList<AnalyseHerrscher> list = new ArrayList<AnalyseHerrscher>();
            if (rs.next()) {
                AnalyseHerrscher p = AnalyseHerrscher.newInstance(core);
                p.setId(rs.getInt("id"));
                p.setHoroskop(rs.getString("horoskop"));
                p.setHerrscher(rs.getString("herrscher"));
                p.setTkz(rs.getString("tkz"));
                p.setTextkey(rs.getString("textkey"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            if (list != null && list.size() > 0) {
                string = ((AnalyseHerrscher)list.get(0)).getTextkey();
                return string;
            }
            string = null;
            return string;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> select(AnalyseSchluesselThema bo, boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            AnalyseSchluesselThema filter = bo;
            String where = "";
            where = Util.addFilter(where, "haus", "=", filter.getHaus());
            where = Util.addFilter(where, "sort", "=", filter.getSort());
            where = Util.addFilter(where, "doppelzeichen", "=", filter.getDoppelzeichen());
            where = Util.addFilter(where, "anzeigen", "=", filter.isAnzeigen());
            where = Util.addFilter(where, "ueberschrift", "=", filter.isUeberschrift());
            where = Util.addFilter(where, "frage", "like", Formatter.dependingOnSecondString("%", filter.getFrage()));
            where = Util.addFilter(where, "antwort", "like", Formatter.dependingOnSecondString("%", filter.getAntwort()));
            where = Util.addFilter(where, "planeten", "like", Formatter.dependingOnSecondString("%", filter.getPlaneten()));
            where = Util.addFilter(where, "haeuser", "like", Formatter.dependingOnSecondString("%", filter.getHaeuser()));
            where = Util.addFilter(where, "tkzs", "like", Formatter.dependingOnSecondString("%", filter.getTkzs()));
            where = Util.addFilter(where, "aspekte", "like", Formatter.dependingOnSecondString("%", filter.getAspekte()));
            where = Util.addFilter(where, "herrscher", "like", Formatter.dependingOnSecondString("%", filter.getHerrscher()));
            ResultSet rs = this.statement.executeQuery("select * from analyseSchluesselThema " + where + " order by haus,sort");
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                AnalyseSchluesselThema p = AnalyseSchluesselThema.newInstance(core);
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setHaus(rs.getString("haus"));
                p.setSort(rs.getInt("sort"));
                p.setDoppelzeichen(rs.getInt("doppelzeichen"));
                p.setAnzeigen(rs.getBoolean("anzeigen"));
                p.setUeberschrift(rs.getBoolean("ueberschrift"));
                p.setFrage(rs.getString("frage"));
                p.setAntwort(rs.getString("antwort"));
                p.setPlaneten(rs.getString("planeten"));
                p.setHaeuser(rs.getString("haeuser"));
                p.setTkzs(rs.getString("tkzs"));
                p.setAspekte(rs.getString("aspekte"));
                p.setHerrscher(rs.getString("herrscher"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> select(Texte bo, boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            Texte filter = bo;
            String where = "";
            where = Util.addFilter(where, "key", "=", filter.getKey());
            where = Util.addFilter(where, "stufe", "=", filter.getStufe());
            where = Util.addFilter(where, "klasse", "=", filter.getKlasse());
            where = Util.addFilter(where, "url", "like", Formatter.dependingOnSecondString("%", filter.getUrl()));
            where = Util.addFilter(where, "text", "like", Formatter.dependingOnSecondString("%", filter.getText()));
            ResultSet rs = this.statement.executeQuery("select * from Texte " + where + " order by key, klasse, stufe");
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                Texte p = Texte.newInstance(core);
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setKey(rs.getString("key"));
                p.setKlasse(rs.getString("klasse"));
                p.setStufe(rs.getInt("stufe"));
                p.setUrl(rs.getString("url"));
                p.setText(rs.getString("text"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> select(Gruppe bo) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            Gruppe filter = bo;
            String where = "";
            where = Util.addFilter(where, "name", "like", filter.getName());
            where = Util.addFilter(where, "beschreibung", "like", filter.getBeschreibung());
            ResultSet rs = this.statement.executeQuery("select * from gruppe " + where + " order by name");
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                Gruppe p = new Gruppe();
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setName(rs.getString("name"));
                p.setBeschreibung(rs.getString("beschreibung"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    public List<PersonGruppe> selectPersonGruppe(Personendaten pd) throws SQLException, ClassNotFoundException {
        this.openCustomConnection();
        ResultSet rs = this.statement.executeQuery("select pg.id, pg.created, pg.changed, pg.personId,pg.gruppeId,*, g.name, g.beschreibung from personGruppe pg join gruppe g on pg.gruppeId = g.id where pg.personId = " + pd.getId() + " order by g.name");
        ArrayList<PersonGruppe> list = new ArrayList<PersonGruppe>();
        while (rs.next()) {
            PersonGruppe p = new PersonGruppe();
            p.setId(rs.getInt("id"));
            p.setCreated(Converter.stringToDate(rs.getString("created")));
            p.setChanged(Converter.stringToDate(rs.getString("changed")));
            p.setPersonId(rs.getInt("personId"));
            p.setGruppeId(rs.getInt("gruppeId"));
            p.setGruppe(rs.getString("name"));
            p.setBeschreibung(rs.getString("beschreibung"));
            list.add(p);
        }
        this.statement.close();
        this.connection.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> select(PersonGruppe bo) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            PersonGruppe filter = bo;
            String where = "";
            where = Util.addFilter(where, "personId", "=", filter.getPersonId());
            where = Util.addFilter(where, "gruppeId", "=", filter.getGruppeId());
            ResultSet rs = this.statement.executeQuery("select * from personGruppe " + where + " order by personId");
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                PersonGruppe p = new PersonGruppe();
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setPersonId(rs.getInt("personId"));
                p.setGruppeId(rs.getInt("gruppeId"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersonBefund> select(PersonBefund bo) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            PersonBefund filter = bo;
            String where = "";
            where = Util.addFilter(where, "personId", "=", filter.getPersonId());
            ResultSet rs = this.statement.executeQuery("select * from PersonBefund " + where + " order by personId, datum desc, id desc");
            ArrayList<PersonBefund> list = new ArrayList<PersonBefund>();
            while (rs.next()) {
                PersonBefund p = new PersonBefund();
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setDatum(Converter.stringToDate(rs.getString("datum")));
                p.setPersonId(rs.getInt("personId"));
                p.setUeberschrift(rs.getString("ueberschrift"));
                p.setText(rs.getString("text"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<PersonBefund> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> selectAnalyseText1(boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            ResultSet rs = this.statement.executeQuery("select distinct text1 from analyse where text1 like '%-Thematik' order by text1");
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            this.statement.close();
            this.connection.close();
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBusinessObject> select(Settings bo) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            Settings filter = bo;
            String where = "";
            where = Util.addFilter(where, "name", "like", Formatter.dependingOnSecondString("%", filter.getName()));
            ResultSet rs = this.statement.executeQuery("select * from settings " + where);
            ArrayList<IBusinessObject> list = new ArrayList<IBusinessObject>();
            while (rs.next()) {
                Settings p = new Settings();
                p.setId(rs.getInt("id"));
                p.setCreated(Converter.stringToDate(rs.getString("created")));
                p.setChanged(Converter.stringToDate(rs.getString("changed")));
                p.setName(rs.getString("name"));
                p.setAdresse1(rs.getString("adresse1"));
                p.setAdresse2(rs.getString("adresse2"));
                p.setAdresse3(rs.getString("adresse3"));
                p.setAdresse4(rs.getString("adresse4"));
                p.setEmail(rs.getString("email"));
                p.setKopfzeile(rs.getString("kopfzeile"));
                p.setKopfzeileKurz(rs.getString("kopfzeileKurz"));
                p.setFusszeile(rs.getString("fusszeile"));
                p.setKontinent(rs.getString("kontinent"));
                p.setLkz(rs.getString("lkz"));
                p.setWebservice(rs.getBoolean("webservice"));
                p.setHaussystem(rs.getString("haussystem"));
                p.setGradzahlen(rs.getBoolean("gradzahlen"));
                p.setZwischenskala(rs.getBoolean("zwischenskala"));
                p.setJahresring(rs.getBoolean("jahresring"));
                p.setZeiger(rs.getBoolean("zeiger"));
                p.setZweiterAcMc(rs.getBoolean("zweiterAcMc"));
                p.setReporttypId(rs.getInt("reporttypId"));
                p.setLineWidth(rs.getInt("lineWidth"));
                p.setOrbisArrayString(rs.getString("orbisArrayString"));
                p.setInterOrbisArrayString(rs.getString("interOrbisArrayString"));
                p.setKonjunktion(rs.getBoolean("konjunktion"));
                p.setSextil(rs.getBoolean("sextil"));
                p.setQuadrat(rs.getBoolean("quadrat"));
                p.setTrigon(rs.getBoolean("trigon"));
                p.setOpposition(rs.getBoolean("opposition"));
                p.setHoroskop1(rs.getBoolean("horoskop1"));
                p.setHoroskop2(rs.getBoolean("horoskop2"));
                p.setAspekte1(rs.getBoolean("aspekte1"));
                p.setAspekte2(rs.getBoolean("aspekte2"));
                p.setInterAspekte(rs.getBoolean("interAspekte"));
                p.setIconTypeId(rs.getInt("iconTypeId"));
                p.setIconSizeId(rs.getInt("iconSizeId"));
                p.setBackupDir(rs.getString("backupDir"));
                p.setTexteDir(rs.getString("texteDir"));
                p.setWorkingDir(rs.getString("workingDir"));
                p.setLogoFile(rs.getString("logoFile"));
                p.setAutomatischeSicherung(rs.getBoolean("automatischeSicherung"));
                p.setSicherungTage(rs.getInt("sicherungTage"));
                p.setLetzteSicherung(Converter.stringToDate(rs.getString("letzteSicherung")));
                p.setStufe1(rs.getInt("stufe1"));
                p.setStufe2(rs.getInt("stufe2"));
                p.setEigeneAnalysetexte(rs.getBoolean("eigeneAnalysetexte"));
                p.setSteuersatz(rs.getInt("steuersatz"));
                p.setHeader1(rs.getString("header1"));
                p.setHeader2(rs.getString("header2"));
                p.setHeader3(rs.getString("header3"));
                p.setAbsender(rs.getString("absender"));
                p.setBetreff(rs.getString("betreff"));
                p.setRechnungsdaten(rs.getString("rechnungsdaten"));
                p.setRechnungsnummer(rs.getString("rechnungsnummer"));
                p.setText1(rs.getString("text1"));
                p.setText2(rs.getString("text2"));
                p.setText3(rs.getString("text3"));
                p.setFooter1(rs.getString("footer1"));
                p.setFooter2(rs.getString("footer2"));
                p.setFooter3(rs.getString("footer3"));
                p.setRand1(rs.getString("rand1"));
                p.setRand2(rs.getString("rand2"));
                p.setRand3(rs.getString("rand3"));
                list.add(p);
            }
            this.statement.close();
            this.connection.close();
            ArrayList<IBusinessObject> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeConnection();
        }
    }

    public void delete(Personendaten filter) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("delete from PersonGruppe where personId = " + filter.getId());
            this.statement.executeUpdate("delete from PersonBefund where personId = " + filter.getId());
            this.statement.executeUpdate("delete from Personendaten where id = " + filter.getId());
        }
        finally {
            this.closeConnection();
        }
    }

    public void delete(Geodaten filter) throws SQLException, ClassNotFoundException {
        try {
            this.openCoreConnection();
            this.statement.executeUpdate("delete from Geodaten where id = " + filter.getId());
        }
        finally {
            this.closeConnection();
        }
    }

    public void delete(Gruppe filter) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("delete from Gruppe where id = " + filter.getId());
        }
        finally {
            this.closeConnection();
        }
    }

    public void delete(PersonGruppe filter) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("delete from PersonGruppe where id = " + filter.getId());
        }
        finally {
            this.closeConnection();
        }
    }

    public void delete(PersonBefund filter) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("delete from PersonBefund where id = " + filter.getId());
        }
        finally {
            this.closeConnection();
        }
    }

    public void delete(Analyse filter, boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            this.statement.executeUpdate("delete from Analyse where id = " + filter.getId());
        }
        finally {
            this.closeConnection();
        }
    }

    public void delete(AnalyseHerrscher filter, boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            this.statement.executeUpdate("delete from AnalyseHerrscher where id = " + filter.getId());
        }
        finally {
            this.closeConnection();
        }
    }

    public void delete(AnalyseSchluesselThema filter, boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            this.statement.executeUpdate("delete from AnalyseSchluesselThema where id = " + filter.getId());
        }
        finally {
            this.closeConnection();
        }
    }

    public void delete(Texte filter, boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            this.statement.executeUpdate("delete from Texte where id = " + filter.getId());
        }
        finally {
            this.closeConnection();
        }
    }

    public void delete(Settings filter) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("delete from Settings where id = " + filter.getId());
        }
        finally {
            this.closeConnection();
        }
    }

    public int truncateGeodaten() throws SQLException, ClassNotFoundException {
        try {
            this.openCoreConnection();
            int n = this.statement.executeUpdate("delete from Geodaten");
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    public int truncateAnalyse(boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            int n = this.statement.executeUpdate("delete from Analyse");
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    public int truncateAnalyseHerrscher(boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            int n = this.statement.executeUpdate("delete from AnalyseHerrscher");
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    public int truncateAnalyseSchluesselThema(boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            int n = this.statement.executeUpdate("delete from AnalyseSchluesselThema");
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    public int truncateTexte(boolean core) throws SQLException, ClassNotFoundException {
        try {
            if (core) {
                this.openCoreConnection();
            } else {
                this.openCustomConnection();
            }
            int n = this.statement.executeUpdate("delete from Texte");
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    public int truncateGruppe() throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            int n = this.statement.executeUpdate("delete from Gruppe");
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    public int truncatePersonGruppe() throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            int n = this.statement.executeUpdate("delete from PersonGruppe");
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    public int truncatePersonBefund() throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            int n = this.statement.executeUpdate("delete from PersonBefund");
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    public int truncateSettings() throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            int n = this.statement.executeUpdate("delete from Settings");
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    public void testConnection() throws ClassNotFoundException {
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:db/signum.db");
            this.statement.executeUpdate("replace  into personendaten values(1, 'leo')");
            this.statement.executeUpdate("drop table if exists person");
            this.statement.executeUpdate("create table person (id integer, name string)");
            this.statement.executeUpdate("insert into person values(1, 'leo')");
            this.statement.executeUpdate("insert into person values(2, 'yui')");
            ResultSet rs = this.statement.executeQuery("select * from person");
            while (rs.next()) {
                log.debug((Object)("name = " + rs.getString("name")));
                log.debug((Object)("id = " + rs.getInt("id")));
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public void excecuteDbUpdateIfRequired() throws SQLException, ClassNotFoundException, CalculationException {
        log.debug((Object)"excecuteDbUpdateIfRequired - Start");
        Properties props = ApplicationProperties.getInstance().getProperties();
        int newDbVersion = Converter.stringToInt(props.getProperty("application.db.version"));
        List<IBusinessObject> list = null;
        try {
            list = this.selectDbVersion();
        }
        catch (Exception e) {
            this.executeDbUpdate(-1);
            DbVersion dbVersion = new DbVersion();
            dbVersion.setCreated(new Date());
            dbVersion.setChanged(dbVersion.getCreated());
            dbVersion.setDbVersion(newDbVersion);
            this.saveDbVersion(dbVersion);
            return;
        }
        if (list != null && list.size() > 1) {
            throw new SQLException("Die Signum Datenbank ist besch\u00e4digt. Es liegen mehrere Versions-Datens\u00e4tze vor.");
        }
        if (list == null || list.size() == 0) {
            this.executeDbUpdate(-1);
            DbVersion dbVersion = new DbVersion();
            dbVersion.setCreated(new Date());
            dbVersion.setChanged(dbVersion.getCreated());
            dbVersion.setDbVersion(newDbVersion);
            this.saveDbVersion(dbVersion);
            return;
        }
        DbVersion dbVersion = (DbVersion)list.get(0);
        int currentDbVersion = dbVersion.getDbVersion();
        log.debug((Object)("aktuelle DB-Version: " + currentDbVersion));
        log.debug((Object)("neue     DB-Version: " + newDbVersion));
        if (currentDbVersion < newDbVersion) {
            this.executeDbUpdate(currentDbVersion);
            this.postExecuteDbUpdate(currentDbVersion);
            dbVersion.setChanged(new Date());
            dbVersion.setDbVersion(newDbVersion);
            this.saveDbVersion(dbVersion);
        }
        log.debug((Object)"excecuteDbUpdateIfRequired - Ende");
    }

    public int getCurrentDbVersion() {
        try {
            List<IBusinessObject> list = this.selectDbVersion();
            if (list != null && list.size() == 1) {
                DbVersion dbVersion = (DbVersion)list.get(0);
                int currentDbVersion = dbVersion.getDbVersion();
                return currentDbVersion;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private void executeDbUpdate(int currentDbVersion) throws SQLException, ClassNotFoundException, CalculationException {
        try {
            if (currentDbVersion >= 0) ** GOTO lbl11
            SqLiteDatabase.log.debug((Object)"currentDbVersion<0 Start");
            try {
                this.createEmptyDatabaseIfNotExists();
                return;
            }
            catch (Exception e) {
                ErrorHandler.handleError(SqLiteDatabase.log, e);
                SqLiteDatabase.log.debug((Object)"currentDbVersion<0 Ende");
lbl11:
                // 2 sources

                this.openCustomConnection();
                if (currentDbVersion < 1) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<1 Start");
                    this.statement.executeUpdate("drop table analyse");
                    this.statement.executeUpdate("drop table geodaten");
                    this.statement.executeUpdate("alter table settings add column kopfzeileKurz String");
                    this.statement.executeUpdate("update settings set kopfzeileKurz=kopfzeile");
                    this.statement.executeUpdate("alter table settings add column zeiger INTEGER");
                    this.statement.executeUpdate("update settings set zeiger=true");
                    this.statement.executeUpdate("vacuum");
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<1 Ende");
                }
                if (currentDbVersion < 2) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<2 Start");
                    this.statement.executeUpdate("alter table personendaten add column anonymeBezeichnung STRING");
                    this.statement.executeUpdate("alter table personendaten add column kontaktDurch STRING");
                    this.statement.executeUpdate("alter table personendaten add column url1 STRING");
                    this.statement.executeUpdate("alter table personendaten add column url2 STRING");
                    this.statement.executeUpdate("alter table personendaten add column url3 STRING");
                    this.statement.executeUpdate("update personendaten set anonymeBezeichnung='', kontaktDurch='',url1 = internet, url2='', url3=''");
                    this.statement.executeUpdate("update personendaten set internet = ''");
                    this.statement.executeUpdate("vacuum");
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<2 Ende");
                }
                if (currentDbVersion < 3) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<3 Start");
                    this.statement.executeUpdate("alter table personendaten add column aktuellKontinent STRING");
                    this.statement.executeUpdate("alter table personendaten add column aktuellLkz STRING");
                    this.statement.executeUpdate("alter table personendaten add column aktuellPlz STRING");
                    this.statement.executeUpdate("alter table personendaten add column aktuellOrt STRING");
                    this.statement.executeUpdate("alter table personendaten add column aktuellManuell Integer");
                    this.statement.executeUpdate("alter table personendaten add column aktuellLatitude STRING");
                    this.statement.executeUpdate("alter table personendaten add column aktuellLongitude STRING");
                    this.statement.executeUpdate("update personendaten set aktuellKontinent='', aktuellLkz='',aktuellPlz='',aktuellOrt='',aktuellManuell=0,aktuellLatitude='',aktuellLongitude=''");
                    this.statement.executeUpdate("vacuum");
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<3 Ende");
                }
                if (currentDbVersion < 4) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<4 Start");
                    this.statement.executeUpdate("alter table settings add column stufe1 INTEGER");
                    this.statement.executeUpdate("alter table settings add column stufe2 INTEGER");
                    this.statement.executeUpdate("update settings set stufe1 = 1");
                    this.statement.executeUpdate("update settings set stufe2 = 1");
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<4 Ende");
                }
                if (currentDbVersion < 5) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<5 Start");
                    this.statement.executeUpdate("create table if not exists gruppe (id  INTEGER PRIMARY KEY AUTOINCREMENT, created Date,changed Date,name TEXT, beschreibung TEXT)");
                    this.statement.executeUpdate("create table if not exists personGruppe (id  INTEGER PRIMARY KEY AUTOINCREMENT, created Date,changed Date,personId INTEGER, gruppeId INTEGER)");
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<5 Ende");
                }
                if (currentDbVersion < 6) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<6 Start");
                    this.statement.executeUpdate("create table if not exists analyse (id  INTEGER PRIMARY KEY AUTOINCREMENT,  created Date,changed Date, horoskop TEXT, sort1 Integer, sort2 Integer,stufe1 INTEGER, stufe2 INTEGER, planet1 TEXT,planet2 TEXT,tkz1    TEXT, tkz2 TEXT,aspekt TEXT,haus TEXT,text1 TEXT,text2 TEXT)");
                    this.statement.executeUpdate("alter table settings add column eigeneAnalysetexte INTEGER");
                    this.statement.executeUpdate("update settings set eigeneAnalysetexte = false");
                    this.statement.executeUpdate("create table if not exists AnalyseSchluesselThema (id  INTEGER PRIMARY KEY AUTOINCREMENT,  created Date,changed Date, haus TEXT, sort INTEGER, doppelzeichen INTEGER, anzeigen INTEGER, ueberschrift INTEGER, frage TEXT, antwort TEXT, planeten TEXT, haeuser TEXT, tkzs TEXT, aspekte TEXT, herrscher TEXT)");
                    this.statement.executeUpdate("create table if not exists personBefund (id  INTEGER PRIMARY KEY AUTOINCREMENT, created Date,changed Date,personId INTEGER,datum Date,ueberschrift TEXT,text TEXT) ");
                    this.statement.executeUpdate("alter table personendaten add column vorgeschichte TEXT");
                    this.statement.executeUpdate("alter table personendaten add column empfehlung TEXT");
                    this.statement.executeUpdate("update personendaten set vorgeschichte ='', empfehlung=''");
                    this.statement.executeUpdate("alter table settings add column automatischeSicherung INTEGER");
                    this.statement.executeUpdate("alter table settings add column sicherungTage INTEGER");
                    this.statement.executeUpdate("alter table settings add column letzteSicherung DATE");
                    this.statement.executeUpdate("update settings set automatischeSicherung=false, sicherungTage=0, letzteSicherung=null");
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<6 Ende");
                }
                if (currentDbVersion < 7) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<7 Start");
                    this.statement.executeUpdate("create table if not exists Texte (id  INTEGER PRIMARY KEY AUTOINCREMENT,  created Date, changed Date, key TEXT, klasse TEXT, stufe Integer,text TEXT)");
                    this.statement.executeUpdate("alter table analyse add column textkey TEXT");
                    this.statement.executeUpdate("update analyse set textkey=''");
                    this.statement.executeUpdate("create unique index Texte_Index1 on Texte(key, Klasse, Stufe)");
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<7 Ende");
                }
                if (currentDbVersion < 8) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<8 Start");
                    this.datumInDbKorrigieren();
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<8 Ende");
                }
                if (currentDbVersion < 9) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<9 Start");
                    this.statement.executeUpdate("alter table Texte add column URL TEXT");
                    this.statement.executeUpdate("update Texte set URL=''");
                    this.statement.executeUpdate("alter table Settings add column texteDir TEXT");
                    this.statement.executeUpdate("update Settings set texteDir=''");
                    this.statement.executeUpdate("create table if not exists AnalyseHerrscher (id  INTEGER PRIMARY KEY AUTOINCREMENT,  created Date, changed Date, horoskop TEXT, herrscher TEXT, tkz TEXT, haus TEXT, textkey TEXT)");
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<9 Ende");
                }
                if (currentDbVersion < 10) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<10 Start");
                    this.statement.executeUpdate("alter table Personendaten add column anrede TEXT");
                    this.statement.executeUpdate("alter table Settings add column steuersatz INTEGER");
                    this.statement.executeUpdate("alter table Settings add column header1 TEXT");
                    this.statement.executeUpdate("alter table Settings add column header2 TEXT");
                    this.statement.executeUpdate("alter table Settings add column header3 TEXT");
                    this.statement.executeUpdate("alter table Settings add column absender TEXT");
                    this.statement.executeUpdate("alter table Settings add column betreff TEXT");
                    this.statement.executeUpdate("alter table Settings add column rechnungsdaten TEXT");
                    this.statement.executeUpdate("alter table Settings add column rechnungsnummer TEXT");
                    this.statement.executeUpdate("alter table Settings add column text1 TEXT");
                    this.statement.executeUpdate("alter table Settings add column text2 TEXT");
                    this.statement.executeUpdate("alter table Settings add column text3 TEXT");
                    this.statement.executeUpdate("alter table Settings add column footer1 TEXT");
                    this.statement.executeUpdate("alter table Settings add column footer2 TEXT");
                    this.statement.executeUpdate("alter table Settings add column footer3 TEXT");
                    this.statement.executeUpdate("alter table Settings add column rand1 TEXT");
                    this.statement.executeUpdate("alter table Settings add column rand2 TEXT");
                    this.statement.executeUpdate("alter table Settings add column rand3 TEXT");
                    this.statement.executeUpdate("update Personendaten set anrede = ''");
                    this.statement.executeUpdate("update Settings set steuersatz=0,header1 ='',header2 ='',header3 ='',absender ='',betreff ='',rechnungsdaten ='',rechnungsnummer ='SIG-00001',text1 ='',text2 ='',text3 ='',footer1 ='',footer2 ='',footer3 ='',rand1 ='',rand2 ='',rand3 =''");
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<10 Ende");
                }
                if (currentDbVersion < 11) {
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<11 Start");
                    SqLiteDatabase.log.debug((Object)"currentDbVersion<11 Ende");
                }
            }
        }
        finally {
            this.closeConnection();
        }
    }

    private void postExecuteDbUpdate(int currentDbVersion) throws SQLException, ClassNotFoundException {
        if (currentDbVersion < 3) {
            this.copyOrben(Horoskop.Transit, Horoskop.Aktualitaet);
        }
        if (currentDbVersion < 4) {
            this.copyOrben(Horoskop.Transit, Horoskop.KompositSeptar);
        }
        if (currentDbVersion < 5) {
            this.copyOrben(Horoskop.KompositSeptar, Horoskop.MultiKomposit);
        }
        if (currentDbVersion < 11) {
            this.copyOrben(Horoskop.Transit, Horoskop.KompositTransit);
        }
    }

    private void copyOrben(Horoskop from, Horoskop to) throws SQLException, ClassNotFoundException {
        Settings filter = new Settings();
        List<IBusinessObject> settingsList = this.select(filter);
        Settings settings = (Settings)settingsList.get(0);
        OrbisCache ob = settings.getOrbisCache();
        OrbisCache interob = settings.getInterOrbisCache();
        ob.copyOrben(from, to);
        interob.copyOrben(from, to);
        settings.setOrbisArrayString(ob.object2string());
        settings.setInterOrbisArrayString(interob.object2string());
        this.save(settings);
    }

    private void datumInDbKorrigieren() throws ClassNotFoundException, SQLException, CalculationException {
        PersonendatenCalculator pc = new PersonendatenCalculator();
        Personendaten filter = new Personendaten();
        List<IBusinessObject> list = this.selectOld(filter);
        this.openCustomConnection();
        String sql = "update Personendaten set geburtsdatum = :datum where id = :id";
        PreparedStatement pstmt = this.connection.prepareStatement(sql);
        for (IBusinessObject obj : list) {
            Personendaten p = (Personendaten)obj;
            Date newDate = pc.getGeburtsdatum(p);
            System.out.print("ID=" + p.getId() + ": UTC-String-Datum " + p.getGeburtsdatumUtc() + " " + p.getGeburtszeitUtc() + ", intern " + p.getGeburtsdatum().toGMTString() + ", richtig:" + newDate.toGMTString());
            boolean isEqual = Util.equals(p.getGeburtsdatum().toGMTString(), newDate.toGMTString());
            System.out.print(isEqual ? "" : " *");
            if (!isEqual) {
                String dateString = Converter.timeToUtcSqlString(newDate);
                pstmt.setString(1, dateString);
                pstmt.setInt(2, p.getId());
                pstmt.executeUpdate();
                System.out.print("- korrigiert - " + dateString);
            }
            System.out.println("");
        }
    }

    public String incrementRechnungsnummer(String rechnungsnummer) throws SQLException, ClassNotFoundException {
        try {
            this.openCustomConnection();
            rechnungsnummer = Util.incrementNumber(rechnungsnummer);
            this.statement.executeUpdate("update settings set rechnungsnummer='" + rechnungsnummer + "'");
            String string = rechnungsnummer;
            return string;
        }
        finally {
            this.closeConnection();
        }
    }

    public void analyseCore2Custom() throws ClassNotFoundException, SQLException {
        List<IBusinessObject> list = null;
        Analyse filter = Analyse.newInstance(true);
        list = this.select(filter);
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("delete from analyse");
        }
        finally {
            this.closeConnection();
        }
        for (IBusinessObject obj : list) {
            Analyse object = (Analyse)obj;
            this.save(object, false);
        }
    }

    public void analyseHerrscherCore2Custom() throws ClassNotFoundException, SQLException {
        List<IBusinessObject> list = null;
        AnalyseHerrscher filter = AnalyseHerrscher.newInstance(true);
        list = this.select(filter);
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("delete from analyseHerrscher");
        }
        finally {
            this.closeConnection();
        }
        for (IBusinessObject obj : list) {
            AnalyseHerrscher object = (AnalyseHerrscher)obj;
            this.save(object, false);
        }
    }

    public void analyseSchlueselThemaCore2Custom() throws ClassNotFoundException, SQLException {
        List<IBusinessObject> list = null;
        AnalyseSchluesselThema filter = AnalyseSchluesselThema.newInstance(true);
        list = this.select(filter);
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("delete from analyseSchluesselThema");
        }
        finally {
            this.closeConnection();
        }
        for (IBusinessObject obj : list) {
            AnalyseSchluesselThema object = (AnalyseSchluesselThema)obj;
            this.save(object, false);
        }
    }

    public void texteCore2Custom() throws ClassNotFoundException, SQLException {
        List<IBusinessObject> list = null;
        Texte filter = Texte.newInstance(true);
        list = this.select(filter);
        try {
            this.openCustomConnection();
            this.statement.executeUpdate("delete from texte");
        }
        finally {
            this.closeConnection();
        }
        for (IBusinessObject obj : list) {
            Texte object = (Texte)obj;
            this.save(object, false);
        }
    }
}

