/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.astrologie.FormatterGradzahlen;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Formatter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.ReadablePartial;
import org.joda.time.Years;

public class Util {
    private static Log log = LogFactory.getLog(Util.class);

    public static String NotNull(String text) {
        if (text == null) {
            return "";
        }
        return text;
    }

    public static String getFirstNotEmptyString(String a, String b) {
        if (!Util.isEmpty(a)) {
            return a;
        }
        if (!Util.isEmpty(b)) {
            return b;
        }
        return "";
    }

    public static int getValue(Integer value) {
        if (value == null) {
            return 0;
        }
        return value;
    }

    public static int getValue(BigInteger value) {
        if (value == null) {
            return 0;
        }
        return value.intValue();
    }

    public static int getValue(BigDecimal value) {
        if (value == null) {
            return 0;
        }
        return value.intValue();
    }

    public static double getValue(Double value) {
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public static String getValue(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static boolean getValue(Boolean value) {
        if (value == null) {
            return false;
        }
        return value;
    }

    public static Date getValue(Date value) {
        return value;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.trim().equals("");
    }

    public static boolean isEmpty(Date text) {
        return text == null;
    }

    public static boolean isInt(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean equals(String text1, String text2) {
        return Util.NotNull(text1).equals(Util.NotNull(text2));
    }

    public static boolean equals(double v1, double v2) {
        return v1 == v2;
    }

    public static boolean equals(boolean v1, boolean v2) {
        return v1 == v2;
    }

    public static boolean equals(String text1, String[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (!Util.equals(text1, a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(int n1, int[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (n1 != a[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String text1, String text2) {
        return Util.NotNull(text1).equalsIgnoreCase(Util.NotNull(text2));
    }

    public static boolean equalsAsNumber(String text1, String text2) {
        try {
            long t1 = Long.parseLong(text1);
            long t2 = Long.parseLong(text2);
            return t1 == t2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean equals(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null || date2 == null) {
            return false;
        }
        return date1.getTime() == date2.getTime();
    }

    public static boolean equals(int n1, int n2) {
        return n1 == n2;
    }

    public static int compare(Date d1, Date d2) {
        Date c1 = d1;
        Date c2 = d2;
        if (c1 == null) {
            c1 = DateUtil.maxDate;
        }
        if (c2 == null) {
            c2 = DateUtil.maxDate;
        }
        return Long.valueOf(c1.getTime()).compareTo(c2.getTime());
    }

    public static int compare(String text1, String text2) {
        return Util.NotNull(text1).compareTo(Util.NotNull(text2));
    }

    public static int compare(int n1, int n2) {
        if (n1 < n2) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    public static int compare(long n1, long n2) {
        if (n1 < n2) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    public static int compare(double n1, double n2) {
        if (n1 < n2) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    public static int compareAsNumber(String text1, String text2) {
        try {
            return Util.compare(Converter.stringToInt(text1), Converter.stringToInt(text2));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int compareAsLongNumber(String text1, String text2) {
        try {
            return Util.compare(Converter.stringToLong(text1), Converter.stringToLong(text2));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String addFilterCondition(String whereClause, String condition) {
        StringBuffer sb = new StringBuffer(whereClause);
        if (!Util.isEmpty(condition)) {
            if (Util.isEmpty(whereClause)) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append(condition);
        }
        return sb.toString();
    }

    public static String strip(String text1, String character) {
        return text1.replaceAll(character, "");
    }

    private static StringBuffer addFilterElement(StringBuffer sb, String field, String comp, String value) {
        sb.append(field);
        sb.append(" ");
        sb.append(comp);
        sb.append(" '");
        sb.append(value);
        if ("like".equalsIgnoreCase(comp)) {
            sb.append("%");
        }
        sb.append("' ");
        return sb;
    }

    private static StringBuffer addLikeFilterElement(StringBuffer sb, String field, String value) {
        sb.append(field);
        sb.append(" ");
        sb.append("like");
        sb.append(" '");
        sb.append(value);
        sb.append("' ");
        return sb;
    }

    private static StringBuffer addFilterElement(StringBuffer sb, String field, String comp, int value) {
        sb.append(field);
        sb.append(" ");
        sb.append(comp);
        sb.append(" ");
        sb.append(value);
        if ("like".equalsIgnoreCase(comp)) {
            sb.append("%");
        }
        sb.append(" ");
        return sb;
    }

    private static StringBuffer addFilterElement(StringBuffer sb, String field, String comp, double value) {
        sb.append(field);
        sb.append(" ");
        sb.append(comp);
        sb.append(" ");
        sb.append(value);
        sb.append(" ");
        return sb;
    }

    public static String addForceFilter(String whereClause, String field, String comp, boolean value) {
        if (value) {
            return Util.addFilter(whereClause, field, comp, "1");
        }
        return Util.addFilter(whereClause, field, comp, "0");
    }

    public static String addFilter(String whereClause, String field, String comp, String value) {
        StringBuffer sb = new StringBuffer(whereClause);
        if (!Util.isEmpty(value)) {
            if (Util.isEmpty(whereClause)) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            Util.addFilterElement(sb, field, comp, value);
        }
        return sb.toString();
    }

    public static String addForceFilter(String whereClause, String field, String comp, String value) {
        StringBuffer sb = new StringBuffer(whereClause);
        value = Util.NotNull(value);
        if (Util.isEmpty(whereClause)) {
            sb.append(" where ");
        } else {
            sb.append(" and ");
        }
        Util.addFilterElement(sb, field, comp, value);
        return sb.toString();
    }

    public static String addLikeFilter(String whereClause, String field, String value) {
        StringBuffer sb = new StringBuffer(whereClause);
        if (!Util.isEmpty(value)) {
            if (Util.isEmpty(whereClause)) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            Util.addLikeFilterElement(sb, field, value);
        }
        return sb.toString();
    }

    public static String addFilter(String whereClause, String field, String comp, int intValue) {
        if (intValue != 0) {
            return Util.addForceFilter(whereClause, field, comp, intValue);
        }
        return whereClause;
    }

    public static String addFilter(String whereClause, String field, String comp, Date date) {
        if (date != null) {
            String value = Converter.dateToSqlString(date);
            return Util.addFilter(whereClause, field, comp, value);
        }
        return whereClause;
    }

    public static String addDateFilter(String whereClause, String field, Date date) {
        if (date != null) {
            Date von = DateUtil.getDateWithoutTime(date);
            Date bis = DateUtil.getDateWithoutTime(date);
            bis = DateUtil.dateAddDays(bis, 1);
            whereClause = Util.addFilter(whereClause, field, ">=", von);
            whereClause = Util.addFilter(whereClause, field, "<", bis);
            return whereClause;
        }
        return whereClause;
    }

    public static String addFilter(String whereClause, String field, String comp, boolean value) {
        if (value) {
            return Util.addFilter(whereClause, field, comp, "1");
        }
        return whereClause;
    }

    public static String addForceFilter(String whereClause, String field, String comp, int intValue) {
        StringBuffer sb = new StringBuffer(whereClause);
        if (Util.isEmpty(whereClause)) {
            sb.append(" where ");
        } else {
            sb.append(" and ");
        }
        Util.addFilterElement(sb, field, comp, intValue);
        return sb.toString();
    }

    public static String addFilter(String whereClause, String field, String comp, double doubleValue) {
        if (doubleValue == 0.0) {
            return whereClause;
        }
        StringBuffer sb = new StringBuffer(whereClause);
        if (Util.isEmpty(whereClause)) {
            sb.append(" where ");
        } else {
            sb.append(" and ");
        }
        Util.addFilterElement(sb, field, comp, doubleValue);
        return sb.toString();
    }

    public static String addOrFilter(String whereClause, String field1, String field2, String field3, String field4, String comp, String value) {
        log.debug((Object)"addOrFilter");
        String clause = "";
        if (value != null && !value.equals("")) {
            StringBuffer sb;
            whereClause = whereClause.equals("") ? whereClause + " where " : whereClause + " and ";
            if (!Util.isEmpty(field1)) {
                sb = new StringBuffer();
                Util.addFilterElement(sb, field1, comp, value);
                clause = clause + sb.toString();
            }
            if (!Util.isEmpty(field2)) {
                sb = new StringBuffer();
                if (!clause.equals("")) {
                    sb.append("or ");
                }
                Util.addFilterElement(sb, field2, comp, value);
                clause = clause + sb.toString();
            }
            if (!Util.isEmpty(field3)) {
                sb = new StringBuffer();
                if (!clause.equals("")) {
                    sb.append("or ");
                }
                Util.addFilterElement(sb, field3, comp, value);
                clause = clause + sb.toString();
            }
            if (!Util.isEmpty(field4)) {
                sb = new StringBuffer();
                if (!clause.equals("")) {
                    sb.append("or ");
                }
                Util.addFilterElement(sb, field4, comp, value);
                clause = clause + sb.toString();
            }
            whereClause = whereClause + "(" + clause + ")";
        }
        return whereClause;
    }

    public static String addOrFilter(String whereClause, String cond1, String cond2, String cond3, String cond4) {
        log.debug((Object)"addOrFilter");
        String clause = null;
        if (!Util.isEmpty(cond1)) {
            cond1 = " (" + cond1 + ") ";
        }
        if (!Util.isEmpty(cond2)) {
            cond2 = " (" + cond2 + ") ";
        }
        if (!Util.isEmpty(cond3)) {
            cond3 = " (" + cond3 + ") ";
        }
        if (!Util.isEmpty(cond4)) {
            cond4 = " (" + cond4 + ") ";
        }
        clause = Util.isEmpty(clause = cond1) ? cond2 : clause + Formatter.dependingOnSecondString("or ", cond2);
        clause = Util.isEmpty(clause) ? cond3 : clause + Formatter.dependingOnSecondString("or ", cond3);
        if (!Util.isEmpty(clause = Util.isEmpty(clause) ? cond4 : clause + Formatter.dependingOnSecondString("or ", cond4))) {
            clause = " ( " + clause + " ) ";
        }
        whereClause = Util.addFilterCondition(whereClause, clause);
        return whereClause;
    }

    public static String addOrFilter(String whereClause, String field, String comp, String value1, String value2, String value3) {
        StringBuffer sb;
        log.debug((Object)"addOrFilter");
        String clause = "";
        whereClause = whereClause.equals("") ? whereClause + " where " : whereClause + " and ";
        if (!Util.isEmpty(value1)) {
            sb = new StringBuffer();
            Util.addFilterElement(sb, field, comp, value1);
            clause = clause + sb.toString();
        }
        if (!Util.isEmpty(value2)) {
            sb = new StringBuffer();
            if (!clause.equals("")) {
                sb.append("or ");
            }
            Util.addFilterElement(sb, field, comp, value2);
            clause = clause + sb.toString();
        }
        if (!Util.isEmpty(value3)) {
            sb = new StringBuffer();
            if (!clause.equals("")) {
                sb.append("or ");
            }
            Util.addFilterElement(sb, field, comp, value3);
            clause = clause + sb.toString();
        }
        whereClause = whereClause + "(" + clause + ")";
        return whereClause;
    }

    public static double round(double value, int precision) {
        if (value >= 0.0) {
            if (precision >= 0) {
                int rounded = (int)Math.round(value / (double)precision);
                value = rounded * precision;
                return value;
            }
            double rounded = (int)Math.round(value * (double)(-precision));
            value = rounded / (double)(-precision);
            return value;
        }
        if (precision >= 0) {
            int rounded = (int)Math.round(-value / (double)precision);
            value = rounded * precision;
            return -value;
        }
        double rounded = (int)Math.round(-value * (double)(-precision));
        value = rounded / (double)(-precision);
        return -value;
    }

    public static int round(int value, int precision) {
        if (value >= 0) {
            double rounded = (double)value / (double)precision + 0.5;
            value = (int)rounded * precision;
            return value;
        }
        double rounded = (double)(-value) / (double)precision + 0.5;
        value = (int)rounded * precision;
        return -value;
    }

    public static double roundUp(double value, int precision) {
        double rounded = Math.ceil(value / (double)precision);
        value = rounded * (double)precision;
        return value;
    }

    public static int roundUp(int value, int precision) {
        double rounded = Math.ceil((double)value / (double)precision);
        value = (int)rounded * precision;
        return value;
    }

    public static String cutString(String s, int maxLength) {
        if (s == null) {
            return s;
        }
        if (maxLength > 0 && s.length() > maxLength) {
            s = s.substring(0, maxLength);
        }
        return s;
    }

    public static String subString(String s, int pos) {
        if (s == null || pos == 0) {
            return s;
        }
        if (s.length() > 0 && s.length() > pos) {
            s = s.substring(pos, s.length());
            return s;
        }
        return "";
    }

    public static String cutString(String s, String character) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int endpos = s.indexOf(character);
        if (endpos < 0) {
            return s;
        }
        return Util.cutString(s, endpos);
    }

    public static String rightString(String s, int cnt) {
        if (s == null || s.length() <= cnt) {
            return s;
        }
        s = s.substring(s.length() - cnt);
        return s;
    }

    public static String leftString(String s, int cnt) {
        if (s == null || s.length() <= cnt) {
            return s;
        }
        s = s.substring(cnt);
        return s;
    }

    public static String ltrim(String source) {
        return source.replaceAll("^\\s+", "");
    }

    public static String trim(String source) {
        return Util.ltrim(Util.rtrim(source));
    }

    public static String rtrim(String source) {
        return source.replaceAll("\\s+$", "");
    }

    public static double euro(double value) {
        BigDecimal result = new BigDecimal(Double.toString(value));
        result = result.setScale(10, 4);
        return result.setScale(2, 4).doubleValue();
    }

    public static double roundGms(double value) {
        BigDecimal result = new BigDecimal(Double.toString(value));
        result = result.setScale(10, 4);
        result = result.setScale(6, 4);
        return result.doubleValue();
    }

    public static double euro(Double value) {
        if (value == null) {
            return 0.0;
        }
        BigDecimal result = new BigDecimal(value);
        return result.setScale(2, 4).doubleValue();
    }

    public static void copyFile(String from, String to) throws IOException {
        int c;
        File inputFile = new File(from);
        File outputFile = new File(to);
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile, false);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static String getZeileFromText(String text, int zeile) {
        if (zeile < 1 || Util.isEmpty(text)) {
            return "";
        }
        String[] s = text.split("\n");
        if (s.length >= zeile) {
            return s[zeile - 1];
        }
        return "";
    }

    public static String toUpperCase(String text) {
        if (text == null) {
            return null;
        }
        return text.toUpperCase();
    }

    public static String toLowerCase(String text) {
        if (text == null) {
            return null;
        }
        return text.toLowerCase();
    }

    public static String[] array2MaxLengthArray(String[] a, int maxLength) {
        if (a == null || a.length == 0 || maxLength < 4) {
            return a;
        }
        String[] b = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = Util.string2MaxLengthString(a[i], maxLength);
        }
        return b;
    }

    public static String string2MaxLengthString(String s, int maxLength) {
        if (s != null && s.length() > maxLength) {
            return Util.cutString(s, maxLength - 3) + "...";
        }
        return s;
    }

    public static String grad2dms(double lat) {
        return FormatterGradzahlen.format(lat, "h\u00b0 m' s\"");
    }

    public static String lat2dms(double lat) {
        return FormatterGradzahlen.format(lat, "h\u00b0 m' s\" n");
    }

    public static String lat2dms(String lat) {
        return Util.lat2dms(Converter.stringToDouble(lat));
    }

    public static double dms2double(String lat) {
        return Util.round(FormatterGradzahlen.dms2double(lat), -1000000);
    }

    public static String lon2dms(double lon) {
        return FormatterGradzahlen.format(lon, "h\u00b0 m' s\" w");
    }

    public static String lon2dms(String lon) {
        return Util.lon2dms(Converter.stringToDouble(lon));
    }

    public static String latLong2dms(double lat, double lon) {
        return "Breite " + Util.lat2dms(lat) + ", L\u00e4nge " + Util.lon2dms(lon);
    }

    public static String latLong2dms(String lat, String lon) {
        return Util.latLong2dms(Converter.stringToDouble(lat), Converter.stringToDouble(lon));
    }

    public static Integer getDiffInYears(Date date) {
        return Util.getDiffInYears(date, DateUtil.getToday());
    }

    public static Integer getDiffInYears(Date date1, Date date2) {
        if (date1 == null) {
            return null;
        }
        LocalDate geb = new LocalDate(DateUtil.getYear(date1), DateUtil.getMonth(date1), DateUtil.getDay(date1));
        LocalDate now = new LocalDate(DateUtil.getYear(date2), DateUtil.getMonth(date2), DateUtil.getDay(date2));
        int yearsBetween = Years.yearsBetween((ReadablePartial)geb, (ReadablePartial)now).getYears();
        return yearsBetween;
    }

    public static Double getDiffInYearsDouble(Date date) {
        if (date == null) {
            return null;
        }
        LocalDate geb = new LocalDate(DateUtil.getYear(date), DateUtil.getMonth(date), DateUtil.getDay(date));
        LocalDate now = LocalDate.now();
        int monthBetween = Months.monthsBetween((ReadablePartial)geb, (ReadablePartial)now).getMonths();
        return (double)monthBetween / 12.0;
    }

    public static double average(double d1, double d2) {
        return (d1 + d2) / 2.0;
    }

    public static int average(int d1, int d2) {
        return (int)Math.round((double)(d1 + d2) / 2.0);
    }

    public static double average(double ... value) {
        if (value == null || value.length == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < value.length; ++i) {
            sum += value[i];
        }
        return sum /= (double)value.length;
    }

    public static String incrementNumber(String number) {
        if (Util.isEmpty(number)) {
            return number;
        }
        char[] cars = number.toUpperCase().toCharArray();
        for (int i = cars.length - 1; i >= 0; --i) {
            if ((cars[i] < 'A' || cars[i] > 'Z') && (cars[i] < '0' || cars[i] > '9')) continue;
            if (cars[i] == 'Z') {
                cars[i] = 65;
                continue;
            }
            if (cars[i] == '9') {
                cars[i] = 48;
                continue;
            }
            int n = i;
            cars[n] = (char)(cars[n] + '\u0001');
            break;
        }
        return String.valueOf(cars);
    }
}

