/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.datamodel;

import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import de.cni.common.datamodel.Basisdaten;

public class GmsKoordinate
extends Basisdaten {
    private static final long serialVersionUID = 1L;
    private int latitudeGrad;
    private int latitudeMinuten;
    private int latitudeSekunden;
    private boolean latitudeNegativ;
    private int longitudeGrad;
    private int longitudeMinuten;
    private int longitudeSekunden;
    private boolean longitudeNegativ;

    public String getLatitude() {
        return this.getStringValue(this.latitudeGrad, this.latitudeMinuten, this.latitudeSekunden, this.latitudeNegativ);
    }

    public String getLongitude() {
        return this.getStringValue(this.longitudeGrad, this.longitudeMinuten, this.longitudeSekunden, this.longitudeNegativ);
    }

    private String getStringValue(int grad, int minuten, int sekunden, boolean negativ) {
        double value = (double)grad + (double)minuten / 60.0 + (double)sekunden / 3600.0;
        if (negativ) {
            value = -value;
        }
        if (this.matchesSekunde(value = Util.roundGms(value), sekunden)) {
            return Double.toString(value);
        }
        double newValue = value + 1.0E-6;
        if (this.matchesSekunde(newValue = Util.roundGms(newValue), sekunden)) {
            return Double.toString(newValue);
        }
        newValue = value - 1.0E-6;
        if (this.matchesSekunde(newValue = Util.roundGms(newValue), sekunden)) {
            return Double.toString(newValue);
        }
        return Double.toString(value);
    }

    private boolean matchesSekunde(double value, int sekunde) {
        try {
            String s = Util.lon2dms(value);
            String sub = s.split(" ")[2];
            int sec = Converter.stringToInt(Util.cutString(sub, 2));
            return sec == sekunde;
        }
        catch (Exception e) {
            return true;
        }
    }

    public int getLatitudeGrad() {
        return this.latitudeGrad;
    }

    public int getLatitudeMinuten() {
        return this.latitudeMinuten;
    }

    public int getLatitudeSekunden() {
        return this.latitudeSekunden;
    }

    public boolean isLatitudeNegativ() {
        return this.latitudeNegativ;
    }

    public int getLongitudeGrad() {
        return this.longitudeGrad;
    }

    public int getLongitudeMinuten() {
        return this.longitudeMinuten;
    }

    public int getLongitudeSekunden() {
        return this.longitudeSekunden;
    }

    public boolean isLongitudeNegativ() {
        return this.longitudeNegativ;
    }

    public void setLatitudeGrad(int latitudeGrad) {
        this.latitudeGrad = latitudeGrad;
    }

    public void setLatitudeMinuten(int latitudeMinuten) {
        this.latitudeMinuten = latitudeMinuten;
    }

    public void setLatitudeSekunden(int latitudeSekunden) {
        this.latitudeSekunden = latitudeSekunden;
    }

    public void setLatitudeNegativ(boolean latitudeNegativ) {
        this.latitudeNegativ = latitudeNegativ;
    }

    public void setLongitudeGrad(int longitudeGrad) {
        this.longitudeGrad = longitudeGrad;
    }

    public void setLongitudeMinuten(int longitudeMinuten) {
        this.longitudeMinuten = longitudeMinuten;
    }

    public void setLongitudeSekunden(int longitudeSekunden) {
        this.longitudeSekunden = longitudeSekunden;
    }

    public void setLongitudeNegativ(boolean longitudeNegativ) {
        this.longitudeNegativ = longitudeNegativ;
    }
}

