/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.datamodel.admin;

import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import de.cni.common.core.Util;
import de.cni.common.datamodel.Basisdaten;
import de.cni.common.datamodel.admin.PersonBefund;
import de.cni.common.datamodel.admin.PersonGruppe;
import de.cni.common.datamodel.admin.PersonendatenZusatzfilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Personendaten
extends Basisdaten {
    private static final long serialVersionUID = 1L;
    public static final int LEN_NACHNAME = 40;
    public static final int LEN_VORNAME = 40;
    public static final int LEN_ORT = 40;
    public static final int LEN_KONTINENT = 10;
    public static final int LEN_LKZ = 2;
    public static final int LEN_PLZ = 20;
    public static final int LEN_ALTER = 3;
    public static final int LEN_LONGITUDE = 11;
    public static final int LEN_LATITUDE = 11;
    public static final int LEN_TOLERANZ = 2;
    public static final int LEN_NOTIZ = 2000;
    public static final int LEN_SYMPTOME = 2000;
    public static final int LEN_TELEFON = 30;
    public static final int LEN_EMAIL = 512;
    public static final int LEN_TIMEZONEID = 40;
    public static final int LEN_GMT = 5;
    public static final int LEN_ANONYME_BEZEICHNUNG = 40;
    public static final int LEN_KONTAKT_DURCH = 40;
    boolean virtuell;
    private String vorname;
    private String nachname;
    String geburtsortKontinent;
    String geburtsortLkz;
    String geburtsortPlz;
    String geburtsort;
    boolean geburtsortManuell;
    String geburtsdatumLocal;
    String geburtszeitLocal;
    String geburtsdatumUtc;
    String geburtszeitUtc;
    Date geburtsdatum;
    String timezoneId;
    int gmtOffsetInMinutes;
    boolean gmtOffsetManuell;
    String longitude;
    String latitude;
    String wohnortKontinent;
    String wohnortLkz;
    String wohnortPlz;
    String wohnort;
    String wohnortLongitude;
    String wohnortLatitude;
    boolean wohnortManuell;
    String aktuellKontinent;
    String aktuellLkz;
    String aktuellPlz;
    String aktuellOrt;
    String aktuellLongitude;
    String aktuellLatitude;
    boolean aktuellManuell;
    String anschrift;
    String anrede;
    String telefon;
    String handy;
    String internet;
    String email;
    String url1;
    String url2;
    String url3;
    String kontaktDurch;
    String anonymeBezeichnung;
    String notiz;
    String symptome;
    String vorgeschichte;
    String empfehlung;
    PersonendatenZusatzfilter personendatenZusatzfilter;
    String filterGruppe;
    List<PersonGruppe> personGruppeList = new ArrayList<PersonGruppe>();
    List<PersonBefund> personBefundList = new ArrayList<PersonBefund>();

    public Integer getAlter() {
        return Util.getDiffInYears(this.geburtsdatum);
    }

    public Double getAlterDouble() {
        return Util.getDiffInYearsDouble(this.geburtsdatum);
    }

    public String getGeburtsdatumString() {
        if (!Util.isEmpty(this.timezoneId) && !this.isGmtOffsetManuell()) {
            return Converter.datetimeToGmtString(this.getGeburtsdatum(), this.getTimezoneId());
        }
        return Converter.datetimeToGmtString(this.getGeburtsdatum(), this.getGmtOffsetInMinutes());
    }

    public String getLatLong() {
        return "Lat: " + this.latitude + " Long: " + this.longitude;
    }

    public String toString() {
        String s = this.getName();
        if (!this.virtuell) {
            s = s + Formatter.dependingOnSecondString(", ", this.geburtsort) + ", " + Util.latLong2dms(this.latitude, this.longitude) + ", geb. " + this.getGeburtsdatumString();
        }
        return s;
    }

    public String getName() {
        return Formatter.append(this.vorname, this.nachname, " ");
    }

    public String geburtToBlock() {
        String block = Formatter.append(this.getName(), Formatter.dependingOnSecondString("geb.: ", this.getGeburtsdatumString()), Formatter.dependingOnSecondString("in ", this.geburtsort), "Breite: " + Util.lat2dms(this.latitude), "L\u00e4nge: " + Util.lon2dms(this.longitude), "\n");
        return block;
    }

    public String wohnortToBlock(Date date) {
        String block = Formatter.append(Formatter.dependingOnSecondString("Berechnung f\u00fcr\n", Converter.datetimeToCetString(date)), Formatter.dependingOnSecondString(" in ", this.wohnort), "Breite: " + Util.lat2dms(this.wohnortLatitude), "L\u00e4nge: " + Util.lon2dms(this.wohnortLongitude), "\n");
        return block;
    }

    public String aktuellToBlock(Date date) {
        String block = Formatter.append(Formatter.dependingOnSecondString("Berechnung f\u00fcr\n", Converter.datetimeToCetString(date)), Formatter.dependingOnSecondString(" in ", this.aktuellOrt), "Breite: " + Util.lat2dms(this.aktuellLatitude), "L\u00e4nge: " + Util.lon2dms(this.aktuellLongitude), "\n");
        return block;
    }

    public String getVorname() {
        return this.vorname;
    }

    public String getNachname() {
        return this.nachname;
    }

    public Date getGeburtsdatum() {
        return this.geburtsdatum;
    }

    public String getGeburtsort() {
        return this.geburtsort;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setVorname(String vorname) {
        this.vorname = vorname;
    }

    public void setNachname(String nachname) {
        this.nachname = nachname;
    }

    public void setGeburtsdatum(Date geburtsdatum) {
        this.geburtsdatum = geburtsdatum;
    }

    public void setGeburtsort(String geburtsort) {
        this.geburtsort = geburtsort;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getNotiz() {
        return this.notiz;
    }

    public void setNotiz(String notiz) {
        this.notiz = notiz;
    }

    public String getGeburtsdatumLocal() {
        return this.geburtsdatumLocal;
    }

    public String getGeburtszeitLocal() {
        return this.geburtszeitLocal;
    }

    public String getGeburtsdatumUtc() {
        return this.geburtsdatumUtc;
    }

    public String getGeburtszeitUtc() {
        return this.geburtszeitUtc;
    }

    public void setGeburtsdatumLocal(String geburtsdatumLocal) {
        this.geburtsdatumLocal = geburtsdatumLocal;
    }

    public void setGeburtszeitLocal(String geburtszeitLocal) {
        this.geburtszeitLocal = geburtszeitLocal;
    }

    public void setGeburtsdatumUtc(String geburtsdatumUtc) {
        this.geburtsdatumUtc = geburtsdatumUtc;
    }

    public void setGeburtszeitUtc(String geburtszeitUtc) {
        this.geburtszeitUtc = geburtszeitUtc;
    }

    public boolean isVirtuell() {
        return this.virtuell;
    }

    public void setVirtuell(boolean virtuell) {
        this.virtuell = virtuell;
    }

    public String getWohnort() {
        return this.wohnort;
    }

    public String getWohnortLongitude() {
        return this.wohnortLongitude;
    }

    public String getWohnortLatitude() {
        return this.wohnortLatitude;
    }

    public void setWohnort(String wohnort) {
        this.wohnort = wohnort;
    }

    public void setWohnortLongitude(String wohnortLongitude) {
        this.wohnortLongitude = wohnortLongitude;
    }

    public void setWohnortLatitude(String wohnortLatitude) {
        this.wohnortLatitude = wohnortLatitude;
    }

    public String getWohnortKontinent() {
        return this.wohnortKontinent;
    }

    public String getWohnortLkz() {
        return this.wohnortLkz;
    }

    public String getWohnortPlz() {
        return this.wohnortPlz;
    }

    public void setWohnortKontinent(String wohnortKontinent) {
        this.wohnortKontinent = wohnortKontinent;
    }

    public void setWohnortLkz(String wohnortLkz) {
        this.wohnortLkz = wohnortLkz;
    }

    public void setWohnortPlz(String wohnortPlz) {
        this.wohnortPlz = wohnortPlz;
    }

    public String getGeburtsortKontinent() {
        return this.geburtsortKontinent;
    }

    public String getGeburtsortLkz() {
        return this.geburtsortLkz;
    }

    public String getGeburtsortPlz() {
        return this.geburtsortPlz;
    }

    public void setGeburtsortKontinent(String geburtsortKontinent) {
        this.geburtsortKontinent = geburtsortKontinent;
    }

    public void setGeburtsortLkz(String geburtsortLkz) {
        this.geburtsortLkz = geburtsortLkz;
    }

    public void setGeburtsortPlz(String geburtsortPlz) {
        this.geburtsortPlz = geburtsortPlz;
    }

    public String getSymptome() {
        return this.symptome;
    }

    public String getAnschrift() {
        return this.anschrift;
    }

    public String getTelefon() {
        return this.telefon;
    }

    public String getHandy() {
        return this.handy;
    }

    public String getInternet() {
        return this.internet;
    }

    public String getEmail() {
        return this.email;
    }

    public void setSymptome(String symptome) {
        this.symptome = symptome;
    }

    public void setAnschrift(String anschrift) {
        this.anschrift = anschrift;
    }

    public void setTelefon(String telefon) {
        this.telefon = telefon;
    }

    public void setHandy(String handy) {
        this.handy = handy;
    }

    public void setInternet(String internet) {
        this.internet = internet;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTimezoneId() {
        return this.timezoneId;
    }

    public void setTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
    }

    public boolean isGmtOffsetManuell() {
        return this.gmtOffsetManuell;
    }

    public void setGmtOffsetManuell(boolean gmtOffsetManuell) {
        this.gmtOffsetManuell = gmtOffsetManuell;
    }

    public boolean isGeburtsortManuell() {
        return this.geburtsortManuell;
    }

    public void setGeburtsortManuell(boolean geburtsortManuell) {
        this.geburtsortManuell = geburtsortManuell;
    }

    public boolean isWohnortManuell() {
        return this.wohnortManuell;
    }

    public void setWohnortManuell(boolean wohnortManuell) {
        this.wohnortManuell = wohnortManuell;
    }

    public int getGmtOffsetInMinutes() {
        return this.gmtOffsetInMinutes;
    }

    public void setGmtOffsetInMinutes(int gmtOffsetInMinutes) {
        this.gmtOffsetInMinutes = gmtOffsetInMinutes;
    }

    public String getUrl1() {
        return this.url1;
    }

    public String getUrl2() {
        return this.url2;
    }

    public String getUrl3() {
        return this.url3;
    }

    public String getKontaktDurch() {
        return this.kontaktDurch;
    }

    public String getAnonymeBezeichnung() {
        return this.anonymeBezeichnung;
    }

    public void setUrl1(String url1) {
        this.url1 = url1;
    }

    public void setUrl2(String url2) {
        this.url2 = url2;
    }

    public void setUrl3(String url3) {
        this.url3 = url3;
    }

    public void setKontaktDurch(String kontaktDurch) {
        this.kontaktDurch = kontaktDurch;
    }

    public void setAnonymeBezeichnung(String anonymeBezeichnung) {
        this.anonymeBezeichnung = anonymeBezeichnung;
    }

    public String getAktuellKontinent() {
        return this.aktuellKontinent;
    }

    public String getAktuellLkz() {
        return this.aktuellLkz;
    }

    public String getAktuellPlz() {
        return this.aktuellPlz;
    }

    public String getAktuellOrt() {
        return this.aktuellOrt;
    }

    public String getAktuellLongitude() {
        return this.aktuellLongitude;
    }

    public String getAktuellLatitude() {
        return this.aktuellLatitude;
    }

    public boolean isAktuellManuell() {
        return this.aktuellManuell;
    }

    public void setAktuellKontinent(String aktuellKontinent) {
        this.aktuellKontinent = aktuellKontinent;
    }

    public void setAktuellLkz(String aktuellLkz) {
        this.aktuellLkz = aktuellLkz;
    }

    public void setAktuellPlz(String aktuellPlz) {
        this.aktuellPlz = aktuellPlz;
    }

    public void setAktuellOrt(String aktuellOrt) {
        this.aktuellOrt = aktuellOrt;
    }

    public void setAktuellLongitude(String aktuellLongitude) {
        this.aktuellLongitude = aktuellLongitude;
    }

    public void setAktuellLatitude(String aktuellLatitude) {
        this.aktuellLatitude = aktuellLatitude;
    }

    public void setAktuellManuell(boolean aktuellManuell) {
        this.aktuellManuell = aktuellManuell;
    }

    public PersonendatenZusatzfilter getPersonendatenZusatzfilter() {
        return this.personendatenZusatzfilter;
    }

    public void setPersonendatenZusatzfilter(PersonendatenZusatzfilter personendatenZusatzfilter) {
        this.personendatenZusatzfilter = personendatenZusatzfilter;
    }

    public List<PersonGruppe> getPersonGruppeList() {
        return this.personGruppeList;
    }

    public void setPersonGruppeList(List<PersonGruppe> personGruppeList) {
        this.personGruppeList = personGruppeList;
    }

    public String getFilterGruppe() {
        return this.filterGruppe;
    }

    public void setFilterGruppe(String filterGruppe) {
        this.filterGruppe = filterGruppe;
    }

    public List<PersonBefund> getPersonBefundList() {
        return this.personBefundList;
    }

    public void setPersonBefundList(List<PersonBefund> personBefundList) {
        this.personBefundList = personBefundList;
    }

    public String getVorgeschichte() {
        return this.vorgeschichte;
    }

    public String getEmpfehlung() {
        return this.empfehlung;
    }

    public void setVorgeschichte(String vorgeschichte) {
        this.vorgeschichte = vorgeschichte;
    }

    public void setEmpfehlung(String empfehlung) {
        this.empfehlung = empfehlung;
    }

    public String getAnrede() {
        return this.anrede;
    }

    public void setAnrede(String anrede) {
        this.anrede = anrede;
    }
}

