/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.exceptions;

import de.cni.common.core.ClassUtils;
import de.cni.common.core.Util;
import java.io.File;

public class PrinterException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ErrorType errorType;
    private String details = null;
    private File file = null;

    public PrinterException(ErrorType errorType, File file, String details) {
        this.errorType = errorType;
        this.file = file;
        this.details = details;
    }

    public PrinterException(ErrorType errorType, File file) {
        this(errorType, file, "");
    }

    public PrinterException(ErrorType errorType, File file, Exception e) {
        this(errorType, file);
        this.details = !Util.isEmpty(e.getMessage()) ? e.getMessage() : ClassUtils.getClassName(e.getClass());
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        switch (this.errorType) {
            case ConnectionException: {
                sb.append("Es kann keine Verbindung zum Open-Office Server hergestellt werden.");
                break;
            }
            case PrinterNotFound: {
                sb.append("Der Drucker wurde nicht gefunden.");
                break;
            }
            case FileNotFound: {
                sb.append("Das zu druckende Dokument wurde nicht gefunden.");
                break;
            }
            case DirNotFound: {
                sb.append("Das zu druckende Verzeichnis wurde nicht gefunden.");
                break;
            }
            case TypeNotSupported: {
                sb.append("Dieser Dateityp kann nicht \u00fcber Open-Office gedruckt werden.");
                break;
            }
            case TechnicalError: {
                sb.append("Beim Drucken ist ein technischer Fehler aufgetreten.");
            }
        }
        if (!Util.isEmpty(this.details)) {
            if (this.file != null) {
                sb.append(" Datei: ");
                sb.append(this.file.getName());
            }
            sb.append("\n" + Util.NotNull(this.details));
        }
        return sb.toString();
    }

    public ErrorType getErrorCode() {
        return this.errorType;
    }

    public static enum ErrorType {
        ConnectionException,
        PrinterNotFound,
        FileNotFound,
        DirNotFound,
        TypeNotSupported,
        TechnicalError;

    }
}

