/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.exceptions;

public class ServerException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ErrorType errorType;

    public ServerException(ErrorType errorType) {
        this.errorType = errorType;
    }

    @Override
    public String getMessage() {
        switch (this.errorType) {
            case CommunicationException: {
                return "Es kann keine Verbindung zum Server hergestellt werden.";
            }
            case NamingException: {
                return "Der Applikationsserver kann nicht erreicht werden.";
            }
            case AuthenticationException: {
                return "Login war nicht erfolgreich.";
            }
        }
        return "";
    }

    public ErrorType getErrorCode() {
        return this.errorType;
    }

    public static enum ErrorType {
        CommunicationException,
        NamingException,
        AuthenticationException;

    }
}

