/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Domain;
import de.cni.common.core.IMappings;
import de.cni.common.core.Util;
import de.cni.common.exceptions.AbortBatchException;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.io.ExportFile;
import de.cni.common.io.ExportModule;
import de.cni.common.io.IExporter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractExporter
implements IExporter {
    private static Log log = LogFactory.getLog(AbstractExporter.class);
    protected static String FIELD_SEPARATOR = "";
    protected static String RECORD_SEPARATOR = "\r\n";
    protected static int JAHR_MIN;
    protected static final int TYPE_A = 1;
    protected static final int TYPE_I = 2;
    protected static final int TYPE_INN = 3;
    protected static final int TYPE_N0 = 4;
    protected static final int TYPE_N1 = 5;
    protected static final int TYPE_N2 = 6;
    protected static final int TYPE_N2V = 7;
    protected static final int TYPE_D = 8;
    protected static final int TYPE_D8 = 9;
    protected static final int TYPE_D10 = 10;
    protected static final int TYPE_T = 11;
    protected static final int TYPE_B = 12;
    protected static final int TYPE_DK = 13;
    protected static final int TYPE_DKN = 14;
    protected static final int TYPE_DL = 15;
    protected static final int TYPE_AR = 16;
    protected static final int TYPE_IGNORE = 17;
    protected int VUNR;
    protected int batchTimeout;
    protected ExportModule module;
    protected ExportFile exportFile;
    protected IMappings mappings;
    protected boolean leadingZeros = false;
    protected int counter = -1;
    protected Object[] valueArray = null;

    public AbstractExporter(ExportModule module) {
        this.module = module;
        JAHR_MIN = DateUtil.getCurrentYear() - 5;
    }

    @Override
    public int export() throws CalculationException, AbortBatchException {
        return 0;
    }

    protected String getExtension() {
        return "txt";
    }

    protected void writeHeaderToFile(ExportFile exportFile) throws IOException {
    }

    protected boolean isSelectDistinct() {
        return false;
    }

    protected String getSql(Element[] ea, int i) {
        return this.getFieldList(ea) + this.getSqlFromPart(i);
    }

    String getFieldList(Element[] ea) {
        StringBuffer sb = this.isSelectDistinct() ? new StringBuffer("select ") : new StringBuffer("select distinct ");
        int cnt = 0;
        for (Element e : ea) {
            if (cnt++ > 0) {
                sb.append(",");
            }
            sb.append(e.name);
        }
        sb.append(" ");
        return sb.toString();
    }

    public void writeRecordToFile(ExportFile exportFile, Element[] ea, Object[] valueArray) throws IOException {
        for (int i = 0; i < ea.length; ++i) {
            Element element = ea[i];
            this.counter = i;
            log.debug((Object)("Print-Position: " + i + " Element=" + element.name));
            if (valueArray[i] == null) {
                exportFile.lprint("", element.len);
                continue;
            }
            if (element.name.startsWith("concat(p.pid")) {
                log.debug((Object)"Debug Zeile");
            }
            switch (element.type) {
                case 1: {
                    Integer iValue;
                    if (valueArray[i] instanceof Integer) {
                        iValue = (Integer)valueArray[i];
                        if (element.intConverter > 0) {
                            String s = this.stringConverter(element.intConverter, Converter.intToString(iValue));
                            iValue = Converter.stringToInt(s);
                        }
                        exportFile.lprint(iValue, element.len);
                        break;
                    }
                    String sValue = (String)valueArray[i];
                    if (element.intConverter > 0) {
                        sValue = this.stringConverter(element.intConverter, sValue);
                    }
                    exportFile.lprint(sValue, element.len);
                    break;
                }
                case 16: {
                    Integer iValue;
                    if (valueArray[i] instanceof Integer) {
                        iValue = (Integer)valueArray[i];
                        if (element.intConverter > 0) {
                            String s = this.stringConverter(element.intConverter, Converter.intToString(iValue));
                            iValue = Converter.stringToInt(s);
                        }
                        exportFile.lprint(iValue, element.len);
                        break;
                    }
                    String srValue = (String)valueArray[i];
                    if (element.intConverter > 0) {
                        srValue = this.stringConverter(element.intConverter, srValue);
                    }
                    exportFile.rprint(srValue, element.len);
                    break;
                }
                case 3: {
                    if (!(valueArray[i] instanceof Integer)) break;
                    Integer iValue = (Integer)valueArray[i];
                    if (element.intConverter > 0) {
                        iValue = this.intConverter(element.intConverter, iValue);
                    }
                    exportFile.rprint(Converter.intToNotNullString(iValue), element.len);
                    break;
                }
                case 2: {
                    Integer iValue;
                    if (valueArray[i] instanceof Integer) {
                        iValue = (Integer)valueArray[i];
                        if (element.intConverter > 0) {
                            iValue = this.intConverter(element.intConverter, iValue);
                        }
                        if (this.isLeadingZeros()) {
                            exportFile.printLeading0(iValue, element.len);
                            break;
                        }
                        exportFile.rprint(iValue, element.len);
                        break;
                    }
                    if (valueArray[i] instanceof Long) {
                        Long lValue = (Long)valueArray[i];
                        if (element.intConverter > 0) {
                            lValue = this.longConverter(element.intConverter, lValue);
                        }
                        if (this.isLeadingZeros()) {
                            exportFile.printLeading0(lValue, element.len);
                            break;
                        }
                        exportFile.rprint(lValue, element.len);
                        break;
                    }
                    if (valueArray[i] instanceof BigInteger) {
                        BigInteger bigValue = (BigInteger)valueArray[i];
                        long lValue = bigValue.longValue();
                        if (element.intConverter > 0) {
                            lValue = this.longConverter(element.intConverter, bigValue.longValue());
                        }
                        if (this.isLeadingZeros()) {
                            exportFile.printLeading0(lValue, element.len);
                            break;
                        }
                        exportFile.rprint(lValue, element.len);
                        break;
                    }
                    String sValue = valueArray[i] instanceof byte[] ? new String((byte[])valueArray[i]) : (String)valueArray[i];
                    if (element.intConverter > 0) {
                        sValue = Converter.intToString(this.intConverter(element.intConverter, Converter.stringToInt(sValue)));
                    }
                    if (this.isLeadingZeros()) {
                        exportFile.printLeading0(Long.parseLong(sValue), element.len);
                        break;
                    }
                    exportFile.rprint(Long.parseLong(sValue), element.len);
                    break;
                }
                case 8: {
                    Date dValue = valueArray[i] instanceof Date ? (Date)valueArray[i] : Converter.stringToDate(new String((byte[])valueArray[i]));
                    if (element.intConverter > 0) {
                        dValue = this.dateConverter(element.intConverter, dValue);
                    }
                    String sValue = Converter.dateToSortableString(dValue);
                    exportFile.lprint(sValue, element.len);
                    break;
                }
                case 9: {
                    Date dValue = valueArray[i] instanceof Date ? (Date)valueArray[i] : (valueArray[i] instanceof String ? Converter.stringToDate((String)valueArray[i]) : Converter.stringToDate(new String((byte[])valueArray[i])));
                    if (element.intConverter > 0) {
                        dValue = this.dateConverter(element.intConverter, dValue);
                    }
                    String sValue = Converter.dateToLongString(dValue);
                    exportFile.lprint(sValue, element.len);
                    break;
                }
                case 10: {
                    Date dValue = valueArray[i] instanceof Date ? (Date)valueArray[i] : (valueArray[i] instanceof String ? Converter.stringToDate((String)valueArray[i]) : Converter.stringToDate(new String((byte[])valueArray[i])));
                    if (element.intConverter > 0) {
                        dValue = this.dateConverter(element.intConverter, dValue);
                    }
                    String sValue = Converter.dateToString(dValue);
                    exportFile.lprint(sValue, element.len);
                    break;
                }
                case 11: {
                    Date dValue = (Date)valueArray[i];
                    String sValue = Converter.timeToSortableString(dValue);
                    exportFile.lprint(sValue + "0", element.len);
                    break;
                }
                case 4: {
                    Double nValue = (Double)valueArray[i];
                    if (element.intConverter > 0) {
                        nValue = this.doubleConverter(element.intConverter, nValue);
                    }
                    if (this.isLeadingZeros()) {
                        exportFile.printLeading0(nValue.longValue(), element.len);
                        break;
                    }
                    exportFile.rprint(nValue.longValue(), element.len);
                    break;
                }
                case 5: {
                    Double nValue = (Double)valueArray[i];
                    if (element.intConverter > 0) {
                        nValue = this.doubleConverter(element.intConverter, nValue);
                    }
                    nValue = Util.euro(nValue * 10.0);
                    if (this.isLeadingZeros()) {
                        exportFile.printLeading0(nValue.longValue(), element.len);
                        break;
                    }
                    exportFile.rprint(nValue.longValue(), element.len);
                    break;
                }
                case 6: {
                    Double nValue = (Double)valueArray[i];
                    if (element.intConverter > 0) {
                        nValue = this.doubleConverter(element.intConverter, nValue);
                    }
                    nValue = Util.euro(nValue * 100.0);
                    if (this.isLeadingZeros()) {
                        exportFile.printLeading0(nValue.longValue(), element.len);
                        break;
                    }
                    exportFile.rprint(nValue.longValue(), element.len);
                    break;
                }
                case 7: {
                    Double nValue = (Double)valueArray[i];
                    if (element.intConverter > 0) {
                        nValue = this.doubleConverter(element.intConverter, nValue);
                    }
                    exportFile.lprint((nValue = Double.valueOf(Util.euro(nValue * 100.0))) < 0.0 ? "-" : "+", 1);
                    if (this.isLeadingZeros()) {
                        exportFile.printLeading0(Math.abs(nValue.longValue()), element.len - 1);
                        break;
                    }
                    exportFile.rprint(Math.abs(nValue.longValue()), element.len - 1);
                    break;
                }
                case 13: {
                    Integer keyKurz = valueArray[i] instanceof BigInteger ? Integer.valueOf(((BigInteger)valueArray[i]).intValue()) : (Integer)valueArray[i];
                    String kurztext = this.mappings.getForceKurztext(element.domain, keyKurz);
                    if (element.intConverter > 0) {
                        kurztext = this.stringConverter(element.intConverter, kurztext);
                    }
                    exportFile.lprint(kurztext, element.len);
                    break;
                }
                case 14: {
                    Integer keyKurz = valueArray[i] instanceof BigInteger ? Integer.valueOf(((BigInteger)valueArray[i]).intValue()) : (Integer)valueArray[i];
                    String kurztext = this.mappings.getForceKurztext(element.domain, keyKurz);
                    if (element.intConverter > 0) {
                        kurztext = this.stringConverter(element.intConverter, kurztext);
                    }
                    exportFile.lprint(Converter.stringToForceLeading0String(kurztext, element.len), element.len);
                    break;
                }
                case 15: {
                    Integer keyLang = valueArray[i] instanceof BigInteger ? Integer.valueOf(((BigInteger)valueArray[i]).intValue()) : (Integer)valueArray[i];
                    String langtext = this.mappings.getForceText(element.domain, keyLang);
                    exportFile.lprint(langtext, element.len);
                    break;
                }
                case 12: {
                    if (valueArray[i] instanceof BigInteger) {
                        int booleanValue = ((BigInteger)valueArray[i]).intValue();
                        exportFile.lprint(booleanValue == 0 ? "N" : "J", element.len);
                        break;
                    }
                    if (valueArray[i] instanceof Integer) {
                        int booleanValue = (Integer)valueArray[i];
                        exportFile.lprint(booleanValue == 0 ? "N" : "J", element.len);
                        break;
                    }
                    Boolean bValue = (Boolean)valueArray[i];
                    exportFile.lprint(bValue == false ? "N" : "J", element.len);
                    break;
                }
                case 17: {
                    if (valueArray[i] instanceof BigInteger) {
                        int iValue = ((BigInteger)valueArray[i]).intValue();
                        this.intConverter(element.intConverter, iValue);
                    }
                    if (valueArray[i] instanceof Integer) {
                        this.intConverter(element.intConverter, (Integer)valueArray[i]);
                    }
                    if (!(valueArray[i] instanceof String)) break;
                    String sV = (String)valueArray[i];
                    this.stringConverter(element.intConverter, sV);
                }
            }
            exportFile.print(FIELD_SEPARATOR);
        }
        exportFile.print(RECORD_SEPARATOR);
    }

    protected int getNumberOfTables() {
        return 1;
    }

    abstract String getSqlFromPart(int var1);

    abstract Element[] getElementArray(int var1);

    protected int intConverter(int converterNumber, int value) {
        return value;
    }

    protected long longConverter(int converterNumber, long value) {
        return value;
    }

    protected String stringConverter(int converterNumber, String value) {
        return value;
    }

    protected double doubleConverter(int converterNumber, double value) {
        return value;
    }

    protected Date dateConverter(int converterNumber, Date value) {
        return value;
    }

    public boolean isLeadingZeros() {
        return this.leadingZeros;
    }

    public void setLeadingZeros(boolean leadingZeros) {
        this.leadingZeros = leadingZeros;
    }

    @Override
    public String getMessage() {
        return null;
    }

    protected class Element {
        FORMAT format;
        String name;
        String ueberschrift;
        int len;
        int type;
        Domain domain;
        int intConverter;

        public Element(String name, int type, Domain domain) {
            this(name, name, type, domain);
        }

        public Element(String name, String ueberschrift, int type, Domain domain) {
            this.name = name;
            this.ueberschrift = ueberschrift;
            this.format = FORMAT.NORMAL;
            this.type = type;
            this.domain = domain;
        }

        public Element(String name, int type, Domain domain, int intConverter) {
            this(name, type, domain);
            this.intConverter = intConverter;
        }

        public Element(String name, String ueberschrift, int type, Domain domain, int intConverter) {
            this(name, ueberschrift, type, domain);
            this.intConverter = intConverter;
        }

        public Element(String name, int len, int type, Domain domain) {
            this.name = name;
            this.len = len;
            this.type = type;
            this.domain = domain;
        }

        public Element(String name, int len, int type, Domain domain, int intConverter) {
            this(name, len, type, domain);
            this.intConverter = intConverter;
        }

        public Element(String name, FORMAT format, int len, int type, Domain domain, int intConverter) {
            this(name, name, format, len, type, domain);
            this.intConverter = intConverter;
        }

        public Element(String name, FORMAT format, int len, int type, Domain domain) {
            this(name, name, format, len, type, domain);
        }

        public Element(String name, String ueberschrift, FORMAT format, int len, int type, Domain domain) {
            this.name = name;
            this.ueberschrift = ueberschrift;
            this.format = format;
            this.len = len;
            this.type = type;
            this.domain = domain;
        }
    }

    public static enum FORMAT {
        NORMAL,
        LEADING_ZERO,
        TRAILING_BLANK;

    }
}

