/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.io.ImportPersonendaten;
import de.cni.common.io.ResultFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportPersonendaten {
    private static Log log = LogFactory.getLog(ExportPersonendaten.class);
    Date now = null;
    ResultFile resultFile;
    StringBuffer message = new StringBuffer();

    public ExportPersonendaten() {
        this.now = new Date();
    }

    public int export(String filename) throws CalculationException {
        try {
            log.debug((Object)"Calculate - Beginn");
            this.resultFile = new ResultFile(filename, StandardCharsets.UTF_8);
            this.writeHeader();
            SqLiteDatabase db = new SqLiteDatabase();
            Personendaten filter = new Personendaten();
            List<IBusinessObject> list = db.select(filter);
            for (IBusinessObject object : list) {
                this.writeLine((Personendaten)object);
            }
            int n = list.size();
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalculationException("Fehler beim Export in eine Datei. " + Util.NotNull(e.getMessage()));
        }
        finally {
            if (this.resultFile != null) {
                this.resultFile.close();
            }
        }
    }

    private void writeHeader() throws IOException {
        for (ImportPersonendaten.Spalte s : ImportPersonendaten.Spalte.values()) {
            this.resultFile.printCsv(s.name());
        }
        this.resultFile.newLine();
    }

    private void writeLine(Personendaten p) throws IOException {
        this.resultFile.printCsv(p.getVorname());
        this.resultFile.printCsv(p.getNachname());
        this.resultFile.printCsv(p.getGeburtsdatumLocal());
        this.resultFile.printCsv(p.getGeburtszeitLocal());
        this.resultFile.printCsv(p.getTimezoneId());
        this.resultFile.printCsv(p.getGmtOffsetInMinutes());
        this.resultFile.printCsv(p.isGmtOffsetManuell());
        this.resultFile.printCsv(p.getGeburtsort());
        this.resultFile.printCsvEncased(p.getLatitude());
        this.resultFile.printCsvEncased(p.getLongitude());
        this.resultFile.printCsv(p.getGeburtsortKontinent());
        this.resultFile.printCsv(p.getGeburtsortLkz());
        this.resultFile.printCsv(p.getGeburtsortPlz());
        this.resultFile.printCsv(p.getTelefon());
        this.resultFile.printCsv(p.getHandy());
        this.resultFile.printCsv(p.getInternet());
        this.resultFile.printCsv(p.getEmail());
        this.resultFile.newLine();
    }
}

