/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.client.calculation.PersonendatenCalculator;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.Converter;
import de.cni.common.core.FormattedStringBuffer;
import de.cni.common.core.Formatter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.InternalErrorException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.exceptions.ReportException;
import de.cni.common.exceptions.TechnicalException;
import de.cni.common.io.AbstractFileImporter;
import de.cni.common.io.ColumnHandler;
import de.cni.common.io.FileProcessor;
import de.cni.common.validation.PersonendatenValidator;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportPersonendaten
extends AbstractFileImporter {
    private static Log log = LogFactory.getLog(ImportPersonendaten.class);
    private static final int INTERVALL_ZWISCHENSUMME = 100;
    private static boolean COMMIT_ALLOWED = false;
    ColumnHandler columnHandler = new ColumnHandler(Spalte.values());
    String filename;
    private int batchTimeout = 0;
    private boolean simulation;
    private Statistik statistik = new Statistik();
    private Personendaten element = new Personendaten();
    SqLiteDatabase db = new SqLiteDatabase();
    PersonendatenValidator validator;
    PersonendatenCalculator calculator;

    public String getResultString() throws IOException {
        if (this.statistik == null) {
            return "";
        }
        FormattedStringBuffer sb = new FormattedStringBuffer();
        int num_len = 10;
        sb.print("Datens\u00e4tze in der Datei       : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzInput), num_len);
        sb.newLine();
        sb.print("Datens\u00e4tze fehlerhaft         : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzErr), num_len);
        sb.newLine();
        sb.print("Datens\u00e4tze ok                 : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzOk), num_len);
        sb.newLine();
        sb.print("Datens\u00e4tze importiert         : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzImp), num_len);
        sb.newLine();
        if (this.statistik.anzErr == 0) {
            sb.println("Der Import war erfolgreich.");
        } else {
            try {
                sb.print("weitere Details               : ");
                sb.println(this.fileProcessor.getResultFile().getFilename());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public ImportPersonendaten(FileProcessor fileProcessor, String filename, boolean simulation) {
        super(fileProcessor);
        this.simulation = simulation;
        this.filename = filename;
        this.validator = new PersonendatenValidator(GlobalData.getInstance().getBrand());
        this.calculator = new PersonendatenCalculator();
        this.now = new Date();
    }

    @Override
    public String getLogfileDir() throws InternalErrorException {
        return "";
    }

    @Override
    public String getImportDir() throws InternalErrorException {
        return "";
    }

    @Override
    public String getResultfileName() throws InternalErrorException {
        return this.filename;
    }

    @Override
    public String getImportFilename() {
        return this.filename;
    }

    @Override
    public String getExtension() {
        return "";
    }

    @Override
    public boolean line2object(String line) throws IOException, DatabaseException, MappingException, TechnicalException, CalculationException {
        String sp;
        boolean saveFlag = true;
        String first = ImportPersonendaten.removeUTF8BOM(this.getCsvToken());
        if (Util.equalsIgnoreCase(first, sp = Spalte.Vorname.toString())) {
            line = ImportPersonendaten.removeUTF8BOM(line);
            this.columnHandler.prepareHeaderMap(line);
            return false;
        }
        this.columnHandler.fillValueMap(line + " ");
        this.element = new Personendaten();
        this.element.setVorname(this.columnHandler.getValue(Spalte.Vorname));
        this.element.setNachname(this.columnHandler.getValue(Spalte.Nachname));
        this.element.setGeburtsdatumLocal(this.columnHandler.getValue(Spalte.Geburtsdatum));
        this.element.setGeburtszeitLocal(this.columnHandler.getValue(Spalte.Geburtszeit));
        this.element.setTimezoneId(this.columnHandler.getValue(Spalte.Zeitzone));
        this.element.setGmtOffsetInMinutes(this.columnHandler.getIntValue(Spalte.GmtOffset));
        this.element.setGmtOffsetManuell(this.columnHandler.getBooleanValue(Spalte.GmtOffsetManuell));
        this.element.setGeburtsort(this.columnHandler.getValue(Spalte.Geburtsort));
        this.element.setLatitude(Converter.strip(this.columnHandler.getValue(Spalte.Latitude), "\""));
        this.element.setLongitude(Converter.strip(this.columnHandler.getValue(Spalte.longitude), "\""));
        this.element.setGeburtsortKontinent(this.columnHandler.getValue(Spalte.GeburtsortKontinent));
        this.element.setGeburtsortLkz(this.columnHandler.getValue(Spalte.GeburtsortLkz));
        this.element.setGeburtsortPlz(this.columnHandler.getValue(Spalte.GeburtsortPlz));
        this.element.setTelefon(this.columnHandler.getValue(Spalte.Telefon));
        this.element.setHandy(this.columnHandler.getValue(Spalte.Handy));
        this.element.setInternet(this.columnHandler.getValue(Spalte.Internet));
        this.element.setEmail(this.columnHandler.getValue(Spalte.Email));
        this.calculator.prepareSave(this.element);
        ++this.statistik.anzInput;
        if (!this.checkElement(this.element)) {
            ++this.statistik.anzErr;
            return false;
        }
        ++this.statistik.anzOk;
        log.debug((Object)"Ende line2Object");
        return saveFlag;
    }

    @Override
    public void save(boolean fast) throws DatabaseException {
        try {
            if (this.element == null) {
                return;
            }
            if (this.simulation) {
                return;
            }
            this.db.save(this.element);
            ++this.statistik.anzImp;
        }
        catch (Exception e) {
            ++this.statistik.anzErr;
            e.printStackTrace();
            throw new DatabaseException(DatabaseException.ErrorType.customText, e);
        }
    }

    @Override
    public boolean isRemoveFile() {
        return false;
    }

    @Override
    public void preImport() throws DatabaseException {
        if (this.simulation) {
            return;
        }
        try {
            this.statistik.anzTerminated = 0;
        }
        catch (Exception e) {
            throw new DatabaseException(DatabaseException.ErrorType.customText, e);
        }
    }

    @Override
    public void postImport() throws DatabaseException {
    }

    public static String doImport(String filename, boolean simulation) throws DatabaseException, CalculationException, ReportException {
        try {
            FileProcessor fp = FileProcessor.newTextFileProcessor("UTF-8");
            ImportPersonendaten worker = new ImportPersonendaten(fp, filename, simulation);
            int n = fp.processImport(worker);
            Popup.infoCourier(worker.getResultString());
            return worker.getResultString();
        }
        catch (Exception e) {
            throw new CalculationException("Fehler beim Import. " + Util.NotNull(e.getMessage()));
        }
    }

    private boolean checkElement(Personendaten obj) {
        if (!this.validator.isValid(obj)) {
            try {
                for (String s : this.validator.getErrorList()) {
                    this.fileProcessor.getResultFile().println("Zeile " + this.getLineNumber() + ":  " + s);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static enum Spalte {
        Vorname,
        Nachname,
        Geburtsdatum,
        Geburtszeit,
        Zeitzone,
        GmtOffset,
        GmtOffsetManuell,
        Geburtsort,
        Latitude,
        longitude,
        GeburtsortKontinent,
        GeburtsortLkz,
        GeburtsortPlz,
        Telefon,
        Handy,
        Internet,
        Email;

    }

    private class Statistik {
        int anzInput;
        int anzErr;
        int anzOk;
        int anzImp;
        int anzTerminated;

        private Statistik() {
        }
    }
}

