/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.validation;

import de.cni.common.core.Brand;
import de.cni.common.datamodel.GmsKoordinate;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.TkzGms;
import de.cni.common.datamodel.admin.Analyse;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.datamodel.admin.Settings;
import de.cni.common.validation.AnalyseValidator;
import de.cni.common.validation.GmsKoordinatenValidator;
import de.cni.common.validation.IValidator;
import de.cni.common.validation.PersonendatenValidator;
import de.cni.common.validation.SettingsValidator;
import de.cni.common.validation.TkzGmsValidator;

public class ValidatorFactory {
    public static IValidator createValidator(IBusinessObject bo, Brand brand) {
        if (bo instanceof Personendaten) {
            return new PersonendatenValidator(brand);
        }
        if (bo instanceof Analyse) {
            return new AnalyseValidator(brand);
        }
        if (bo instanceof GmsKoordinate) {
            return new GmsKoordinatenValidator(brand);
        }
        if (bo instanceof TkzGms) {
            return new TkzGmsValidator(brand);
        }
        if (bo instanceof Settings) {
            return new SettingsValidator(brand);
        }
        return null;
    }
}

