/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.validation;

import de.cni.common.core.Brand;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.validation.IValidator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ValidatorTemplate
implements IValidator {
    Brand brand;
    boolean valid = true;
    List<String> errorList;

    public ValidatorTemplate(Brand brand) {
        this.brand = brand;
    }

    @Override
    public boolean isSaveable(IBusinessObject bo) {
        this.valid = true;
        this.errorList = new ArrayList<String>();
        this.checkSaveableConditions(bo);
        return this.valid;
    }

    @Override
    public boolean isValid(IBusinessObject bo) {
        this.valid = true;
        this.isSaveable(bo);
        this.checkValidationConditions(bo);
        return this.valid;
    }

    protected void addErrorToList(String error) {
        this.valid = false;
        this.errorList.add(error);
    }

    protected void addErrorListToList(List<String> list) {
        this.valid = false;
        this.errorList.addAll(list);
    }

    @Override
    public String getErrorText() {
        StringBuffer sb = new StringBuffer("Speichern nicht m\u00f6glich.");
        for (String s : this.errorList) {
            sb.append("\n");
            sb.append(s);
        }
        return sb.toString();
    }

    protected void checkSaveableConditions(IBusinessObject bo) {
    }

    protected void checkValidationConditions(IBusinessObject bo) {
    }

    @Override
    public List<String> getErrorList() {
        return this.errorList;
    }

    protected void pflichtfeld(Brand brand, int x, String feldname) {
        if (this.brand == brand) {
            this.pflichtfeld(x, feldname);
        }
    }

    protected void pflichtfeld(Brand brand, String x, String feldname) {
        if (this.brand == brand) {
            this.pflichtfeld(x, feldname);
        }
    }

    protected void pflichtfeld(String x, String feldname) {
        if (Util.isEmpty(x)) {
            this.addErrorToList(feldname + " ist Pflichtfeld");
        }
    }

    protected void orPflichtfeld(String x, String y, String feldname) {
        if (Util.isEmpty(x) && Util.isEmpty(y)) {
            this.addErrorToList("Entweder " + feldname + " sind Pflichtfeld");
        }
    }

    protected void pflichtfeld(int x, String feldname) {
        if (x == 0) {
            this.addErrorToList(feldname + " ist Pflichtfeld");
        }
    }

    protected void pflichtfeld(Object x, String feldname) {
        if (x == null) {
            this.addErrorToList(feldname + " ist Pflichtfeld");
        }
    }

    protected void checkLength(String value, int length, String feldname) {
        if (!Util.isEmpty(value) && value.length() != length) {
            this.addErrorToList("Das Feld '" + feldname + "' muss genau " + length + " Stellen haben.");
        }
    }

    protected void checkMaxLength(String value, int length, String feldname) {
        if (!Util.isEmpty(value) && value.length() > length) {
            this.addErrorToList("Das Feld '" + feldname + "' darf nicht mehr als " + length + " Stellen haben.");
        }
    }

    protected void checkMinLength(String value, int length, String feldname) {
        if (!Util.isEmpty(value) && value.length() < length) {
            this.addErrorToList("Das Feld '" + feldname + "' muss mindestens " + length + " Stellen haben.");
        }
    }

    protected void beginnEnde(Date beginn, Date ende) {
        this.beginnEnde(beginn, ende, "Das Endedatum darf nicht vor dem Beginn-Datum liegen.");
    }

    protected void beginnEnde(Date beginn, Date ende, String meldung) {
        if (!Util.isEmpty(beginn) && !Util.isEmpty(ende) && Util.compare(beginn, ende) > 0) {
            this.addErrorToList(meldung);
        }
    }

    protected void XorEmpty(double x1, double x2, String feldname1, String feldname2) {
        if (x1 != 0.0 && x2 != 0.0) {
            this.addErrorToList("Nur eines der Felder '" + feldname1 + "' und '" + feldname2 + "' darf gef\u00fcllt sein");
        }
    }
}

