/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import swisseph.DblObj;
import swisseph.Epsilon;
import swisseph.Extensions;
import swisseph.FileData;
import swisseph.FilePtr;
import swisseph.MeffEle;
import swisseph.Nut;
import swisseph.PlanData;
import swisseph.SavePositions;
import swisseph.SidData;
import swisseph.SweDate;
import swisseph.SweHouse;
import swisseph.Swecl;
import swisseph.Swemmoon;
import swisseph.SwephData;
import swisseph.SwephMosh;
import swisseph.SwissData;
import swisseph.SwissLib;
import swisseph.SwissephException;
import swisseph.TransitCalculator;

public class SwissEph {
    SwissData swed = new SwissData();
    SwephMosh smosh;
    SwissLib sl = new SwissLib(this.swed);
    Swecl sc = null;
    Swemmoon sm = new Swemmoon(this.swed, this.sl);
    SweHouse sh = null;
    Extensions ext = null;
    double lastLat = 0.0;
    double lastLong = 0.0;
    int lastHSys = -1;
    private int httpBufSize = 300;
    private int swe_calc_epheflag_sv = 0;
    static final MeffEle[] eff_arr = new MeffEle[]{new MeffEle(1.0, 1.0), new MeffEle(0.99, 0.999979), new MeffEle(0.98, 0.99994), new MeffEle(0.97, 0.999881), new MeffEle(0.96, 0.999811), new MeffEle(0.95, 0.999724), new MeffEle(0.94, 0.999622), new MeffEle(0.93, 0.999497), new MeffEle(0.92, 0.999354), new MeffEle(0.91, 0.999192), new MeffEle(0.9, 0.999), new MeffEle(0.89, 0.998786), new MeffEle(0.88, 0.998535), new MeffEle(0.87, 0.998242), new MeffEle(0.86, 0.997919), new MeffEle(0.85, 0.997571), new MeffEle(0.84, 0.997198), new MeffEle(0.83, 0.996792), new MeffEle(0.82, 0.996316), new MeffEle(0.81, 0.995791), new MeffEle(0.8, 0.995226), new MeffEle(0.79, 0.994625), new MeffEle(0.78, 0.993991), new MeffEle(0.77, 0.993326), new MeffEle(0.76, 0.992598), new MeffEle(0.75, 0.99177), new MeffEle(0.74, 0.990873), new MeffEle(0.73, 0.989919), new MeffEle(0.72, 0.988912), new MeffEle(0.71, 0.987856), new MeffEle(0.7, 0.986755), new MeffEle(0.69, 0.98561), new MeffEle(0.68, 0.984398), new MeffEle(0.67, 0.982986), new MeffEle(0.66, 0.981437), new MeffEle(0.65, 0.979779), new MeffEle(0.64, 0.978024), new MeffEle(0.63, 0.976182), new MeffEle(0.62, 0.974256), new MeffEle(0.61, 0.972253), new MeffEle(0.6, 0.970174), new MeffEle(0.59, 0.968024), new MeffEle(0.58, 0.965594), new MeffEle(0.57, 0.962797), new MeffEle(0.56, 0.959758), new MeffEle(0.55, 0.956515), new MeffEle(0.54, 0.953088), new MeffEle(0.53, 0.949495), new MeffEle(0.52, 0.945741), new MeffEle(0.51, 0.941838), new MeffEle(0.5, 0.93779), new MeffEle(0.49, 0.933563), new MeffEle(0.48, 0.928668), new MeffEle(0.47, 0.923288), new MeffEle(0.46, 0.917527), new MeffEle(0.45, 0.911432), new MeffEle(0.44, 0.905035), new MeffEle(0.43, 0.898353), new MeffEle(0.42, 0.891022), new MeffEle(0.41, 0.88294), new MeffEle(0.4, 0.874312), new MeffEle(0.39, 0.865206), new MeffEle(0.38, 0.855423), new MeffEle(0.37, 0.844619), new MeffEle(0.36, 0.833074), new MeffEle(0.35, 0.820876), new MeffEle(0.34, 0.808031), new MeffEle(0.33, 0.793962), new MeffEle(0.32, 0.778931), new MeffEle(0.31, 0.763021), new MeffEle(0.3, 0.745815), new MeffEle(0.29, 0.727557), new MeffEle(0.28, 0.708234), new MeffEle(0.27, 0.687583), new MeffEle(0.26, 0.665741), new MeffEle(0.25, 0.642597), new MeffEle(0.24, 0.618252), new MeffEle(0.23, 0.592586), new MeffEle(0.22, 0.565747), new MeffEle(0.21, 0.537697), new MeffEle(0.2, 0.508554), new MeffEle(0.19, 0.47842), new MeffEle(0.18, 0.447322), new MeffEle(0.17, 0.415454), new MeffEle(0.16, 0.382892), new MeffEle(0.15, 0.349955), new MeffEle(0.14, 0.316691), new MeffEle(0.13, 0.283565), new MeffEle(0.12, 0.250431), new MeffEle(0.11, 0.218327), new MeffEle(0.1, 0.186794), new MeffEle(0.09, 0.156287), new MeffEle(0.08, 0.128421), new MeffEle(0.07, 0.102237), new MeffEle(0.06, 0.077393), new MeffEle(0.05, 0.054833), new MeffEle(0.04, 0.036361), new MeffEle(0.03, 0.020953), new MeffEle(0.02, 0.009645), new MeffEle(0.01, 0.002767), new MeffEle(0.0, 0.0)};
    int chck_nut_nutflag = 0;

    public SwissEph() {
        this(null);
    }

    public SwissEph(String path) {
        this.smosh = new SwephMosh(this.sl, this, this.swed);
        this.swed.ephe_path_is_set = false;
        this.swed.jpl_file_is_open = false;
        this.swed.fixfp = null;
        this.swed.ephepath = ".:./ephe:/users/ephe2/:/users/ephe/";
        this.swed.jplfnam = "de406.eph";
        this.swed.geopos_is_set = false;
        this.swed.ayana_is_set = false;
        this.swe_set_ephe_path(path);
    }

    public void setHttpBufSize(int size) {
        this.httpBufSize = size;
        if (size < 100) {
            this.httpBufSize = 100;
        }
        this.swe_close();
    }

    public int swe_calc_ut(double tjd_ut, int ipl, int iflag, double[] xx, StringBuffer serr) {
        return this.swe_calc(tjd_ut + SweDate.getDeltaT(tjd_ut), ipl, iflag, xx, serr);
    }

    public int swe_calc(double tjd, int ipl, int iflag, double[] xx, StringBuffer serr) {
        int ret = 0;
        try {
            ret = this._calc(tjd, ipl, iflag, xx, serr);
        }
        catch (SwissephException se) {
            ret = se.getRC();
            serr.setLength(0);
            serr.append(se.getMessage());
        }
        return ret;
    }

    public int calc(double jdET, int ipl, int iflag, double[] xx) throws SwissephException {
        return this._calc(jdET, ipl, iflag, xx, new StringBuffer());
    }

    private int _calc(double tjd, int ipl, int iflag, double[] xx, StringBuffer serr) throws SwissephException {
        int j;
        int epheflag;
        int iflgsave = iflag;
        double[] x = new double[6];
        double[] x0 = new double[24];
        double[] x2 = new double[24];
        if ((iflag & 1) != 0) {
            iflag &= 0xFFFFFFF8;
            iflag |= 2;
        }
        if ((iflag & 4) != 0) {
            iflag &= 0xFFFFFFF8;
            iflag |= 2;
        }
        if (((epheflag = iflag & 7) & 2) != 0) {
            epheflag = 0;
        }
        if (this.swe_calc_epheflag_sv != epheflag && ipl != -1) {
            this.swe_close();
            this.swe_calc_epheflag_sv = epheflag;
        }
        if ((iflag & 0x80) != 0 && (iflag & 0x100) != 0) {
            iflag &= 0xFFFFFF7F;
        }
        if ((iflag & 0x1000) != 0 && (iflag & 0x2000) != 0) {
            iflag &= 0xFFFFDFFF;
        }
        SavePositions sd = ipl < 21 && ipl >= 0 ? this.swed.savedat[ipl] : this.swed.savedat[21];
        int iflgcoor = 14336;
        try {
            if (sd.tsave != tjd || tjd == 0.0 || ipl != sd.ipl || (sd.iflgsave & ~iflgcoor) != (iflag & ~iflgcoor)) {
                if ((iflag & 0x80) == 0) {
                    sd.tsave = tjd;
                    sd.ipl = ipl;
                    sd.iflgsave = this.swecalc(tjd, ipl, iflag, sd.xsaves, serr);
                    if (sd.iflgsave == -1) {
                        return this.swe_calc_error(xx);
                    }
                } else {
                    double dt;
                    sd.tsave = tjd;
                    sd.ipl = ipl;
                    switch (ipl) {
                        case 1: {
                            dt = 5.0E-5;
                            break;
                        }
                        case 11: 
                        case 13: {
                            dt = 0.1;
                            break;
                        }
                        default: {
                            dt = 1.0E-4;
                        }
                    }
                    sd.iflgsave = this.swecalc(tjd - dt, ipl, iflag, x0, serr);
                    if (sd.iflgsave == -1) {
                        return this.swe_calc_error(xx);
                    }
                    sd.iflgsave = this.swecalc(tjd + dt, ipl, iflag, x2, serr);
                    if (sd.iflgsave == -1) {
                        return this.swe_calc_error(xx);
                    }
                    sd.iflgsave = this.swecalc(tjd, ipl, iflag, sd.xsaves, serr);
                    if (sd.iflgsave == -1) {
                        return this.swe_calc_error(xx);
                    }
                    this.denormalize_positions(x0, sd.xsaves, x2);
                    this.calc_speed(x0, sd.xsaves, x2, dt);
                }
            }
        }
        catch (SwissephException se) {
            sd.iflgsave = -1;
            this.swe_calc_error(xx);
            throw se;
        }
        int xsOffset = 0;
        double[] xs = sd.xsaves;
        if ((iflag & 0x800) != 0) {
            xsOffset = 12;
        }
        if ((iflag & 0x1000) != 0) {
            xsOffset += 6;
        }
        int i = ipl == -1 ? 4 : 3;
        for (j = 0; j < i; ++j) {
            x[j] = xs[j + xsOffset];
        }
        for (j = i; j < 6; ++j) {
            x[j] = 0.0;
        }
        if ((iflag & 0x180) != 0) {
            for (j = 3; j < 6; ++j) {
                x[j] = xs[j + xsOffset];
            }
        }
        if ((iflag & 0x2000) != 0) {
            if (ipl == -1) {
                j = 0;
                while (j < 4) {
                    int n = j++;
                    x[n] = x[n] * 0.0174532925199433;
                }
            } else {
                j = 0;
                while (j < 2) {
                    int n = j++;
                    x[n] = x[n] * 0.0174532925199433;
                }
                if ((iflag & 0x180) != 0) {
                    j = 3;
                    while (j < 5) {
                        int n = j++;
                        x[n] = x[n] * 0.0174532925199433;
                    }
                }
            }
        }
        for (i = 0; i <= 5; ++i) {
            xx[i] = x[i];
        }
        iflag = sd.iflgsave;
        if ((iflgsave & 7) == 0) {
            iflag &= 0xFFFFFFFD;
        }
        return iflag;
    }

    public void swe_close() {
        try {
            int i;
            for (i = 0; i < 7; ++i) {
                this.swed.fidat[i].clearData();
            }
            for (i = 0; i < 18; ++i) {
                this.swed.pldat[i].clearData();
            }
            for (i = 0; i <= 21; ++i) {
                this.swed.savedat[i].clearData();
            }
            for (i = 0; i < 4; ++i) {
                this.swed.nddat[i].clearData();
            }
            this.swed.oec.clearData();
            this.swed.oec2000.clearData();
            this.swed.nut.clearData();
            this.swed.nut2000.clearData();
            this.swed.nutv.clearData();
            this.swed.jpl_file_is_open = false;
            if (this.swed.fixfp != null) {
                this.swed.fixfp.close();
                this.swed.fixfp = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void swe_set_ephe_path(String path) {
        String s = "";
        this.swed.ephe_path_is_set = true;
        this.swe_close();
        s = path == null || path.length() == 0 ? ".:./ephe:/users/ephe2/:/users/ephe/" : (path.length() <= 242 ? path : ".:./ephe:/users/ephe2/:/users/ephe/");
        this.swed.ephepath = s;
    }

    public void swe_set_jpl_file(String fname) {
        this.swe_close();
        if (fname.indexOf(this.swed.DIR_GLUE) >= 0) {
            fname = fname.substring(fname.lastIndexOf(this.swed.DIR_GLUE));
        }
        if (fname.length() >= 256) {
            fname = fname.substring(0, 256);
        }
        this.swed.jplfnam = fname;
    }

    public void swe_set_sid_mode(int sid_mode, double t0, double ayan_t0) {
        SidData sip = this.swed.sidd;
        sip.sid_mode = sid_mode;
        if (sid_mode >= 256) {
            sid_mode %= 256;
        }
        if (sid_mode == 18 || sid_mode == 19 || sid_mode == 20) {
            sip.sid_mode |= 0x100;
        }
        if (sid_mode >= 21 && sid_mode != 255) {
            sid_mode = 0;
            sip.sid_mode = 0;
        }
        this.swed.ayana_is_set = true;
        if (sid_mode == 255) {
            sip.t0 = t0;
            sip.ayan_t0 = ayan_t0;
        } else {
            sip.t0 = SwephData.ayanamsa[sid_mode].t0;
            sip.ayan_t0 = SwephData.ayanamsa[sid_mode].ayan_t0;
        }
        this.swi_force_app_pos_etc();
    }

    public double swe_get_ayanamsa(double tjd_et) {
        double[] x = new double[6];
        SidData sip = this.swed.sidd;
        if (!this.swed.ayana_is_set) {
            this.swe_set_sid_mode(0, 0.0, 0.0);
        }
        x[0] = 1.0;
        x[2] = 0.0;
        x[1] = 0.0;
        if (tjd_et != 2451545.0) {
            this.sl.swi_precess(x, tjd_et, 1);
        }
        this.sl.swi_precess(x, sip.t0, -1);
        double eps = this.sl.swi_epsiln(sip.t0);
        this.sl.swi_coortrf(x, x, eps);
        this.sl.swi_cartpol(x, x);
        x[0] = x[0] * 57.2957795130823 - sip.ayan_t0;
        return this.sl.swe_degnorm(-x[0]);
    }

    public double swe_get_ayanamsa_ut(double tjd_ut) {
        return this.swe_get_ayanamsa(tjd_ut + SweDate.getDeltaT(tjd_ut));
    }

    public int swe_fixstar(StringBuffer star, double tjd, int iflag, double[] xx, StringBuffer serr) {
        int cmplen;
        int star_nr = 0;
        boolean isnomclat = false;
        String sstar = null;
        String fstar = null;
        int line = 0;
        int fline = 0;
        int epheflag = 0;
        int iflgsave = iflag;
        if (serr != null) {
            serr.setLength(0);
        }
        if (((iflag = this.plaus_iflag(iflag)) & 0x10000) != 0 && !this.swed.ayana_is_set) {
            this.swe_set_sid_mode(0, 0.0, 0.0);
        }
        epheflag = iflag & 7;
        this.swi_check_ecliptic(tjd);
        this.swi_check_nutation(tjd, iflag);
        if (this.swed.fixfp == null) {
            try {
                this.swed.fixfp = this.swi_fopen(4, "fixstars.cat", this.swed.ephepath, serr);
            }
            catch (SwissephException se) {
                return this.swe_fixstar_error(xx, -1);
            }
        }
        this.swed.fixfp.seek(0L);
        sstar = star.toString().substring(0, Math.min(star.length(), 20));
        if (sstar.length() > 0) {
            if (sstar.charAt(0) == ',') {
                isnomclat = true;
            } else if (Character.isDigit(sstar.charAt(0))) {
                star_nr = Integer.parseInt(sstar);
            } else if ((sstar = sstar.toLowerCase()).indexOf(44) >= 0) {
                sstar = sstar.substring(0, sstar.indexOf(44));
            }
            sstar = sstar.trim();
        }
        if ((cmplen = sstar.length()) == 0) {
            if (serr != null) {
                serr.setLength(0);
                serr.append("star name empty");
            }
            return this.swe_fixstar_error(xx, -1);
        }
        try {
            String s;
            while ((s = this.swed.fixfp.readLine()) != null) {
                int i;
                ++fline;
                if (s.startsWith("#")) continue;
                if (star_nr == ++line) {
                    return this.swe_fixstar_found(serr, s, star, tjd, iflag, iflgsave, epheflag, xx);
                }
                if (star_nr > 0) continue;
                if (s.indexOf(44) < 0) {
                    if (serr != null) {
                        serr.setLength(0);
                        serr.append("star file fixstars.cat damaged at line " + fline);
                    }
                    return this.swe_fixstar_error(xx, -1);
                }
                String sp = s.substring(s.indexOf(44));
                if (!(isnomclat ? sp.substring(0, Math.min(sp.length(), cmplen)).equals(sstar.substring(0, Math.min(sstar.length(), cmplen))) : (i = (fstar = s.substring(0, Math.min(20, s.indexOf(44))).trim()).length()) >= cmplen && (fstar = fstar.toLowerCase()).substring(0, Math.min(fstar.length(), cmplen)).equals(sstar.substring(0, Math.min(sstar.length(), cmplen))))) continue;
                return this.swe_fixstar_found(serr, s, star, tjd, iflag, iflgsave, epheflag, xx);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (serr != null && star.length() < 236) {
            serr.setLength(0);
            serr.append("star " + star + " not found");
        }
        return this.swe_fixstar_error(xx, -1);
    }

    public int swe_fixstar_ut(StringBuffer star, double tjd_ut, int iflag, double[] xx, StringBuffer serr) {
        return this.swe_fixstar(star, tjd_ut + SweDate.getDeltaT(tjd_ut), iflag, xx, serr);
    }

    public String swe_get_planet_name(int ipl) {
        String s = "";
        double[] xp = new double[6];
        if (ipl != 0 && ipl == this.swed.i_saved_planet_name) {
            s = this.swed.saved_planet_name;
            return s;
        }
        switch (ipl) {
            case 0: {
                return "Sun";
            }
            case 1: {
                return "Moon";
            }
            case 2: {
                return "Mercury";
            }
            case 3: {
                return "Venus";
            }
            case 4: {
                return "Mars";
            }
            case 5: {
                return "Jupiter";
            }
            case 6: {
                return "Saturn";
            }
            case 7: {
                return "Uranus";
            }
            case 8: {
                return "Neptune";
            }
            case 9: {
                return "Pluto";
            }
            case 10: {
                return "mean Node";
            }
            case 11: {
                return "true Node";
            }
            case 12: {
                return "mean Apogee";
            }
            case 13: {
                return "osc. Apogee";
            }
            case 14: {
                return "Earth";
            }
            case 15: 
            case 12060: {
                return "Chiron";
            }
            case 16: 
            case 15145: {
                return "Pholus";
            }
            case 17: 
            case 10001: {
                return "Ceres";
            }
            case 18: 
            case 10002: {
                return "Pallas";
            }
            case 19: 
            case 10003: {
                return "Juno";
            }
            case 20: 
            case 10004: {
                return "Vesta";
            }
        }
        if (ipl >= 40 && ipl <= 999) {
            return this.smosh.swi_get_fict_name(ipl - 40, s);
        }
        if (ipl > 10000) {
            int retc;
            s = ipl == this.swed.fidat[3].ipl[0] ? this.swed.fidat[3].astnam : ((retc = this.sweph(2451545.0, ipl, 3, 0, null, false, xp, null)) != -1 && retc != -2 ? this.swed.fidat[3].astnam : ipl - 10000 + ": not found");
            if (s.charAt(0) == '?' || Character.isDigit(s.charAt(1))) {
                int ipli = ipl - 10000;
                int iplf = 0;
                FilePtr fp = null;
                try {
                    fp = this.swi_fopen(-1, "seasnam.txt", this.swed.ephepath, null);
                }
                catch (SwissephException swissephException) {
                    // empty catch block
                }
                if (fp != null) {
                    while (ipli != iplf) {
                        try {
                            String si = fp.readLine();
                            if (si != null) {
                                StringTokenizer tk = new StringTokenizer(si, " \t([{");
                                String sk = tk.nextToken();
                                if (sk.startsWith("#") || Character.isWhitespace(sk.charAt(0)) || ipli != (iplf = Double.valueOf(sk).intValue())) continue;
                                s = tk.nextToken("#\r\n").trim();
                                fp.close();
                            }
                            break;
                        }
                        catch (IOException tk) {
                        }
                        catch (NoSuchElementException nse) {}
                    }
                }
            }
        } else {
            int i = ipl;
            s = "" + i;
        }
        if (s.length() < 80) {
            this.swed.i_saved_planet_name = ipl;
            this.swed.saved_planet_name = s;
        }
        return s;
    }

    String swe_get_ayanamsa_name(int isidmode) {
        if (isidmode < 21) {
            return SwissData.ayanamsa_name[isidmode];
        }
        return null;
    }

    public void swe_set_topo(double geolon, double geolat, double geoalt) {
        this.swed.topd.geolon = geolon;
        this.swed.topd.geolat = geolat;
        this.swed.topd.geoalt = geoalt;
        this.swed.geopos_is_set = true;
        this.swed.topd.teval = 0.0;
        this.swi_force_app_pos_etc();
    }

    public void swe_azalt(double tjd_ut, int calc_flag, double[] geopos, double atpress, double attemp, double[] xin, double[] xaz) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        this.sc.swe_azalt(tjd_ut, calc_flag, geopos, atpress, attemp, xin, xaz);
    }

    public void swe_azalt_rev(double tjd_ut, int calc_flag, double[] geopos, double[] xin, double[] xout) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        this.sc.swe_azalt_rev(tjd_ut, calc_flag, geopos, xin, xout);
    }

    public int swe_lun_eclipse_how(double tjd_ut, int ifl, double[] geopos, double[] attr, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_lun_eclipse_how(tjd_ut, ifl, geopos, attr, serr);
    }

    public int swe_lun_eclipse_when(double tjd_start, int ifl, int ifltype, double[] tret, int backward, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_lun_eclipse_when(tjd_start, ifl, ifltype, tret, backward, serr);
    }

    public int swe_nod_aps(double tjd_et, int ipl, int iflag, int method, double[] xnasc, double[] xndsc, double[] xperi, double[] xaphe, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_nod_aps(tjd_et, ipl, iflag, method, xnasc, xndsc, xperi, xaphe, serr);
    }

    public int swe_nod_aps_ut(double tjd_ut, int ipl, int iflag, int method, double[] xnasc, double[] xndsc, double[] xperi, double[] xaphe, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_nod_aps_ut(tjd_ut, ipl, iflag, method, xnasc, xndsc, xperi, xaphe, serr);
    }

    public int swe_pheno(double tjd, int ipl, int iflag, double[] attr, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_pheno(tjd, ipl, iflag, attr, serr);
    }

    public int swe_pheno_ut(double tjd_ut, int ipl, int iflag, double[] attr, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_pheno_ut(tjd_ut, ipl, iflag, attr, serr);
    }

    public double swe_refrac(double inalt, double atpress, double attemp, int calc_flag) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_refrac(inalt, atpress, attemp, calc_flag);
    }

    public int swe_rise_trans(double tjd_ut, int ipl, StringBuffer starname, int epheflag, int rsmi, double[] geopos, double atpress, double attemp, DblObj tret, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_rise_trans(tjd_ut, ipl, starname, epheflag, rsmi, geopos, atpress, attemp, tret, serr);
    }

    public int swe_sol_eclipse_how(double tjd_ut, int ifl, double[] geopos, double[] attr, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_sol_eclipse_how(tjd_ut, ifl, geopos, attr, serr);
    }

    public int swe_sol_eclipse_when_glob(double tjd_start, int ifl, int ifltype, double[] tret, int backward, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_sol_eclipse_when_glob(tjd_start, ifl, ifltype, tret, backward, serr);
    }

    public int swe_sol_eclipse_when_loc(double tjd_start, int ifl, double[] geopos, double[] tret, double[] attr, int backward, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_sol_eclipse_when_loc(tjd_start, ifl, geopos, tret, attr, backward, serr);
    }

    public int swe_sol_eclipse_where(double tjd_ut, int ifl, double[] geopos, double[] attr, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_sol_eclipse_where(tjd_ut, ifl, geopos, attr, serr);
    }

    public int swe_lun_occult_when_loc(double tjd_start, int ipl, StringBuffer starname, int ifl, double[] geopos, double[] tret, double[] attr, int backward, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_lun_occult_when_loc(tjd_start, ipl, starname, ifl, geopos, tret, attr, backward, serr);
    }

    public int swe_lun_occult_where(double tjd_ut, int ipl, StringBuffer starname, int ifl, double[] geopos, double[] attr, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_lun_occult_where(tjd_ut, ipl, starname, ifl, geopos, attr, serr);
    }

    public int swe_lun_occult_when_glob(double tjd_start, int ipl, StringBuffer starname, int ifl, int ifltype, double[] tret, int backward, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_lun_occult_when_glob(tjd_start, ipl, starname, ifl, ifltype, tret, backward, serr);
    }

    public int swe_gauquelin_sector(double t_ut, int ipl, StringBuffer starname, int iflag, int imeth, double[] geopos, double atpress, double attemp, DblObj dgsect, StringBuffer serr) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, null, this.swed);
        }
        return this.sc.swe_gauquelin_sector(t_ut, ipl, starname, iflag, imeth, geopos, atpress, attemp, dgsect, serr);
    }

    public double swe_house_pos(double armc, double geolat, double eps, int hsys, double[] xpin, StringBuffer serr) {
        if (this.sh == null) {
            this.sh = new SweHouse(this.sl, this, this.swed);
        }
        return this.sh.swe_house_pos(armc, geolat, eps, hsys, xpin, serr);
    }

    public int swe_houses_armc(double armc, double geolat, double eps, int hsys, double[] cusp, double[] ascmc) {
        if (this.sh == null) {
            this.sh = new SweHouse(this.sl, this, this.swed);
        }
        return this.sh.swe_houses_armc(armc, geolat, eps, hsys, cusp, ascmc, 0);
    }

    public int swe_houses(double tjd_ut, int iflag, double geolat, double geolon, int hsys, double[] cusp, double[] ascmc) {
        return this.swe_houses(tjd_ut, iflag, geolat, geolon, hsys, cusp, ascmc, 0);
    }

    public int swe_houses(double tjd_ut, int iflag, double geolat, double geolon, int hsys, double[] cusp, double[] ascmc, int aOffs) {
        if (this.sh == null) {
            this.sh = new SweHouse(this.sl, this, this.swed);
        }
        return this.sh.swe_houses(tjd_ut, iflag, geolat, geolon, hsys, cusp, ascmc, aOffs);
    }

    public double getTransitET(TransitCalculator tc, double jdET, boolean backwards) throws IllegalArgumentException, SwissephException {
        return this.getTransitET(tc, jdET, backwards, backwards ? -1.7976931348623157E308 : Double.MAX_VALUE);
    }

    public double getTransitET(TransitCalculator tc, double jdET, boolean backwards, double jdLimit) throws IllegalArgumentException, SwissephException {
        if (this.ext == null) {
            this.ext = new Extensions(this);
        }
        return this.ext.getTransit(tc, jdET, backwards, jdLimit);
    }

    public double getTransitUT(TransitCalculator tc, double jdUT, boolean backwards) throws IllegalArgumentException, SwissephException {
        if (this.ext == null) {
            this.ext = new Extensions(this);
        }
        return this.ext.getTransit(tc, jdUT + SweDate.getDeltaT(jdUT), backwards, backwards ? -1.7976931348623157E308 : Double.MAX_VALUE);
    }

    public double getTransitUT(TransitCalculator tc, double jdUT, boolean backwards, double jdLimit) throws IllegalArgumentException, SwissephException {
        if (this.ext == null) {
            this.ext = new Extensions(this);
        }
        return this.ext.getTransit(tc, jdUT + SweDate.getDeltaT(jdUT), backwards, jdLimit + SweDate.getDeltaT(jdLimit));
    }

    private int swe_calc_error(double[] xx) {
        for (int i = 0; i < xx.length; ++i) {
            xx[i] = 0.0;
        }
        return -1;
    }

    int swecalc(double tjd, int ipl, int iflag, double[] x, StringBuffer serr) throws SwissephException {
        int i;
        double[] xp2;
        PlanData ndp;
        int retc;
        double[] xp;
        PlanData pdp;
        int ipli;
        int epheflag = 2;
        PlanData pedp = this.swed.pldat[0];
        PlanData psdp = this.swed.pldat[10];
        String serr2 = "";
        if (serr != null) {
            serr.setLength(0);
        }
        if (((iflag = this.plaus_iflag(iflag)) & 4) != 0) {
            epheflag = 4;
        }
        if ((iflag & 2) != 0) {
            epheflag = 2;
        }
        if ((iflag & 1) != 0) {
            epheflag = 1;
        }
        if ((iflag & 0x4000) != 0 && (iflag & 4) != 0) {
            if (serr != null) {
                serr.append("barycentric Moshier positions are not supported.");
            }
            throw new SwissephException(tjd, 1152, -1, serr);
        }
        if (epheflag != 4 && !this.swed.ephe_path_is_set) {
            this.swe_set_ephe_path(null);
        }
        if ((iflag & 0x10000) != 0 && !this.swed.ayana_is_set) {
            this.swe_set_sid_mode(0, 0.0, 0.0);
        }
        this.swi_check_ecliptic(tjd);
        this.swi_check_nutation(tjd, iflag);
        if (ipl == -1) {
            x[0] = this.swed.oec.eps + this.swed.nut.nutlo[1];
            x[1] = this.swed.oec.eps;
            x[2] = this.swed.nut.nutlo[0];
            x[3] = this.swed.nut.nutlo[1];
            int i2 = 0;
            while (i2 <= 3) {
                int n = i2++;
                x[n] = x[n] * 57.2957795130823;
            }
            return iflag;
        }
        if (ipl == 1) {
            ipli = 1;
            pdp = this.swed.pldat[ipli];
            xp = pdp.xreturn;
            switch (epheflag) {
                case 2: {
                    retc = this.sweph_moon(tjd, ipli, iflag, serr);
                    if (retc != -1) break;
                    return this.swecalc_error(x);
                }
            }
            retc = this.app_pos_etc_moon(iflag, serr);
            if (retc != 0) {
                return this.swecalc_error(x);
            }
        } else if (ipl == 0 && (iflag & 0x4000) != 0) {
            ipli = 0;
            xp = pedp.xreturn;
            switch (epheflag) {
                case 2: {
                    retc = this.sweph_sbar(tjd, iflag, psdp, pedp, serr);
                    if (retc != -1) break;
                    return this.swecalc_error(x);
                }
                default: {
                    return -1;
                }
            }
            retc = this.app_pos_etc_sbar(iflag, serr);
            if (retc != 0) {
                return this.swecalc_error(x);
            }
            iflag = pedp.xflgs;
            pedp.xflgs = -1;
        } else if (ipl == 0 || ipl == 2 || ipl == 3 || ipl == 4 || ipl == 5 || ipl == 6 || ipl == 7 || ipl == 8 || ipl == 9 || ipl == 14) {
            if ((iflag & 8) != 0) {
                if (ipl == 0) {
                    for (int i3 = 0; i3 < 24; ++i3) {
                        x[i3] = 0.0;
                    }
                    return iflag;
                }
            } else if ((iflag & 0x4000) == 0 && ipl == 14) {
                for (int i4 = 0; i4 < 24; ++i4) {
                    x[i4] = 0.0;
                }
                return iflag;
            }
            ipli = SwissData.pnoext2int[ipl];
            pdp = this.swed.pldat[ipli];
            xp = pdp.xreturn;
            retc = this.main_planet(tjd, ipli, epheflag, iflag, serr);
            if (retc == -1) {
                return this.swecalc_error(x);
            }
            iflag = pdp.xflgs;
        } else if (ipl == 10) {
            if ((iflag & 8) != 0 || (iflag & 0x4000) != 0) {
                for (int i5 = 0; i5 < 24; ++i5) {
                    x[i5] = 0.0;
                }
                return iflag;
            }
            ndp = this.swed.nddat[0];
            xp = ndp.xreturn;
            xp2 = ndp.x;
            retc = this.sm.swi_mean_node(tjd, xp2, serr);
            if (retc == -1) {
                return this.swecalc_error(x);
            }
            retc = this.sm.swi_mean_node(tjd - 0.001, xp2, 3, serr);
            if (retc == -1) {
                return this.swecalc_error(x);
            }
            xp2[3] = this.sl.swe_difrad2n(xp2[0], xp2[3]) / 0.001;
            xp2[5] = 0.0;
            xp2[4] = 0.0;
            ndp.teval = tjd;
            ndp.xflgs = -1;
            retc = this.app_pos_etc_mean(0, iflag, serr);
            if (retc != 0) {
                return this.swecalc_error(x);
            }
            if ((iflag & 0x10000) == 0 && (iflag & 0x20) == 0) {
                ndp.xreturn[1] = 0.0;
                ndp.xreturn[4] = 0.0;
                ndp.xreturn[5] = 0.0;
                ndp.xreturn[8] = 0.0;
                ndp.xreturn[11] = 0.0;
            }
            if (retc == -1) {
                return this.swecalc_error(x);
            }
        } else if (ipl == 12) {
            if ((iflag & 8) != 0 || (iflag & 0x4000) != 0) {
                for (int i6 = 0; i6 < 24; ++i6) {
                    x[i6] = 0.0;
                }
                return iflag;
            }
            ndp = this.swed.nddat[2];
            xp = ndp.xreturn;
            xp2 = ndp.x;
            retc = this.sm.swi_mean_apog(tjd, xp2, serr);
            if (retc == -1) {
                return this.swecalc_error(x);
            }
            retc = this.sm.swi_mean_apog(tjd - 0.001, xp2, 3, serr);
            if (retc == -1) {
                return this.swecalc_error(x);
            }
            for (i = 0; i <= 1; ++i) {
                xp2[3 + i] = this.sl.swe_difrad2n(xp2[i], xp2[3 + i]) / 0.001;
            }
            xp2[5] = 0.0;
            ndp.teval = tjd;
            ndp.xflgs = -1;
            retc = this.app_pos_etc_mean(2, iflag, serr);
            if (retc != 0) {
                return this.swecalc_error(x);
            }
            ndp.xreturn[5] = 0.0;
            if (retc == -1) {
                return this.swecalc_error(x);
            }
        } else if (ipl == 11) {
            if ((iflag & 8) != 0 || (iflag & 0x4000) != 0) {
                for (int i7 = 0; i7 < 24; ++i7) {
                    x[i7] = 0.0;
                }
                return iflag;
            }
            ndp = this.swed.nddat[1];
            xp = ndp.xreturn;
            retc = this.lunar_osc_elem(tjd, 1, iflag, serr);
            iflag = ndp.xflgs;
            if ((iflag & 0x10000) == 0 && (iflag & 0x20) == 0) {
                ndp.xreturn[1] = 0.0;
                ndp.xreturn[4] = 0.0;
                ndp.xreturn[8] = 0.0;
                ndp.xreturn[11] = 0.0;
            }
            if (retc == -1) {
                return this.swecalc_error(x);
            }
        } else if (ipl == 13) {
            if ((iflag & 8) != 0 || (iflag & 0x4000) != 0) {
                for (int i8 = 0; i8 < 24; ++i8) {
                    x[i8] = 0.0;
                }
                return iflag;
            }
            ndp = this.swed.nddat[3];
            xp = ndp.xreturn;
            retc = this.lunar_osc_elem(tjd, 3, iflag, serr);
            iflag = ndp.xflgs;
            if (retc == -1) {
                return this.swecalc_error(x);
            }
        } else if (ipl == 15 || ipl == 16 || ipl == 17 || ipl == 18 || ipl == 19 || ipl == 20 || ipl > 10000) {
            if (ipl < 21) {
                ipli = SwissData.pnoext2int[ipl];
            } else if (ipl <= 10004) {
                ipli = 14 + ipl - 10000 - 1;
                ipl = 17 + ipl - 10000 - 1;
            } else {
                ipli = 11;
            }
            int ipli_ast = ipli == 11 ? ipl : ipli;
            pdp = this.swed.pldat[ipli];
            xp = pdp.xreturn;
            int ifno = ipli_ast > 10000 ? 3 : 2;
            if (ipli == 12 && (tjd < 1958470.5 || tjd > 3419437.5)) {
                if (serr != null) {
                    serr.setLength(0);
                    serr.append("Chiron's ephemeris is restricted to JD 1958470.5 - JD 3419437.5");
                }
                return -1;
            }
            if (ipli == 13 && tjd < 314845.5) {
                if (serr != null) {
                    serr.setLength(0);
                    serr.append("Pholus's ephemeris is restricted to the time after JD 314845.5");
                }
                return -1;
            }
            retc = this.main_planet(tjd, 0, epheflag, iflag, serr);
            if (retc == -1) {
                return this.swecalc_error(x);
            }
            iflag = this.swed.pldat[0].xflgs;
            if (serr != null) {
                serr2 = serr.toString();
                serr.setLength(0);
            }
            if ((retc = this.sweph(tjd, ipli_ast, ifno, iflag, psdp.x, true, null, serr)) == -1 || retc == -2) {
                return this.swecalc_error(x);
            }
            retc = this.app_pos_etc_plan(ipli_ast, iflag, serr);
            if (retc == -1) {
                return this.swecalc_error(x);
            }
            if (retc == -2 || retc == -3) {
                return this.swecalc_error(x);
            }
            if (serr != null && serr.length() == 0 && serr2.length() != 0) {
                serr.setLength(0);
                serr2 = serr2.substring(0, Math.min(serr2.length(), 251));
                serr.append("sun: " + serr2);
            }
        } else if (ipl >= 40 && ipl <= 999) {
            ipli = 11;
            pdp = this.swed.pldat[ipli];
            xp = pdp.xreturn;
            retc = this.main_planet(tjd, 0, epheflag, iflag, serr);
            iflag = this.swed.pldat[0].xflgs;
            if (this.smosh.swi_osc_el_plan(tjd, pdp.x, ipl - 40, ipli, pedp.x, psdp.x, serr) != 0) {
                return this.swecalc_error(x);
            }
            if (retc == -1) {
                return this.swecalc_error(x);
            }
            retc = this.app_pos_etc_plan_osc(ipl, ipli, iflag, serr);
            if (retc == -1) {
                return this.swecalc_error(x);
            }
            if (retc == -2 || retc == -3) {
                return this.swecalc_error(x);
            }
        } else {
            if (serr != null) {
                serr.setLength(0);
                serr.append("illegal planet number " + ipl + ".");
            }
            return this.swecalc_error(x);
        }
        for (i = 0; i < 24; ++i) {
            x[i] = xp[i];
        }
        return iflag;
    }

    int swecalc_error(double[] x) {
        for (int i = 0; i < 24; ++i) {
            x[i] = 0.0;
        }
        return -1;
    }

    int sweph_sbar(double tjd, int iflag, PlanData psdp, PlanData pedp, StringBuffer serr) {
        int retc = this.sweplan(tjd, 0, 0, iflag, true, null, null, null, null, serr);
        if (retc == -1 || retc == -2) {
            return -1;
        }
        psdp.teval = tjd;
        return 0;
    }

    int sweph_moon(double tjd, int ipli, int iflag, StringBuffer serr) {
        int retc = this.sweplan(tjd, ipli, 1, iflag, true, null, null, null, null, serr);
        if (retc == -1) {
            return -1;
        }
        if (retc == -2) {
            return -1;
        }
        return 0;
    }

    void calc_epsilon(double tjd, Epsilon e) {
        e.teps = tjd;
        e.eps = this.sl.swi_epsiln(tjd);
        e.seps = Math.sin(e.eps);
        e.ceps = Math.cos(e.eps);
    }

    int main_planet(double tjd, int ipli, int epheflag, int iflag, StringBuffer serr) {
        boolean calc_swieph = false;
        boolean calc_moshier = false;
        if (epheflag == 2 || calc_swieph) {
            int retc = this.sweplan(tjd, ipli, 0, iflag, true, null, null, null, null, serr);
            if (retc == -1) {
                return -1;
            }
            if (retc == -2) {
                return -1;
            }
            if (!calc_moshier) {
                retc = ipli == 0 ? this.app_pos_etc_sun(iflag, serr) : this.app_pos_etc_plan(ipli, iflag, serr);
                if (retc == -1) {
                    return -1;
                }
                if (retc == -2) {
                    return -1;
                }
            }
        }
        return 0;
    }

    int main_planet_bary(double tjd, int ipli, int epheflag, int iflag, boolean do_save, double[] xp, double[] xe, double[] xs, double[] xm, StringBuffer serr) {
        int retc;
        boolean calc_swieph = false;
        if (!(epheflag != 2 && !calc_swieph || (retc = this.sweplan(tjd, ipli, 0, iflag, do_save, xp, xe, xs, xm, serr)) != -1 && retc != -2)) {
            return retc;
        }
        return 0;
    }

    int swemoon(double tjd, int iflag, boolean do_save, double[] xpret, StringBuffer serr) {
        PlanData pdp = this.swed.pldat[1];
        double[] xx = new double[6];
        double[] xp = do_save ? pdp.x : xx;
        int speedf1 = pdp.xflgs & 0x100;
        int speedf2 = iflag & 0x100;
        if (tjd == pdp.teval && pdp.iephe == 2 && (speedf2 == 0 || speedf1 != 0)) {
            xp = pdp.x;
        } else {
            int retc = this.sweph(tjd, 1, 1, iflag, null, do_save, xp, serr);
            if (retc != 0) {
                return retc;
            }
            if (do_save) {
                pdp.teval = tjd;
                pdp.xflgs = -1;
                pdp.iephe = 2;
            }
        }
        if (xpret != null) {
            for (int i = 0; i <= 5; ++i) {
                xpret[i] = xp[i];
            }
        }
        return 0;
    }

    int sweplan(double tjd, int ipli, int ifno, int iflag, boolean do_save, double[] xpret, double[] xperet, double[] xpsret, double[] xpmret, StringBuffer serr) {
        int retc;
        int i;
        int speedf1;
        double[] xpm;
        double[] xps;
        double[] xpe;
        double[] xp;
        boolean do_earth = false;
        boolean do_moon = false;
        boolean do_sunbary = false;
        PlanData pdp = this.swed.pldat[ipli];
        PlanData pebdp = this.swed.pldat[0];
        PlanData psbdp = this.swed.pldat[10];
        PlanData pmdp = this.swed.pldat[1];
        double[] xxp = new double[6];
        double[] xxm = new double[6];
        double[] xxs = new double[6];
        double[] xxe = new double[6];
        if (do_save || ipli == 10 || (pdp.iflg & 1) != 0 || xpsret != null || (iflag & 8) != 0) {
            do_sunbary = true;
        }
        if (do_save || ipli == 0 || xperet != null) {
            do_earth = true;
        }
        if (ipli == 1) {
            do_earth = true;
            do_sunbary = true;
        }
        if (do_save || ipli == 1 || ipli == 0 || xperet != null || xpmret != null) {
            do_moon = true;
        }
        if (do_save) {
            xp = pdp.x;
            xpe = pebdp.x;
            xps = psbdp.x;
            xpm = pmdp.x;
        } else {
            xp = xxp;
            xpe = xxe;
            xps = xxs;
            xpm = xxm;
        }
        int speedf2 = iflag & 0x100;
        if (do_sunbary) {
            speedf1 = psbdp.xflgs & 0x100;
            if (tjd == psbdp.teval && psbdp.iephe == 2 && (speedf2 == 0 || speedf1 != 0)) {
                for (i = 0; i <= 5; ++i) {
                    xps[i] = psbdp.x[i];
                }
            } else {
                retc = this.sweph(tjd, 10, 0, iflag, null, do_save, xps, serr);
                if (retc != 0) {
                    return retc;
                }
            }
            if (xpsret != null) {
                for (i = 0; i <= 5; ++i) {
                    xpsret[i] = xps[i];
                }
            }
        }
        if (do_moon) {
            speedf1 = pmdp.xflgs & 0x100;
            if (tjd == pmdp.teval && pmdp.iephe == 2 && (speedf2 == 0 || speedf1 != 0)) {
                for (i = 0; i <= 5; ++i) {
                    xpm[i] = pmdp.x[i];
                }
            } else {
                retc = this.sweph(tjd, 1, 1, iflag, null, do_save, xpm, serr);
                if (retc == -1) {
                    return retc;
                }
                if (this.swed.fidat[1].fptr == null) {
                    return -1;
                }
            }
            if (xpmret != null) {
                for (i = 0; i <= 5; ++i) {
                    xpmret[i] = xpm[i];
                }
            }
        }
        if (do_earth) {
            speedf1 = pebdp.xflgs & 0x100;
            if (tjd == pebdp.teval && pebdp.iephe == 2 && (speedf2 == 0 || speedf1 != 0)) {
                for (i = 0; i <= 5; ++i) {
                    xpe[i] = pebdp.x[i];
                }
            } else {
                retc = this.sweph(tjd, 0, 0, iflag, null, do_save, xpe, serr);
                if (retc != 0) {
                    return retc;
                }
                this.embofs(xpe, 0, xpm, 0);
                if (xpe == pebdp.x || (iflag & 0x100) != 0) {
                    this.embofs(xpe, 3, xpm, 3);
                }
            }
            if (xperet != null) {
                for (i = 0; i <= 5; ++i) {
                    xperet[i] = xpe[i];
                }
            }
        }
        if (ipli == 1) {
            for (i = 0; i <= 5; ++i) {
                xp[i] = xpm[i];
            }
        } else if (ipli == 0) {
            for (i = 0; i <= 5; ++i) {
                xp[i] = xpe[i];
            }
        } else if (ipli == 0) {
            for (i = 0; i <= 5; ++i) {
                xp[i] = xps[i];
            }
        } else {
            speedf1 = pdp.xflgs & 0x100;
            if (tjd == pdp.teval && pdp.iephe == 2 && (speedf2 == 0 || speedf1 != 0)) {
                for (i = 0; i <= 5; ++i) {
                    xp[i] = pdp.x[i];
                }
                return 0;
            }
            retc = this.sweph(tjd, ipli, ifno, iflag, null, do_save, xp, serr);
            if (retc != 0) {
                return retc;
            }
            if ((pdp.iflg & 1) != 0) {
                for (i = 0; i <= 2; ++i) {
                    int n = i;
                    xp[n] = xp[n] + xps[i];
                }
                if (do_save || (iflag & 0x100) != 0) {
                    for (i = 3; i <= 5; ++i) {
                        int n = i;
                        xp[n] = xp[n] + xps[i];
                    }
                }
            }
        }
        if (xpret != null) {
            for (i = 0; i <= 5; ++i) {
                xpret[i] = xp[i];
            }
        }
        return 0;
    }

    int sweph(double tjd, int ipli, int ifno, int iflag, double[] xsunb, boolean do_save, double[] xpret, StringBuffer serr) {
        int i;
        int retc;
        String s = "";
        double[] xemb = new double[6];
        double[] xx = new double[6];
        PlanData pedp = this.swed.pldat[0];
        PlanData psdp = this.swed.pldat[10];
        FileData fdp = this.swed.fidat[ifno];
        int ipl = ipli;
        if (ipli > 10000) {
            ipl = 11;
        }
        PlanData pdp = this.swed.pldat[ipl];
        double[] xp = do_save ? pdp.x : xx;
        int speedf1 = pdp.xflgs & 0x100;
        int speedf2 = iflag & 0x100;
        if (tjd == pdp.teval && pdp.iephe == 2 && (speedf2 == 0 || speedf1 != 0) && ipl < 11) {
            if (xpret != null) {
                for (int i2 = 0; i2 <= 5; ++i2) {
                    xpret[i2] = pdp.x[i2];
                }
            }
            return 0;
        }
        if (fdp.fptr != null && (tjd < fdp.tfstart || tjd > fdp.tfend || ipl == 11 && ipli != pdp.ibdy)) {
            try {
                fdp.fptr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fdp.fptr = null;
            if (pdp.refep != null) {
                pdp.refep = null;
            }
            if (pdp.segp != null) {
                pdp.segp = null;
            }
        }
        if (fdp.fptr == null) {
            int subdirlen;
            String fname = this.sl.swi_gen_filename(new SweDate(tjd), ipli);
            String subdirnam = fname;
            if (subdirnam.lastIndexOf(this.swed.DIR_GLUE) > 0) {
                subdirnam = subdirnam.substring(0, subdirnam.indexOf(this.swed.DIR_GLUE));
                subdirlen = subdirnam.length();
            } else {
                subdirlen = 0;
            }
            s = fname;
            while (fdp.fptr == null) {
                try {
                    fdp.fptr = this.swi_fopen(ifno, s, this.swed.ephepath, serr);
                }
                catch (SwissephException swissephException) {
                    // empty catch block
                }
                if (fdp.fptr == null || fdp.fptr != null && fdp.fptr.fp == null && fdp.fptr.sk == null) {
                    if (ipli > 10000) {
                        if (s.indexOf("s.") <= 0) {
                            s = s.substring(0, s.indexOf(".")) + "s." + "se1";
                            continue;
                        }
                        s = s.substring(0, s.indexOf("s.")) + s.substring(s.indexOf("s.") + 1);
                        if (subdirlen > 0 && s.startsWith(subdirnam.substring(0, Math.min(subdirnam.length(), subdirlen)))) {
                            s = s.substring(subdirlen + 1);
                            continue;
                        }
                    }
                    return -2;
                }
                if (fdp.fptr == null) continue;
            }
            if (serr != null) {
                serr.setLength(0);
            }
            if ((retc = this.swed.fidat[ifno].read_const(ifno, serr, this.swed)) != 0) {
                return retc;
            }
        }
        if (tjd < fdp.tfstart || tjd > fdp.tfend) {
            if (serr != null) {
                s = tjd < fdp.tfstart ? "jd " + tjd + " < Swiss Eph. lower limit " + fdp.tfstart + ";" : "jd " + tjd + " > Swiss Eph. upper limit " + fdp.tfend + ";";
                if (serr.length() + s.length() < 256) {
                    serr.append(s);
                }
            }
            return -2;
        }
        if (pdp.segp == null || tjd < pdp.tseg0 || tjd > pdp.tseg1) {
            retc = this.swed.fidat[ifno].get_new_segment(this.swed, tjd, ipl, ifno, serr);
            if (retc != 0) {
                return retc;
            }
            if ((pdp.iflg & 2) != 0) {
                this.rot_back(ipl);
            } else {
                pdp.neval = pdp.ncoe;
            }
        }
        double t = (tjd - pdp.tseg0) / pdp.dseg;
        t = t * 2.0 - 1.0;
        boolean need_speed = do_save || (iflag & 0x100) != 0;
        for (i = 0; i <= 2; ++i) {
            xp[i] = this.sl.swi_echeb(t, pdp.segp, i * pdp.ncoe, pdp.neval);
            xp[i + 3] = need_speed ? this.sl.swi_edcheb(t, pdp.segp, i * pdp.ncoe, pdp.neval) / pdp.dseg * 2.0 : 0.0;
        }
        if (fdp.sweph_denum >= 403 && ipl < 11) {
            this.sl.swi_IERS_FK5(xp, xp, 1);
            if (need_speed) {
                this.sl.swi_IERS_FK5(xp, 3, xp, 3, 1);
            }
        }
        if (ipl == 10 && (pdp.iflg & 8) != 0) {
            double tsv = pedp.teval;
            pedp.teval = 0.0;
            retc = this.sweph(tjd, 0, ifno, iflag | 0x100, null, false, xemb, serr);
            if (retc != 0) {
                return retc;
            }
            pedp.teval = tsv;
            for (i = 0; i <= 2; ++i) {
                xp[i] = xemb[i] - xp[i];
            }
            if (need_speed) {
                for (i = 3; i <= 5; ++i) {
                    xp[i] = xemb[i] - xp[i];
                }
            }
        }
        if (((iflag & 1) != 0 || (iflag & 2) != 0) && ipl >= 11) {
            for (i = 0; i <= 2; ++i) {
                int n = i;
                xp[n] = xp[n] + xsunb[i];
            }
            if (need_speed) {
                for (i = 3; i <= 5; ++i) {
                    int n = i;
                    xp[n] = xp[n] + xsunb[i];
                }
            }
        }
        if (do_save) {
            pdp.teval = tjd;
            pdp.xflgs = -1;
            pdp.iephe = ifno == 0 || ifno == 1 ? 2 : psdp.iephe;
        }
        if (xpret != null) {
            for (i = 0; i <= 5; ++i) {
                xpret[i] = xp[i];
            }
        }
        return 0;
    }

    FilePtr swi_fopen(int ifno, String fname, String ephepath, StringBuffer serr) throws SwissephException {
        RandomAccessFile fp = null;
        String[] cpos = new String[20];
        String s1 = ephepath;
        int np = this.sl.swi_cutstr(s1, ";:", cpos, 20);
        for (int i = 0; i < np; ++i) {
            FilePtr f;
            String fnamp;
            String path = cpos[i];
            if ("".equals(path)) {
                path = ".";
            }
            if ((fnamp = path + this.swed.DIR_GLUE).length() + fname.length() >= 256) {
                if (serr != null) {
                    serr.setLength(0);
                    serr.append("error: file path and name must be shorter than 256.");
                }
                throw new SwissephException(Double.POSITIVE_INFINITY, 5, -1, serr);
            }
            fnamp = fnamp + fname;
            try {
                fp = new RandomAccessFile(fnamp, "r");
                if (ifno >= 0) {
                    this.swed.fidat[ifno].fnam = fnamp;
                }
                FilePtr sfp = new FilePtr(fp, null, null, null, fnamp, -1L, this.httpBufSize);
                return sfp;
            }
            catch (IOException ex) {
                f = this.tryFileAsURL(path + "/" + fname, ifno);
                if (f == null) continue;
                return f;
            }
            catch (SecurityException ex) {
                f = this.tryFileAsURL(path + "/" + fname, ifno);
                if (f == null) continue;
                return f;
            }
        }
        String s = "SwissEph file '" + fname + "' not found in the paths of: ";
        for (int n = 0; n < cpos.length; ++n) {
            if (cpos[n] == null || "".equals(cpos[n])) continue;
            s = s + "'" + cpos[n] + "', ";
        }
        if (serr != null) {
            serr.setLength(0);
            serr.append(s);
        }
        throw new SwissephException(Double.POSITIVE_INFINITY, 9, -2, serr);
    }

    private FilePtr tryFileAsURL(String fnamp, int ifno) {
        Socket sk = null;
        try {
            URL u = new URL(fnamp);
            sk = new Socket(u.getHost(), u.getPort() < 0 ? 80 : u.getPort());
            String sht = "HEAD " + fnamp + " HTTP/1.1\r\nUser-Agent: " + "swisseph-java-1.67.00(03)" + "\r\nHost: " + u.getHost() + ":" + (u.getPort() < 0 ? 80 : u.getPort()) + "\r\n\r\n";
            sk.setSoTimeout(5000);
            InputStream is = sk.getInputStream();
            BufferedOutputStream os = new BufferedOutputStream(sk.getOutputStream());
            for (int n = 0; n < sht.length(); ++n) {
                os.write((byte)sht.charAt(n));
            }
            os.flush();
            String sret = "" + (char)is.read();
            while (is.available() > 0) {
                sret = sret + (char)is.read();
            }
            int idx = sret.indexOf("Content-Length:");
            if (idx < 0) {
                sk.close();
                return null;
            }
            if (sret.indexOf("Accept-Ranges: none") >= 0) {
                System.err.println("Server does not accept HTTP range requests. Aborting!");
                sk.close();
                return null;
            }
            sret = sret.substring(idx + "Content-Length:".length());
            sret = sret.substring(0, sret.indexOf("\n")).trim();
            long len = Long.parseLong(sret);
            if (ifno >= 0) {
                this.swed.fidat[ifno].fnam = fnamp;
            }
            return new FilePtr(null, sk, is, os, fnamp, len, this.httpBufSize);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            sk.close();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    int app_pos_etc_plan(int ipli, int iflag, StringBuffer serr) {
        int i;
        PlanData pdp;
        int ibody;
        int ifno;
        int retc = 0;
        double[] xx = new double[6];
        double[] dx = new double[3];
        double[] xobs = new double[6];
        double[] xobs2 = new double[6];
        double[] xearth = new double[6];
        double[] xsun = new double[6];
        double[] xxsp = new double[6];
        double[] xxsv = new double[6];
        PlanData pedp = this.swed.pldat[0];
        Epsilon oe = this.swed.oec2000;
        int epheflag = iflag & 7;
        double dtsave_for_defl = 0.0;
        double t = 0.0;
        if (ipli > 10000) {
            ifno = 3;
            ibody = 2;
            pdp = this.swed.pldat[11];
        } else if (ipli == 12 || ipli == 13 || ipli == 14 || ipli == 15 || ipli == 16 || ipli == 17) {
            ifno = 2;
            ibody = 3;
            pdp = this.swed.pldat[ipli];
        } else {
            ifno = 0;
            ibody = 0;
            pdp = this.swed.pldat[ipli];
        }
        int flg1 = iflag & 0xFFFFF7FF & 0xFFFFEFFF;
        int flg2 = pdp.xflgs & 0xFFFFF7FF & 0xFFFFEFFF;
        if (flg1 == flg2) {
            pdp.xflgs = iflag;
            pdp.iephe = iflag & 7;
            return 0;
        }
        for (i = 0; i <= 5; ++i) {
            xx[i] = pdp.x[i];
        }
        if ((iflag & 8) != 0 && (pdp.iephe == 1 || pdp.iephe == 2)) {
            for (i = 0; i <= 5; ++i) {
                int n = i;
                xx[n] = xx[n] - this.swed.pldat[10].x[i];
            }
        }
        if ((iflag & 0x8000) != 0) {
            if (this.swed.topd.teval != pedp.teval || pedp.teval == 0.0) {
                if (this.swi_get_observer(pedp.teval, iflag, true, xobs, serr) != 0) {
                    return -1;
                }
            } else {
                for (i = 0; i <= 5; ++i) {
                    xobs[i] = this.swed.topd.xobs[i];
                }
            }
            for (i = 0; i <= 5; ++i) {
                xobs[i] = xobs[i] + pedp.x[i];
            }
        } else {
            for (i = 0; i <= 5; ++i) {
                xobs[i] = pedp.x[i];
            }
        }
        if ((iflag & 0x10) == 0) {
            double dt;
            int j;
            int niter = pdp.iephe == 1 || pdp.iephe == 2 ? 1 : 0;
            if ((iflag & 0x100) != 0) {
                for (i = 0; i <= 2; ++i) {
                    xxsv[i] = xxsp[i] = xx[i] - xx[i + 3];
                }
                for (j = 0; j <= niter; ++j) {
                    for (i = 0; i <= 2; ++i) {
                        dx[i] = xxsp[i];
                        if ((iflag & 8) != 0 || (iflag & 0x4000) != 0) continue;
                        int n = i;
                        dx[n] = dx[n] - (xobs[i] - xobs[i + 3]);
                    }
                    dt = Math.sqrt(this.sl.square_sum(dx)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                    for (i = 0; i <= 2; ++i) {
                        xxsp[i] = xxsv[i] - dt * pdp.x[i + 3];
                    }
                }
                for (i = 0; i <= 2; ++i) {
                    xxsp[i] = xxsv[i] - xxsp[i];
                }
            }
            for (j = 0; j <= niter; ++j) {
                for (i = 0; i <= 2; ++i) {
                    dx[i] = xx[i];
                    if ((iflag & 8) != 0 || (iflag & 0x4000) != 0) continue;
                    int n = i;
                    dx[n] = dx[n] - xobs[i];
                }
                dt = Math.sqrt(this.sl.square_sum(dx)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                t = pdp.teval - dt;
                dtsave_for_defl = dt;
                for (i = 0; i <= 2; ++i) {
                    xx[i] = pdp.x[i] - dt * pdp.x[i + 3];
                }
            }
            if ((iflag & 0x100) != 0) {
                for (i = 0; i <= 2; ++i) {
                    xxsp[i] = pdp.x[i] - xx[i] - xxsp[i];
                }
            }
            switch (epheflag) {
                case 2: {
                    if (ibody == 0) {
                        retc = this.sweplan(t, ipli, ifno, iflag, false, xx, xearth, xsun, null, serr);
                    } else {
                        retc = this.sweplan(t, 0, 0, iflag, false, xearth, null, xsun, null, serr);
                        if (retc == 0) {
                            retc = this.sweph(t, ipli, ifno, iflag, xsun, false, xx, serr);
                        }
                    }
                    if (retc == 0) break;
                    return retc;
                }
            }
            if ((iflag & 8) != 0 && (pdp.iephe == 1 || pdp.iephe == 2)) {
                for (i = 0; i <= 5; ++i) {
                    int n = i;
                    xx[n] = xx[n] - this.swed.pldat[10].x[i];
                }
            }
            if ((iflag & 0x100) != 0) {
                if ((iflag & 0x8000) != 0) {
                    if (this.swi_get_observer(t, iflag, false, xobs2, serr) != 0) {
                        return -1;
                    }
                    for (i = 0; i <= 5; ++i) {
                        int n = i;
                        xobs2[n] = xobs2[n] + xearth[i];
                    }
                } else {
                    for (i = 0; i <= 5; ++i) {
                        xobs2[i] = xearth[i];
                    }
                }
            }
        }
        if ((iflag & 8) == 0 && (iflag & 0x4000) == 0) {
            for (i = 0; i <= 5; ++i) {
                int n = i;
                xx[n] = xx[n] - xobs[i];
            }
            if ((iflag & 0x10) == 0 && (iflag & 0x100) != 0) {
                for (i = 3; i <= 5; ++i) {
                    int n = i;
                    xx[n] = xx[n] - xxsp[i - 3];
                }
            }
        }
        if ((iflag & 0x100) == 0) {
            for (i = 3; i <= 5; ++i) {
                xx[i] = 0.0;
            }
        }
        if ((iflag & 0x10) == 0 && (iflag & 0x200) == 0) {
            this.swi_deflect_light(xx, 0, dtsave_for_defl, iflag);
        }
        if ((iflag & 0x10) == 0 && (iflag & 0x400) == 0) {
            this.swi_aberr_light(xx, xobs, iflag);
            if ((iflag & 0x100) != 0) {
                for (i = 3; i <= 5; ++i) {
                    int n = i;
                    xx[n] = xx[n] + (xobs[i] - xobs2[i]);
                }
            }
        }
        for (i = 0; i <= 5; ++i) {
            xxsv[i] = xx[i];
        }
        if ((iflag & 0x20) == 0) {
            this.sl.swi_precess(xx, pdp.teval, -1);
            if ((iflag & 0x100) != 0) {
                this.swi_precess_speed(xx, pdp.teval, -1);
            }
            oe = this.swed.oec;
        } else {
            oe = this.swed.oec2000;
        }
        return this.app_pos_rest(pdp, iflag, xx, xxsv, oe, serr);
    }

    int app_pos_rest(PlanData pdp, int iflag, double[] xx, double[] x2000, Epsilon oe, StringBuffer serr) {
        int i;
        if ((iflag & 0x40) == 0) {
            this.swi_nutate(xx, 0, iflag, false);
        }
        for (i = 0; i <= 5; ++i) {
            pdp.xreturn[18 + i] = xx[i];
        }
        this.sl.swi_coortrf2(xx, xx, oe.seps, oe.ceps);
        if ((iflag & 0x100) != 0) {
            this.sl.swi_coortrf2(xx, 3, xx, 3, oe.seps, oe.ceps);
        }
        if ((iflag & 0x40) == 0) {
            this.sl.swi_coortrf2(xx, xx, this.swed.nut.snut, this.swed.nut.cnut);
            if ((iflag & 0x100) != 0) {
                this.sl.swi_coortrf2(xx, 3, xx, 3, this.swed.nut.snut, this.swed.nut.cnut);
            }
        }
        for (i = 0; i <= 5; ++i) {
            pdp.xreturn[6 + i] = xx[i];
        }
        if ((iflag & 0x10000) != 0) {
            if ((this.swed.sidd.sid_mode & 0x100) != 0) {
                if (this.swi_trop_ra2sid_lon(x2000, pdp.xreturn, 6, pdp.xreturn, 18, iflag, serr) != 0) {
                    return -1;
                }
            } else if ((this.swed.sidd.sid_mode & 0x200) != 0) {
                if (this.swi_trop_ra2sid_lon_sosy(x2000, pdp.xreturn, 6, pdp.xreturn, 18, iflag, serr) != 0) {
                    return -1;
                }
            } else {
                this.sl.swi_cartpol_sp(pdp.xreturn, 6, pdp.xreturn, 0);
                pdp.xreturn[0] = pdp.xreturn[0] - this.swe_get_ayanamsa(pdp.teval) * 0.0174532925199433;
                this.sl.swi_polcart_sp(pdp.xreturn, 0, pdp.xreturn, 6);
            }
        }
        this.sl.swi_cartpol_sp(pdp.xreturn, 18, pdp.xreturn, 12);
        this.sl.swi_cartpol_sp(pdp.xreturn, 6, pdp.xreturn, 0);
        for (i = 0; i < 2; ++i) {
            int n = i;
            pdp.xreturn[n] = pdp.xreturn[n] * 57.2957795130823;
            int n2 = i + 3;
            pdp.xreturn[n2] = pdp.xreturn[n2] * 57.2957795130823;
            int n3 = i + 12;
            pdp.xreturn[n3] = pdp.xreturn[n3] * 57.2957795130823;
            int n4 = i + 15;
            pdp.xreturn[n4] = pdp.xreturn[n4] * 57.2957795130823;
        }
        pdp.xflgs = iflag;
        pdp.iephe = iflag & 7;
        return 0;
    }

    int swi_trop_ra2sid_lon(double[] xin, double[] xout, double[] xoutr, int iflag, StringBuffer serr) {
        return this.swi_trop_ra2sid_lon(xin, xout, 0, xoutr, 0, iflag, serr);
    }

    int swi_trop_ra2sid_lon(double[] xin, double[] xout, int xoOffs, double[] xoutr, int xrOffs, int iflag, StringBuffer serr) {
        int i;
        double[] x = new double[6];
        SidData sip = this.swed.sidd;
        Epsilon oectmp = new Epsilon();
        for (i = 0; i <= 5; ++i) {
            x[i] = xin[i];
        }
        if (sip.t0 != 2451545.0) {
            this.sl.swi_precess(x, sip.t0, -1);
            this.sl.swi_precess(x, 3, sip.t0, -1);
        }
        for (i = 0; i <= 5; ++i) {
            xoutr[i + xrOffs] = x[i];
        }
        this.calc_epsilon(this.swed.sidd.t0, oectmp);
        this.sl.swi_coortrf2(x, x, oectmp.seps, oectmp.ceps);
        if ((iflag & 0x100) != 0) {
            this.sl.swi_coortrf2(x, 3, x, 3, oectmp.seps, oectmp.ceps);
        }
        this.sl.swi_cartpol_sp(x, x);
        x[0] = x[0] - sip.ayan_t0 * 0.0174532925199433;
        this.sl.swi_polcart_sp(x, 0, xout, xoOffs);
        return 0;
    }

    int swi_trop_ra2sid_lon_sosy(double[] xin, double[] xout, double[] xoutr, int iflag, StringBuffer serr) {
        return this.swi_trop_ra2sid_lon_sosy(xin, xout, 0, xoutr, 0, iflag, serr);
    }

    int swi_trop_ra2sid_lon_sosy(double[] xin, double[] xout, int xoOffs, double[] xoutr, int xrOffs, int iflag, StringBuffer serr) {
        double[] x = new double[6];
        double[] x0 = new double[6];
        SidData sip = this.swed.sidd;
        Epsilon oe = this.swed.oec2000;
        double plane_node = 1.877670046803984;
        double plane_incl = 0.027553530354527005;
        for (int i = 0; i <= 5; ++i) {
            x[i] = xin[i];
        }
        this.sl.swi_coortrf2(x, x, oe.seps, oe.ceps);
        if ((iflag & 0x100) != 0) {
            this.sl.swi_coortrf2(x, 3, x, 3, oe.seps, oe.ceps);
        }
        this.sl.swi_cartpol_sp(x, x);
        x[0] = x[0] - plane_node;
        this.sl.swi_polcart_sp(x, x);
        this.sl.swi_coortrf(x, x, plane_incl);
        this.sl.swi_coortrf(x, 3, x, 3, plane_incl);
        this.sl.swi_cartpol_sp(x, x);
        x0[0] = 1.0;
        x0[2] = 0.0;
        x0[1] = 0.0;
        if (sip.t0 != 2451545.0) {
            this.sl.swi_precess(x0, sip.t0, 1);
        }
        this.sl.swi_coortrf2(x0, x0, oe.seps, oe.ceps);
        this.sl.swi_cartpol(x0, x0);
        x0[0] = x0[0] - plane_node;
        this.sl.swi_polcart(x0, x0);
        this.sl.swi_coortrf(x0, x0, plane_incl);
        this.sl.swi_cartpol(x0, x0);
        x[0] = x[0] - x0[0];
        x[0] = x[0] * 57.2957795130823;
        x[0] = x[0] - sip.ayan_t0;
        x[0] = this.sl.swe_degnorm(x[0]) * 0.0174532925199433;
        this.sl.swi_polcart_sp(x, 0, xout, xoOffs);
        return 0;
    }

    int app_pos_etc_plan_osc(int ipl, int ipli, int iflag, StringBuffer serr) {
        int i;
        double[] xx = new double[6];
        double[] dx = new double[3];
        double[] xearth = new double[6];
        double[] xsun = new double[6];
        double[] xmoon = new double[6];
        double[] xxsv = new double[6];
        double[] xxsp = new double[6];
        double[] xobs = new double[6];
        double[] xobs2 = new double[6];
        PlanData pdp = this.swed.pldat[ipli];
        PlanData pedp = this.swed.pldat[0];
        PlanData psdp = this.swed.pldat[10];
        Epsilon oe = this.swed.oec2000;
        int epheflag = 2;
        double dtsave_for_defl = 0.0;
        double dt = 0.0;
        if ((iflag & 4) != 0) {
            epheflag = 4;
        } else if ((iflag & 2) != 0) {
            epheflag = 2;
        } else if ((iflag & 1) != 0) {
            epheflag = 1;
        }
        for (i = 0; i <= 5; ++i) {
            xx[i] = pdp.x[i];
        }
        if ((iflag & 0x8000) != 0) {
            if (this.swed.topd.teval != pedp.teval || this.swed.topd.teval != 0.0) {
                if (this.swi_get_observer(pedp.teval, iflag, true, xobs, serr) != 0) {
                    return -1;
                }
            } else {
                for (i = 0; i <= 5; ++i) {
                    xobs[i] = this.swed.topd.xobs[i];
                }
            }
            for (i = 0; i <= 5; ++i) {
                xobs[i] = xobs[i] + pedp.x[i];
            }
        } else if ((iflag & 0x4000) != 0) {
            for (i = 0; i <= 5; ++i) {
                xobs[i] = 0.0;
            }
        } else if ((iflag & 8) != 0) {
            if ((iflag & 4) != 0) {
                for (i = 0; i <= 5; ++i) {
                    xobs[i] = 0.0;
                }
            } else {
                for (i = 0; i <= 5; ++i) {
                    xobs[i] = psdp.x[i];
                }
            }
        } else {
            for (i = 0; i <= 5; ++i) {
                xobs[i] = pedp.x[i];
            }
        }
        if ((iflag & 0x10) == 0) {
            int j;
            int niter = 1;
            if ((iflag & 0x100) != 0) {
                for (i = 0; i <= 2; ++i) {
                    xxsv[i] = xxsp[i] = xx[i] - xx[i + 3];
                }
                for (j = 0; j <= niter; ++j) {
                    for (i = 0; i <= 2; ++i) {
                        dx[i] = xxsp[i];
                        if ((iflag & 8) != 0 || (iflag & 0x4000) != 0) continue;
                        int n = i;
                        dx[n] = dx[n] - (xobs[i] - xobs[i + 3]);
                    }
                    dt = Math.sqrt(this.sl.square_sum(dx)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                    for (i = 0; i <= 2; ++i) {
                        xxsp[i] = xxsv[i] - dt * pdp.x[i + 3];
                    }
                }
                for (i = 0; i <= 2; ++i) {
                    xxsp[i] = xxsv[i] - xxsp[i];
                }
            }
            for (j = 0; j <= niter; ++j) {
                for (i = 0; i <= 2; ++i) {
                    dx[i] = xx[i];
                    if ((iflag & 8) != 0 || (iflag & 0x4000) != 0) continue;
                    int n = i;
                    dx[n] = dx[n] - xobs[i];
                }
                dtsave_for_defl = dt = Math.sqrt(this.sl.square_sum(dx)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                for (i = 0; i <= 2; ++i) {
                    xx[i] = pdp.x[i] - dt * pdp.x[i + 3];
                    xx[i + 3] = pdp.x[i + 3];
                }
            }
            if ((iflag & 0x100) != 0) {
                for (i = 0; i <= 2; ++i) {
                    xxsp[i] = pdp.x[i] - xx[i] - xxsp[i];
                }
                double t = pdp.teval - dt;
                int retc = this.main_planet_bary(t, 0, epheflag, iflag, false, xearth, xearth, xsun, xmoon, serr);
                if (this.smosh.swi_osc_el_plan(t, xx, ipl - 40, ipli, xearth, xsun, serr) != 0) {
                    return -1;
                }
                if (retc != 0) {
                    return retc;
                }
                if ((iflag & 0x8000) != 0) {
                    if (this.swi_get_observer(t, iflag, false, xobs2, serr) != 0) {
                        return -1;
                    }
                    for (i = 0; i <= 5; ++i) {
                        int n = i;
                        xobs2[n] = xobs2[n] + xearth[i];
                    }
                } else {
                    for (i = 0; i <= 5; ++i) {
                        xobs2[i] = xearth[i];
                    }
                }
            }
        }
        for (i = 0; i <= 5; ++i) {
            int n = i;
            xx[n] = xx[n] - xobs[i];
        }
        if ((iflag & 0x10) == 0 && (iflag & 0x100) != 0) {
            for (i = 3; i <= 5; ++i) {
                int n = i;
                xx[n] = xx[n] - xxsp[i - 3];
            }
        }
        if ((iflag & 0x100) == 0) {
            for (i = 3; i <= 5; ++i) {
                xx[i] = 0.0;
            }
        }
        if ((iflag & 0x10) == 0 && (iflag & 0x200) == 0) {
            this.swi_deflect_light(xx, 0, dtsave_for_defl, iflag);
        }
        if ((iflag & 0x10) == 0 && (iflag & 0x400) == 0) {
            this.swi_aberr_light(xx, xobs, iflag);
            if ((iflag & 0x100) != 0) {
                for (i = 3; i <= 5; ++i) {
                    int n = i;
                    xx[n] = xx[n] + (xobs[i] - xobs2[i]);
                }
            }
        }
        for (i = 0; i <= 5; ++i) {
            xxsv[i] = xx[i];
        }
        if ((iflag & 0x20) == 0) {
            this.sl.swi_precess(xx, pdp.teval, -1);
            if ((iflag & 0x100) != 0) {
                this.swi_precess_speed(xx, pdp.teval, -1);
            }
            oe = this.swed.oec;
        } else {
            oe = this.swed.oec2000;
        }
        return this.app_pos_rest(pdp, iflag, xx, xxsv, oe, serr);
    }

    void swi_precess_speed(double[] xx, double t, int direction) {
        this.swi_precess_speed(xx, 0, t, direction);
    }

    void swi_precess_speed(double[] xx, int xOffs, double t, int direction) {
        Epsilon oe;
        double fac;
        double tprec = (t - 2451545.0) / 36525.0;
        if (direction == -1) {
            fac = 1.0;
            oe = this.swed.oec;
        } else {
            fac = -1.0;
            oe = this.swed.oec2000;
        }
        this.sl.swi_precess(xx, 3 + xOffs, t, direction);
        this.sl.swi_coortrf2(xx, xOffs, xx, xOffs, oe.seps, oe.ceps);
        this.sl.swi_coortrf2(xx, 3 + xOffs, xx, 3 + xOffs, oe.seps, oe.ceps);
        this.sl.swi_cartpol_sp(xx, xOffs, xx, xOffs);
        int n = 3 + xOffs;
        xx[n] = xx[n] + (50.290966 + 0.0222226 * tprec) / 3600.0 / 365.25 * 0.0174532925199433 * fac;
        this.sl.swi_polcart_sp(xx, xOffs, xx, xOffs);
        this.sl.swi_coortrf2(xx, xOffs, xx, xOffs, -oe.seps, oe.ceps);
        this.sl.swi_coortrf2(xx, 3 + xOffs, xx, 3 + xOffs, -oe.seps, oe.ceps);
    }

    void swi_nutate(double[] xx, int offs, int iflag, boolean backward) {
        int i;
        double[] x = new double[6];
        double[] xv = new double[6];
        for (i = 0; i <= 2; ++i) {
            x[i] = backward ? xx[0 + offs] * this.swed.nut.matrix[i][0] + xx[1 + offs] * this.swed.nut.matrix[i][1] + xx[2 + offs] * this.swed.nut.matrix[i][2] : xx[0 + offs] * this.swed.nut.matrix[0][i] + xx[1 + offs] * this.swed.nut.matrix[1][i] + xx[2 + offs] * this.swed.nut.matrix[2][i];
        }
        if ((iflag & 0x100) != 0) {
            for (i = 0; i <= 2; ++i) {
                x[i + 3] = backward ? xx[3 + offs] * this.swed.nut.matrix[i][0] + xx[4 + offs] * this.swed.nut.matrix[i][1] + xx[5 + offs] * this.swed.nut.matrix[i][2] : xx[3 + offs] * this.swed.nut.matrix[0][i] + xx[4 + offs] * this.swed.nut.matrix[1][i] + xx[5 + offs] * this.swed.nut.matrix[2][i];
            }
            for (i = 0; i <= 2; ++i) {
                xv[i] = backward ? xx[0 + offs] * this.swed.nutv.matrix[i][0] + xx[1 + offs] * this.swed.nutv.matrix[i][1] + xx[2 + offs] * this.swed.nutv.matrix[i][2] : xx[0 + offs] * this.swed.nutv.matrix[0][i] + xx[1 + offs] * this.swed.nutv.matrix[1][i] + xx[2 + offs] * this.swed.nutv.matrix[2][i];
                xx[3 + i + offs] = x[3 + i] + (x[i] - xv[i]) / 1.0E-4;
            }
        }
        for (i = 0; i <= 2; ++i) {
            xx[i + offs] = x[i];
        }
    }

    void swi_aberr_light(double[] xx, double[] xe, int iflag) {
        this.swi_aberr_light(xx, 0, xe, iflag);
    }

    void swi_aberr_light(double[] xx, int xxOffs, double[] xe, int iflag) {
        int i;
        double[] xxs = new double[6];
        double[] v = new double[6];
        double[] u = new double[6];
        double[] xx2 = new double[6];
        double intv = 1.0E-4;
        for (i = 0; i <= 5; ++i) {
            u[i] = xxs[i] = xx[i + xxOffs];
        }
        double ru = Math.sqrt(this.sl.square_sum(u));
        for (i = 0; i <= 2; ++i) {
            v[i] = xe[i + 3] / 24.0 / 3600.0 / 2.99792458E8 * 1.4959787066E11;
        }
        double v2 = this.sl.square_sum(v);
        double b_1 = Math.sqrt(1.0 - v2);
        double f1 = this.dot_prod(u, v) / ru;
        double f2 = 1.0 + f1 / (1.0 + b_1);
        for (i = 0; i <= 2; ++i) {
            xx[i + xxOffs] = (b_1 * xx[i + xxOffs] + f2 * ru * v[i]) / (1.0 + f1);
        }
        if ((iflag & 0x100) != 0) {
            for (i = 0; i <= 2; ++i) {
                u[i] = xxs[i] - intv * xxs[i + 3];
            }
            ru = Math.sqrt(this.sl.square_sum(u));
            f1 = this.dot_prod(u, v) / ru;
            f2 = 1.0 + f1 / (1.0 + b_1);
            for (i = 0; i <= 2; ++i) {
                xx2[i] = (b_1 * u[i] + f2 * ru * v[i]) / (1.0 + f1);
            }
            for (i = 0; i <= 2; ++i) {
                double dx1 = xx[i + xxOffs] - xxs[i];
                double dx2 = xx2[i] - u[i];
                int n = i + 3 + xxOffs;
                xx[n] = xx[n] + (dx1 -= dx2) / intv;
            }
        }
    }

    void swi_deflect_light(double[] xx, int offs, double dt, int iflag) {
        double sin_sunr;
        int i;
        double[] xx2 = new double[6];
        double[] u = new double[6];
        double[] e = new double[6];
        double[] q = new double[6];
        double[] xx3 = new double[6];
        double[] xsun = new double[6];
        double[] xearth = new double[6];
        PlanData pedp = this.swed.pldat[0];
        PlanData psdp = this.swed.pldat[10];
        int iephe = pedp.iephe;
        for (i = 0; i <= 5; ++i) {
            xearth[i] = pedp.x[i];
        }
        if ((iflag & 0x8000) != 0) {
            for (i = 0; i <= 5; ++i) {
                int n = i;
                xearth[n] = xearth[n] + this.swed.topd.xobs[i];
            }
        }
        for (i = 0; i <= 2; ++i) {
            u[i] = xx[i + offs];
        }
        if (iephe == 1 || iephe == 2) {
            for (i = 0; i <= 2; ++i) {
                e[i] = xearth[i] - psdp.x[i];
            }
        } else {
            for (i = 0; i <= 2; ++i) {
                e[i] = xearth[i];
            }
        }
        if (iephe == 1 || iephe == 2) {
            for (i = 0; i <= 2; ++i) {
                xsun[i] = psdp.x[i] - dt * psdp.x[i + 3];
            }
            for (i = 3; i <= 5; ++i) {
                xsun[i] = psdp.x[i];
            }
        } else {
            for (i = 0; i <= 5; ++i) {
                xsun[i] = psdp.x[i];
            }
        }
        for (i = 0; i <= 2; ++i) {
            q[i] = xx[i + offs] + xearth[i] - xsun[i];
        }
        double ru = Math.sqrt(this.sl.square_sum(u));
        double rq = Math.sqrt(this.sl.square_sum(q));
        double re = Math.sqrt(this.sl.square_sum(e));
        i = 0;
        while (i <= 2) {
            int n = i;
            u[n] = u[n] / ru;
            int n2 = i;
            q[n2] = q[n2] / rq;
            int n3 = i++;
            e[n3] = e[n3] / re;
        }
        double uq = this.dot_prod(u, q);
        double ue = this.dot_prod(u, e);
        double qe = this.dot_prod(q, e);
        double sina = Math.sqrt(1.0 - ue * ue);
        double meff_fact = sina < (sin_sunr = 0.004652417528031441 / re) ? this.meff(sina / sin_sunr) : 1.0;
        double g1 = 2.65424876E20 * meff_fact / 2.99792458E8 / 2.99792458E8 / 1.4959787066E11 / re;
        double g2 = 1.0 + qe;
        for (i = 0; i <= 2; ++i) {
            xx2[i] = ru * (u[i] + g1 / g2 * (uq * e[i] - ue * q[i]));
        }
        if ((iflag & 0x100) != 0) {
            double dtsp = -5.0E-7;
            for (i = 0; i <= 2; ++i) {
                u[i] = xx[i + offs] - dtsp * xx[i + 3 + offs];
            }
            if (iephe == 1 || iephe == 2) {
                for (i = 0; i <= 2; ++i) {
                    e[i] = xearth[i] - psdp.x[i] - dtsp * (xearth[i + 3] - psdp.x[i + 3]);
                }
            } else {
                for (i = 0; i <= 2; ++i) {
                    e[i] = xearth[i] - dtsp * xearth[i + 3];
                }
            }
            for (i = 0; i <= 2; ++i) {
                q[i] = u[i] + xearth[i] - xsun[i] - dtsp * (xearth[i + 3] - xsun[i + 3]);
            }
            ru = Math.sqrt(this.sl.square_sum(u));
            rq = Math.sqrt(this.sl.square_sum(q));
            re = Math.sqrt(this.sl.square_sum(e));
            i = 0;
            while (i <= 2) {
                int n = i;
                u[n] = u[n] / ru;
                int n4 = i;
                q[n4] = q[n4] / rq;
                int n5 = i++;
                e[n5] = e[n5] / re;
            }
            uq = this.dot_prod(u, q);
            ue = this.dot_prod(u, e);
            qe = this.dot_prod(q, e);
            sina = Math.sqrt(1.0 - ue * ue);
            meff_fact = sina < (sin_sunr = 0.004652417528031441 / re) ? this.meff(sina / sin_sunr) : 1.0;
            g1 = 2.65424876E20 * meff_fact / 2.99792458E8 / 2.99792458E8 / 1.4959787066E11 / re;
            g2 = 1.0 + qe;
            for (i = 0; i <= 2; ++i) {
                xx3[i] = ru * (u[i] + g1 / g2 * (uq * e[i] - ue * q[i]));
            }
            for (i = 0; i <= 2; ++i) {
                double dx1 = xx2[i] - xx[i + offs];
                double dx2 = xx3[i] - u[i] * ru;
                int n = i + 3 + offs;
                xx[n] = xx[n] + (dx1 -= dx2) / dtsp;
            }
        }
        for (i = 0; i <= 2; ++i) {
            xx[i + offs] = xx2[i];
        }
    }

    int app_pos_etc_sun(int iflag, StringBuffer serr) {
        int i;
        int retc = 0;
        double[] xx = new double[6];
        double[] xxsv = new double[6];
        double[] dx = new double[3];
        double[] xearth = new double[6];
        double[] xsun = new double[6];
        double[] xobs = new double[6];
        PlanData pedp = this.swed.pldat[0];
        PlanData psdp = this.swed.pldat[10];
        Epsilon oe = this.swed.oec2000;
        int flg1 = iflag & 0xFFFFF7FF & 0xFFFFEFFF;
        int flg2 = pedp.xflgs & 0xFFFFF7FF & 0xFFFFEFFF;
        if (flg1 == flg2) {
            pedp.xflgs = iflag;
            pedp.iephe = iflag & 7;
            return 0;
        }
        if ((iflag & 0x8000) != 0) {
            if (this.swed.topd.teval != pedp.teval || this.swed.topd.teval == 0.0) {
                if (this.swi_get_observer(pedp.teval, iflag, true, xobs, serr) != 0) {
                    return -1;
                }
            } else {
                for (i = 0; i <= 5; ++i) {
                    xobs[i] = this.swed.topd.xobs[i];
                }
            }
            for (i = 0; i <= 5; ++i) {
                xobs[i] = xobs[i] + pedp.x[i];
            }
        } else {
            for (i = 0; i <= 5; ++i) {
                xobs[i] = pedp.x[i];
            }
        }
        if (pedp.iephe == 4 || (iflag & 0x4000) != 0) {
            for (i = 0; i <= 5; ++i) {
                xx[i] = xobs[i];
            }
        } else {
            for (i = 0; i <= 5; ++i) {
                xx[i] = xobs[i] - psdp.x[i];
            }
        }
        if ((iflag & 0x10) == 0 && (pedp.iephe == 1 || pedp.iephe == 2 || (iflag & 8) != 0 || (iflag & 0x4000) != 0)) {
            for (i = 0; i <= 5; ++i) {
                xearth[i] = xobs[i];
                xsun[i] = pedp.iephe == 4 ? 0.0 : psdp.x[i];
            }
            int niter = 1;
            for (int j = 0; j <= niter; ++j) {
                for (i = 0; i <= 2; ++i) {
                    dx[i] = xearth[i];
                    if ((iflag & 0x4000) != 0) continue;
                    int n = i;
                    dx[n] = dx[n] - xsun[i];
                }
                double dt = Math.sqrt(this.sl.square_sum(dx)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                double t = pedp.teval - dt;
                switch (pedp.iephe) {
                    case 2: {
                        if ((iflag & 8) != 0 || (iflag & 0x4000) != 0) {
                            retc = this.sweplan(t, 0, 0, iflag, false, xearth, null, xsun, null, serr);
                            break;
                        }
                        retc = this.sweph(t, 10, 0, iflag, null, false, xsun, serr);
                        break;
                    }
                    default: {
                        retc = -1;
                    }
                }
                if (retc == 0) continue;
                return retc;
            }
            for (i = 0; i <= 5; ++i) {
                xx[i] = xearth[i];
                if ((iflag & 0x4000) != 0) continue;
                int n = i;
                xx[n] = xx[n] - xsun[i];
            }
        }
        if ((iflag & 0x100) == 0) {
            for (i = 3; i <= 5; ++i) {
                xx[i] = 0.0;
            }
        }
        if ((iflag & 8) == 0 && (iflag & 0x4000) == 0) {
            for (i = 0; i <= 5; ++i) {
                xx[i] = -xx[i];
            }
        }
        if ((iflag & 0x10) == 0 && (iflag & 0x400) == 0) {
            this.swi_aberr_light(xx, xobs, iflag);
        }
        for (i = 0; i <= 5; ++i) {
            xxsv[i] = xx[i];
        }
        if ((iflag & 0x20) == 0) {
            this.sl.swi_precess(xx, pedp.teval, -1);
            if ((iflag & 0x100) != 0) {
                this.swi_precess_speed(xx, pedp.teval, -1);
            }
            oe = this.swed.oec;
        } else {
            oe = this.swed.oec2000;
        }
        return this.app_pos_rest(pedp, iflag, xx, xxsv, oe, serr);
    }

    int app_pos_etc_moon(int iflag, StringBuffer serr) {
        int i;
        double[] xx = new double[6];
        double[] xxsv = new double[6];
        double[] xobs = new double[6];
        double[] xxm = new double[6];
        double[] xs = new double[6];
        double[] xe = new double[6];
        double[] xobs2 = new double[6];
        PlanData pedp = this.swed.pldat[0];
        PlanData psdp = this.swed.pldat[10];
        PlanData pdp = this.swed.pldat[1];
        Epsilon oe = this.swed.oec;
        int flg1 = iflag & 0xFFFFF7FF & 0xFFFFEFFF;
        int flg2 = pdp.xflgs & 0xFFFFF7FF & 0xFFFFEFFF;
        if (flg1 == flg2) {
            pdp.xflgs = iflag;
            pdp.iephe = iflag & 7;
            return 0;
        }
        for (i = 0; i <= 5; ++i) {
            xx[i] = pdp.x[i];
            xxm[i] = xx[i];
        }
        for (i = 0; i <= 5; ++i) {
            int n = i;
            xx[n] = xx[n] + pedp.x[i];
        }
        if ((iflag & 0x8000) != 0) {
            if (this.swed.topd.teval != pdp.teval || this.swed.topd.teval == 0.0) {
                if (this.swi_get_observer(pdp.teval, iflag, true, xobs, null) != 0) {
                    return -1;
                }
            } else {
                for (i = 0; i <= 5; ++i) {
                    xobs[i] = this.swed.topd.xobs[i];
                }
            }
            for (i = 0; i <= 5; ++i) {
                int n = i;
                xxm[n] = xxm[n] - xobs[i];
            }
            for (i = 0; i <= 5; ++i) {
                int n = i;
                xobs[n] = xobs[n] + pedp.x[i];
            }
        } else if ((iflag & 0x4000) != 0) {
            for (i = 0; i <= 5; ++i) {
                xobs[i] = 0.0;
            }
            for (i = 0; i <= 5; ++i) {
                int n = i;
                xxm[n] = xxm[n] + pedp.x[i];
            }
        } else if ((iflag & 8) != 0) {
            for (i = 0; i <= 5; ++i) {
                xobs[i] = psdp.x[i];
            }
            for (i = 0; i <= 5; ++i) {
                int n = i;
                xxm[n] = xxm[n] + (pedp.x[i] - psdp.x[i]);
            }
        } else {
            for (i = 0; i <= 5; ++i) {
                xobs[i] = pedp.x[i];
            }
        }
        if ((iflag & 0x10) == 0) {
            double dt = Math.sqrt(this.sl.square_sum(xxm)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
            double t = pdp.teval - dt;
            switch (pdp.iephe) {
                case 2: {
                    int retc = this.sweplan(t, 1, 1, iflag, false, xx, xe, xs, null, serr);
                    if (retc != 0) {
                        return retc;
                    }
                    for (i = 0; i <= 5; ++i) {
                        int n = i;
                        xx[n] = xx[n] + xe[i];
                    }
                    break;
                }
                case 4: {
                    for (i = 0; i <= 2; ++i) {
                        int n = i;
                        xx[n] = xx[n] - dt * xx[i + 3];
                        xe[i] = pedp.x[i] - dt * pedp.x[i + 3];
                        xe[i + 3] = pedp.x[i + 3];
                        xs[i] = 0.0;
                        xs[i + 3] = 0.0;
                    }
                    break;
                }
            }
            if ((iflag & 0x8000) != 0) {
                if (this.swi_get_observer(t, iflag, false, xobs2, null) != 0) {
                    return -1;
                }
                for (i = 0; i <= 5; ++i) {
                    int n = i;
                    xobs2[n] = xobs2[n] + xe[i];
                }
            } else if ((iflag & 0x4000) != 0) {
                for (i = 0; i <= 5; ++i) {
                    xobs2[i] = 0.0;
                }
            } else if ((iflag & 8) != 0) {
                for (i = 0; i <= 5; ++i) {
                    xobs2[i] = xs[i];
                }
            } else {
                for (i = 0; i <= 5; ++i) {
                    xobs2[i] = xe[i];
                }
            }
        }
        for (i = 0; i <= 5; ++i) {
            int n = i;
            xx[n] = xx[n] - xobs[i];
        }
        if ((iflag & 0x10) == 0 && (iflag & 0x400) == 0) {
            this.swi_aberr_light(xx, xobs, iflag);
            if ((iflag & 0x100) != 0) {
                for (i = 3; i <= 5; ++i) {
                    int n = i;
                    xx[n] = xx[n] + (xobs[i] - xobs2[i]);
                }
            }
        }
        if ((iflag & 0x100) == 0) {
            for (i = 3; i <= 5; ++i) {
                xx[i] = 0.0;
            }
        }
        for (i = 0; i <= 5; ++i) {
            xxsv[i] = xx[i];
        }
        if ((iflag & 0x20) == 0) {
            this.sl.swi_precess(xx, pdp.teval, -1);
            if ((iflag & 0x100) != 0) {
                this.swi_precess_speed(xx, pdp.teval, -1);
            }
            oe = this.swed.oec;
        } else {
            oe = this.swed.oec2000;
        }
        return this.app_pos_rest(pdp, iflag, xx, xxsv, oe, serr);
    }

    int app_pos_etc_sbar(int iflag, StringBuffer serr) {
        int i;
        double[] xx = new double[6];
        double[] xxsv = new double[6];
        PlanData psdp = this.swed.pldat[0];
        PlanData psbdp = this.swed.pldat[10];
        Epsilon oe = this.swed.oec;
        for (i = 0; i <= 5; ++i) {
            xx[i] = psbdp.x[i];
        }
        if ((iflag & 0x10) == 0) {
            double dt = Math.sqrt(this.sl.square_sum(xx)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
            for (i = 0; i <= 2; ++i) {
                int n = i;
                xx[n] = xx[n] - dt * xx[i + 3];
            }
        }
        if ((iflag & 0x100) == 0) {
            for (i = 3; i <= 5; ++i) {
                xx[i] = 0.0;
            }
        }
        for (i = 0; i <= 5; ++i) {
            xxsv[i] = xx[i];
        }
        if ((iflag & 0x20) == 0) {
            this.sl.swi_precess(xx, psbdp.teval, -1);
            if ((iflag & 0x100) != 0) {
                this.swi_precess_speed(xx, psbdp.teval, -1);
            }
            oe = this.swed.oec;
        } else {
            oe = this.swed.oec2000;
        }
        return this.app_pos_rest(psdp, iflag, xx, xxsv, oe, serr);
    }

    int app_pos_etc_mean(int ipl, int iflag, StringBuffer serr) {
        Epsilon oe;
        int i;
        double[] xx = new double[6];
        double[] xxsv = new double[6];
        PlanData pdp = this.swed.nddat[ipl];
        int flg1 = iflag & 0xFFFFF7FF & 0xFFFFEFFF;
        int flg2 = pdp.xflgs & 0xFFFFF7FF & 0xFFFFEFFF;
        if (flg1 == flg2) {
            pdp.xflgs = iflag;
            pdp.iephe = iflag & 7;
            return 0;
        }
        for (i = 0; i <= 5; ++i) {
            xx[i] = pdp.x[i];
        }
        this.sl.swi_polcart_sp(xx, xx);
        this.sl.swi_coortrf2(xx, xx, -this.swed.oec.seps, this.swed.oec.ceps);
        this.sl.swi_coortrf2(xx, 3, xx, 3, -this.swed.oec.seps, this.swed.oec.ceps);
        if ((iflag & 0x100) == 0) {
            for (i = 3; i <= 5; ++i) {
                xx[i] = 0.0;
            }
        }
        if ((iflag & 0x10000) != 0 && (this.swed.sidd.sid_mode & 0x100) != 0 || (this.swed.sidd.sid_mode & 0x200) != 0) {
            for (i = 0; i <= 5; ++i) {
                xxsv[i] = xx[i];
            }
            if (pdp.teval != 2451545.0) {
                this.sl.swi_precess(xxsv, pdp.teval, 1);
                if ((iflag & 0x100) != 0) {
                    this.swi_precess_speed(xxsv, pdp.teval, 1);
                }
            }
        }
        if ((iflag & 0x20) != 0) {
            this.sl.swi_precess(xx, pdp.teval, 1);
            if ((iflag & 0x100) != 0) {
                this.swi_precess_speed(xx, pdp.teval, 1);
            }
            oe = this.swed.oec2000;
        } else {
            oe = this.swed.oec;
        }
        return this.app_pos_rest(pdp, iflag, xx, xxsv, oe, serr);
    }

    void rot_back(int ipli) {
        double pav;
        double qav;
        int i;
        double[][] x = new double[41][3];
        double[] uix = new double[3];
        double[] uiy = new double[3];
        double[] uiz = new double[3];
        double seps2000 = this.swed.oec2000.seps;
        double ceps2000 = this.swed.oec2000.ceps;
        PlanData pdp = this.swed.pldat[ipli];
        int nco = pdp.ncoe;
        double t = pdp.tseg0 + pdp.dseg / 2.0;
        double[] chcfx = pdp.segp;
        int chcfyOffs = nco;
        int chcfzOffs = 2 * nco;
        double[] refepx = pdp.refep;
        int refepyOffs = nco;
        double tdiff = (t - pdp.telem) / 365250.0;
        if (ipli == 1) {
            double dn = pdp.prot + tdiff * pdp.dprot;
            i = (int)(dn / (Math.PI * 2));
            qav = (pdp.qrot + tdiff * pdp.dqrot) * Math.cos(dn -= (double)i * (Math.PI * 2));
            pav = (pdp.qrot + tdiff * pdp.dqrot) * Math.sin(dn);
        } else {
            qav = pdp.qrot + tdiff * pdp.dqrot;
            pav = pdp.prot + tdiff * pdp.dprot;
        }
        for (i = 0; i < nco; ++i) {
            x[i][0] = chcfx[i];
            x[i][1] = chcfx[i + chcfyOffs];
            x[i][2] = chcfx[i + chcfzOffs];
        }
        if ((pdp.iflg & 4) != 0) {
            double omtild = pdp.peri + tdiff * pdp.dperi;
            i = (int)(omtild / (Math.PI * 2));
            double com = Math.cos(omtild -= (double)i * (Math.PI * 2));
            double som = Math.sin(omtild);
            for (i = 0; i < nco; ++i) {
                x[i][0] = chcfx[i] + com * refepx[i] - som * refepx[i + refepyOffs];
                x[i][1] = chcfx[i + chcfyOffs] + com * refepx[i + refepyOffs] + som * refepx[i];
            }
        }
        double cosih2 = 1.0 / (1.0 + qav * qav + pav * pav);
        uiz[0] = 2.0 * pav * cosih2;
        uiz[1] = -2.0 * qav * cosih2;
        uiz[2] = (1.0 - qav * qav - pav * pav) * cosih2;
        uix[0] = (1.0 + qav * qav - pav * pav) * cosih2;
        uix[1] = 2.0 * qav * pav * cosih2;
        uix[2] = -2.0 * pav * cosih2;
        uiy[0] = 2.0 * qav * pav * cosih2;
        uiy[1] = (1.0 - qav * qav + pav * pav) * cosih2;
        uiy[2] = 2.0 * qav * cosih2;
        for (i = 0; i < nco; ++i) {
            double xrot = x[i][0] * uix[0] + x[i][1] * uiy[0] + x[i][2] * uiz[0];
            double yrot = x[i][0] * uix[1] + x[i][1] * uiy[1] + x[i][2] * uiz[1];
            double zrot = x[i][0] * uix[2] + x[i][1] * uiy[2] + x[i][2] * uiz[2];
            if (Math.abs(xrot) + Math.abs(yrot) + Math.abs(zrot) >= 1.0E-14) {
                pdp.neval = i;
            }
            x[i][0] = xrot;
            x[i][1] = yrot;
            x[i][2] = zrot;
            if (ipli != 1) continue;
            x[i][1] = ceps2000 * yrot - seps2000 * zrot;
            x[i][2] = seps2000 * yrot + ceps2000 * zrot;
        }
        for (i = 0; i < nco; ++i) {
            chcfx[i] = x[i][0];
            chcfx[i + chcfyOffs] = x[i][1];
            chcfx[i + chcfzOffs] = x[i][2];
        }
    }

    void embofs(double[] xemb, int eOffs, double[] xmoon, int mOffs) {
        for (int i = 0; i <= 2; ++i) {
            int n = i + eOffs;
            xemb[n] = xemb[n] - xmoon[i + mOffs] / 82.30058827479664;
        }
    }

    void nut_matrix(Nut nu, Epsilon oe) {
        double psi = nu.nutlo[0];
        double eps = oe.eps + nu.nutlo[1];
        double sinpsi = Math.sin(psi);
        double cospsi = Math.cos(psi);
        double sineps0 = oe.seps;
        double coseps0 = oe.ceps;
        double sineps = Math.sin(eps);
        double coseps = Math.cos(eps);
        nu.matrix[0][0] = cospsi;
        nu.matrix[0][1] = sinpsi * coseps;
        nu.matrix[0][2] = sinpsi * sineps;
        nu.matrix[1][0] = -sinpsi * coseps0;
        nu.matrix[1][1] = cospsi * coseps * coseps0 + sineps * sineps0;
        nu.matrix[1][2] = cospsi * sineps * coseps0 - coseps * sineps0;
        nu.matrix[2][0] = -sinpsi * sineps0;
        nu.matrix[2][1] = cospsi * coseps * sineps0 - sineps * coseps0;
        nu.matrix[2][2] = cospsi * sineps * sineps0 + coseps * coseps0;
    }

    int lunar_osc_elem(double tjd, int ipl, int iflag, StringBuffer serr) {
        int j;
        int i;
        int epheflag = 2;
        int retc = -1;
        double speed_intv = 1.0E-4;
        double[][] xpos = new double[3][6];
        double[][] xx = new double[3][6];
        double[][] xxa = new double[3][6];
        double[] xnorm = new double[6];
        double[] r = new double[6];
        Epsilon oe = this.swed.oec;
        PlanData ndp = this.swed.nddat[ipl];
        int flg1 = iflag & 0xFFFFF7FF & 0xFFFFEFFF;
        int flg2 = ndp.xflgs & 0xFFFFF7FF & 0xFFFFEFFF;
        int speedf1 = ndp.xflgs & 0x100;
        int speedf2 = iflag & 0x100;
        if (tjd == ndp.teval && tjd != 0.0 && flg1 == flg2 && (speedf2 == 0 || speedf1 != 0)) {
            ndp.xflgs = iflag;
            ndp.iephe = iflag & 7;
            return 0;
        }
        if ((iflag & 4) != 0) {
            epheflag = 4;
        } else if ((iflag & 2) != 0) {
            epheflag = 2;
        } else if ((iflag & 1) != 0) {
            epheflag = 1;
        }
        this.swed.pldat[1].teval = 0.0;
        int istart = (iflag & 0x100) != 0 ? 0 : 2;
        if (serr != null) {
            serr.setLength(0);
        }
        do {
            switch (epheflag) {
                case 2: {
                    speed_intv = 1.0E-4;
                    for (i = istart; i <= 2; ++i) {
                        double dt;
                        double t = i == 0 ? tjd - speed_intv : (i == 1 ? tjd + speed_intv : tjd);
                        retc = this.swemoon(t, iflag | 0x100, false, xpos[i], serr);
                        if (retc == -1) {
                            return -1;
                        }
                        if ((iflag & 0x10) == 0 && retc >= 0 && (retc = this.swemoon(t - (dt = Math.sqrt(this.sl.square_sum(xpos[i])) * 1.4959787066E11 / 2.99792458E8 / 86400.0), iflag | 0x100, false, xpos[i], serr)) == -1) {
                            return -1;
                        }
                        if (retc == -2) {
                            return -1;
                        }
                        retc = this.swi_plan_for_osc_elem(iflag, t, xpos[i]);
                    }
                }
            }
        } while (retc == -2 || retc == -3);
        PlanData ndnp = this.swed.nddat[1];
        for (i = istart; i <= 2; ++i) {
            if (Math.abs(xpos[i][5]) < 1.0E-15) {
                xpos[i][5] = 1.0E-15;
            }
            double fac = xpos[i][2] / xpos[i][5];
            double sgn = xpos[i][5] / Math.abs(xpos[i][5]);
            for (j = 0; j <= 2; ++j) {
                xx[i][j] = (xpos[i][j] - fac * xpos[i][j + 3]) * sgn;
            }
        }
        for (i = 0; i <= 2; ++i) {
            ndnp.x[i] = xx[2][i];
            if ((iflag & 0x100) != 0) {
                double b = (xx[1][i] - xx[0][i]) / 2.0;
                double a = (xx[1][i] + xx[0][i]) / 2.0 - xx[2][i];
                ndnp.x[i + 3] = (2.0 * a + b) / speed_intv;
            } else {
                ndnp.x[i + 3] = 0.0;
            }
            ndnp.teval = tjd;
            ndnp.iephe = epheflag;
        }
        PlanData ndap = this.swed.nddat[3];
        double Gmsm = 8.997011655185388E-10;
        for (i = istart; i <= 2; ++i) {
            double rxy = Math.sqrt(xx[i][0] * xx[i][0] + xx[i][1] * xx[i][1]);
            double cosnode = xx[i][0] / rxy;
            double sinnode = xx[i][1] / rxy;
            this.sl.swi_cross_prod(xpos[i], 0, xpos[i], 3, xnorm, 0);
            rxy = xnorm[0] * xnorm[0] + xnorm[1] * xnorm[1];
            double c2 = rxy + xnorm[2] * xnorm[2];
            double rxyz = Math.sqrt(c2);
            rxy = Math.sqrt(rxy);
            double sinincl = rxy / rxyz;
            double cosincl = Math.sqrt(1.0 - sinincl * sinincl);
            double cosu = xpos[i][0] * cosnode + xpos[i][1] * sinnode;
            double sinu = xpos[i][2] / sinincl;
            double uu = Math.atan2(sinu, cosu);
            rxyz = Math.sqrt(this.sl.square_sum(xpos[i]));
            double v2 = this.sl.square_sum(xpos[i], 3);
            double sema = 1.0 / (2.0 / rxyz - v2 / Gmsm);
            double pp = c2 / Gmsm;
            double ecce = Math.sqrt(1.0 - pp / sema);
            double cosE = 1.0 / ecce * (1.0 - rxyz / sema);
            double sinE = 1.0 / ecce / Math.sqrt(sema * Gmsm) * this.dot_prod(xpos[i], xpos[i], 3);
            double ny = 2.0 * Math.atan(Math.sqrt((1.0 + ecce) / (1.0 - ecce)) * sinE / (1.0 + cosE));
            xxa[i][0] = this.sl.swi_mod2PI(uu - ny + Math.PI);
            xxa[i][1] = 0.0;
            xxa[i][2] = sema * (1.0 + ecce);
            this.sl.swi_polcart(xxa[i], xxa[i]);
            this.sl.swi_coortrf2(xxa[i], xxa[i], -sinincl, cosincl);
            this.sl.swi_cartpol(xxa[i], xxa[i]);
            double[] dArray = xxa[i];
            dArray[0] = dArray[0] + Math.atan2(sinnode, cosnode);
            this.sl.swi_polcart(xxa[i], xxa[i]);
            ny = this.sl.swi_mod2PI(ny - uu);
            cosE = Math.cos(2.0 * Math.atan(Math.tan(ny / 2.0) / Math.sqrt((1.0 + ecce) / (1.0 - ecce))));
            r[0] = sema * (1.0 - ecce * cosE);
            r[1] = Math.sqrt(this.sl.square_sum(xx[i]));
            j = 0;
            while (j <= 2) {
                double[] dArray2 = xx[i];
                int n = j++;
                dArray2[n] = dArray2[n] * (r[0] / r[1]);
            }
        }
        for (i = 0; i <= 2; ++i) {
            ndap.x[i] = xxa[2][i];
            ndap.x[i + 3] = (iflag & 0x100) != 0 ? (xxa[1][i] - xxa[0][i]) / speed_intv / 2.0 : 0.0;
            ndap.teval = tjd;
            ndap.iephe = epheflag;
            ndnp.x[i] = xx[2][i];
            ndnp.x[i + 3] = (iflag & 0x100) != 0 ? (xx[1][i] - xx[0][i]) / speed_intv / 2.0 : 0.0;
        }
        double[] x = new double[6];
        for (j = 0; j <= 1; ++j) {
            ndp = j == 0 ? this.swed.nddat[1] : this.swed.nddat[3];
            for (int z = 0; z < ndp.xreturn.length; ++z) {
                ndp.xreturn[z] = 0.0;
            }
            for (i = 0; i <= 5; ++i) {
                ndp.xreturn[6 + i] = ndp.x[i];
            }
            this.sl.swi_cartpol_sp(ndp.xreturn, 6, ndp.xreturn, 0);
            this.sl.swi_coortrf2(ndp.xreturn, 6, ndp.xreturn, 18, -oe.seps, oe.ceps);
            if ((iflag & 0x100) != 0) {
                this.sl.swi_coortrf2(ndp.xreturn, 9, ndp.xreturn, 21, -oe.seps, oe.ceps);
            }
            if ((iflag & 0x40) == 0) {
                this.sl.swi_coortrf2(ndp.xreturn, 18, ndp.xreturn, 18, -this.swed.nut.snut, this.swed.nut.cnut);
                if ((iflag & 0x100) != 0) {
                    this.sl.swi_coortrf2(ndp.xreturn, 21, ndp.xreturn, 21, -this.swed.nut.snut, this.swed.nut.cnut);
                }
            }
            this.sl.swi_cartpol_sp(ndp.xreturn, 18, ndp.xreturn, 12);
            ndp.xflgs = iflag;
            ndp.iephe = iflag & 7;
            if ((iflag & 0x10000) != 0) {
                if ((this.swed.sidd.sid_mode & 0x100) != 0 || (this.swed.sidd.sid_mode & 0x200) != 0) {
                    for (i = 0; i <= 5; ++i) {
                        x[i] = ndp.xreturn[18 + i];
                    }
                    if ((iflag & 0x40) == 0) {
                        this.swi_nutate(x, 0, iflag, true);
                    }
                    this.sl.swi_precess(x, tjd, 1);
                    if ((iflag & 0x100) != 0) {
                        this.swi_precess_speed(x, tjd, 1);
                    }
                    if ((this.swed.sidd.sid_mode & 0x100) != 0) {
                        this.swi_trop_ra2sid_lon(x, ndp.xreturn, 6, ndp.xreturn, 18, iflag, null);
                    } else if ((this.swed.sidd.sid_mode & 0x200) != 0) {
                        this.swi_trop_ra2sid_lon_sosy(x, ndp.xreturn, 6, ndp.xreturn, 18, iflag, null);
                    }
                    this.sl.swi_cartpol_sp(ndp.xreturn, 6, ndp.xreturn, 0);
                    this.sl.swi_cartpol_sp(ndp.xreturn, 18, ndp.xreturn, 12);
                } else {
                    this.sl.swi_cartpol_sp(ndp.xreturn, 6, ndp.xreturn, 0);
                    ndp.xreturn[0] = ndp.xreturn[0] - this.swe_get_ayanamsa(ndp.teval) * 0.0174532925199433;
                    this.sl.swi_polcart_sp(ndp.xreturn, 0, ndp.xreturn, 6);
                }
            } else if ((iflag & 0x20) != 0) {
                for (i = 0; i <= 5; ++i) {
                    x[i] = ndp.xreturn[18 + i];
                }
                this.sl.swi_precess(x, tjd, 1);
                if ((iflag & 0x100) != 0) {
                    this.swi_precess_speed(x, tjd, 1);
                }
                for (i = 0; i <= 5; ++i) {
                    ndp.xreturn[18 + i] = x[i];
                }
                this.sl.swi_cartpol_sp(ndp.xreturn, 18, ndp.xreturn, 12);
                this.sl.swi_coortrf2(ndp.xreturn, 18, ndp.xreturn, 6, this.swed.oec2000.seps, this.swed.oec2000.ceps);
                if ((iflag & 0x100) != 0) {
                    this.sl.swi_coortrf2(ndp.xreturn, 21, ndp.xreturn, 9, this.swed.oec2000.seps, this.swed.oec2000.ceps);
                }
                this.sl.swi_cartpol_sp(ndp.xreturn, 6, ndp.xreturn, 0);
            }
            for (i = 0; i < 2; ++i) {
                int n = i;
                ndp.xreturn[n] = ndp.xreturn[n] * 57.2957795130823;
                int n2 = i + 3;
                ndp.xreturn[n2] = ndp.xreturn[n2] * 57.2957795130823;
                int n3 = i + 12;
                ndp.xreturn[n3] = ndp.xreturn[n3] * 57.2957795130823;
                int n4 = i + 15;
                ndp.xreturn[n4] = ndp.xreturn[n4] * 57.2957795130823;
            }
            ndp.xreturn[0] = this.sl.swe_degnorm(ndp.xreturn[0]);
            ndp.xreturn[12] = this.sl.swe_degnorm(ndp.xreturn[12]);
        }
        return 0;
    }

    int swi_plan_for_osc_elem(int iflag, double tjd, double[] xx) {
        Nut nuttmp;
        double[] x = new double[6];
        Nut nutp = nuttmp = new Nut();
        Epsilon oe = this.swed.oec;
        Epsilon oectmp = new Epsilon();
        this.sl.swi_precess(xx, tjd, -1);
        this.sl.swi_precess(xx, 3, tjd, -1);
        if (tjd == this.swed.oec.teps) {
            oe = this.swed.oec;
        } else if (tjd == 2451545.0) {
            oe = this.swed.oec2000;
        } else {
            this.calc_epsilon(tjd, oectmp);
            oe = oectmp;
        }
        if ((iflag & 0x40) == 0) {
            int i;
            if (tjd == this.swed.nut.tnut) {
                nutp = this.swed.nut;
            } else if (tjd == 2451545.0) {
                nutp = this.swed.nut2000;
            } else if (tjd == this.swed.nutv.tnut) {
                nutp = this.swed.nutv;
            } else {
                nutp = nuttmp;
                this.sl.swi_nutation(tjd, nutp.nutlo);
                nutp.tnut = tjd;
                nutp.snut = Math.sin(nutp.nutlo[1]);
                nutp.cnut = Math.cos(nutp.nutlo[1]);
                this.nut_matrix(nutp, oe);
            }
            for (i = 0; i <= 2; ++i) {
                x[i] = xx[0] * nutp.matrix[0][i] + xx[1] * nutp.matrix[1][i] + xx[2] * nutp.matrix[2][i];
            }
            for (i = 0; i <= 2; ++i) {
                x[i + 3] = xx[3] * nutp.matrix[0][i] + xx[4] * nutp.matrix[1][i] + xx[5] * nutp.matrix[2][i];
            }
            for (i = 0; i <= 5; ++i) {
                xx[i] = x[i];
            }
        }
        this.sl.swi_coortrf2(xx, xx, oe.seps, oe.ceps);
        this.sl.swi_coortrf2(xx, 3, xx, 3, oe.seps, oe.ceps);
        if ((iflag & 0x40) == 0) {
            this.sl.swi_coortrf2(xx, xx, nutp.snut, nutp.cnut);
            this.sl.swi_coortrf2(xx, 3, xx, 3, nutp.snut, nutp.cnut);
        }
        return 0;
    }

    double meff(double r) {
        if (r <= 0.0) {
            return 0.0;
        }
        if (r >= 1.0) {
            return 1.0;
        }
        int i = 0;
        while (SwissEph.eff_arr[i].r > r) {
            ++i;
        }
        double f = (r - SwissEph.eff_arr[i - 1].r) / (SwissEph.eff_arr[i].r - SwissEph.eff_arr[i - 1].r);
        double m = SwissEph.eff_arr[i - 1].m + f * (SwissEph.eff_arr[i].m - SwissEph.eff_arr[i - 1].m);
        return m;
    }

    void denormalize_positions(double[] x0, double[] x1, double[] x2) {
        for (int i = 0; i <= 12; i += 12) {
            if (x1[i] - x0[i] < -180.0) {
                int n = i;
                x0[n] = x0[n] - 360.0;
            }
            if (x1[i] - x0[i] > 180.0) {
                int n = i;
                x0[n] = x0[n] + 360.0;
            }
            if (x1[i] - x2[i] < -180.0) {
                int n = i;
                x2[n] = x2[n] - 360.0;
            }
            if (!(x1[i] - x2[i] > 180.0)) continue;
            int n = i;
            x2[n] = x2[n] + 360.0;
        }
    }

    void calc_speed(double[] x0, double[] x1, double[] x2, double dt) {
        for (int j = 0; j <= 18; j += 6) {
            for (int i = 0; i < 3; ++i) {
                int k = j + i;
                double b = (x2[k] - x0[k]) / 2.0;
                double a = (x2[k] + x0[k]) / 2.0 - x1[k];
                x1[k + 3] = (2.0 * a + b) / dt;
            }
        }
    }

    void swi_check_ecliptic(double tjd) {
        if (this.swed.oec2000.teps != 2451545.0) {
            this.calc_epsilon(2451545.0, this.swed.oec2000);
        }
        if (tjd == 2451545.0) {
            this.swed.oec.teps = this.swed.oec2000.teps;
            this.swed.oec.eps = this.swed.oec2000.eps;
            this.swed.oec.seps = this.swed.oec2000.seps;
            this.swed.oec.ceps = this.swed.oec2000.ceps;
            return;
        }
        if (this.swed.oec.teps != tjd || tjd == 0.0) {
            this.calc_epsilon(tjd, this.swed.oec);
        }
    }

    void swi_check_nutation(double tjd, int iflag) {
        int speedf1 = this.chck_nut_nutflag & 0x100;
        int speedf2 = iflag & 0x100;
        if ((iflag & 0x40) == 0 && (tjd != this.swed.nut.tnut || tjd == 0.0 || speedf1 == 0 && speedf2 != 0)) {
            this.sl.swi_nutation(tjd, this.swed.nut.nutlo);
            this.swed.nut.tnut = tjd;
            this.swed.nut.snut = Math.sin(this.swed.nut.nutlo[1]);
            this.swed.nut.cnut = Math.cos(this.swed.nut.nutlo[1]);
            this.chck_nut_nutflag = iflag;
            this.nut_matrix(this.swed.nut, this.swed.oec);
            if ((iflag & 0x100) != 0) {
                double t = tjd - 1.0E-4;
                this.sl.swi_nutation(t, this.swed.nutv.nutlo);
                this.swed.nutv.tnut = t;
                this.swed.nutv.snut = Math.sin(this.swed.nutv.nutlo[1]);
                this.swed.nutv.cnut = Math.cos(this.swed.nutv.nutlo[1]);
                this.nut_matrix(this.swed.nutv, this.swed.oec);
            }
        }
    }

    int plaus_iflag(int iflag) {
        int epheflag = 0;
        if ((iflag & 0x8000) != 0) {
            iflag &= 0xFFFFBFF7;
        }
        if ((iflag & 8) != 0) {
            iflag |= 0x600;
        }
        if ((iflag & 0x4000) != 0) {
            iflag |= 0x600;
        }
        if ((iflag & 0x20) != 0) {
            iflag |= 0x40;
        }
        if ((iflag & 0x10) != 0) {
            iflag |= 0x600;
        }
        if ((iflag & 0x10000) != 0) {
            iflag |= 0x40;
        }
        if ((iflag & 4) != 0) {
            epheflag = 4;
        }
        if ((iflag & 2) != 0) {
            epheflag = 2;
        }
        if ((iflag & 1) != 0) {
            epheflag = 1;
        }
        if (epheflag == 0) {
            epheflag = 2;
        }
        if (epheflag == 4) {
            epheflag = 2;
        }
        if (epheflag == 1) {
            epheflag = 2;
        }
        iflag = iflag & 0xFFFFFFF8 | epheflag;
        return iflag;
    }

    int swe_fixstar_found(StringBuffer serr, String s, StringBuffer star, double tjd, int iflag, int iflgsave, int epheflag, double[] xx) {
        int retc;
        double epoch;
        Object xpo = null;
        double[] x = new double[6];
        double[] xxsv = new double[6];
        double[] xobs = new double[6];
        PlanData pedp = this.swed.pldat[0];
        PlanData psdp = this.swed.pldat[10];
        Epsilon oe = this.swed.oec2000;
        String[] cpos = new String[20];
        StringTokenizer tk = new StringTokenizer(s, ",");
        int i = tk.countTokens();
        int n = 0;
        while (tk.hasMoreTokens() && n < 20) {
            cpos[n++] = tk.nextToken();
        }
        cpos[0] = cpos[0].trim();
        cpos[1] = cpos[1].trim();
        if (i < 13) {
            if (serr != null) {
                serr.setLength(0);
                serr.append("data of star '" + cpos[0] + "," + cpos[1] + "' incomplete");
            }
            return this.swe_fixstar_error(xx, -1);
        }
        int idx = cpos[2].length();
        while (true) {
            try {
                epoch = Double.valueOf(cpos[2].substring(0, idx));
            }
            catch (NumberFormatException nf) {
                if (--idx != 0) continue;
                epoch = 0.0;
            }
            break;
        }
        double ra_h = new Double(cpos[3]);
        double ra_m = new Double(cpos[4]);
        double ra_s = new Double(cpos[5]);
        double de_d = new Double(cpos[6]);
        String sde_d = cpos[6];
        double de_m = new Double(cpos[7]);
        double de_s = new Double(cpos[8]);
        double ra_pm = new Double(cpos[9]);
        double de_pm = new Double(cpos[10]);
        double radv = new Double(cpos[11]);
        double parall = new Double(cpos[12]);
        if (cpos[0].length() > 20) {
            cpos[0] = cpos[0].substring(0, 20);
        }
        if (cpos[1].length() > 19) {
            cpos[1] = cpos[1].substring(0, 19);
        }
        star.setLength(0);
        star.append(cpos[0] + "," + cpos[1]);
        double ra = (ra_s / 3600.0 + ra_m / 60.0 + ra_h) * 15.0;
        double de = sde_d.indexOf(45) < 0 ? de_s / 3600.0 + de_m / 60.0 + de_d : -de_s / 3600.0 - de_m / 60.0 + de_d;
        ra_pm = ra_pm * 15.0 / 3600.0;
        de_pm /= 3600.0;
        parall = parall > 1.0 ? 1.0 / parall / 3600.0 : (parall /= 3600.0);
        radv *= 21.095;
        ra_pm *= 0.0174532925199433;
        de_pm *= 0.0174532925199433;
        parall *= 0.0174532925199433;
        x[0] = ra *= 0.0174532925199433;
        x[1] = de *= 0.0174532925199433;
        x[2] = 1.0;
        this.sl.swi_polcart(x, x);
        double cosra = Math.cos(ra);
        double cosde = Math.cos(de);
        double sinra = Math.sin(ra);
        double sinde = Math.sin(de);
        x[3] = -ra_pm * cosde * sinra - de_pm * sinde * cosra + radv * parall * cosde * cosra;
        x[4] = ra_pm * cosde * cosra - de_pm * sinde * sinra + radv * parall * cosde * sinra;
        x[5] = de_pm * cosde + radv * parall * sinde;
        x[3] = x[3] / 36525.0;
        x[4] = x[4] / 36525.0;
        x[5] = x[5] / 36525.0;
        if (epoch == 1950.0) {
            this.sl.swi_FK4_FK5(x, 2433282.42345905);
            this.sl.swi_precess(x, 2433282.42345905, 1);
            this.sl.swi_precess(x, 3, 2433282.42345905, 1);
        }
        if ((retc = this.main_planet(tjd, 0, epheflag, iflag, serr)) != 0) {
            return this.swe_fixstar_error(xx, -1);
        }
        iflag = this.swed.pldat[0].xflgs;
        if ((iflag & 0x8000) != 0) {
            if (this.swed.topd.teval != pedp.teval || this.swed.topd.teval == 0.0) {
                if (this.swi_get_observer(pedp.teval, iflag, true, xobs, serr) != 0) {
                    return -1;
                }
            } else {
                for (i = 0; i <= 5; ++i) {
                    xobs[i] = this.swed.topd.xobs[i];
                }
            }
            for (i = 0; i <= 5; ++i) {
                xobs[i] = xobs[i] + pedp.x[i];
            }
        } else {
            for (i = 0; i <= 5; ++i) {
                xobs[i] = pedp.x[i];
            }
        }
        double t = epoch == 1950.0 ? tjd - 2433282.42345905 : tjd - 2451545.0;
        xpo = (iflag & 8) != 0 && (iflag & 4) != 0 ? null : ((iflag & 8) != 0 ? psdp.x : (Object)((iflag & 0x4000) != 0 ? null : xobs));
        if (xpo == null) {
            for (i = 0; i <= 2; ++i) {
                int n2 = i;
                x[n2] = x[n2] + t * x[i + 3];
            }
        } else {
            for (i = 0; i <= 2; ++i) {
                int n3 = i;
                x[n3] = x[n3] + (t * x[i + 3] - parall * xpo[i]);
                int n4 = i + 3;
                x[n4] = x[n4] - parall * xpo[i + 3];
            }
        }
        i = 0;
        while (i <= 5) {
            int n5 = i++;
            x[n5] = x[n5] * 10000.0;
        }
        if ((iflag & 0x10) == 0 && (iflag & 0x200) == 0) {
            this.swi_deflect_light(x, 0, 0.0, iflag & 0x100);
        }
        if ((iflag & 0x10) == 0 && (iflag & 0x400) == 0) {
            this.swi_aberr_light(x, (double[])xpo, iflag & 0x100);
        }
        for (i = 0; i <= 5; ++i) {
            xxsv[i] = x[i];
        }
        if ((iflag & 0x20) == 0) {
            this.sl.swi_precess(x, tjd, -1);
            if ((iflag & 0x100) != 0) {
                this.swi_precess_speed(x, tjd, -1);
            }
            oe = this.swed.oec;
        } else {
            oe = this.swed.oec2000;
        }
        if ((iflag & 0x40) == 0) {
            this.swi_nutate(x, 0, 0, false);
        }
        double u = Math.sqrt(this.sl.square_sum(x));
        i = 0;
        while (i <= 5) {
            int n6 = i++;
            x[n6] = x[n6] / u;
        }
        u = Math.sqrt(this.sl.square_sum(xxsv));
        i = 0;
        while (i <= 5) {
            int n7 = i++;
            xxsv[n7] = xxsv[n7] / u;
        }
        for (i = 3; i <= 5; ++i) {
            xxsv[i] = 0.0;
            x[i] = 0.0;
        }
        if ((iflag & 0x800) == 0) {
            this.sl.swi_coortrf2(x, x, oe.seps, oe.ceps);
            if ((iflag & 0x100) != 0) {
                this.sl.swi_coortrf2(x, 3, x, 3, oe.seps, oe.ceps);
            }
            if ((iflag & 0x40) == 0) {
                this.sl.swi_coortrf2(x, x, this.swed.nut.snut, this.swed.nut.cnut);
                if ((iflag & 0x100) != 0) {
                    this.sl.swi_coortrf2(x, 3, x, 3, this.swed.nut.snut, this.swed.nut.cnut);
                }
            }
        }
        if ((iflag & 0x10000) != 0) {
            if ((this.swed.sidd.sid_mode & 0x100) != 0) {
                if (this.swi_trop_ra2sid_lon(xxsv, x, xxsv, iflag, serr) != 0) {
                    return -1;
                }
                if ((iflag & 0x800) != 0) {
                    for (i = 0; i <= 5; ++i) {
                        x[i] = xxsv[i];
                    }
                }
            } else if ((this.swed.sidd.sid_mode & 0x200) != 0) {
                if (this.swi_trop_ra2sid_lon_sosy(xxsv, x, xxsv, iflag, serr) != 0) {
                    return -1;
                }
                if ((iflag & 0x800) != 0) {
                    for (i = 0; i <= 5; ++i) {
                        x[i] = xxsv[i];
                    }
                }
            } else {
                this.sl.swi_cartpol_sp(x, x);
                x[0] = x[0] - this.swe_get_ayanamsa(tjd) * 0.0174532925199433;
                this.sl.swi_polcart_sp(x, x);
            }
        }
        if ((iflag & 0x1000) == 0) {
            this.sl.swi_cartpol_sp(x, x);
        }
        if ((iflag & 0x2000) == 0 && (iflag & 0x1000) == 0) {
            for (i = 0; i < 2; ++i) {
                int n8 = i;
                x[n8] = x[n8] * 57.2957795130823;
                int n9 = i + 3;
                x[n9] = x[n9] * 57.2957795130823;
            }
        }
        for (i = 0; i <= 5; ++i) {
            xx[i] = x[i];
        }
        if ((iflgsave & 7) == 0) {
            iflag &= 0xFFFFFFFD;
        }
        return iflag;
    }

    int swe_fixstar_error(double[] xx, int retc) {
        for (int i = 0; i <= 5; ++i) {
            xx[i] = 0.0;
        }
        return retc;
    }

    void swi_force_app_pos_etc() {
        int i;
        for (i = 0; i < 18; ++i) {
            this.swed.pldat[i].xflgs = -1;
        }
        for (i = 0; i < 4; ++i) {
            this.swed.nddat[i].xflgs = -1;
        }
        for (i = 0; i < 21; ++i) {
            this.swed.savedat[i].tsave = 0.0;
            this.swed.savedat[i].iflgsave = -1;
        }
    }

    int swi_get_observer(double tjd, int iflag, boolean do_save, double[] xobs, StringBuffer serr) {
        double nut;
        double eps;
        double[] nutlo = new double[2];
        double f = 0.0033528106647474805;
        double re = 6378137.0;
        if (!this.swed.geopos_is_set) {
            if (serr != null) {
                serr.setLength(0);
                serr.append("geographic position has not been set");
            }
            return -1;
        }
        double delt = SweDate.getDeltaT(tjd);
        double tjd_ut = tjd - delt;
        if (this.swed.oec.teps == tjd && this.swed.nut.tnut == tjd) {
            eps = this.swed.oec.eps;
            nutlo[1] = this.swed.nut.nutlo[1];
            nutlo[0] = this.swed.nut.nutlo[0];
        } else {
            eps = this.sl.swi_epsiln(tjd);
            if ((iflag & 0x40) == 0) {
                this.sl.swi_nutation(tjd, nutlo);
            }
        }
        if ((iflag & 0x40) != 0) {
            nut = 0.0;
        } else {
            eps += nutlo[1];
            nut = nutlo[0];
        }
        double sidt = this.sl.swe_sidtime0(tjd_ut, eps, nut);
        double cosfi = Math.cos(this.swed.topd.geolat * 0.0174532925199433);
        double sinfi = Math.sin(this.swed.topd.geolat * 0.0174532925199433);
        double cc = 1.0 / Math.sqrt(cosfi * cosfi + (1.0 - f) * (1.0 - f) * sinfi * sinfi);
        double ss = (1.0 - f) * (1.0 - f) * cc;
        double cosl = Math.cos((this.swed.topd.geolon + (sidt *= 15.0)) * 0.0174532925199433);
        double sinl = Math.sin((this.swed.topd.geolon + sidt) * 0.0174532925199433);
        double h = this.swed.topd.geoalt;
        xobs[0] = (re * cc + h) * cosfi * cosl;
        xobs[1] = (re * cc + h) * cosfi * sinl;
        xobs[2] = (re * ss + h) * sinfi;
        this.sl.swi_cartpol(xobs, xobs);
        xobs[3] = 6.300387486748799;
        xobs[5] = 0.0;
        xobs[4] = 0.0;
        this.sl.swi_polcart_sp(xobs, xobs);
        int i = 0;
        while (i <= 5) {
            int n = i++;
            xobs[n] = xobs[n] / 1.4959787066E11;
        }
        if ((iflag & 0x40) == 0) {
            this.sl.swi_coortrf2(xobs, xobs, -this.swed.nut.snut, this.swed.nut.cnut);
            if ((iflag & 0x100) != 0) {
                this.sl.swi_coortrf2(xobs, 3, xobs, 3, -this.swed.nut.snut, this.swed.nut.cnut);
            }
            this.swi_nutate(xobs, 0, iflag, true);
        }
        this.sl.swi_precess(xobs, tjd, 1);
        if ((iflag & 0x100) != 0) {
            this.swi_precess_speed(xobs, tjd, 1);
        }
        if (do_save) {
            for (i = 0; i <= 5; ++i) {
                this.swed.topd.xobs[i] = xobs[i];
            }
            this.swed.topd.teval = tjd;
            this.swed.topd.tjd_ut = tjd_ut;
        }
        return 0;
    }

    public int swe_time_equ(double tjd, DblObj E, StringBuffer serr) {
        double[] x = new double[6];
        double[] nutlo = new double[2];
        double tau = (tjd - 2451545.0) / 365250.0;
        double tau2 = tau * tau;
        double tau3 = tau * tau2;
        double tau4 = tau * tau3;
        double tau5 = tau * tau4;
        double L0 = 280.4664567 + this.sl.swe_degnorm(tau * 360007.6982779) + tau2 * 0.03032028 + tau3 * 1.0 / 49931.0 - tau4 * 1.0 / 15299.0 - tau5 * 1.0 / 1988000.0;
        this.sl.swi_nutation(tjd, nutlo);
        double eps = (this.sl.swi_epsiln(tjd) + nutlo[1]) * 57.2957795130823;
        double dpsi = nutlo[0] * 57.2957795130823;
        if (this.swe_calc(tjd, 0, 2048, x, serr) == -1) {
            return -1;
        }
        E.val = this.sl.swe_degnorm(L0 - 0.0057183 - x[0] + dpsi * Math.cos(eps * 0.0174532925199433));
        if (E.val > 180.0) {
            E.val -= 360.0;
        }
        E.val *= 0.002777777777777778;
        return 0;
    }

    double dot_prod(double[] x, double[] y) {
        return x[0] * y[0] + x[1] * y[1] + x[2] * y[2];
    }

    double dot_prod(double[] x, double[] y, int yOffs) {
        return x[0] * y[yOffs] + x[1] * y[1 + yOffs] + x[2] * y[2 + yOffs];
    }
}

