/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.util.StringTokenizer;
import swisseph.DblObj;
import swisseph.IntObj;
import swisseph.SweDate;
import swisseph.SwissData;

public class SwissLib {
    SwissData swed;
    static final double[] pAcof = new double[]{-8.66E-10, -4.759E-8, 2.424E-7, 1.3095E-5, 1.7451E-4, -0.0018055, -0.235316, 0.076, 110.5407, 50287.7};
    static final double[] nodecof = new double[]{6.6402E-16, -2.69151E-15, -1.547021E-12, 7.521313E-12, 1.9E-10, -3.54E-9, -1.8103E-7, 1.26E-7, 7.436169E-5, -0.04207794833, 3.052115282424};
    static final double[] inclcof = new double[]{1.2147E-16, 7.3759E-17, -8.26287E-14, 2.50341E-13, 2.4650839E-11, -5.4000441E-11, 1.32115526E-9, -6.012E-7, -1.62442E-5, 0.00227850649, 0.0};
    static final short ENDMARK = -99;
    static short[] nt = new short[]{0, 0, 0, 0, 2, 2062, 2, -895, 5, -2, 0, 2, 0, 1, 46, 0, -24, 0, 2, 0, -2, 0, 0, 11, 0, 0, 0, -2, 0, 2, 0, 2, -3, 0, 1, 0, 1, -1, 0, -1, 0, -3, 0, 0, 0, 0, -2, 2, -2, 1, -2, 0, 1, 0, 2, 0, -2, 0, 1, 1, 0, 0, 0, 0, 0, 2, -2, 2, -13187, -16, 5736, -31, 0, 1, 0, 0, 0, 1426, -34, 54, -1, 0, 1, 2, -2, 2, -517, 12, 224, -6, 0, -1, 2, -2, 2, 217, -5, -95, 3, 0, 0, 2, -2, 1, 129, 1, -70, 0, 2, 0, 0, -2, 0, 48, 0, 1, 0, 0, 0, 2, -2, 0, -22, 0, 0, 0, 0, 2, 0, 0, 0, 17, -1, 0, 0, 0, 1, 0, 0, 1, -15, 0, 9, 0, 0, 2, 2, -2, 2, -16, 1, 7, 0, 0, -1, 0, 0, 1, -12, 0, 6, 0, -2, 0, 0, 2, 1, -6, 0, 3, 0, 0, -1, 2, -2, 1, -5, 0, 3, 0, 2, 0, 0, -2, 1, 4, 0, -2, 0, 0, 1, 2, -2, 1, 4, 0, -2, 0, 1, 0, 0, -1, 0, -4, 0, 0, 0, 2, 1, 0, -2, 0, 1, 0, 0, 0, 0, 0, -2, 2, 1, 1, 0, 0, 0, 0, 1, -2, 2, 0, -1, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0, 0, -1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 2, -2, 0, -1, 0, 0, 0, 0, 0, 2, 0, 2, -2274, -2, 977, -5, 1, 0, 0, 0, 0, 712, 1, -7, 0, 0, 0, 2, 0, 1, -386, -4, 200, 0, 1, 0, 2, 0, 2, -301, 0, 129, -1, 1, 0, 0, -2, 0, -158, 0, -1, 0, -1, 0, 2, 0, 2, 123, 0, -53, 0, 0, 0, 0, 2, 0, 63, 0, -2, 0, 1, 0, 0, 0, 1, 63, 1, -33, 0, -1, 0, 0, 0, 1, -58, -1, 32, 0, -1, 0, 2, 2, 2, -59, 0, 26, 0, 1, 0, 2, 0, 1, -51, 0, 27, 0, 0, 0, 2, 2, 2, -38, 0, 16, 0, 2, 0, 0, 0, 0, 29, 0, -1, 0, 1, 0, 2, -2, 2, 29, 0, -12, 0, 2, 0, 2, 0, 2, -31, 0, 13, 0, 0, 0, 2, 0, 0, 26, 0, -1, 0, -1, 0, 2, 0, 1, 21, 0, -10, 0, -1, 0, 0, 2, 1, 16, 0, -8, 0, 1, 0, 0, -2, 1, -13, 0, 7, 0, -1, 0, 2, 2, 1, -10, 0, 5, 0, 1, 1, 0, -2, 0, -7, 0, 0, 0, 0, 1, 2, 0, 2, 7, 0, -3, 0, 0, -1, 2, 0, 2, -7, 0, 3, 0, 1, 0, 2, 2, 2, -8, 0, 3, 0, 1, 0, 0, 2, 0, 6, 0, 0, 0, 2, 0, 2, -2, 2, 6, 0, -3, 0, 0, 0, 0, 2, 1, -6, 0, 3, 0, 0, 0, 2, 2, 1, -7, 0, 3, 0, 1, 0, 2, -2, 1, 6, 0, -3, 0, 0, 0, 0, -2, 1, -5, 0, 3, 0, 1, -1, 0, 0, 0, 5, 0, 0, 0, 2, 0, 2, 0, 1, -5, 0, 3, 0, 0, 1, 0, -2, 0, -4, 0, 0, 0, 1, 0, -2, 0, 0, 4, 0, 0, 0, 0, 0, 0, 1, 0, -4, 0, 0, 0, 1, 1, 0, 0, 0, -3, 0, 0, 0, 1, 0, 2, 0, 0, 3, 0, 0, 0, 1, -1, 2, 0, 2, -3, 0, 1, 0, -1, -1, 2, 2, 2, -3, 0, 1, 0, -2, 0, 0, 0, 1, -2, 0, 1, 0, 3, 0, 2, 0, 2, -3, 0, 1, 0, 0, -1, 2, 2, 2, -3, 0, 1, 0, 1, 1, 2, 0, 2, 2, 0, -1, 0, -1, 0, 2, -2, 1, -2, 0, 1, 0, 2, 0, 0, 0, 1, 2, 0, -1, 0, 1, 0, 0, 0, 2, -2, 0, 1, 0, 3, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 1, 2, 2, 0, -1, 0, -1, 0, 0, 0, 2, 1, 0, -1, 0, 1, 0, 0, -4, 0, -1, 0, 0, 0, -2, 0, 2, 2, 2, 1, 0, -1, 0, -1, 0, 2, 4, 2, -2, 0, 1, 0, 2, 0, 0, -4, 0, -1, 0, 0, 0, 1, 1, 2, -2, 2, 1, 0, -1, 0, 1, 0, 2, 2, 1, -1, 0, 1, 0, -2, 0, 2, 4, 2, -1, 0, 1, 0, -1, 0, 4, 0, 2, 1, 0, 0, 0, 1, -1, 0, -2, 0, 1, 0, 0, 0, 2, 0, 2, -2, 1, 1, 0, -1, 0, 2, 0, 2, 2, 2, -1, 0, 0, 0, 1, 0, 0, 2, 1, -1, 0, 0, 0, 0, 0, 4, -2, 2, 1, 0, 0, 0, 3, 0, 2, -2, 2, 1, 0, 0, 0, 1, 0, 2, -2, 0, -1, 0, 0, 0, 0, 1, 2, 0, 1, 1, 0, 0, 0, -1, -1, 0, 2, 1, 1, 0, 0, 0, 0, 0, -2, 0, 1, -1, 0, 0, 0, 0, 0, 2, -1, 2, -1, 0, 0, 0, 0, 1, 0, 2, 0, -1, 0, 0, 0, 1, 0, -2, -2, 0, -1, 0, 0, 0, 0, -1, 2, 0, 1, -1, 0, 0, 0, 1, 1, 0, -2, 1, -1, 0, 0, 0, 1, 0, -2, 2, 0, -1, 0, 0, 0, 2, 0, 0, 2, 0, 1, 0, 0, 0, 0, 0, 2, 4, 2, -1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, -99};
    static final double PREC_IAU_CTIES = 2.0;

    public SwissLib() {
        this(null);
    }

    public SwissLib(SwissData swed) {
        this.swed = swed;
        if (this.swed == null) {
            this.swed = new SwissData();
        }
    }

    public double square_sum(double[] x) {
        return x[0] * x[0] + x[1] * x[1] + x[2] * x[2];
    }

    public double square_sum(double[] x, int offset) {
        return x[offset] * x[offset] + x[1 + offset] * x[1 + offset] + x[2 + offset] * x[2 + offset];
    }

    public double swe_degnorm(double x) {
        if (Double.doubleToLongBits(x) == -4531507609219491683L) {
            x = Double.longBitsToDouble(-4531507609219491682L);
        } else if (Double.doubleToLongBits(x) == -4531404703936197856L) {
            x = Double.longBitsToDouble(-4531404703936197855L);
        } else if (Double.doubleToLongBits(x) == -4532053966826609004L) {
            x = Double.longBitsToDouble(-4532053966826609003L);
        } else if (Double.doubleToLongBits(x) == 4656693294511473960L) {
            x = Double.longBitsToDouble(4656693294511473959L);
        }
        double y = x % 360.0;
        if (Math.abs(y) < 1.0E-13) {
            y = 0.0;
        }
        if (y < 0.0) {
            y += 360.0;
        }
        return y;
    }

    public double swe_radnorm(double x) {
        double y = x % (Math.PI * 2);
        if (Math.abs(y) < 1.0E-13) {
            y = 0.0;
        }
        if (y < 0.0) {
            y += Math.PI * 2;
        }
        return y;
    }

    public double swe_deg_midp(double x1, double x0) {
        double y = this.swe_degnorm((x1 + x0) / 2.0);
        return y;
    }

    public double swe_rad_midp(double x1, double x0) {
        return 0.0174532925199433 * this.swe_deg_midp(x1 * 57.2957795130823, x0 * 57.2957795130823);
    }

    public double swi_mod2PI(double x) {
        double y = x % (Math.PI * 2);
        if (y < 0.0) {
            y += Math.PI * 2;
        }
        return y;
    }

    public double swi_angnorm(double x) {
        if (x < 0.0) {
            return x + Math.PI * 2;
        }
        if (x >= Math.PI * 2) {
            return x - Math.PI * 2;
        }
        return x;
    }

    public void swi_cross_prod(double[] a, int aOffs, double[] b, int bOffs, double[] x, int xOffs) {
        x[0 + xOffs] = a[1 + aOffs] * b[2 + bOffs] - a[2 + aOffs] * b[1 + bOffs];
        x[1 + xOffs] = a[2 + aOffs] * b[0 + bOffs] - a[0 + aOffs] * b[2 + bOffs];
        x[2 + xOffs] = a[0 + aOffs] * b[1 + bOffs] - a[1 + aOffs] * b[0 + bOffs];
    }

    public double swi_echeb(double x, double[] coef, int offs, int ncf) {
        if (Double.doubleToLongBits(coef[0]) == -4629862475185489266L) {
            coef[0] = Double.longBitsToDouble(-4629862475185489267L);
        }
        if (Double.doubleToLongBits(coef[5]) == 4591554683707967254L) {
            coef[5] = Double.longBitsToDouble(4591554683707967255L);
        }
        if (Double.doubleToLongBits(coef[6]) == -4650564622438720972L) {
            coef[6] = Double.longBitsToDouble(-4650564622438720971L);
        }
        if (Double.doubleToLongBits(coef[10]) == 4536761645709362926L) {
            coef[10] = Double.longBitsToDouble(4536761645709362925L);
        }
        double x2 = x * 2.0;
        double br = 0.0;
        double brp2 = 0.0;
        double brpp = 0.0;
        for (int j = ncf - 1; j >= 0; --j) {
            brp2 = brpp;
            brpp = br;
            br = x2 * brpp - brp2 + coef[j + offs];
        }
        return (br - brp2) * 0.5;
    }

    public double swi_edcheb(double x, double[] coef, int offs, int ncf) {
        double x2 = x * 2.0;
        double bf = 0.0;
        double bj = 0.0;
        double xjp2 = 0.0;
        double xjpl = 0.0;
        double bjp2 = 0.0;
        double bjpl = 0.0;
        for (int j = ncf - 1; j >= 1; --j) {
            double dj = j + j;
            double xj = coef[j + offs] * dj + xjp2;
            bj = x2 * bjpl - bjp2 + xj;
            bf = bjp2;
            bjp2 = bjpl;
            bjpl = bj;
            xjp2 = xjpl;
            xjpl = xj;
        }
        return (bj - bf) * 0.5;
    }

    public void swe_cotrans(double[] xpo, int oOffs, double[] xpn, int nOffs, double eps) {
        int i;
        double[] x = new double[6];
        double e = eps * 0.0174532925199433;
        for (i = 0; i <= 1; ++i) {
            x[i] = xpo[i + oOffs];
        }
        x[0] = x[0] * 0.0174532925199433;
        x[1] = x[1] * 0.0174532925199433;
        x[2] = 1.0;
        for (i = 3; i <= 5; ++i) {
            x[i] = 0.0;
        }
        this.swi_polcart(x, x);
        this.swi_coortrf(x, x, e);
        this.swi_cartpol(x, x);
        xpn[nOffs] = x[0] * 57.2957795130823;
        xpn[1 + nOffs] = x[1] * 57.2957795130823;
        xpn[2 + nOffs] = xpo[2 + oOffs];
    }

    public void swe_cotrans_sp(double[] xpo, double[] xpn, double eps) {
        double[] x = new double[6];
        double e = eps * 0.0174532925199433;
        for (int i = 0; i <= 5; ++i) {
            x[i] = xpo[i];
        }
        x[0] = x[0] * 0.0174532925199433;
        x[1] = x[1] * 0.0174532925199433;
        x[2] = 1.0;
        x[3] = x[3] * 0.0174532925199433;
        x[4] = x[4] * 0.0174532925199433;
        this.swi_polcart_sp(x, x);
        this.swi_coortrf(x, x, e);
        this.swi_coortrf(x, 3, x, 3, e);
        this.swi_cartpol_sp(x, xpn);
        xpn[0] = xpn[0] * 57.2957795130823;
        xpn[1] = xpn[1] * 57.2957795130823;
        xpn[2] = xpo[2];
        xpn[3] = xpn[3] * 57.2957795130823;
        xpn[4] = xpn[4] * 57.2957795130823;
        xpn[5] = xpo[5];
    }

    public void swi_coortrf(double[] xpo, double[] xpn, double eps) {
        this.swi_coortrf(xpo, 0, xpn, 0, eps);
    }

    public void swi_coortrf(double[] xpo, int oOffs, double[] xpn, int nOffs, double eps) {
        double[] x = new double[3];
        double sineps = Math.sin(eps);
        double coseps = Math.cos(eps);
        x[0] = xpo[oOffs];
        x[1] = xpo[1 + oOffs] * coseps + xpo[2 + oOffs] * sineps;
        x[2] = -xpo[1 + oOffs] * sineps + xpo[2 + oOffs] * coseps;
        xpn[0 + nOffs] = x[0];
        xpn[1 + nOffs] = x[1];
        xpn[2 + nOffs] = x[2];
    }

    public void swi_coortrf2(double[] xpo, double[] xpn, double sineps, double coseps) {
        this.swi_coortrf2(xpo, 0, xpn, 0, sineps, coseps);
    }

    public void swi_coortrf2(double[] xpo, int oOffs, double[] xpn, int nOffs, double sineps, double coseps) {
        double[] x = new double[]{xpo[0 + oOffs], xpo[1 + oOffs] * coseps + xpo[2 + oOffs] * sineps, -xpo[1 + oOffs] * sineps + xpo[2 + oOffs] * coseps};
        xpn[0 + nOffs] = x[0];
        xpn[1 + nOffs] = x[1];
        xpn[2 + nOffs] = x[2];
    }

    public void swi_cartpol(double[] x, double[] l) {
        this.swi_cartpol(x, 0, l, 0);
    }

    public void swi_cartpol(double[] x, int xOffs, double[] l, int lOffs) {
        double[] ll = new double[3];
        if (x[0 + xOffs] == 0.0 && x[1 + xOffs] == 0.0 && x[2 + xOffs] == 0.0) {
            l[2 + lOffs] = 0.0;
            l[1 + lOffs] = 0.0;
            l[0 + lOffs] = 0.0;
            return;
        }
        double rxy = x[0 + xOffs] * x[0 + xOffs] + x[1 + xOffs] * x[1 + xOffs];
        ll[2] = Math.sqrt(rxy + x[2 + xOffs] * x[2 + xOffs]);
        rxy = Math.sqrt(rxy);
        ll[0] = Math.atan2(x[1 + xOffs], x[0 + xOffs]);
        if (ll[0] < 0.0) {
            ll[0] = ll[0] + Math.PI * 2;
        }
        ll[1] = Math.atan(x[2 + xOffs] / rxy);
        l[0 + lOffs] = ll[0];
        l[1 + lOffs] = ll[1];
        l[2 + lOffs] = ll[2];
    }

    public void swi_polcart(double[] l, double[] x) {
        this.swi_polcart(l, 0, x, 0);
    }

    public void swi_polcart(double[] l, int lOffs, double[] x, int xOffs) {
        double[] xx = new double[3];
        double cosl1 = Math.cos(l[lOffs + 1]);
        xx[0] = l[lOffs + 2] * cosl1 * Math.cos(l[lOffs]);
        xx[1] = l[lOffs + 2] * cosl1 * Math.sin(l[lOffs]);
        xx[2] = l[lOffs + 2] * Math.sin(l[lOffs + 1]);
        x[xOffs] = xx[0];
        x[xOffs + 1] = xx[1];
        x[xOffs + 2] = xx[2];
    }

    public void swi_cartpol_sp(double[] x, double[] l) {
        this.swi_cartpol_sp(x, 0, l, 0);
    }

    public void swi_cartpol_sp(double[] x, int xOffs, double[] l, int lOffs) {
        double[] xx = new double[6];
        double[] ll = new double[6];
        if (x[0 + xOffs] == 0.0 && x[1 + xOffs] == 0.0 && x[2 + xOffs] == 0.0) {
            l[4 + lOffs] = 0.0;
            l[3 + lOffs] = 0.0;
            l[1 + lOffs] = 0.0;
            l[0 + lOffs] = 0.0;
            l[5 + lOffs] = Math.sqrt(this.square_sum(x, 3 + xOffs));
            this.swi_cartpol(x, 3 + xOffs, l, 0 + lOffs);
            l[2 + lOffs] = 0.0;
            return;
        }
        if (x[3 + xOffs] == 0.0 && x[4 + xOffs] == 0.0 && x[5 + xOffs] == 0.0) {
            l[5 + lOffs] = 0.0;
            l[4 + lOffs] = 0.0;
            l[3 + lOffs] = 0.0;
            this.swi_cartpol(x, xOffs, l, lOffs);
            return;
        }
        double rxy = x[0 + xOffs] * x[0 + xOffs] + x[1 + xOffs] * x[1 + xOffs];
        ll[2] = Math.sqrt(rxy + x[2 + xOffs] * x[2 + xOffs]);
        rxy = Math.sqrt(rxy);
        ll[0] = Math.atan2(x[1 + xOffs], x[0 + xOffs]);
        if (ll[0] < 0.0) {
            ll[0] = ll[0] + Math.PI * 2;
        }
        ll[1] = Math.atan(x[2 + xOffs] / rxy);
        double coslon = x[0 + xOffs] / rxy;
        double sinlon = x[1 + xOffs] / rxy;
        double coslat = rxy / ll[2];
        double sinlat = x[2 + xOffs] / ll[2];
        xx[3] = x[3 + xOffs] * coslon + x[4 + xOffs] * sinlon;
        xx[4] = -x[3 + xOffs] * sinlon + x[4 + xOffs] * coslon;
        l[3 + lOffs] = xx[4] / rxy;
        xx[4] = -sinlat * xx[3] + coslat * x[5 + xOffs];
        xx[5] = coslat * xx[3] + sinlat * x[5 + xOffs];
        l[4 + lOffs] = xx[4] / ll[2];
        l[5 + lOffs] = xx[5];
        l[0 + lOffs] = ll[0];
        l[1 + lOffs] = ll[1];
        l[2 + lOffs] = ll[2];
    }

    public void swi_polcart_sp(double[] l, double[] x) {
        this.swi_polcart_sp(l, 0, x, 0);
    }

    public void swi_polcart_sp(double[] l, int lOffs, double[] x, int xOffs) {
        double[] xx = new double[6];
        if (l[3 + lOffs] == 0.0 && l[4 + lOffs] == 0.0 && l[5 + lOffs] == 0.0) {
            x[5 + xOffs] = 0.0;
            x[4 + xOffs] = 0.0;
            x[3 + xOffs] = 0.0;
            this.swi_polcart(l, lOffs, x, xOffs);
            return;
        }
        double coslon = Math.cos(l[0 + lOffs]);
        double sinlon = Math.sin(l[0 + lOffs]);
        double coslat = Math.cos(l[1 + lOffs]);
        double sinlat = Math.sin(l[1 + lOffs]);
        xx[0] = l[2 + lOffs] * coslat * coslon;
        xx[1] = l[2 + lOffs] * coslat * sinlon;
        xx[2] = l[2 + lOffs] * sinlat;
        double rxyz = l[2 + lOffs];
        double rxy = Math.sqrt(xx[0] * xx[0] + xx[1] * xx[1]);
        xx[5] = l[5 + lOffs];
        xx[4] = l[4 + lOffs] * rxyz;
        x[5 + xOffs] = sinlat * xx[5] + coslat * xx[4];
        xx[3] = coslat * xx[5] - sinlat * xx[4];
        xx[4] = l[3 + lOffs] * rxy;
        x[3 + xOffs] = coslon * xx[3] - sinlon * xx[4];
        x[4 + xOffs] = sinlon * xx[3] + coslon * xx[4];
        x[0 + xOffs] = xx[0];
        x[1 + xOffs] = xx[1];
        x[2 + xOffs] = xx[2];
    }

    public double swi_dot_prod_unit(double[] x, double[] y) {
        double dop = x[0] * y[0] + x[1] * y[1] + x[2] * y[2];
        double e1 = Math.sqrt(x[0] * x[0] + x[1] * x[1] + x[2] * x[2]);
        double e2 = Math.sqrt(y[0] * y[0] + y[1] * y[1] + y[2] * y[2]);
        dop /= e1;
        if ((dop /= e2) > 1.0) {
            dop = 1.0;
        }
        if (dop < -1.0) {
            dop = -1.0;
        }
        return dop;
    }

    public double swi_epsiln(double J) {
        double eps;
        double T = (J - 2451545.0) / 36525.0;
        if (Math.abs(T) < 2.0) {
            eps = (((0.001813 * T - 5.9E-4) * T - 46.815) * T + 84381.448) * 0.0174532925199433 / 3600.0;
        } else {
            eps = (((((((((2.45E-10 * (T /= 10.0) + 5.79E-9) * T + 2.787E-7) * T + 7.12E-7) * T - 3.905E-5) * T - 0.0024967) * T - 0.005138) * T + 1.99925) * T - 0.0155) * T - 468.093) * T + 84381.448;
            eps *= 4.848136811095361E-6;
        }
        return eps;
    }

    public int swi_precess(double[] R, double J, int direction) {
        return this.swi_precess(R, 0, J, direction);
    }

    public int swi_precess(double[] R, int rOffs, double J, int direction) {
        int i;
        double B;
        double A;
        double z;
        double[] x = new double[3];
        if (J == 2451545.0) {
            return 0;
        }
        double T = (J - 2451545.0) / 36525.0;
        if (Math.abs(T) <= 2.0) {
            double Z = ((0.017998 * T + 0.30188) * T + 2306.2181) * T * 0.0174532925199433 / 3600.0;
            z = ((0.018203 * T + 1.09468) * T + 2306.2181) * T * 0.0174532925199433 / 3600.0;
            double TH = ((-0.041833 * T - 0.42665) * T + 2004.3109) * T * 0.0174532925199433 / 3600.0;
            double sinth = Math.sin(TH);
            double costh = Math.cos(TH);
            double sinZ = Math.sin(Z);
            double cosZ = Math.cos(Z);
            double sinz = Math.sin(z);
            double cosz = Math.cos(z);
            A = cosZ * costh;
            B = sinZ * costh;
            if (direction < 0) {
                x[0] = (A * cosz - sinZ * sinz) * R[0 + rOffs] - (B * cosz + cosZ * sinz) * R[1 + rOffs] - sinth * cosz * R[2 + rOffs];
                x[1] = (A * sinz + sinZ * cosz) * R[0 + rOffs] - (B * sinz - cosZ * cosz) * R[1 + rOffs] - sinth * sinz * R[2 + rOffs];
                x[2] = cosZ * sinth * R[0 + rOffs] - sinZ * sinth * R[1 + rOffs] + costh * R[2 + rOffs];
            } else {
                x[0] = (A * cosz - sinZ * sinz) * R[0 + rOffs] + (A * sinz + sinZ * cosz) * R[1 + rOffs] + cosZ * sinth * R[2 + rOffs];
                x[1] = -(B * cosz + cosZ * sinz) * R[0 + rOffs] - (B * sinz - cosZ * cosz) * R[1 + rOffs] - sinZ * sinth * R[2 + rOffs];
                x[2] = -sinth * cosz * R[0 + rOffs] - sinth * sinz * R[1 + rOffs] + costh * R[2 + rOffs];
            }
        } else {
            double eps = direction == 1 ? this.swi_epsiln(J) : this.swi_epsiln(2451545.0);
            double sineps = Math.sin(eps);
            double coseps = Math.cos(eps);
            x[0] = R[0 + rOffs];
            z = coseps * R[1 + rOffs] + sineps * R[2 + rOffs];
            x[2] = -sineps * R[1 + rOffs] + coseps * R[2 + rOffs];
            x[1] = z;
            T /= 10.0;
            int pn = 0;
            double pA = pAcof[pn];
            ++pn;
            for (i = 0; i < 9; ++i) {
                pA = pA * T + pAcof[pn];
                ++pn;
            }
            pA *= 4.848136811095361E-6 * T;
            pn = 0;
            double W = nodecof[pn];
            ++pn;
            for (i = 0; i < 10; ++i) {
                W = W * T + nodecof[pn];
                ++pn;
            }
            z = direction == 1 ? W + pA : W;
            B = Math.cos(z);
            A = Math.sin(z);
            z = B * x[0] + A * x[1];
            x[1] = -A * x[0] + B * x[1];
            x[0] = z;
            pn = 0;
            z = inclcof[pn];
            ++pn;
            for (i = 0; i < 10; ++i) {
                z = z * T + inclcof[pn];
                ++pn;
            }
            if (direction == 1) {
                z = -z;
            }
            B = Math.cos(z);
            A = Math.sin(z);
            z = B * x[1] + A * x[2];
            x[2] = -A * x[1] + B * x[2];
            x[1] = z;
            z = direction == 1 ? -W : -W - pA;
            B = Math.cos(z);
            A = Math.sin(z);
            z = B * x[0] + A * x[1];
            x[1] = -A * x[0] + B * x[1];
            x[0] = z;
            eps = direction == 1 ? this.swi_epsiln(2451545.0) : this.swi_epsiln(J);
            sineps = Math.sin(eps);
            coseps = Math.cos(eps);
            z = coseps * x[1] - sineps * x[2];
            x[2] = sineps * x[1] + coseps * x[2];
            x[1] = z;
        }
        for (i = 0; i < 3; ++i) {
            R[i + rOffs] = x[i];
        }
        return 0;
    }

    public int swi_nutation(double J, double[] nutlo) {
        double cv;
        double sv;
        double cu;
        double su;
        int k;
        double[][] ss = new double[5][8];
        double[][] cc = new double[5][8];
        double[] args = new double[5];
        int[] ns = new int[5];
        double T = (J - 2451545.0) / 36525.0;
        double T2 = T * T;
        double OM = -6962890.539 * T + 450160.28 + (0.008 * T + 7.455) * T2;
        OM = this.swe_degnorm(OM / 3600.0) * 0.0174532925199433;
        double MS = 1.29596581224E8 * T + 1287099.804 - (0.012 * T + 0.577) * T2;
        MS = this.swe_degnorm(MS / 3600.0) * 0.0174532925199433;
        double MM = 1.717915922633E9 * T + 485866.733 + (0.064 * T + 31.31) * T2;
        MM = this.swe_degnorm(MM / 3600.0) * 0.0174532925199433;
        double FF = 1.739527263137E9 * T + 335778.877 + (0.011 * T - 13.257) * T2;
        FF = this.swe_degnorm(FF / 3600.0) * 0.0174532925199433;
        double DD = 1.602961601328E9 * T + 1072261.307 + (0.019 * T - 6.891) * T2;
        DD = this.swe_degnorm(DD / 3600.0) * 0.0174532925199433;
        args[0] = MM;
        ns[0] = 3;
        args[1] = MS;
        ns[1] = 2;
        args[2] = FF;
        ns[2] = 4;
        args[3] = DD;
        ns[3] = 4;
        args[4] = OM;
        ns[4] = 2;
        for (k = 0; k <= 4; ++k) {
            double arg = args[k];
            int n = ns[k];
            su = Math.sin(arg);
            cu = Math.cos(arg);
            ss[k][0] = su;
            cc[k][0] = cu;
            sv = 2.0 * su * cu;
            cv = cu * cu - su * su;
            ss[k][1] = sv;
            cc[k][1] = cv;
            for (int i = 2; i < n; ++i) {
                double s = su * cv + cu * sv;
                cv = cu * cv - su * sv;
                ss[k][i] = sv = s;
                cc[k][i] = cv;
            }
        }
        double C = (-0.01742 * T - 17.1996) * ss[4][0];
        double D = (8.9E-4 * T + 9.2025) * cc[4][0];
        int pn = 0;
        while (nt[pn] != -99) {
            boolean k1 = false;
            cv = 0.0;
            sv = 0.0;
            for (int m = 0; m < 5; ++m) {
                int j = nt[pn + m];
                if (j > 100) {
                    j = 0;
                }
                if (j == 0) continue;
                k = j;
                if (j < 0) {
                    k = -k;
                }
                su = ss[m][k - 1];
                if (j < 0) {
                    su = -su;
                }
                cu = cc[m][k - 1];
                if (!k1) {
                    sv = su;
                    cv = cu;
                    k1 = true;
                    continue;
                }
                double sw = su * cv + cu * sv;
                cv = cu * cv - su * sv;
                sv = sw;
            }
            double f = (double)nt[pn + 5] * 1.0E-4;
            if (nt[pn + 6] != 0) {
                f += 1.0E-5 * T * (double)nt[pn + 6];
            }
            double g = (double)nt[pn + 7] * 1.0E-4;
            if (nt[pn + 8] != 0) {
                g += 1.0E-5 * T * (double)nt[pn + 8];
            }
            if (nt[pn] >= 100) {
                f *= 0.1;
                g *= 0.1;
            }
            if (nt[pn] != 102) {
                C += f * sv;
                D += g * cv;
            } else {
                C += f * cv;
                D += g * sv;
            }
            pn += 9;
        }
        nutlo[0] = 0.0174532925199433 * C / 3600.0;
        nutlo[1] = 0.0174532925199433 * D / 3600.0;
        return 0;
    }

    public int swi_cutstr(String s, String cutlist, String[] cpos, int nmax) {
        int n;
        if ((s = s.trim()).indexOf(10) >= 0) {
            s = s.substring(0, s.indexOf(10));
        }
        if (s.indexOf(13) >= 0) {
            s = s.substring(0, s.indexOf(13));
        }
        StringTokenizer tk = new StringTokenizer(s, cutlist, true);
        for (n = 0; tk.hasMoreTokens() && n < 20; ++n) {
            String g = tk.nextToken();
            while (g.endsWith("\\") && tk.hasMoreTokens()) {
                g = g.substring(0, g.length() - 1) + tk.nextToken();
                if (!tk.hasMoreTokens()) continue;
                g = g + tk.nextToken();
            }
            cpos[n] = g;
            if (!tk.hasMoreTokens()) continue;
            tk.nextToken();
        }
        cpos[19] = "";
        while (tk.hasMoreTokens()) {
            cpos[19] = cpos[19] + tk.nextToken();
        }
        if (n < nmax) {
            cpos[n] = null;
        }
        return n;
    }

    public double swe_sidtime0(double tjd, double eps, double nut) {
        double jd = tjd;
        double jd0 = Math.floor(jd);
        double secs = tjd - jd0;
        if (secs < 0.5) {
            jd0 -= 0.5;
            secs += 0.5;
        } else {
            jd0 += 0.5;
            secs -= 0.5;
        }
        double T0 = (jd0 - 2451545.0) / 36525.0;
        double eqeq = 240.0 * nut * Math.cos(eps * 0.0174532925199433);
        double gmst = ((-6.2E-6 * T0 + 0.093104) * T0 + 8640184.812866) * T0 + 24110.54841;
        double msday = 1.0 + ((-1.86E-5 * T0 + 0.186208) * T0 + 8640184.812866) / 3.15576E9;
        gmst = gmst + msday * (secs *= 86400.0) + eqeq;
        gmst -= 86400.0 * Math.floor(gmst / 86400.0);
        return gmst /= 3600.0;
    }

    public double swe_sidtime(double tjd_ut) {
        double[] nutlo = new double[2];
        double tjde = tjd_ut + SweDate.getDeltaT(tjd_ut);
        double eps = this.swi_epsiln(tjde) * 57.2957795130823;
        this.swi_nutation(tjde, nutlo);
        int i = 0;
        while (i < 2) {
            int n = i++;
            nutlo[n] = nutlo[n] * 57.2957795130823;
        }
        double tsid = this.swe_sidtime0(tjd_ut, eps + nutlo[1], nutlo[0]);
        return tsid;
    }

    public String swi_gen_filename(SweDate sd, int ipli) {
        String fname;
        int ncties = 6;
        double jut = 0.0;
        switch (ipli) {
            case 1: {
                fname = "semo";
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                fname = "sepl";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                fname = "seas";
                break;
            }
            default: {
                String iplNr = "00000" + (ipli - 10000);
                iplNr = iplNr.substring(iplNr.length() - 6);
                if (ipli - 10000 <= 99999) {
                    iplNr = iplNr.substring(1);
                }
                String fname2 = "ast" + (ipli - 10000) / 1000 + this.swed.DIR_GLUE + "se" + iplNr + "." + "se1";
                return fname2;
            }
        }
        if (sd.getJulDay() >= 2305447.5) {
            sd.setCalendarType(true, false);
        } else {
            sd.setCalendarType(false, false);
        }
        int year = sd.getYear();
        int sgn = year < 0 ? -1 : 1;
        int icty = year / 100;
        if (sgn < 0 && year % 100 != 0) {
            --icty;
        }
        while (icty % ncties != 0) {
            --icty;
        }
        fname = icty < 0 ? fname + "m" : fname + "_";
        icty = Math.abs(icty);
        fname = fname + (icty < 10 ? "0" : "") + icty + "." + "se1";
        return fname;
    }

    public void swe_split_deg(double ddeg, int roundflag, IntObj ideg, IntObj imin, IntObj isec, DblObj dsecfr, IntObj isgn) {
        double dadd = 0.0;
        isgn.val = 1;
        if (ddeg < 0.0) {
            isgn.val = -1;
            ddeg = -ddeg;
        }
        if ((roundflag & 4) != 0) {
            dadd = 0.5;
        } else if ((roundflag & 2) != 0) {
            dadd = 0.008333333333333333;
        } else if ((roundflag & 1) != 0) {
            dadd = 1.388888888888889E-4;
        }
        if ((roundflag & 0x20) != 0) {
            if ((int)(ddeg + dadd) - (int)ddeg > 0) {
                dadd = 0.0;
            }
        } else if ((roundflag & 0x10) != 0 && ddeg % 30.0 + dadd >= 30.0) {
            dadd = 0.0;
        }
        ddeg += dadd;
        if ((roundflag & 8) != 0) {
            isgn.val = (int)(ddeg / 30.0);
            ddeg %= 30.0;
        }
        ideg.val = (int)ddeg;
        imin.val = (int)((ddeg -= (double)ideg.val) * 60.0);
        isec.val = (int)((ddeg -= (double)imin.val / 60.0) * 3600.0);
        if ((roundflag & 7) == 0) {
            dsecfr.val = ddeg * 3600.0 - (double)isec.val;
        }
    }

    public double swi_kepler(double E, double M, double ecce) {
        double dE = 1.0;
        if (ecce < 0.4) {
            while (dE > 1.0E-12) {
                double E0 = E;
                E = M + ecce * Math.sin(E0);
                dE = Math.abs(E - E0);
            }
        } else {
            while (dE > 1.0E-12) {
                double E0 = E;
                double x = (M + ecce * Math.sin(E0) - E0) / (1.0 - ecce * Math.cos(E0));
                dE = Math.abs(x);
                if (dE < 0.01) {
                    E = E0 + x;
                    continue;
                }
                E = this.swi_mod2PI(E0 + x);
                dE = Math.abs(E - E0);
            }
        }
        return E;
    }

    public void swi_FK4_FK5(double[] xp, double tjd) {
        if (xp[0] == 0.0 && xp[1] == 0.0 && xp[2] == 0.0) {
            return;
        }
        this.swi_cartpol(xp, xp);
        xp[0] = xp[0] + (0.035 + 0.085 * (tjd - 2433282.42345905) / 36524.2198782) / 3600.0 * 15.0 * 0.0174532925199433;
        xp[3] = xp[3] + 1.6924042333443586E-10;
        this.swi_polcart(xp, xp);
    }

    public void swi_FK5_FK4(double[] xp, double tjd) {
        if (xp[0] == 0.0 && xp[1] == 0.0 && xp[2] == 0.0) {
            return;
        }
        this.swi_cartpol(xp, xp);
        xp[0] = xp[0] - (0.035 + 0.085 * (tjd - 2433282.42345905) / 36524.2198782) / 3600.0 * 15.0 * 0.0174532925199433;
        xp[3] = xp[3] - 1.6924042333443586E-10;
        this.swi_polcart(xp, xp);
    }

    public void swi_IERS_FK5(double[] xin, double[] xout, int dir) {
        this.swi_IERS_FK5(xin, 0, xout, 0, dir);
    }

    public void swi_IERS_FK5(double[] xin, int inOff, double[] xout, int outOff, int dir) {
        for (int i = 0; i < 3; ++i) {
            xout[i] = xin[i];
        }
    }

    public int swe_d2l(double x) {
        if (x >= 0.0) {
            return (int)(x + 0.5);
        }
        return -((int)(0.5 - x));
    }

    public double swe_difdeg2n(double p1, double p2) {
        double dif = this.swe_degnorm(p1 - p2);
        if (dif >= 180.0) {
            return dif - 360.0;
        }
        return dif;
    }

    public double swe_difrad2n(double p1, double p2) {
        double dif = this.swe_radnorm(p1 - p2);
        if (dif >= Math.PI) {
            return dif - Math.PI * 2;
        }
        return dif;
    }

    public static synchronized double atof(String src) {
        int idx;
        src = src.trim();
        for (idx = 0; idx < src.length() && (Character.isDigit(src.charAt(idx)) || src.charAt(idx) == '.'); ++idx) {
        }
        String sout = src.substring(0, idx).trim();
        if (sout.length() == 0 || sout.replace('.', ' ').trim().length() == 0) {
            return 0.0;
        }
        return Double.valueOf(sout);
    }

    public static synchronized int atoi(String src) {
        int idx;
        src = src.trim();
        for (idx = 0; idx < src.length() && Character.isDigit(src.charAt(idx)); ++idx) {
        }
        String sout = src.substring(0, idx).trim();
        if (sout.length() == 0 || sout.replace('.', ' ').trim().length() == 0) {
            return 0;
        }
        return Integer.valueOf(sout);
    }
}

