/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import swisseph.Houses;
import swisseph.SMath;
import swisseph.SidData;
import swisseph.SweDate;
import swisseph.SwissData;
import swisseph.SwissEph;
import swisseph.SwissLib;

class SweHouse
implements Serializable {
    static final double MILLIARCSEC = 2.7777777777777776E-7;
    SwissLib sl = null;
    SwissEph sw = null;
    SwissData swed = null;
    static final double VERY_SMALL = 1.0E-10;

    SweHouse() {
        this.sl = new SwissLib();
        this.sw = new SwissEph();
        this.swed = new SwissData();
    }

    SweHouse(SwissLib swissLib, SwissEph swissEph, SwissData swissData) {
        this.sl = swissLib;
        this.sw = swissEph;
        this.swed = swissData;
        if (this.sl == null) {
            this.sl = new SwissLib();
        }
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        if (this.swed == null) {
            this.swed = new SwissData();
        }
    }

    private double sind(double d) {
        return SMath.sin(d * 0.0174532925199433);
    }

    private double cosd(double d) {
        return SMath.cos(d * 0.0174532925199433);
    }

    private double tand(double d) {
        return SMath.tan(d * 0.0174532925199433);
    }

    private double asind(double d) {
        return SMath.asin(d) * 57.2957795130823;
    }

    private double atand(double d) {
        return SMath.atan(d) * 57.2957795130823;
    }

    int swe_houses(double d, int n, double d2, double d3, int n2, double[] dArray, double[] dArray2) {
        return this.swe_houses(d, n, d2, d3, n2, dArray, dArray2, 0);
    }

    int swe_houses(double d, int n, double d2, double d3, int n2, double[] dArray, double[] dArray2, int n3) {
        int n4 = 0;
        double[] dArray3 = new double[2];
        double d4 = d + SweDate.getDeltaT(d);
        SidData sidData = this.swed.sidd;
        int n5 = Character.toUpperCase((char)n2) == 'G' ? 36 : 12;
        if ((n & 0x10000) != 0 && !this.swed.ayana_is_set) {
            this.sw.swe_set_sid_mode(0, 0.0, 0.0);
        }
        double d5 = this.sl.swi_epsiln(d4, 0) * 57.2957795130823;
        this.sl.swi_nutation(d4, 0, dArray3);
        int n6 = 0;
        while (n6 < 2) {
            int n7 = n6++;
            dArray3[n7] = dArray3[n7] * 57.2957795130823;
        }
        double d6 = this.sl.swe_degnorm(this.sl.swe_sidtime0(d, d5 + dArray3[1], dArray3[0]) * 15.0 + d3);
        n4 = (n & 0x10000) != 0 ? ((sidData.sid_mode & 0x100) != 0 ? this.sidereal_houses_ecl_t0(d4, d6, d5 + dArray3[1], dArray3, d2, n2, dArray, dArray2, n3) : ((sidData.sid_mode & 0x200) != 0 ? this.sidereal_houses_ssypl(d4, d6, d5 + dArray3[1], dArray3, d2, n2, dArray, dArray2, n3) : this.sidereal_houses_trad(d4, d6, d5 + dArray3[1], dArray3[0], d2, n2, dArray, dArray2, n3))) : this.swe_houses_armc(d6, d2, d5 + dArray3[1], n2, dArray, dArray2, n3);
        if ((n & 0x2000) != 0) {
            n6 = 1;
            while (n6 <= n5) {
                int n8 = n6++;
                dArray[n8] = dArray[n8] * 0.0174532925199433;
            }
            for (n6 = 0; n6 < 8; ++n6) {
                int n9 = n6 + n3;
                dArray2[n9] = dArray2[n9] * 0.0174532925199433;
            }
        }
        return n4;
    }

    private int sidereal_houses_ecl_t0(double d, double d2, double d3, double[] dArray, double d4, int n, double[] dArray2, double[] dArray3, int n2) {
        int n3;
        int n4 = 0;
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        SidData sidData = this.swed.sidd;
        int n5 = Character.toUpperCase((char)n) == 'G' ? 36 : 12;
        double d5 = this.sl.swi_epsiln(sidData.t0, 0);
        dArray4[4] = 1.0;
        dArray4[0] = 1.0;
        dArray4[5] = 0.0;
        dArray4[3] = 0.0;
        dArray4[2] = 0.0;
        dArray4[1] = 0.0;
        this.sl.swi_coortrf(dArray4, dArray4, -d5);
        this.sl.swi_coortrf(dArray4, 3, dArray4, 3, -d5);
        this.sl.swi_precess(dArray4, sidData.t0, 0, 1);
        this.sl.swi_precess(dArray4, d, 0, -1);
        this.sl.swi_precess(dArray4, 3, sidData.t0, 0, 1);
        this.sl.swi_precess(dArray4, 3, d, 0, -1);
        this.sl.swi_coortrf(dArray4, dArray4, (d3 - dArray[1]) * 0.0174532925199433);
        this.sl.swi_coortrf(dArray4, 3, dArray4, 3, (d3 - dArray[1]) * 0.0174532925199433);
        this.sl.swi_cartpol_sp(dArray4, 0, dArray4, 0);
        dArray4[0] = dArray4[0] + dArray[0] * 0.0174532925199433;
        this.sl.swi_polcart_sp(dArray4, dArray4);
        this.sl.swi_coortrf(dArray4, dArray4, -d3 * 0.0174532925199433);
        this.sl.swi_coortrf(dArray4, 3, dArray4, 3, -d3 * 0.0174532925199433);
        this.sl.swi_cross_prod(dArray4, 0, dArray4, 3, dArray7, 0);
        double d6 = dArray7[0] * dArray7[0] + dArray7[1] * dArray7[1];
        double d7 = d6 + dArray7[2] * dArray7[2];
        double d8 = SMath.sqrt(d7);
        d6 = SMath.sqrt(d6);
        double d9 = SMath.asin(d6 / d8) * 57.2957795130823;
        if (SMath.abs(dArray4[5]) < 1.0E-15) {
            dArray4[5] = 1.0E-15;
        }
        double d10 = dArray4[2] / dArray4[5];
        double d11 = dArray4[5] / SMath.abs(dArray4[5]);
        for (int i = 0; i <= 2; ++i) {
            dArray5[i] = (dArray4[i] - d10 * dArray4[i + 3]) * d11;
        }
        this.sl.swi_cartpol(dArray5, dArray6);
        double d12 = dArray6[0] * 57.2957795130823;
        double d13 = this.sl.swe_degnorm(d2 - d12);
        n4 = this.swe_houses_armc(d13, d4, d9, n, dArray2, dArray3, n2);
        double d14 = SMath.acos(this.sl.swi_dot_prod_unit(dArray4, dArray5)) * 57.2957795130823;
        if (d < sidData.t0) {
            d14 = -d14;
        }
        for (n3 = 1; n3 <= n5; ++n3) {
            dArray2[n3] = this.sl.swe_degnorm(dArray2[n3] - d14 - sidData.ayan_t0);
        }
        for (n3 = 0; n3 <= 8; ++n3) {
            dArray3[n2 + n3] = this.sl.swe_degnorm(dArray3[n2 + n3] - d14 - sidData.ayan_t0);
        }
        return n4;
    }

    private int sidereal_houses_ssypl(double d, double d2, double d3, double[] dArray, double d4, int n, double[] dArray2, double[] dArray3, int n2) {
        int n3;
        int n4 = 0;
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        double[] dArray8 = new double[6];
        SidData sidData = this.swed.sidd;
        int n5 = Character.toUpperCase((char)n) == 'G' ? 36 : 12;
        double d5 = this.sl.swi_epsiln(2451545.0, 0);
        dArray4[4] = 1.0;
        dArray4[0] = 1.0;
        dArray4[5] = 0.0;
        dArray4[3] = 0.0;
        dArray4[2] = 0.0;
        dArray4[1] = 0.0;
        this.sl.swi_coortrf(dArray4, dArray4, -0.027553530354527005);
        this.sl.swi_coortrf(dArray4, 3, dArray4, 3, -0.027553530354527005);
        this.sl.swi_cartpol_sp(dArray4, 0, dArray4, 0);
        dArray4[0] = dArray4[0] + 1.877670046803984;
        this.sl.swi_polcart_sp(dArray4, dArray4);
        this.sl.swi_coortrf(dArray4, dArray4, -d5);
        this.sl.swi_coortrf(dArray4, 3, dArray4, 3, -d5);
        this.sl.swi_precess(dArray4, d, 0, -1);
        this.sl.swi_precess(dArray4, 3, d, 0, -1);
        this.sl.swi_coortrf(dArray4, dArray4, (d3 - dArray[1]) * 0.0174532925199433);
        this.sl.swi_coortrf(dArray4, 3, dArray4, 3, (d3 - dArray[1]) * 0.0174532925199433);
        this.sl.swi_cartpol_sp(dArray4, 0, dArray4, 0);
        dArray4[0] = dArray4[0] + dArray[0] * 0.0174532925199433;
        this.sl.swi_polcart_sp(dArray4, dArray4);
        this.sl.swi_coortrf(dArray4, dArray4, -d3 * 0.0174532925199433);
        this.sl.swi_coortrf(dArray4, 3, dArray4, 3, -d3 * 0.0174532925199433);
        this.sl.swi_cross_prod(dArray4, 0, dArray4, 3, dArray8, 0);
        double d6 = dArray8[0] * dArray8[0] + dArray8[1] * dArray8[1];
        double d7 = d6 + dArray8[2] * dArray8[2];
        double d8 = SMath.sqrt(d7);
        d6 = SMath.sqrt(d6);
        double d9 = SMath.asin(d6 / d8) * 57.2957795130823;
        if (SMath.abs(dArray4[5]) < 1.0E-15) {
            dArray4[5] = 1.0E-15;
        }
        double d10 = dArray4[2] / dArray4[5];
        double d11 = dArray4[5] / SMath.abs(dArray4[5]);
        for (int i = 0; i <= 2; ++i) {
            dArray6[i] = (dArray4[i] - d10 * dArray4[i + 3]) * d11;
        }
        this.sl.swi_cartpol(dArray6, dArray7);
        double d12 = dArray7[0] * 57.2957795130823;
        double d13 = this.sl.swe_degnorm(d2 - d12);
        n4 = this.swe_houses_armc(d13, d4, d9, n, dArray2, dArray3, n2);
        double d14 = SMath.acos(this.sl.swi_dot_prod_unit(dArray4, dArray6)) * 57.2957795130823;
        d14 -= 107.58883387999998;
        dArray5[0] = 1.0;
        dArray5[2] = 0.0;
        dArray5[1] = 0.0;
        if (sidData.t0 != 2451545.0) {
            this.sl.swi_precess(dArray5, sidData.t0, 0, 1);
        }
        this.sl.swi_coortrf(dArray5, dArray5, d5);
        this.sl.swi_cartpol(dArray5, dArray5);
        dArray5[0] = dArray5[0] - 1.877670046803984;
        this.sl.swi_polcart(dArray5, dArray5);
        this.sl.swi_coortrf(dArray5, dArray5, 0.027553530354527005);
        this.sl.swi_cartpol(dArray5, dArray5);
        dArray5[0] = dArray5[0] + 1.8777793895872261;
        double d15 = dArray5[0] * 57.2957795130823;
        for (n3 = 1; n3 <= n5; ++n3) {
            dArray2[n3] = this.sl.swe_degnorm(dArray2[n3] - d14 - sidData.ayan_t0 - d15);
        }
        for (n3 = 0; n3 <= 8; ++n3) {
            dArray3[n2 + n3] = this.sl.swe_degnorm(dArray3[n2 + n3] - d14 - sidData.ayan_t0 - d15);
        }
        return n4;
    }

    private int sidereal_houses_trad(double d, double d2, double d3, double d4, double d5, int n, double[] dArray, double[] dArray2, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n4 = Character.toUpperCase((char)n);
        double d6 = this.sw.swe_get_ayanamsa(d);
        int n7 = n4 == 71 ? 36 : 12;
        if (n4 == 87) {
            n6 = 69;
        }
        n5 = this.swe_houses_armc(d2, d5, d3, n6, dArray, dArray2, n2);
        for (n3 = 1; n3 <= n7; ++n3) {
            dArray[n3] = this.sl.swe_degnorm(dArray[n3] - d6 - d4);
        }
        if (n4 == 87) {
            int n8 = n3;
            dArray[n8] = dArray[n8] - dArray[n3] % 30.0;
        }
        for (n3 = 0; n3 < 8; ++n3) {
            if (n3 == 2) continue;
            dArray2[n2 + n3] = this.sl.swe_degnorm(dArray2[n2 + n3] - d6 - d4);
        }
        return n5;
    }

    int swe_houses_armc(double d, double d2, double d3, int n, double[] dArray, double[] dArray2, int n2) {
        int n3;
        Houses houses = new Houses();
        int n4 = 0;
        int n5 = Character.toUpperCase((char)n) == 'G' ? 36 : 12;
        d = this.sl.swe_degnorm(d);
        n4 = this.CalcH(d, d2, d3, (char)n, 2, houses);
        dArray[0] = 0.0;
        for (n3 = 1; n3 <= n5; ++n3) {
            dArray[n3] = houses.cusp[n3];
        }
        dArray2[n2 + 0] = houses.ac;
        dArray2[n2 + 1] = houses.mc;
        dArray2[n2 + 2] = d;
        dArray2[n2 + 3] = houses.vertex;
        dArray2[n2 + 4] = houses.equasc;
        dArray2[n2 + 5] = houses.coasc1;
        dArray2[n2 + 6] = houses.coasc2;
        dArray2[n2 + 7] = houses.polasc;
        for (n3 = 8; n3 < 10; ++n3) {
            dArray2[n2 + n3] = 0.0;
        }
        return n4;
    }

    private double apc_sector(int n, double d, double d2, double d3) {
        int n2;
        boolean bl = false;
        double d4 = SMath.atan(SMath.tan(d) * SMath.tan(d2) * SMath.cos(d3) / (1.0 + SMath.tan(d) * SMath.tan(d2) * SMath.sin(d3)));
        double d5 = SMath.atan(SMath.sin(d4) / SMath.tan(d));
        if (n < 8) {
            bl = true;
            n2 = n - 1;
        } else {
            n2 = n - 13;
        }
        double d6 = bl ? d4 + d3 + 1.5707963267948966 + (double)n2 * (1.5707963267948966 - d4) / 3.0 : d4 + d3 + 1.5707963267948966 + (double)n2 * (1.5707963267948966 + d4) / 3.0;
        d6 = this.sl.swe_radnorm(d6);
        double d7 = SMath.atan2(SMath.tan(d5) * SMath.tan(d) * SMath.sin(d3) + SMath.sin(d6), SMath.cos(d2) * (SMath.tan(d5) * SMath.tan(d) * SMath.cos(d3) + SMath.cos(d6)) + SMath.sin(d2) * SMath.tan(d) * SMath.sin(d3 - d6));
        d7 = this.sl.swe_degnorm(d7 * 57.2957795130823);
        return d7;
    }

    String swe_house_name(int n) {
        switch (Character.toUpperCase((char)n)) {
            case 'A': {
                return "equal";
            }
            case 'E': {
                return "equal";
            }
            case 'B': {
                return "Alcabitius";
            }
            case 'C': {
                return "Campanus";
            }
            case 'G': {
                return "Gauquelin sectors";
            }
            case 'H': {
                return "horizon/azimut";
            }
            case 'K': {
                return "Koch";
            }
            case 'M': {
                return "Morinus";
            }
            case 'O': {
                return "Porphyry";
            }
            case 'R': {
                return "Regiomontanus";
            }
            case 'T': {
                return "Polich/Page";
            }
            case 'U': {
                return "Krusinski-Pisa-Goelzer";
            }
            case 'V': {
                return "equal/Vehlow";
            }
            case 'W': {
                return "equal/ whole sign";
            }
            case 'X': {
                return "axial rotation system/Meridian houses";
            }
            case 'Y': {
                return "APC houses";
            }
        }
        return "Placidus";
    }

    private int CalcH(double d, double d2, double d3, char c, int n, Houses houses) {
        double d4;
        double d5;
        double d6;
        double d7;
        int n2 = 0;
        double[] dArray = new double[3];
        double d8 = this.cosd(d3);
        double d9 = this.sind(d3);
        double d10 = this.tand(d3);
        if (SMath.abs(SMath.abs(d2) - 90.0) < 1.0E-10) {
            d2 = d2 < 0.0 ? -89.9999999999 : 89.9999999999;
        }
        double d11 = this.tand(d2);
        if (SMath.abs(d - 90.0) > 1.0E-10 && SMath.abs(d - 270.0) > 1.0E-10) {
            d7 = this.tand(d);
            houses.mc = this.atand(d7 / d8);
            if (d > 90.0 && d <= 270.0) {
                houses.mc = this.sl.swe_degnorm(houses.mc + 180.0);
            }
        } else {
            houses.mc = SMath.abs(d - 90.0) <= 1.0E-10 ? 90.0 : 270.0;
        }
        houses.mc = this.sl.swe_degnorm(houses.mc);
        houses.cusp[1] = houses.ac = this.Asc1(d + 90.0, d2, d9, d8);
        houses.cusp[10] = houses.mc;
        c = Character.toUpperCase(c);
        block0 : switch (c) {
            case 'A': 
            case 'E': {
                double d12 = this.sl.swe_difdeg2n(houses.ac, houses.mc);
                if (d12 < 0.0) {
                    houses.cusp[1] = houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                }
                for (int i = 2; i <= 12; ++i) {
                    houses.cusp[i] = this.sl.swe_degnorm(houses.cusp[1] + (double)((i - 1) * 30));
                }
                break;
            }
            case 'C': 
            case 'H': {
                int n3;
                double d13;
                double d14;
                double d15;
                if (c == 'H') {
                    if (SMath.abs(SMath.abs(d2 = d2 > 0.0 ? 90.0 - d2 : -90.0 - d2) - 90.0) < 1.0E-10) {
                        d2 = d2 < 0.0 ? -89.9999999999 : 89.9999999999;
                    }
                    d = this.sl.swe_degnorm(d + 180.0);
                }
                double d16 = this.asind(this.sind(d2) / 2.0);
                double d17 = this.asind(SMath.sqrt(3.0) / 2.0 * this.sind(d2));
                double d18 = this.cosd(d2);
                if (SMath.abs(d18) == 0.0) {
                    if (d2 > 0.0) {
                        d15 = 90.0;
                        d14 = 90.0;
                    } else {
                        d15 = 270.0;
                        d14 = 270.0;
                    }
                } else {
                    d14 = this.atand(SMath.sqrt(3.0) / d18);
                    d15 = this.atand(1.0 / SMath.sqrt(3.0) / d18);
                }
                houses.cusp[11] = this.Asc1(d + 90.0 - d14, d16, d9, d8);
                houses.cusp[12] = this.Asc1(d + 90.0 - d15, d17, d9, d8);
                if (c == 'H') {
                    houses.cusp[1] = this.Asc1(d + 90.0, d2, d9, d8);
                }
                houses.cusp[2] = this.Asc1(d + 90.0 + d15, d17, d9, d8);
                houses.cusp[3] = this.Asc1(d + 90.0 + d14, d16, d9, d8);
                if (SMath.abs(d2) >= 90.0 - d3 && (d13 = this.sl.swe_difdeg2n(houses.ac, houses.mc)) < 0.0) {
                    houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                    houses.mc = this.sl.swe_degnorm(houses.mc + 180.0);
                    for (n3 = 1; n3 <= 12; ++n3) {
                        houses.cusp[n3] = this.sl.swe_degnorm(houses.cusp[n3] + 180.0);
                    }
                }
                if (c != 'H') break;
                for (n3 = 1; n3 <= 3; ++n3) {
                    houses.cusp[n3] = this.sl.swe_degnorm(houses.cusp[n3] + 180.0);
                }
                for (n3 = 11; n3 <= 12; ++n3) {
                    houses.cusp[n3] = this.sl.swe_degnorm(houses.cusp[n3] + 180.0);
                }
                d2 = d2 > 0.0 ? 90.0 - d2 : -90.0 - d2;
                d = this.sl.swe_degnorm(d + 180.0);
                d13 = this.sl.swe_difdeg2n(houses.ac, houses.mc);
                if (!(d13 < 0.0)) break;
                houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                break;
            }
            case 'K': {
                if (SMath.abs(d2) >= 90.0 - d3) {
                    n2 = -1;
                    this.makePorphyry(houses);
                    break;
                }
                double d19 = this.sind(houses.mc) * d9 / this.cosd(d2);
                if (d19 > 1.0) {
                    d19 = 1.0;
                }
                if (d19 < -1.0) {
                    d19 = -1.0;
                }
                double d20 = SMath.sqrt(1.0 - d19 * d19);
                double d21 = this.atand(d11 / d20);
                double d22 = this.asind(this.sind(d21) * d19) / 3.0;
                houses.cusp[11] = this.Asc1(d + 30.0 - 2.0 * d22, d2, d9, d8);
                houses.cusp[12] = this.Asc1(d + 60.0 - d22, d2, d9, d8);
                houses.cusp[2] = this.Asc1(d + 120.0 + d22, d2, d9, d8);
                houses.cusp[3] = this.Asc1(d + 150.0 + 2.0 * d22, d2, d9, d8);
                break;
            }
            case 'O': {
                this.makePorphyry(houses);
                break;
            }
            case 'R': {
                double d23;
                double d24 = this.atand(d11 * 0.5);
                double d25 = this.atand(d11 * this.cosd(30.0));
                houses.cusp[11] = this.Asc1(30.0 + d, d24, d9, d8);
                houses.cusp[12] = this.Asc1(60.0 + d, d25, d9, d8);
                houses.cusp[2] = this.Asc1(120.0 + d, d25, d9, d8);
                houses.cusp[3] = this.Asc1(150.0 + d, d24, d9, d8);
                if (!(SMath.abs(d2) >= 90.0 - d3) || !((d23 = this.sl.swe_difdeg2n(houses.ac, houses.mc)) < 0.0)) break;
                houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                houses.mc = this.sl.swe_degnorm(houses.mc + 180.0);
                for (int i = 1; i <= 12; ++i) {
                    houses.cusp[i] = this.sl.swe_degnorm(houses.cusp[i] + 180.0);
                }
                break;
            }
            case 'T': {
                double d26;
                double d27 = this.atand(d11 / 3.0);
                double d28 = this.atand(d11 * 2.0 / 3.0);
                houses.cusp[11] = this.Asc1(30.0 + d, d27, d9, d8);
                houses.cusp[12] = this.Asc1(60.0 + d, d28, d9, d8);
                houses.cusp[2] = this.Asc1(120.0 + d, d28, d9, d8);
                houses.cusp[3] = this.Asc1(150.0 + d, d27, d9, d8);
                if (!(SMath.abs(d2) >= 90.0 - d3) || !((d26 = this.sl.swe_difdeg2n(houses.ac, houses.mc)) < 0.0)) break;
                houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                houses.mc = this.sl.swe_degnorm(houses.mc + 180.0);
                for (int i = 1; i <= 12; ++i) {
                    houses.cusp[i] = this.sl.swe_degnorm(houses.cusp[i] + 180.0);
                }
                break;
            }
            case 'V': {
                double d29 = this.sl.swe_difdeg2n(houses.ac, houses.mc);
                if (d29 < 0.0) {
                    houses.cusp[1] = houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                }
                houses.cusp[1] = this.sl.swe_degnorm(houses.ac - 15.0);
                for (int i = 2; i <= 12; ++i) {
                    houses.cusp[i] = this.sl.swe_degnorm(houses.cusp[1] + (double)((i - 1) * 30));
                }
                break;
            }
            case 'W': {
                double d30 = this.sl.swe_difdeg2n(houses.ac, houses.mc);
                if (d30 < 0.0) {
                    houses.cusp[1] = houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                }
                houses.cusp[1] = houses.ac - houses.ac % 30.0;
                for (int i = 2; i <= 12; ++i) {
                    houses.cusp[i] = this.sl.swe_degnorm(houses.cusp[1] + (double)((i - 1) * 30));
                }
                break;
            }
            case 'X': {
                double d31 = d;
                for (int i = 1; i <= 12; ++i) {
                    int n4 = i + 10;
                    if (n4 > 12) {
                        n4 -= 12;
                    }
                    if (SMath.abs((d31 = this.sl.swe_degnorm(d31 + 30.0)) - 90.0) > 1.0E-10 && SMath.abs(d31 - 270.0) > 1.0E-10) {
                        d7 = this.tand(d31);
                        houses.cusp[n4] = this.atand(d7 / d8);
                        if (d31 > 90.0 && d31 <= 270.0) {
                            houses.cusp[n4] = this.sl.swe_degnorm(houses.cusp[n4] + 180.0);
                        }
                    } else {
                        houses.cusp[n4] = SMath.abs(d31 - 90.0) <= 1.0E-10 ? 90.0 : 270.0;
                    }
                    houses.cusp[n4] = this.sl.swe_degnorm(houses.cusp[n4]);
                }
                double d32 = this.sl.swe_difdeg2n(houses.ac, houses.mc);
                if (!(d32 < 0.0)) break;
                houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                break;
            }
            case 'M': {
                double d33 = d;
                double[] dArray2 = new double[3];
                for (int i = 1; i <= 12; ++i) {
                    int n5 = i + 10;
                    if (n5 > 12) {
                        n5 -= 12;
                    }
                    dArray2[0] = d33 = this.sl.swe_degnorm(d33 + 30.0);
                    dArray2[1] = 0.0;
                    this.sl.swe_cotrans(dArray2, 0, dArray2, 0, d3);
                    houses.cusp[n5] = dArray2[0];
                }
                double d34 = this.sl.swe_difdeg2n(houses.ac, houses.mc);
                if (!(d34 < 0.0)) break;
                houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                break;
            }
            case 'B': {
                double d35 = this.sl.swe_difdeg2n(houses.ac, houses.mc);
                if (d35 < 0.0) {
                    houses.cusp[1] = houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                    d35 = this.sl.swe_difdeg2n(houses.ac, houses.mc);
                }
                double d36 = this.asind(this.sind(houses.ac) * d9);
                double d37 = -d11 * this.tand(d36);
                double d38 = SMath.acos(d37) * 57.2957795130823;
                double d39 = 180.0 - d38;
                double d40 = d38 / 3.0;
                double d41 = d39 / 3.0;
                double d42 = this.sl.swe_degnorm(d + d40);
                houses.cusp[11] = this.Asc1(d42, 0.0, d9, d8);
                d42 = this.sl.swe_degnorm(d + 2.0 * d40);
                houses.cusp[12] = this.Asc1(d42, 0.0, d9, d8);
                d42 = this.sl.swe_degnorm(d + 180.0 - 2.0 * d41);
                houses.cusp[2] = this.Asc1(d42, 0.0, d9, d8);
                d42 = this.sl.swe_degnorm(d + 180.0 - d41);
                houses.cusp[3] = this.Asc1(d42, 0.0, d9, d8);
                break;
            }
            case 'G': {
                double d43;
                double d44;
                int n6;
                int n7;
                int n8;
                for (n8 = 1; n8 <= 36; ++n8) {
                    houses.cusp[n8] = 0.0;
                }
                if (SMath.abs(d2) >= 90.0 - d3) {
                    n2 = -1;
                    this.makePorphyry(houses);
                }
                double d45 = this.asind(this.tand(d2) * d10);
                for (n7 = 2; n7 <= 9; ++n7) {
                    n6 = 10 - n7;
                    d44 = this.atand(this.sind(d45 * (double)n6 / 9.0) / d10);
                    d43 = this.sl.swe_degnorm((double)(10 * n6) + d);
                    d7 = this.tand(this.asind(d9 * this.sind(this.Asc1(d43, d44, d9, d8))));
                    if (SMath.abs(d7) < 1.0E-10) {
                        houses.cusp[n7] = d43;
                    } else {
                        d6 = this.atand(this.sind(this.asind(d11 * d7) * (double)n6 / 9.0) / d7);
                        houses.cusp[n7] = this.Asc1(d43, d6, d9, d8);
                        for (n8 = 1; n8 <= n; ++n8) {
                            d7 = this.tand(this.asind(d9 * this.sind(houses.cusp[n7])));
                            if (SMath.abs(d7) < 1.0E-10) {
                                houses.cusp[n7] = d43;
                                break;
                            }
                            d6 = this.atand(this.sind(this.asind(d11 * d7) * (double)n6 / 9.0) / d7);
                            houses.cusp[n7] = this.Asc1(d43, d6, d9, d8);
                        }
                    }
                    houses.cusp[n7 + 18] = this.sl.swe_degnorm(houses.cusp[n7] + 180.0);
                }
                for (n7 = 29; n7 <= 36; ++n7) {
                    n6 = n7 - 28;
                    d44 = this.atand(this.sind(d45 * (double)n6 / 9.0) / d10);
                    d43 = this.sl.swe_degnorm((double)(180 - n6 * 90 / 9) + d);
                    d7 = this.tand(this.asind(d9 * this.sind(this.Asc1(d43, d44, d9, d8))));
                    if (SMath.abs(d7) < 1.0E-10) {
                        houses.cusp[n7] = d43;
                    } else {
                        d6 = this.atand(this.sind(this.asind(d11 * d7) * (double)n6 / 9.0) / d7);
                        houses.cusp[n7] = this.Asc1(d43, d6, d9, d8);
                        for (n8 = 1; n8 <= n; ++n8) {
                            d7 = this.tand(this.asind(d9 * this.sind(houses.cusp[n7])));
                            if (SMath.abs(d7) < 1.0E-10) {
                                houses.cusp[n7] = d43;
                                break;
                            }
                            d6 = this.atand(this.sind(this.asind(d11 * d7) * (double)n6 / 9.0) / d7);
                            houses.cusp[n7] = this.Asc1(d43, d6, d9, d8);
                        }
                    }
                    houses.cusp[n7 - 18] = this.sl.swe_degnorm(houses.cusp[n7] + 180.0);
                }
                houses.cusp[1] = houses.ac;
                houses.cusp[10] = houses.mc;
                houses.cusp[19] = this.sl.swe_degnorm(houses.ac + 180.0);
                houses.cusp[28] = this.sl.swe_degnorm(houses.mc + 180.0);
                break;
            }
            case 'U': {
                double d46 = this.sl.swe_difdeg2n(houses.ac, houses.mc);
                if (d46 < 0.0) {
                    houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                }
                dArray[0] = houses.ac;
                dArray[1] = 0.0;
                dArray[2] = 1.0;
                this.sl.swe_cotrans(dArray, dArray, -d3);
                dArray[0] = dArray[0] - (d - 90.0);
                this.sl.swe_cotrans(dArray, dArray, -(90.0 - d2));
                double d47 = dArray[0];
                dArray[0] = dArray[0] - dArray[0];
                this.sl.swe_cotrans(dArray, dArray, -90.0);
                for (int i = 0; i < 6; ++i) {
                    dArray[0] = 30.0 * (double)i;
                    dArray[1] = 0.0;
                    this.sl.swe_cotrans(dArray, dArray, 90.0);
                    dArray[0] = dArray[0] + d47;
                    this.sl.swe_cotrans(dArray, dArray, 90.0 - d2);
                    dArray[0] = this.sl.swe_degnorm(dArray[0] + (d - 90.0));
                    houses.cusp[i + 1] = this.atand(this.tand(dArray[0]) / this.cosd(d3));
                    if (dArray[0] > 90.0 && dArray[0] <= 270.0) {
                        houses.cusp[i + 1] = this.sl.swe_degnorm(houses.cusp[i + 1] + 180.0);
                    }
                    houses.cusp[i + 1] = this.sl.swe_degnorm(houses.cusp[i + 1]);
                    houses.cusp[i + 7] = this.sl.swe_degnorm(houses.cusp[i + 1] + 180.0);
                }
                break;
            }
            case 'Y': {
                double d48;
                int n9;
                for (n9 = 1; n9 <= 12; ++n9) {
                    houses.cusp[n9] = this.apc_sector(n9, d2 * 0.0174532925199433, d3 * 0.0174532925199433, d * 0.0174532925199433);
                }
                houses.ac = houses.cusp[1];
                houses.mc = houses.cusp[10];
                if (!(SMath.abs(d2) >= 90.0 - d3) || !((d48 = this.sl.swe_difdeg2n(houses.ac, houses.mc)) < 0.0)) break;
                houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
                houses.mc = this.sl.swe_degnorm(houses.mc + 180.0);
                for (n9 = 1; n9 <= 12; ++n9) {
                    houses.cusp[n9] = this.sl.swe_degnorm(houses.cusp[n9] + 180.0);
                }
                break;
            }
            default: {
                int n10;
                if (c != 'P') {
                    System.err.println("swe_houses: make Placidus, unknown key " + c);
                }
                if (SMath.abs(d2) >= 90.0 - d3) {
                    n2 = -1;
                    this.makePorphyry(houses);
                    break;
                }
                double d49 = this.asind(this.tand(d2) * d10);
                double d50 = this.atand(this.sind(d49 / 3.0) / d10);
                double d51 = this.atand(this.sind(d49 * 2.0 / 3.0) / d10);
                double d52 = this.sl.swe_degnorm(30.0 + d);
                d7 = this.tand(this.asind(d9 * this.sind(this.Asc1(d52, d50, d9, d8))));
                if (SMath.abs(d7) < 1.0E-10) {
                    houses.cusp[11] = d52;
                } else {
                    d6 = this.atand(this.sind(this.asind(d11 * d7) / 3.0) / d7);
                    houses.cusp[11] = this.Asc1(d52, d6, d9, d8);
                    for (n10 = 1; n10 <= n; ++n10) {
                        d7 = this.tand(this.asind(d9 * this.sind(houses.cusp[11])));
                        if (SMath.abs(d7) < 1.0E-10) {
                            houses.cusp[11] = d52;
                            break;
                        }
                        d6 = this.atand(this.sind(this.asind(d11 * d7) / 3.0) / d7);
                        houses.cusp[11] = this.Asc1(d52, d6, d9, d8);
                    }
                }
                d52 = this.sl.swe_degnorm(60.0 + d);
                d7 = this.tand(this.asind(d9 * this.sind(this.Asc1(d52, d51, d9, d8))));
                if (SMath.abs(d7) < 1.0E-10) {
                    houses.cusp[12] = d52;
                } else {
                    d6 = this.atand(this.sind(this.asind(d11 * d7) / 1.5) / d7);
                    houses.cusp[12] = this.Asc1(d52, d6, d9, d8);
                    for (n10 = 1; n10 <= n; ++n10) {
                        d7 = this.tand(this.asind(d9 * this.sind(houses.cusp[12])));
                        if (SMath.abs(d7) < 1.0E-10) {
                            houses.cusp[12] = d52;
                            break;
                        }
                        d6 = this.atand(this.sind(this.asind(d11 * d7) / 1.5) / d7);
                        houses.cusp[12] = this.Asc1(d52, d6, d9, d8);
                    }
                }
                d52 = this.sl.swe_degnorm(120.0 + d);
                d7 = this.tand(this.asind(d9 * this.sind(this.Asc1(d52, d51, d9, d8))));
                if (SMath.abs(d7) < 1.0E-10) {
                    houses.cusp[2] = d52;
                } else {
                    d6 = this.atand(this.sind(this.asind(d11 * d7) / 1.5) / d7);
                    houses.cusp[2] = this.Asc1(d52, d6, d9, d8);
                    for (n10 = 1; n10 <= n; ++n10) {
                        d7 = this.tand(this.asind(d9 * this.sind(houses.cusp[2])));
                        if (SMath.abs(d7) < 1.0E-10) {
                            houses.cusp[2] = d52;
                            break;
                        }
                        d6 = this.atand(this.sind(this.asind(d11 * d7) / 1.5) / d7);
                        houses.cusp[2] = this.Asc1(d52, d6, d9, d8);
                    }
                }
                d52 = this.sl.swe_degnorm(150.0 + d);
                d7 = this.tand(this.asind(d9 * this.sind(this.Asc1(d52, d50, d9, d8))));
                if (SMath.abs(d7) < 1.0E-10) {
                    houses.cusp[3] = d52;
                    break;
                }
                d6 = this.atand(this.sind(this.asind(d11 * d7) / 3.0) / d7);
                houses.cusp[3] = this.Asc1(d52, d6, d9, d8);
                for (n10 = 1; n10 <= n; ++n10) {
                    d7 = this.tand(this.asind(d9 * this.sind(houses.cusp[3])));
                    if (SMath.abs(d7) < 1.0E-10) {
                        houses.cusp[3] = d52;
                        break block0;
                    }
                    d6 = this.atand(this.sind(this.asind(d11 * d7) / 3.0) / d7);
                    houses.cusp[3] = this.Asc1(d52, d6, d9, d8);
                }
            }
        }
        if (c != 'G' && c != 'Y') {
            houses.cusp[4] = this.sl.swe_degnorm(houses.cusp[10] + 180.0);
            houses.cusp[5] = this.sl.swe_degnorm(houses.cusp[11] + 180.0);
            houses.cusp[6] = this.sl.swe_degnorm(houses.cusp[12] + 180.0);
            houses.cusp[7] = this.sl.swe_degnorm(houses.cusp[1] + 180.0);
            houses.cusp[8] = this.sl.swe_degnorm(houses.cusp[2] + 180.0);
            houses.cusp[9] = this.sl.swe_degnorm(houses.cusp[3] + 180.0);
        }
        d6 = d2 >= 0.0 ? 90.0 - d2 : -90.0 - d2;
        houses.vertex = this.Asc1(d - 90.0, d6, d9, d8);
        if (SMath.abs(d2) <= d3 && (d5 = this.sl.swe_difdeg2n(houses.vertex, houses.mc)) > 0.0) {
            houses.vertex = this.sl.swe_degnorm(houses.vertex + 180.0);
        }
        if (SMath.abs((d4 = this.sl.swe_degnorm(d + 90.0)) - 90.0) > 1.0E-10 && SMath.abs(d4 - 270.0) > 1.0E-10) {
            d7 = this.tand(d4);
            houses.equasc = this.atand(d7 / d8);
            if (d4 > 90.0 && d4 <= 270.0) {
                houses.equasc = this.sl.swe_degnorm(houses.equasc + 180.0);
            }
        } else {
            houses.equasc = SMath.abs(d4 - 90.0) <= 1.0E-10 ? 90.0 : 270.0;
        }
        houses.equasc = this.sl.swe_degnorm(houses.equasc);
        houses.coasc1 = this.sl.swe_degnorm(this.Asc1(d - 90.0, d2, d9, d8) + 180.0);
        houses.coasc2 = d2 >= 0.0 ? this.Asc1(d + 90.0, 90.0 - d2, d9, d8) : this.Asc1(d + 90.0, -90.0 - d2, d9, d8);
        houses.polasc = this.Asc1(d - 90.0, d2, d9, d8);
        return n2;
    }

    private void makePorphyry(Houses houses) {
        double d = this.sl.swe_difdeg2n(houses.ac, houses.mc);
        if (d < 0.0) {
            houses.cusp[1] = houses.ac = this.sl.swe_degnorm(houses.ac + 180.0);
            d = this.sl.swe_difdeg2n(houses.ac, houses.mc);
        }
        houses.cusp[2] = this.sl.swe_degnorm(houses.ac + (180.0 - d) / 3.0);
        houses.cusp[3] = this.sl.swe_degnorm(houses.ac + (180.0 - d) / 3.0 * 2.0);
        houses.cusp[11] = this.sl.swe_degnorm(houses.mc + d / 3.0);
        houses.cusp[12] = this.sl.swe_degnorm(houses.mc + d / 3.0 * 2.0);
    }

    private double Asc1(double d, double d2, double d3, double d4) {
        int n = (int)((d = this.sl.swe_degnorm(d)) / 90.0 + 1.0);
        double d5 = n == 1 ? this.Asc2(d, d2, d3, d4) : (n == 2 ? 180.0 - this.Asc2(180.0 - d, -d2, d3, d4) : (n == 3 ? 180.0 + this.Asc2(d - 180.0, -d2, d3, d4) : 360.0 - this.Asc2(360.0 - d, d2, d3, d4)));
        if (SMath.abs((d5 = this.sl.swe_degnorm(d5)) - 90.0) < 1.0E-10) {
            d5 = 90.0;
        }
        if (SMath.abs(d5 - 180.0) < 1.0E-10) {
            d5 = 180.0;
        }
        if (SMath.abs(d5 - 270.0) < 1.0E-10) {
            d5 = 270.0;
        }
        if (SMath.abs(d5 - 360.0) < 1.0E-10) {
            d5 = 0.0;
        }
        return d5;
    }

    private double Asc2(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = -this.tand(d2) * d3 + d4 * this.cosd(d);
        if (SMath.abs(d6) < 1.0E-10) {
            d6 = 0.0;
        }
        if (SMath.abs(d5 = this.sind(d)) < 1.0E-10) {
            d5 = 0.0;
        }
        d6 = d5 == 0.0 ? (d6 < 0.0 ? -1.0E-10 : 1.0E-10) : (d6 == 0.0 ? (d5 < 0.0 ? -90.0 : 90.0) : this.atand(d5 / d6));
        if (d6 < 0.0) {
            d6 = 180.0 + d6;
        }
        return d6;
    }

    double swe_house_pos(double d, double d2, double d3, int n, double[] dArray, StringBuffer stringBuffer) {
        double d4;
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double d5 = this.sind(d3);
        double d6 = this.cosd(d3);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (stringBuffer != null) {
            stringBuffer.setLength(0);
        }
        n = Character.toUpperCase((char)n);
        dArray3[0] = dArray[0];
        dArray3[1] = dArray[1];
        dArray3[2] = 1.0;
        this.sl.swe_cotrans(dArray, 0, dArray3, 0, -d3);
        double d7 = dArray3[0];
        double d8 = dArray3[1];
        double d9 = this.sl.swe_degnorm(d7 - d);
        double d10 = this.sl.swe_degnorm(d9 + 180.0);
        if (d9 >= 180.0) {
            d9 -= 360.0;
        }
        if (d10 >= 180.0) {
            d10 -= 360.0;
        }
        switch (n) {
            case 65: 
            case 69: 
            case 86: 
            case 87: {
                double d11 = this.Asc1(this.sl.swe_degnorm(d + 90.0), d2, d5, d6);
                double d12 = this.atand(this.sind(d) * this.tand(d3));
                if (d2 >= 0.0 && 90.0 - d2 + d12 < 0.0) {
                    d11 = this.sl.swe_degnorm(d11 + 180.0);
                }
                if (d2 < 0.0 && -90.0 - d2 + d12 > 0.0) {
                    d11 = this.sl.swe_degnorm(d11 + 180.0);
                }
                dArray2[0] = this.sl.swe_degnorm(dArray[0] - d11);
                if (n == 86) {
                    dArray2[0] = this.sl.swe_degnorm(dArray2[0] + 15.0);
                }
                if (n == 87) {
                    dArray2[0] = this.sl.swe_degnorm(dArray2[0] + d11 % 30.0);
                }
                dArray2[0] = this.sl.swe_degnorm(dArray2[0] + 2.7777777777777776E-7);
                d4 = dArray2[0] / 30.0 + 1.0;
                break;
            }
            case 66: 
            case 79: {
                double d13;
                double d14 = this.Asc1(this.sl.swe_degnorm(d + 90.0), d2, d5, d6);
                double d15 = this.atand(this.sind(d) * this.tand(d3));
                if (SMath.abs(d - 90.0) > 1.0E-10 && SMath.abs(d - 270.0) > 1.0E-10) {
                    double d16 = this.tand(d);
                    d13 = this.sl.swe_degnorm(this.atand(d16 / d6));
                    if (d > 90.0 && d <= 270.0) {
                        d13 = this.sl.swe_degnorm(d13 + 180.0);
                    }
                } else {
                    d13 = SMath.abs(d - 90.0) <= 1.0E-10 ? 90.0 : 270.0;
                }
                if (d2 >= 0.0 && 90.0 - d2 + d15 < 0.0) {
                    d14 = this.sl.swe_degnorm(d14 + 180.0);
                }
                if (d2 < 0.0 && -90.0 - d2 + d15 > 0.0) {
                    d14 = this.sl.swe_degnorm(d14 + 180.0);
                }
                if (n == 79) {
                    dArray2[0] = this.sl.swe_degnorm(dArray[0] - d14);
                    dArray2[0] = this.sl.swe_degnorm(dArray2[0] + 2.7777777777777776E-7);
                    if (dArray2[0] < 180.0) {
                        d4 = 1.0;
                    } else {
                        d4 = 7.0;
                        dArray2[0] = dArray2[0] - 180.0;
                    }
                    double d17 = this.sl.swe_difdeg2n(d14, d13);
                    if (dArray2[0] < 180.0 - d17) {
                        d4 += dArray2[0] * 3.0 / (180.0 - d17);
                        break;
                    }
                    d4 += 3.0 + (dArray2[0] - 180.0 + d17) * 3.0 / d17;
                    break;
                }
                double d18 = this.asind(this.sind(d14) * d5);
                double d19 = this.tand(d2);
                double d20 = -d19 * this.tand(d18);
                double d21 = SMath.acos(d20) * 57.2957795130823;
                double d22 = 180.0 - d21;
                d4 = d9 > 0.0 ? (d9 < d21 ? d9 * 90.0 / d21 : 90.0 + (d9 - d21) * 90.0 / d22) : (d9 > -d22 ? 360.0 + d9 * 90.0 / d22 : 270.0 + (d9 + d22) * 90.0 / d21);
                d4 = this.sl.swe_degnorm(d4 - 90.0) / 30.0 + 1.0;
                if (!(d4 >= 13.0)) break;
                d4 -= 12.0;
                break;
            }
            case 88: {
                d4 = this.sl.swe_degnorm(d9 - 90.0) / 30.0 + 1.0;
                break;
            }
            case 77: {
                double d23 = dArray[0];
                if (SMath.abs(d23 - 90.0) > 1.0E-10 && SMath.abs(d23 - 270.0) > 1.0E-10) {
                    double d24 = this.tand(d23);
                    d4 = this.atand(d24 / d6);
                    if (d23 > 90.0 && d23 <= 270.0) {
                        d4 = this.sl.swe_degnorm(d4 + 180.0);
                    }
                } else {
                    d4 = SMath.abs(d23 - 90.0) <= 1.0E-10 ? 90.0 : 270.0;
                }
                d4 = this.sl.swe_degnorm(d4 - d - 90.0);
                d4 = d4 / 30.0 + 1.0;
                break;
            }
            case 75: {
                double d25;
                double d26;
                double d27 = this.atand(this.sind(d) * this.tand(d3));
                bl2 = false;
                bl3 = false;
                if (90.0 - d2 < d8 || -90.0 - d2 > d8) {
                    d26 = 90.0;
                    bl3 = true;
                } else if (d2 - 90.0 > d8 || d2 + 90.0 < d8) {
                    d26 = -90.0;
                    bl3 = true;
                } else {
                    d26 = this.asind(this.tand(d2) * this.tand(d8));
                }
                double d28 = this.tand(d3) * this.tand(d2) * this.sind(d);
                if (SMath.abs(d28) > 1.0) {
                    d28 = d28 > 1.0 ? 1.0 : -1.0;
                    bl3 = true;
                }
                if ((d25 = 90.0 + (d28 = this.asind(d28))) == 0.0) {
                    bl2 = true;
                }
                if (SMath.abs(d25) > 0.0) {
                    if (d9 >= 0.0) {
                        double d29 = (d9 - d26 + d28) / d25;
                        dArray2[0] = this.sl.swe_degnorm((d29 - 1.0) * 90.0);
                        dArray2[0] = this.sl.swe_degnorm(dArray2[0] + 2.7777777777777776E-7);
                        if (d29 > 2.0 || d29 < 0.0) {
                            bl2 = true;
                        }
                    } else {
                        double d30 = (d9 + 180.0 + d26 + d28) / d25;
                        dArray2[0] = this.sl.swe_degnorm((d30 + 1.0) * 90.0);
                        dArray2[0] = this.sl.swe_degnorm(dArray2[0] + 2.7777777777777776E-7);
                        if (d30 > 2.0 || d30 < 0.0) {
                            bl2 = true;
                        }
                    }
                }
                if (bl2) {
                    dArray2[0] = 0.0;
                    d4 = 0.0;
                    if (stringBuffer == null) break;
                    stringBuffer.setLength(0);
                    stringBuffer.append("Koch house position failed in circumpolar area");
                    break;
                }
                if (bl3 && stringBuffer != null) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("Koch house position, doubtful result in circumpolar area");
                }
                d4 = dArray2[0] / 30.0 + 1.0;
                break;
            }
            case 67: {
                dArray3[0] = this.sl.swe_degnorm(d9 - 90.0);
                this.sl.swe_cotrans(dArray3, 0, dArray2, 0, -d2);
                dArray2[0] = this.sl.swe_degnorm(dArray2[0] + 2.7777777777777776E-7);
                d4 = dArray2[0] / 30.0 + 1.0;
                break;
            }
            case 85: {
                double d31;
                double d32 = this.Asc1(this.sl.swe_degnorm(d + 90.0), d2, d5, d6);
                double d33 = this.atand(this.sind(d) * this.tand(d3));
                if (d2 >= 0.0 && 90.0 - d2 + d33 < 0.0) {
                    d32 = this.sl.swe_degnorm(d32 + 180.0);
                }
                if (d2 < 0.0 && -90.0 - d2 + d33 > 0.0) {
                    d32 = this.sl.swe_degnorm(d32 + 180.0);
                }
                dArray4[0] = d32;
                dArray4[1] = 0.0;
                dArray4[2] = 1.0;
                this.sl.swe_cotrans(dArray4, dArray4, -d3);
                double d34 = this.sl.swe_degnorm(d + 90.0);
                dArray4[0] = this.sl.swe_degnorm(d34 - dArray4[0]);
                this.sl.swe_cotrans(dArray4, dArray4, -(90.0 - d2));
                double d35 = this.atand(this.tand(dArray4[0]) / this.cosd(90.0 - d2));
                if (dArray4[0] > 90.0 && dArray4[0] <= 270.0) {
                    d35 = this.sl.swe_degnorm(d35 + 180.0);
                }
                dArray4[0] = this.sl.swe_degnorm(d35);
                dArray4[0] = d31 = this.sl.swe_degnorm(d34 - dArray4[0]);
                dArray4[1] = 0.0;
                dArray4[0] = this.sl.swe_degnorm(d34 - dArray4[0]);
                this.sl.swe_cotrans(dArray4, dArray4, -(90.0 - d2));
                dArray4[1] = dArray4[1] + 90.0;
                this.sl.swe_cotrans(dArray4, dArray4, 90.0 - d2);
                double d36 = dArray4[1];
                dArray5[0] = d32;
                dArray5[1] = 0.0;
                dArray5[2] = 1.0;
                this.sl.swe_cotrans(dArray5, dArray5, -d3);
                dArray5[0] = this.sl.swe_degnorm(dArray5[0] - d31);
                d35 = this.atand(this.tand(dArray5[0]) / this.cosd(d36));
                if (dArray5[0] > 90.0 && dArray5[0] <= 270.0) {
                    d35 = this.sl.swe_degnorm(d35 + 180.0);
                }
                dArray5[0] = this.sl.swe_degnorm(d35);
                dArray2[0] = this.sl.swe_degnorm(dArray3[0] - d31);
                d35 = this.atand(this.tand(dArray2[0]) / this.cosd(d36));
                if (dArray2[0] > 90.0 && dArray2[0] <= 270.0) {
                    d35 = this.sl.swe_degnorm(d35 + 180.0);
                }
                dArray2[0] = this.sl.swe_degnorm(d35);
                dArray2[0] = this.sl.swe_degnorm(dArray2[0] - dArray5[0]);
                dArray4[0] = dArray3[0];
                dArray4[1] = dArray3[1];
                this.sl.swe_cotrans(dArray4, dArray4, d36);
                dArray2[1] = dArray3[1] - dArray4[1];
                dArray2[0] = this.sl.swe_degnorm(dArray2[0] + 2.7777777777777776E-7);
                d4 = dArray2[0] / 30.0 + 1.0;
                break;
            }
            case 72: {
                dArray3[0] = this.sl.swe_degnorm(d9 - 90.0);
                this.sl.swe_cotrans(dArray3, 0, dArray2, 0, 90.0 - d2);
                dArray2[0] = this.sl.swe_degnorm(dArray2[0] + 2.7777777777777776E-7);
                d4 = dArray2[0] / 30.0 + 1.0;
                break;
            }
            case 82: {
                if (SMath.abs(d9) < 1.0E-10) {
                    dArray2[0] = 270.0;
                } else if (180.0 - SMath.abs(d9) < 1.0E-10) {
                    dArray2[0] = 90.0;
                } else {
                    if (90.0 - SMath.abs(d2) < 1.0E-10) {
                        d2 = d2 > 0.0 ? 89.9999999999 : -89.9999999999;
                    }
                    if (90.0 - SMath.abs(d8) < 1.0E-10) {
                        d8 = d8 > 0.0 ? 89.9999999999 : -89.9999999999;
                    }
                    double d37 = this.tand(d2) * this.tand(d8) + this.cosd(d9);
                    dArray2[0] = this.sl.swe_degnorm(this.atand(-d37 / this.sind(d9)));
                    if (d9 < 0.0) {
                        dArray2[0] = dArray2[0] + 180.0;
                    }
                    dArray2[0] = this.sl.swe_degnorm(dArray2[0]);
                    dArray2[0] = this.sl.swe_degnorm(dArray2[0] + 2.7777777777777776E-7);
                }
                d4 = dArray2[0] / 30.0 + 1.0;
                break;
            }
            case 84: {
                d9 = this.sl.swe_degnorm(d9);
                if (d8 > 89.9999999999) {
                    d8 = 89.9999999999;
                }
                if (d8 < -89.9999999999) {
                    d8 = -89.9999999999;
                }
                double d38 = this.tand(d8) * this.tand(d2);
                double d39 = this.asind(d38);
                double d40 = d38 + this.cosd(d9);
                if (d40 >= 0.0) {
                    bl = true;
                }
                if (!bl) {
                    d7 = this.sl.swe_degnorm(d7 + 180.0);
                    d8 = -d8;
                    d9 = this.sl.swe_degnorm(d9 + 180.0);
                }
                if (d9 > 180.0) {
                    d7 = this.sl.swe_degnorm(d - d9);
                }
                double d41 = this.tand(d2);
                double d42 = d2;
                double d43 = this.sl.swe_degnorm(d + 90.0);
                dArray2[1] = 1.0;
                dArray3[1] = d8;
                double d44 = 2.0;
                while (SMath.abs(dArray2[1]) > 1.0E-6) {
                    if (dArray2[1] > 0.0) {
                        d42 = this.atand(this.tand(d42) - d41 / d44);
                        d43 -= 90.0 / d44;
                    } else {
                        d42 = this.atand(this.tand(d42) + d41 / d44);
                        d43 += 90.0 / d44;
                    }
                    dArray3[0] = this.sl.swe_degnorm(d7 - d43);
                    this.sl.swe_cotrans(dArray3, 0, dArray2, 0, 90.0 - d42);
                    d44 *= 2.0;
                }
                d4 = this.sl.swe_degnorm(d43 - d);
                if (d9 > 180.0) {
                    d4 = this.sl.swe_degnorm(-d4);
                }
                if (!bl) {
                    d4 = this.sl.swe_degnorm(d4 + 180.0);
                }
                d4 = this.sl.swe_degnorm(d4 - 90.0) / 30.0 + 1.0;
                break;
            }
            default: {
                if (90.0 - SMath.abs(d8) <= SMath.abs(d2)) {
                    dArray2[0] = d8 * d2 < 0.0 ? this.sl.swe_degnorm(90.0 + d10 / 2.0) : this.sl.swe_degnorm(270.0 + d9 / 2.0);
                    if (stringBuffer != null) {
                        stringBuffer.append("Otto Ludwig procedure within circumpolar regions.");
                    }
                } else {
                    double d45 = this.tand(d8) * this.tand(d2);
                    double d46 = this.asind(d45);
                    double d47 = d45 + this.cosd(d9);
                    if (d47 >= 0.0) {
                        bl = true;
                    }
                    double d48 = 90.0 + d46;
                    double d49 = 90.0 - d46;
                    dArray2[0] = bl ? (d9 / d48 + 3.0) * 90.0 : (d10 / d49 + 1.0) * 90.0;
                    dArray2[0] = this.sl.swe_degnorm(dArray2[0] + 2.7777777777777776E-7);
                }
                if ((char)n == 'G') {
                    dArray2[0] = 360.0 - dArray2[0];
                    d4 = dArray2[0] / 10.0 + 1.0;
                    break;
                }
                d4 = dArray2[0] / 30.0 + 1.0;
            }
        }
        return d4;
    }
}

