/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import swisseph.FilePtr;
import swisseph.JplSave;
import swisseph.SMath;
import swisseph.SwissData;
import swisseph.SwissEph;
import swisseph.SwissLib;
import swisseph.SwissephException;

class SwephJPL
implements Serializable {
    static final int J_MERCURY = 0;
    static final int J_VENUS = 1;
    static final int J_EARTH = 2;
    static final int J_MARS = 3;
    static final int J_JUPITER = 4;
    static final int J_SATURN = 5;
    static final int J_URANUS = 6;
    static final int J_NEPTUNE = 7;
    static final int J_PLUTO = 8;
    static final int J_MOON = 9;
    static final int J_SUN = 10;
    static final int J_SBARY = 11;
    static final int J_EMB = 12;
    static final int J_NUT = 13;
    static final int J_LIB = 14;
    JplSave js = new JplSave();
    SwissEph sw = null;
    SwissData swed = null;
    SwissLib sl = null;
    int np_interp;
    int nv_interp;
    int nac_interp;
    int njk_interp;
    double twot = 0.0;
    int irecsz_state;
    int nrl_state;
    int[] lpt_state = new int[3];
    int ncoeffs_state;

    SwephJPL(SwissEph swissEph, SwissData swissData, SwissLib swissLib) {
        this.sw = swissEph;
        this.swed = swissData;
        this.sl = swissLib;
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        if (this.swed == null) {
            this.swed = new SwissData();
        }
        if (this.sl == null) {
            this.sl = new SwissLib();
        }
    }

    private int fsizer(StringBuffer stringBuffer) throws SwissephException {
        int n;
        double[] dArray = new double[3];
        int[] nArray = new int[3];
        String string = "";
        try {
            int n2;
            int n3;
            this.js.jplfptr = this.sw.swi_fopen(0, this.js.jplfname, this.js.jplfpath, stringBuffer);
            for (n3 = 0; n3 < 252; ++n3) {
                string = string + (char)this.js.jplfptr.readByte();
            }
            for (n3 = 0; n3 < 2400; ++n3) {
                string = string + (char)this.js.jplfptr.readByte();
            }
            for (n3 = 0; n3 < 3; ++n3) {
                dArray[n3] = this.js.jplfptr.readDouble();
            }
            if (dArray[2] < 1.0 || dArray[2] > 200.0) {
                this.js.jplfptr.setBigendian(false);
                this.js.jplfptr.seek(this.js.jplfptr.getFilePointer() - 24L);
                for (n3 = 0; n3 < 3; ++n3) {
                    dArray[n3] = this.js.jplfptr.readDouble();
                }
            } else {
                this.js.jplfptr.setBigendian(true);
            }
            for (n2 = 0; n2 < 3; ++n2) {
                this.js.eh_ss[n2] = dArray[n2];
            }
            if (this.js.eh_ss[0] < -5583942.0 || this.js.eh_ss[1] > 9025909.0 || this.js.eh_ss[2] < 1.0 || this.js.eh_ss[2] > 200.0) {
                throw new SwissephException(Double.POSITIVE_INFINITY, 3072, -2, "alleged ephemeris file (" + this.js.jplfname + ") has invalid format.");
            }
            int n4 = this.js.jplfptr.readInt();
            double d = this.js.jplfptr.readDouble();
            double d2 = this.js.jplfptr.readDouble();
            for (n3 = 0; n3 < 36; ++n3) {
                this.js.eh_ipt[n3] = this.js.jplfptr.readInt();
            }
            int n5 = this.js.jplfptr.readInt();
            nArray[0] = this.js.jplfptr.readInt();
            nArray[1] = this.js.jplfptr.readInt();
            nArray[2] = this.js.jplfptr.readInt();
            for (n2 = 0; n2 < 3; ++n2) {
                this.js.eh_ipt[n2 + 36] = nArray[n2];
            }
            this.js.jplfptr.seek(0L);
            int n6 = 0;
            int n7 = 0;
            for (n2 = 0; n2 < 13; ++n2) {
                if (this.js.eh_ipt[n2 * 3] <= n6) continue;
                n6 = this.js.eh_ipt[n2 * 3];
                n7 = n2 + 1;
            }
            int n8 = n7 == 12 ? 2 : 3;
            n = (int)(((long)(this.js.eh_ipt[n7 * 3 - 3] + n8 * this.js.eh_ipt[n7 * 3 - 2] * this.js.eh_ipt[n7 * 3 - 1]) - 1L) * 2L);
            if (n == 1546) {
                n = 1652;
            }
        }
        catch (IOException iOException) {
            throw new SwissephException(Double.POSITIVE_INFINITY, 33, -1, iOException.getMessage());
        }
        catch (SwissephException swissephException) {
            throw swissephException;
        }
        if (n < 1000 || n > 5000) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("JPL ephemeris file does not provide valid ksize (").append(n).append(")");
            }
            throw new SwissephException(Double.POSITIVE_INFINITY, 65, -2, stringBuffer);
        }
        return n;
    }

    int swi_pleph(double d, int n, int n2, double[] dArray, StringBuffer stringBuffer) throws SwissephException {
        int n3;
        int[] nArray = new int[12];
        double[] dArray2 = this.js.pv;
        double[] dArray3 = this.js.pvsun;
        for (n3 = 0; n3 < 6; ++n3) {
            dArray[n3] = 0.0;
        }
        if (n == n2) {
            return 0;
        }
        for (n3 = 0; n3 < 12; ++n3) {
            nArray[n3] = 0;
        }
        if (n == 13) {
            if (this.js.eh_ipt[34] > 0) {
                nArray[10] = 2;
                return this.state(d, nArray, false, dArray2, dArray3, dArray, stringBuffer);
            }
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("No nutations on the JPL ephemeris file;");
            }
            throw new SwissephException(d, 0, -2, stringBuffer);
        }
        if (n == 14) {
            if (this.js.eh_ipt[37] > 0) {
                nArray[11] = 2;
                int n4 = this.state(d, nArray, false, dArray2, dArray3, dArray, stringBuffer);
                for (n3 = 0; n3 < 6; ++n3) {
                    dArray[n3] = dArray2[n3 + 60];
                }
                return 0;
            }
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("No librations on the ephemeris file;");
            }
            throw new SwissephException(d, 65, -2, stringBuffer);
        }
        if (n < 10) {
            nArray[n] = 2;
        }
        if (n == 9) {
            nArray[2] = 2;
        }
        if (n == 2) {
            nArray[9] = 2;
        }
        if (n == 12) {
            nArray[2] = 2;
        }
        if (n2 < 10) {
            nArray[n2] = 2;
        }
        if (n2 == 9) {
            nArray[2] = 2;
        }
        if (n2 == 2) {
            nArray[9] = 2;
        }
        if (n2 == 12) {
            nArray[2] = 2;
        }
        int n5 = this.state(d, nArray, true, dArray2, dArray3, dArray, stringBuffer);
        if (n == 10 || n2 == 10) {
            for (n3 = 0; n3 < 6; ++n3) {
                dArray2[n3 + 60] = dArray3[n3];
            }
        }
        if (n == 11 || n2 == 11) {
            for (n3 = 0; n3 < 6; ++n3) {
                dArray2[n3 + 66] = 0.0;
            }
        }
        if (n == 12 || n2 == 12) {
            for (n3 = 0; n3 < 6; ++n3) {
                dArray2[n3 + 72] = dArray2[n3 + 12];
            }
        }
        if (n == 2 && n2 == 9 || n == 9 && n2 == 2) {
            for (n3 = 0; n3 < 6; ++n3) {
                dArray2[n3 + 12] = 0.0;
            }
        } else {
            if (nArray[2] == 2) {
                for (n3 = 0; n3 < 6; ++n3) {
                    int n6 = n3 + 12;
                    dArray2[n6] = dArray2[n6] - dArray2[n3 + 54] / (this.js.eh_emrat + 1.0);
                }
            }
            if (nArray[9] == 2) {
                for (n3 = 0; n3 < 6; ++n3) {
                    int n7 = n3 + 54;
                    dArray2[n7] = dArray2[n7] + dArray2[n3 + 12];
                }
            }
        }
        for (n3 = 0; n3 < 6; ++n3) {
            dArray[n3] = dArray2[n3 + n * 6] - dArray2[n3 + n2 * 6];
        }
        return 0;
    }

    private int interp(double[] dArray, int n, double d, double d2, int n2, int n3, int n4, int n5, double[] dArray2, int n6) {
        int n7;
        int n8;
        double[] dArray3 = this.js.pc;
        double[] dArray4 = this.js.vc;
        double[] dArray5 = this.js.ac;
        double[] dArray6 = this.js.jc;
        int n9 = n2;
        int n10 = n3;
        int n11 = n4;
        double d3 = d >= 0.0 ? SMath.floor(d) : -SMath.floor(-d);
        double d4 = (double)n11 * d;
        int n12 = (int)(d4 - d3);
        double d5 = (d4 % 1.0 + d3) * 2.0 - 1.0;
        if (d5 != dArray3[1]) {
            this.np_interp = 2;
            this.nv_interp = 3;
            this.nac_interp = 4;
            this.njk_interp = 5;
            dArray3[1] = d5;
            this.twot = d5 + d5;
        }
        if (this.np_interp < n9) {
            for (n8 = this.np_interp; n8 < n9; ++n8) {
                dArray3[n8] = this.twot * dArray3[n8 - 1] - dArray3[n8 - 2];
            }
            this.np_interp = n9;
        }
        for (n8 = 0; n8 < n10; ++n8) {
            dArray2[n6 + n8] = 0.0;
            for (n7 = n9 - 1; n7 >= 0; --n7) {
                int n13 = n6 + n8;
                dArray2[n13] = dArray2[n13] + dArray3[n7] * dArray[n + n7 + (n8 + n12 * n10) * n9];
            }
        }
        if (n5 <= 1) {
            return 0;
        }
        double d6 = (double)(n11 + n11) / d2;
        dArray4[2] = this.twot + this.twot;
        if (this.nv_interp < n9) {
            for (n8 = this.nv_interp; n8 < n9; ++n8) {
                dArray4[n8] = this.twot * dArray4[n8 - 1] + dArray3[n8 - 1] + dArray3[n8 - 1] - dArray4[n8 - 2];
            }
            this.nv_interp = n9;
        }
        for (n8 = 0; n8 < n10; ++n8) {
            dArray2[n6 + n8 + n10] = 0.0;
            for (n7 = n9 - 1; n7 >= 1; --n7) {
                int n14 = n6 + n8 + n10;
                dArray2[n14] = dArray2[n14] + dArray4[n7] * dArray[n + n7 + (n8 + n12 * n10) * n9];
            }
            int n15 = n6 + n8 + n10;
            dArray2[n15] = dArray2[n15] * d6;
        }
        if (n5 == 2) {
            return 0;
        }
        double d7 = d6 * d6;
        dArray5[3] = dArray3[1] * 24.0;
        if (this.nac_interp < n9) {
            for (n8 = this.nac_interp = n9; n8 < n9; ++n8) {
                dArray5[n8] = this.twot * dArray5[n8 - 1] + dArray4[n8 - 1] * 4.0 - dArray5[n8 - 2];
            }
        }
        for (n8 = 0; n8 < n10; ++n8) {
            dArray2[n6 + n8 + n10 * 2] = 0.0;
            for (n7 = n9 - 1; n7 >= 2; --n7) {
                int n16 = n6 + n8 + n10 * 2;
                dArray2[n16] = dArray2[n16] + dArray5[n7] * dArray[n + n7 + (n8 + n12 * n10) * n9];
            }
            int n17 = n6 + n8 + n10 * 2;
            dArray2[n17] = dArray2[n17] * d7;
        }
        if (n5 == 3) {
            return 0;
        }
        double d8 = d6 * d7;
        dArray6[4] = dArray3[1] * 192.0;
        if (this.njk_interp < n9) {
            for (n8 = this.njk_interp = n9; n8 < n9; ++n8) {
                dArray6[n8] = this.twot * dArray6[n8 - 1] + dArray5[n8 - 1] * 6.0 - dArray6[n8 - 2];
            }
        }
        for (n8 = 0; n8 < n10; ++n8) {
            dArray2[n6 + n8 + n10 * 3] = 0.0;
            for (n7 = n9 - 1; n7 >= 3; --n7) {
                int n18 = n6 + n8 + n10 * 3;
                dArray2[n18] = dArray2[n18] + dArray6[n7] * dArray[n + n7 + (n8 + n12 * n10) * n9];
            }
            int n19 = n6 + n8 + n10 * 3;
            dArray2[n19] = dArray2[n19] * d8;
        }
        return 0;
    }

    private int state(double d, int[] nArray, boolean bl, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer) throws SwissephException {
        int n;
        double[] dArray4 = this.js.buf;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray5 = new double[4];
        int[] nArray2 = this.js.eh_ipt;
        String string = "";
        boolean bl2 = false;
        try {
            int n2;
            if (this.js.jplfptr == null || this.js.jplfptr.fp == null && this.js.jplfptr.sk == null) {
                int n3;
                int n4 = this.fsizer(stringBuffer);
                int n5 = 4;
                this.irecsz_state = n5 * n4;
                this.ncoeffs_state = n4 / 2;
                for (n3 = 0; n3 < 252; ++n3) {
                    string = string + (char)this.js.jplfptr.readByte();
                }
                for (n3 = 0; n3 < 2400; ++n3) {
                    this.js.ch_cnam = this.js.ch_cnam + (char)this.js.jplfptr.readByte();
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    this.js.eh_ss[n3] = this.js.jplfptr.readDouble();
                }
                this.js.eh_ncon = this.js.jplfptr.readInt();
                this.js.eh_au = this.js.jplfptr.readDouble();
                this.js.eh_emrat = this.js.jplfptr.readDouble();
                for (n3 = 0; n3 < 36; ++n3) {
                    nArray2[n3] = this.js.jplfptr.readInt();
                }
                this.js.eh_denum = this.js.jplfptr.readInt();
                for (n3 = 0; n3 < 3; ++n3) {
                    this.lpt_state[n3] = this.js.jplfptr.readInt();
                }
                this.js.jplfptr.seek(1L * (long)this.irecsz_state);
                for (n3 = 0; n3 < 400; ++n3) {
                    this.js.eh_cval[n3] = this.js.jplfptr.readDouble();
                }
                for (n = 0; n < 3; ++n) {
                    nArray2[n + 36] = this.lpt_state[n];
                }
                this.nrl_state = 0;
                this.js.jplfptr.seek(this.js.jplfptr.length());
                long l = this.js.jplfptr.length();
                int n6 = (int)((this.js.eh_ss[1] - this.js.eh_ss[0]) / this.js.eh_ss[2]);
                long l2 = 0L;
                for (n = 0; n < 13; ++n) {
                    n2 = 3;
                    if (n == 11) {
                        n2 = 2;
                    }
                    l2 += (long)(nArray2[n * 3 + 1] * nArray2[n * 3 + 2] * n2 * n6);
                }
                l2 += (long)(2 * n6);
                l2 *= 8L;
                if (l != (l2 += (long)(2 * n4 * n5)) && l - l2 != (long)(n4 * n5)) {
                    if (stringBuffer != null) {
                        stringBuffer.setLength(0);
                        stringBuffer.append("JPL ephemeris file is mutilated; length = " + l + " instead of " + l2 + ".");
                        if (stringBuffer.length() + this.js.jplfname.length() < 255) {
                            stringBuffer.setLength(0);
                            stringBuffer.append("JPL ephemeris file " + this.js.jplfname + " is mutilated; length = " + l + " instead of " + l2 + ".");
                        }
                    }
                    throw new SwissephException(d, 33, -1, stringBuffer);
                }
                this.js.jplfptr.seek(2L * (long)this.irecsz_state);
                dArray5[0] = this.js.jplfptr.readDouble();
                dArray5[1] = this.js.jplfptr.readDouble();
                this.js.jplfptr.seek((long)(n6 + 2 - 1) * (long)this.irecsz_state);
                dArray5[2] = this.js.jplfptr.readDouble();
                dArray5[3] = this.js.jplfptr.readDouble();
                if (dArray5[0] != this.js.eh_ss[0] || dArray5[3] != this.js.eh_ss[1]) {
                    if (stringBuffer != null) {
                        stringBuffer.setLength(0);
                        stringBuffer.append("JPL ephemeris file is corrupt; start/end date check failed. " + dArray5[0] + " != " + this.js.eh_ss[0] + " || " + dArray5[3] + " != " + this.js.eh_ss[1]);
                    }
                    throw new SwissephException(d, 65, -2, stringBuffer);
                }
            }
            if (nArray == null) {
                return 0;
            }
            double d5 = d - 0.5;
            double d6 = SMath.floor(d5);
            double d7 = d5 - d6;
            d6 += 0.5;
            if (d < this.js.eh_ss[0] || d > this.js.eh_ss[1]) {
                if (stringBuffer != null) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("jd " + d + " outside JPL eph. range " + this.js.eh_ss[0] + " .. " + this.js.eh_ss[1] + ";");
                }
                throw new SwissephException(d, 3072, -3, stringBuffer);
            }
            int n7 = (int)((d6 - this.js.eh_ss[0]) / this.js.eh_ss[2]) + 2;
            if (d6 == this.js.eh_ss[1]) {
                --n7;
            }
            d3 = (d6 - ((double)(n7 - 2) * this.js.eh_ss[2] + this.js.eh_ss[0]) + d7) / this.js.eh_ss[2];
            if (n7 != this.nrl_state) {
                this.nrl_state = n7;
                this.js.jplfptr.seek((long)n7 * (long)this.irecsz_state);
                for (n2 = 1; n2 <= this.ncoeffs_state; ++n2) {
                    dArray4[n2 - 1] = this.js.jplfptr.readDouble();
                }
            }
            if (this.js.do_km) {
                d4 = this.js.eh_ss[2] * 86400.0;
                d2 = 1.0;
            } else {
                d4 = this.js.eh_ss[2];
                d2 = 1.0 / this.js.eh_au;
            }
        }
        catch (EOFException eOFException) {
            bl2 = true;
        }
        catch (IOException iOException) {
            bl2 = true;
        }
        catch (SwissephException swissephException) {
            throw swissephException;
        }
        if (bl2) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("Read error in JPL eph. at " + d + "\n");
            }
            throw new SwissephException(d, 33, -2, stringBuffer);
        }
        this.interp(dArray4, nArray2[30] - 1, d3, d4, nArray2[31], 3, nArray2[32], 2, dArray2, 0);
        n = 0;
        while (n < 6) {
            int n8 = n++;
            dArray2[n8] = dArray2[n8] * d2;
        }
        for (n = 0; n < 10; ++n) {
            if (nArray[n] <= 0) continue;
            this.interp(dArray4, nArray2[n * 3] - 1, d3, d4, nArray2[n * 3 + 1], 3, nArray2[n * 3 + 2], nArray[n], dArray, n * 6);
            for (int i = 0; i < 6; ++i) {
                if (n < 9 && !bl) {
                    dArray[i + n * 6] = dArray[i + n * 6] * d2 - dArray2[i];
                    continue;
                }
                int n9 = i + n * 6;
                dArray[n9] = dArray[n9] * d2;
            }
        }
        if (nArray[10] > 0 && nArray2[34] > 0) {
            this.interp(dArray4, nArray2[33] - 1, d3, d4, nArray2[34], 2, nArray2[35], nArray[10], dArray3, 0);
        }
        if (nArray[11] > 0 && nArray2[37] > 0) {
            this.interp(dArray4, nArray2[36] - 1, d3, d4, nArray2[37], 3, nArray2[38], nArray[1], dArray, 60);
        }
        return 0;
    }

    private int read_const_jpl(double[] dArray, StringBuffer stringBuffer) throws SwissephException {
        this.state(0.0, null, false, null, null, null, stringBuffer);
        for (int i = 0; i < 3; ++i) {
            dArray[i] = this.js.eh_ss[i];
        }
        return 0;
    }

    void swi_close_jpl_file() {
        if (this.js != null) {
            try {
                if (this.js.jplfptr != null) {
                    this.js.jplfptr.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.js.jplfname != null) {
                this.js.jplfname = null;
            }
            if (this.js.jplfpath != null) {
                this.js.jplfpath = null;
            }
            this.js = null;
        }
    }

    int swi_open_jpl_file(double[] dArray, String string, String string2, StringBuffer stringBuffer) throws SwissephException {
        int n = 0;
        if (this.js != null && this.js.jplfptr != null) {
            return 0;
        }
        this.js = new JplSave();
        this.js.jplfname = string;
        this.js.jplfpath = string2;
        try {
            n = this.read_const_jpl(dArray, stringBuffer);
        }
        catch (SwissephException swissephException) {
            this.swi_close_jpl_file();
            return swissephException.getRC();
        }
        this.js.pc[0] = 1.0;
        this.js.pc[1] = 2.0;
        this.js.vc[1] = 1.0;
        this.js.ac[2] = 4.0;
        this.js.jc[3] = 24.0;
        return n;
    }

    int swi_get_jpl_denum() {
        return this.js.eh_denum;
    }

    double[] getJPLRange(String string) throws SwissephException {
        double d = Double.NaN;
        double d2 = Double.NaN;
        FilePtr filePtr = null;
        try {
            filePtr = this.sw.swi_fopen(0, string, this.swed.ephepath, null);
            filePtr.seek(2652L);
            d = filePtr.readDouble();
            d2 = filePtr.readDouble();
            double d3 = filePtr.readDouble();
            if (d3 < 1.0 || d3 > 200.0) {
                long l = Double.doubleToLongBits(d);
                l = ((l & 0xFFL) << 56) + ((l & 0xFF00L) << 40) + ((l & 0xFF0000L) << 24) + ((l & 0xFF000000L) << 8) + ((l & 0xFF00000000L) >> 8) + ((l & 0xFF0000000000L) >> 24) + ((l & 0xFF000000000000L) >> 40) + ((l & 0xFF00000000000000L) >> 56);
                d = Double.longBitsToDouble(l);
                l = Double.doubleToLongBits(d2);
                l = ((l & 0xFFL) << 56) + ((l & 0xFF00L) << 40) + ((l & 0xFF0000L) << 24) + ((l & 0xFF000000L) << 8) + ((l & 0xFF00000000L) >> 8) + ((l & 0xFF0000000000L) >> 24) + ((l & 0xFF000000000000L) >> 40) + ((l & 0xFF00000000000000L) >> 56);
                d2 = Double.longBitsToDouble(l);
            }
        }
        catch (SwissephException swissephException) {
            throw swissephException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filePtr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new double[]{d, d2};
    }
}

