/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import java.util.StringTokenizer;
import swisseph.DblObj;
import swisseph.IntObj;
import swisseph.SMath;
import swisseph.SweDate;
import swisseph.Swenut2000a;
import swisseph.Swenut2000aNls;
import swisseph.Swenut2000a_cls;
import swisseph.Swenut2000a_npl;
import swisseph.SwissData;

public class SwissLib
implements Serializable {
    static final double PREC_IAU_1976_CTIES = 2.0;
    static final double PREC_IAU_2000_CTIES = 2.0;
    static final double PREC_IAU_2006_CTIES = 75.0;
    public static final String DPSI_DEPS_IAU1980_FILE_EOPC04 = "eop_1962_today.txt";
    public static final String DPSI_DEPS_IAU1980_FILE_FINALS = "eop_finals.txt";
    public static final double DPSI_DEPS_IAU1980_TJD0_HORIZONS = 2437684.5;
    public static final double HORIZONS_TJD0_DPSI_DEPS_IAU1980 = 2437684.5;
    SwissData swed;
    static final double AS2R = 4.848136811095361E-6;
    static final double D2PI = Math.PI * 2;
    static final double EPS0 = 0.40909260060058295;
    static final int NPOL_PEPS = 4;
    static final int NPER_PEPS = 10;
    static final int NPOL_PECL = 4;
    static final int NPER_PECL = 8;
    static final int NPOL_PEQU = 4;
    static final int NPER_PEQU = 14;
    private static final double[][] pepol = new double[][]{{8134.017132, 84028.206305}, {5043.0520035, 0.3624445}, {-0.00710733, -4.039E-5}, {2.71E-7, -1.1E-7}};
    private static final double[][] peper = new double[][]{{409.9, 396.15, 537.22, 402.9, 417.15, 288.92, 4043.0, 306.0, 277.0, 203.0}, {-6908.287473, -3198.706291, 1453.674527, -857.748557, 1173.231614, -156.981465, 371.83655, -216.61904, 193.691479, 11.891524}, {753.87278, -247.805823, 379.471484, -53.880558, -90.109153, -353.60019, -63.115353, -28.248187, 17.703387, 38.911307}, {-2845.175469, 449.844989, -1255.915323, 886.736783, 418.887514, 997.912441, -240.97971, 76.541307, -36.788069, -170.964086}, {-1704.720302, -862.308358, 447.832178, -889.571909, 190.402846, -56.564991, -296.222622, -75.859952, 67.473503, 3.014055}};
    private static final double[][] pqpol = new double[][]{{5851.607687, -1600.8863}, {-0.1189, 1.1689818}, {-2.8913E-4, -2.0E-7}, {1.01E-7, -4.37E-7}};
    private static final double[][] pqper = new double[][]{{708.15, 2309.0, 1620.0, 492.2, 1183.0, 622.0, 882.0, 547.0}, {-5486.751211, -17.127623, -617.517403, 413.44294, 78.614193, -180.732815, -87.676083, 46.140315}, {-684.66156, 2446.28388, 399.671049, -356.652376, -186.387003, -316.80007, 198.296701, 101.135679}, {667.66673, -2354.886252, -428.152441, 376.202861, 184.778874, 335.321713, -185.138669, -120.97283}, {-5523.863691, -549.74745, -310.998056, 421.535876, -36.776172, -145.278396, -34.74445, 22.885731}};
    private static final double[][] xypol = new double[][]{{5453.282155, -73750.93035}, {0.4252841, -0.7675452}, {-3.7173E-4, -1.8725E-4}, {-1.52E-7, 2.31E-7}};
    private static final double[][] xyper = new double[][]{{256.75, 708.15, 274.2, 241.45, 2309.0, 492.2, 396.1, 288.9, 231.1, 1610.0, 620.0, 157.87, 220.3, 1200.0}, {-819.940624, -8444.676815, 2600.009459, 2755.17563, -167.659835, 871.855056, 44.769698, -512.313065, -819.415595, -538.071099, -189.793622, -402.922932, 179.516345, -9.814756}, {75004.344875, 624.033993, 1251.136893, -1102.212834, -2660.66498, 699.291817, 153.16722, -950.865637, 499.754645, -145.18821, 558.116553, -23.923029, -165.405086, 9.344131}, {81491.287984, 787.163481, 1251.296102, -1257.950837, -2966.79973, 639.744522, 131.600209, -445.040117, 584.522874, -89.756563, 524.42963, -13.549067, -210.157124, -44.919798}, {1558.515853, 7774.939698, -2219.534038, -2523.969396, 247.850422, -846.485643, -1393.124055, 368.526116, 749.045012, 444.704518, 235.934465, 374.049623, -171.33018, -22.899655}};
    static final double OFFSET_EPS_JPLHORIZONS = 35.95;
    static final double DCOR_EPS_JPL_TJD0 = 2437846.5;
    static final int NDCOR_EPS_JPL = 51;
    double[] dcor_eps_jpl = new double[]{36.726, 36.627, 36.595, 36.578, 36.64, 36.659, 36.731, 36.765, 36.662, 36.555, 36.335, 36.321, 36.354, 36.227, 36.289, 36.348, 36.257, 36.163, 35.979, 35.896, 35.842, 35.825, 35.912, 35.95, 36.093, 36.191, 36.009, 35.943, 35.875, 35.771, 35.788, 35.753, 35.822, 35.866, 35.771, 35.732, 35.543, 35.498, 35.449, 35.409, 35.497, 35.556, 35.672, 35.76, 35.596, 35.565, 35.51, 35.394, 35.385, 35.375, 35.415};
    private double[] pAcof_williams = new double[]{-8.66E-10, -4.759E-8, 2.424E-7, 1.3095E-5, 1.7451E-4, -0.0018055, -0.235316, 0.076, 110.5407, 50287.7};
    private double[] nodecof_williams = new double[]{6.6402E-16, -2.69151E-15, -1.547021E-12, 7.521313E-12, 1.9E-10, -3.54E-9, -1.8103E-7, 1.26E-7, 7.436169E-5, -0.04207794833, 3.052115282424};
    private double[] inclcof_williams = new double[]{1.2147E-16, 7.3759E-17, -8.26287E-14, 2.50341E-13, 2.4650839E-11, -5.4000441E-11, 1.32115526E-9, -6.012E-7, -1.62442E-5, 0.00227850649, 0.0};
    private double[] pAcof_simon = new double[]{-8.66E-10, -4.759E-8, 2.424E-7, 1.3095E-5, 1.7451E-4, -0.0018055, -0.235316, 0.07732, 111.2022, 50288.2};
    private double[] nodecof_simon = new double[]{6.6402E-16, -2.69151E-15, -1.547021E-12, 7.521313E-12, 1.9E-10, -3.54E-9, -1.8103E-7, 2.579E-8, 7.4379679E-5, -0.04207829, 3.0521126906};
    private double[] inclcof_simon = new double[]{1.2147E-16, 7.3759E-17, -8.26287E-14, 2.50341E-13, 2.4650839E-11, -5.4000441E-11, 1.32115526E-9, -5.99908E-7, -1.624383E-5, 0.002278492868, 0.0};
    private double[] pAcof_laskar = new double[]{-8.66E-10, -4.759E-8, 2.424E-7, 1.3095E-5, 1.7451E-4, -0.0018055, -0.235316, 0.07732, 111.1971, 50290.966};
    private double[] nodecof_laskar = new double[]{6.6402E-16, -2.69151E-15, -1.547021E-12, 7.521313E-12, 6.3190131E-10, -3.48388152E-9, -1.813065896E-7, 2.75036225E-8, 7.4394531426E-5, -0.042078604317, 3.052112654975};
    private double[] inclcof_laskar = new double[]{1.2147E-16, 7.3759E-17, -8.26287E-14, 2.50341E-13, 2.4650839E-11, -5.4000441E-11, 1.32115526E-9, -5.998737027E-7, -1.6242797091E-5, 0.002278495537, 0.0};
    static final short ENDMARK = -99;
    static short[] nt = new short[]{0, 0, 0, 0, 2, 2062, 2, -895, 5, -2, 0, 2, 0, 1, 46, 0, -24, 0, 2, 0, -2, 0, 0, 11, 0, 0, 0, -2, 0, 2, 0, 2, -3, 0, 1, 0, 1, -1, 0, -1, 0, -3, 0, 0, 0, 0, -2, 2, -2, 1, -2, 0, 1, 0, 2, 0, -2, 0, 1, 1, 0, 0, 0, 0, 0, 2, -2, 2, -13187, -16, 5736, -31, 0, 1, 0, 0, 0, 1426, -34, 54, -1, 0, 1, 2, -2, 2, -517, 12, 224, -6, 0, -1, 2, -2, 2, 217, -5, -95, 3, 0, 0, 2, -2, 1, 129, 1, -70, 0, 2, 0, 0, -2, 0, 48, 0, 1, 0, 0, 0, 2, -2, 0, -22, 0, 0, 0, 0, 2, 0, 0, 0, 17, -1, 0, 0, 0, 1, 0, 0, 1, -15, 0, 9, 0, 0, 2, 2, -2, 2, -16, 1, 7, 0, 0, -1, 0, 0, 1, -12, 0, 6, 0, -2, 0, 0, 2, 1, -6, 0, 3, 0, 0, -1, 2, -2, 1, -5, 0, 3, 0, 2, 0, 0, -2, 1, 4, 0, -2, 0, 0, 1, 2, -2, 1, 4, 0, -2, 0, 1, 0, 0, -1, 0, -4, 0, 0, 0, 2, 1, 0, -2, 0, 1, 0, 0, 0, 0, 0, -2, 2, 1, 1, 0, 0, 0, 0, 1, -2, 2, 0, -1, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0, 0, -1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 2, -2, 0, -1, 0, 0, 0, 0, 0, 2, 0, 2, -2274, -2, 977, -5, 1, 0, 0, 0, 0, 712, 1, -7, 0, 0, 0, 2, 0, 1, -386, -4, 200, 0, 1, 0, 2, 0, 2, -301, 0, 129, -1, 1, 0, 0, -2, 0, -158, 0, -1, 0, -1, 0, 2, 0, 2, 123, 0, -53, 0, 0, 0, 0, 2, 0, 63, 0, -2, 0, 1, 0, 0, 0, 1, 63, 1, -33, 0, -1, 0, 0, 0, 1, -58, -1, 32, 0, -1, 0, 2, 2, 2, -59, 0, 26, 0, 1, 0, 2, 0, 1, -51, 0, 27, 0, 0, 0, 2, 2, 2, -38, 0, 16, 0, 2, 0, 0, 0, 0, 29, 0, -1, 0, 1, 0, 2, -2, 2, 29, 0, -12, 0, 2, 0, 2, 0, 2, -31, 0, 13, 0, 0, 0, 2, 0, 0, 26, 0, -1, 0, -1, 0, 2, 0, 1, 21, 0, -10, 0, -1, 0, 0, 2, 1, 16, 0, -8, 0, 1, 0, 0, -2, 1, -13, 0, 7, 0, -1, 0, 2, 2, 1, -10, 0, 5, 0, 1, 1, 0, -2, 0, -7, 0, 0, 0, 0, 1, 2, 0, 2, 7, 0, -3, 0, 0, -1, 2, 0, 2, -7, 0, 3, 0, 1, 0, 2, 2, 2, -8, 0, 3, 0, 1, 0, 0, 2, 0, 6, 0, 0, 0, 2, 0, 2, -2, 2, 6, 0, -3, 0, 0, 0, 0, 2, 1, -6, 0, 3, 0, 0, 0, 2, 2, 1, -7, 0, 3, 0, 1, 0, 2, -2, 1, 6, 0, -3, 0, 0, 0, 0, -2, 1, -5, 0, 3, 0, 1, -1, 0, 0, 0, 5, 0, 0, 0, 2, 0, 2, 0, 1, -5, 0, 3, 0, 0, 1, 0, -2, 0, -4, 0, 0, 0, 1, 0, -2, 0, 0, 4, 0, 0, 0, 0, 0, 0, 1, 0, -4, 0, 0, 0, 1, 1, 0, 0, 0, -3, 0, 0, 0, 1, 0, 2, 0, 0, 3, 0, 0, 0, 1, -1, 2, 0, 2, -3, 0, 1, 0, -1, -1, 2, 2, 2, -3, 0, 1, 0, -2, 0, 0, 0, 1, -2, 0, 1, 0, 3, 0, 2, 0, 2, -3, 0, 1, 0, 0, -1, 2, 2, 2, -3, 0, 1, 0, 1, 1, 2, 0, 2, 2, 0, -1, 0, -1, 0, 2, -2, 1, -2, 0, 1, 0, 2, 0, 0, 0, 1, 2, 0, -1, 0, 1, 0, 0, 0, 2, -2, 0, 1, 0, 3, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 1, 2, 2, 0, -1, 0, -1, 0, 0, 0, 2, 1, 0, -1, 0, 1, 0, 0, -4, 0, -1, 0, 0, 0, -2, 0, 2, 2, 2, 1, 0, -1, 0, -1, 0, 2, 4, 2, -2, 0, 1, 0, 2, 0, 0, -4, 0, -1, 0, 0, 0, 1, 1, 2, -2, 2, 1, 0, -1, 0, 1, 0, 2, 2, 1, -1, 0, 1, 0, -2, 0, 2, 4, 2, -1, 0, 1, 0, -1, 0, 4, 0, 2, 1, 0, 0, 0, 1, -1, 0, -2, 0, 1, 0, 0, 0, 2, 0, 2, -2, 1, 1, 0, -1, 0, 2, 0, 2, 2, 2, -1, 0, 0, 0, 1, 0, 0, 2, 1, -1, 0, 0, 0, 0, 0, 4, -2, 2, 1, 0, 0, 0, 3, 0, 2, -2, 2, 1, 0, 0, 0, 1, 0, 2, -2, 0, -1, 0, 0, 0, 0, 1, 2, 0, 1, 1, 0, 0, 0, -1, -1, 0, 2, 1, 1, 0, 0, 0, 0, 0, -2, 0, 1, -1, 0, 0, 0, 0, 0, 2, -1, 2, -1, 0, 0, 0, 0, 1, 0, 2, 0, -1, 0, 0, 0, 1, 0, -2, -2, 0, -1, 0, 0, 0, 0, -1, 2, 0, 1, -1, 0, 0, 0, 1, 1, 0, -2, 1, -1, 0, 0, 0, 1, 0, -2, 2, 0, -1, 0, 0, 0, 2, 0, 0, 2, 0, 1, 0, 0, 0, 0, 0, 2, 4, 2, -1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 101, 0, 0, 0, 1, -725, 0, 213, 0, 101, 1, 0, 0, 0, 523, 0, 208, 0, 101, 0, 2, -2, 2, 102, 0, -41, 0, 101, 0, 2, 0, 2, -81, 0, 32, 0, 102, 0, 0, 0, 1, 417, 0, 224, 0, 102, 1, 0, 0, 0, 61, 0, -24, 0, 102, 0, 2, -2, 2, -118, 0, -47, 0, -99};
    static final double OFFSET_JPLHORIZONS = -52.3;
    static final double DCOR_RA_JPL_TJD0 = 2437846.5;
    static final int NDCOR_RA_JPL = 51;
    double[] dcor_ra_jpl = new double[]{-51.257, -51.103, -51.065, -51.503, -51.224, -50.796, -51.161, -51.181, -50.932, -51.064, -51.182, -51.386, -51.416, -51.428, -51.586, -51.766, -52.038, -52.37, -52.553, -52.397, -52.34, -52.676, -52.348, -51.964, -52.444, -52.364, -51.988, -52.212, -52.37, -52.523, -52.541, -52.496, -52.59, -52.629, -52.788, -53.014, -53.053, -52.902, -52.85, -53.087, -52.635, -52.185, -52.588, -52.292, -51.796, -51.961, -52.055, -52.134, -52.165, -52.141, -52.255};
    static final int SIDTNTERM = 33;
    private double[] stcf = new double[]{2640.96, -0.39, 63.52, -0.02, 11.75, 0.01, 11.21, 0.01, -4.55, 0.0, 2.02, 0.0, 1.98, 0.0, -1.72, 0.0, -1.41, -0.01, -1.26, -0.01, -0.63, 0.0, -0.63, 0.0, 0.46, 0.0, 0.45, 0.0, 0.36, 0.0, -0.24, -0.12, 0.32, 0.0, 0.28, 0.0, 0.27, 0.0, 0.26, 0.0, -0.21, 0.0, 0.19, 0.0, 0.18, 0.0, -0.1, 0.05, 0.15, 0.0, -0.14, 0.0, 0.14, 0.0, -0.14, 0.0, 0.14, 0.0, 0.13, 0.0, -0.11, 0.0, 0.11, 0.0, 0.11, 0.0};
    static final int SIDTNARG = 14;
    private static final int[] stfarg = new int[]{0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, -2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, -2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, -4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 1, 0, -8, 12, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -2, 2, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -2, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, -13, 0, 0, 0, 0, 0, -1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, -2, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, -2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, -2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, -2, 0, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, -2, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final double SIDT_LTERM_T0 = 2396758.5;
    static final double SIDT_LTERM_T1 = 2469807.5;
    static final double SIDT_LTERM_OFS0 = 0.0021885756666666666;
    static final double SIDT_LTERM_OFS1 = -0.0043595532666666666;
    static final double PREC_IAU_CTIES = 2.0;

    public SwissLib() {
        this(null);
    }

    public SwissLib(SwissData swissData) {
        this.swed = swissData;
        if (this.swed == null) {
            this.swed = new SwissData();
        }
    }

    public double square_sum(double[] dArray) {
        return dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
    }

    public double square_sum(double[] dArray, int n) {
        return dArray[n] * dArray[n] + dArray[1 + n] * dArray[1 + n] + dArray[2 + n] * dArray[2 + n];
    }

    public double swe_degnorm(double d) {
        double d2 = d % 360.0;
        if (SMath.abs(d2) < 1.0E-13) {
            d2 = 0.0;
        }
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        return d2;
    }

    public double swe_radnorm(double d) {
        double d2 = d % (Math.PI * 2);
        if (SMath.abs(d2) < 1.0E-13) {
            d2 = 0.0;
        }
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    public double swe_deg_midp(double d, double d2) {
        double d3 = this.swe_difdeg2n(d, d2);
        double d4 = this.swe_degnorm(d2 + d3 / 2.0);
        return d4;
    }

    public double swe_rad_midp(double d, double d2) {
        return 0.0174532925199433 * this.swe_deg_midp(d * 57.2957795130823, d2 * 57.2957795130823);
    }

    public double swi_mod2PI(double d) {
        double d2 = d % (Math.PI * 2);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    public double swi_angnorm(double d) {
        if (d < 0.0) {
            return d + Math.PI * 2;
        }
        if (d >= Math.PI * 2) {
            return d - Math.PI * 2;
        }
        return d;
    }

    public void swi_cross_prod(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        dArray3[0 + n3] = dArray[1 + n] * dArray2[2 + n2] - dArray[2 + n] * dArray2[1 + n2];
        dArray3[1 + n3] = dArray[2 + n] * dArray2[0 + n2] - dArray[0 + n] * dArray2[2 + n2];
        dArray3[2 + n3] = dArray[0 + n] * dArray2[1 + n2] - dArray[1 + n] * dArray2[0 + n2];
    }

    public double swi_echeb(double d, double[] dArray, int n, int n2) {
        double d2 = d * 2.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = n2 - 1; i >= 0; --i) {
            d4 = d5;
            d5 = d3;
            d3 = d2 * d5 - d4 + dArray[i + n];
        }
        return (d3 - d4) * 0.5;
    }

    public double swi_edcheb(double d, double[] dArray, int n, int n2) {
        double d2 = d * 2.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = n2 - 1; i >= 1; --i) {
            double d9 = i + i;
            double d10 = dArray[i + n] * d9 + d5;
            d4 = d2 * d8 - d7 + d10;
            d3 = d7;
            d7 = d8;
            d8 = d4;
            d5 = d6;
            d6 = d10;
        }
        return (d4 - d3) * 0.5;
    }

    public void swe_cotrans(double[] dArray, double[] dArray2, double d) {
        this.swe_cotrans(dArray, 0, dArray2, 0, d);
    }

    public void swe_cotrans(double[] dArray, int n, double[] dArray2, int n2, double d) {
        int n3;
        double[] dArray3 = new double[6];
        double d2 = d * 0.0174532925199433;
        for (n3 = 0; n3 <= 1; ++n3) {
            dArray3[n3] = dArray[n3 + n];
        }
        dArray3[0] = dArray3[0] * 0.0174532925199433;
        dArray3[1] = dArray3[1] * 0.0174532925199433;
        dArray3[2] = 1.0;
        for (n3 = 3; n3 <= 5; ++n3) {
            dArray3[n3] = 0.0;
        }
        this.swi_polcart(dArray3, dArray3);
        this.swi_coortrf(dArray3, dArray3, d2);
        this.swi_cartpol(dArray3, dArray3);
        dArray2[n2] = dArray3[0] * 57.2957795130823;
        dArray2[1 + n2] = dArray3[1] * 57.2957795130823;
        dArray2[2 + n2] = dArray[2 + n];
    }

    public void swe_cotrans_sp(double[] dArray, double[] dArray2, double d) {
        double[] dArray3 = new double[6];
        double d2 = d * 0.0174532925199433;
        for (int i = 0; i <= 5; ++i) {
            dArray3[i] = dArray[i];
        }
        dArray3[0] = dArray3[0] * 0.0174532925199433;
        dArray3[1] = dArray3[1] * 0.0174532925199433;
        dArray3[2] = 1.0;
        dArray3[3] = dArray3[3] * 0.0174532925199433;
        dArray3[4] = dArray3[4] * 0.0174532925199433;
        this.swi_polcart_sp(dArray3, dArray3);
        this.swi_coortrf(dArray3, dArray3, d2);
        this.swi_coortrf(dArray3, 3, dArray3, 3, d2);
        this.swi_cartpol_sp(dArray3, dArray2);
        dArray2[0] = dArray2[0] * 57.2957795130823;
        dArray2[1] = dArray2[1] * 57.2957795130823;
        dArray2[2] = dArray[2];
        dArray2[3] = dArray2[3] * 57.2957795130823;
        dArray2[4] = dArray2[4] * 57.2957795130823;
        dArray2[5] = dArray[5];
    }

    public void swi_coortrf(double[] dArray, double[] dArray2, double d) {
        this.swi_coortrf(dArray, 0, dArray2, 0, d);
    }

    public void swi_coortrf(double[] dArray, int n, double[] dArray2, int n2, double d) {
        double[] dArray3 = new double[3];
        double d2 = SMath.sin(d);
        double d3 = SMath.cos(d);
        dArray3[0] = dArray[n];
        dArray3[1] = dArray[1 + n] * d3 + dArray[2 + n] * d2;
        dArray3[2] = -dArray[1 + n] * d2 + dArray[2 + n] * d3;
        dArray2[0 + n2] = dArray3[0];
        dArray2[1 + n2] = dArray3[1];
        dArray2[2 + n2] = dArray3[2];
    }

    public void swi_coortrf2(double[] dArray, double[] dArray2, double d, double d2) {
        this.swi_coortrf2(dArray, 0, dArray2, 0, d, d2);
    }

    public void swi_coortrf2(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) {
        double[] dArray3 = new double[]{dArray[0 + n], dArray[1 + n] * d2 + dArray[2 + n] * d, -dArray[1 + n] * d + dArray[2 + n] * d2};
        dArray2[0 + n2] = dArray3[0];
        dArray2[1 + n2] = dArray3[1];
        dArray2[2 + n2] = dArray3[2];
    }

    public void swi_cartpol(double[] dArray, double[] dArray2) {
        this.swi_cartpol(dArray, 0, dArray2, 0);
    }

    public void swi_cartpol(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[3];
        if (dArray[0 + n] == 0.0 && dArray[1 + n] == 0.0 && dArray[2 + n] == 0.0) {
            dArray2[2 + n2] = 0.0;
            dArray2[1 + n2] = 0.0;
            dArray2[0 + n2] = 0.0;
            return;
        }
        double d = dArray[0 + n] * dArray[0 + n] + dArray[1 + n] * dArray[1 + n];
        dArray3[2] = SMath.sqrt(d + dArray[2 + n] * dArray[2 + n]);
        d = SMath.sqrt(d);
        dArray3[0] = SMath.atan2(dArray[1 + n], dArray[0 + n]);
        if (dArray3[0] < 0.0) {
            dArray3[0] = dArray3[0] + Math.PI * 2;
        }
        dArray3[1] = SMath.atan(dArray[2 + n] / d);
        dArray2[0 + n2] = dArray3[0];
        dArray2[1 + n2] = dArray3[1];
        dArray2[2 + n2] = dArray3[2];
    }

    public void swi_polcart(double[] dArray, double[] dArray2) {
        this.swi_polcart(dArray, 0, dArray2, 0);
    }

    public void swi_polcart(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[3];
        double d = SMath.cos(dArray[n + 1]);
        dArray3[0] = dArray[n + 2] * d * SMath.cos(dArray[n]);
        dArray3[1] = dArray[n + 2] * d * SMath.sin(dArray[n]);
        dArray3[2] = dArray[n + 2] * SMath.sin(dArray[n + 1]);
        dArray2[n2] = dArray3[0];
        dArray2[n2 + 1] = dArray3[1];
        dArray2[n2 + 2] = dArray3[2];
    }

    public void swi_cartpol_sp(double[] dArray, double[] dArray2) {
        this.swi_cartpol_sp(dArray, 0, dArray2, 0);
    }

    public void swi_cartpol_sp(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        if (dArray[0 + n] == 0.0 && dArray[1 + n] == 0.0 && dArray[2 + n] == 0.0) {
            dArray2[4 + n2] = 0.0;
            dArray2[3 + n2] = 0.0;
            dArray2[1 + n2] = 0.0;
            dArray2[0 + n2] = 0.0;
            dArray2[5 + n2] = SMath.sqrt(this.square_sum(dArray, 3 + n));
            this.swi_cartpol(dArray, 3 + n, dArray2, 0 + n2);
            dArray2[2 + n2] = 0.0;
            return;
        }
        if (dArray[3 + n] == 0.0 && dArray[4 + n] == 0.0 && dArray[5 + n] == 0.0) {
            dArray2[5 + n2] = 0.0;
            dArray2[4 + n2] = 0.0;
            dArray2[3 + n2] = 0.0;
            this.swi_cartpol(dArray, n, dArray2, n2);
            return;
        }
        double d = dArray[0 + n] * dArray[0 + n] + dArray[1 + n] * dArray[1 + n];
        dArray4[2] = SMath.sqrt(d + dArray[2 + n] * dArray[2 + n]);
        d = SMath.sqrt(d);
        dArray4[0] = SMath.atan2(dArray[1 + n], dArray[0 + n]);
        if (dArray4[0] < 0.0) {
            dArray4[0] = dArray4[0] + Math.PI * 2;
        }
        dArray4[1] = SMath.atan(dArray[2 + n] / d);
        double d2 = dArray[0 + n] / d;
        double d3 = dArray[1 + n] / d;
        double d4 = d / dArray4[2];
        double d5 = dArray[2 + n] / dArray4[2];
        dArray3[3] = dArray[3 + n] * d2 + dArray[4 + n] * d3;
        dArray3[4] = -dArray[3 + n] * d3 + dArray[4 + n] * d2;
        dArray2[3 + n2] = dArray3[4] / d;
        dArray3[4] = -d5 * dArray3[3] + d4 * dArray[5 + n];
        dArray3[5] = d4 * dArray3[3] + d5 * dArray[5 + n];
        dArray2[4 + n2] = dArray3[4] / dArray4[2];
        dArray2[5 + n2] = dArray3[5];
        dArray2[0 + n2] = dArray4[0];
        dArray2[1 + n2] = dArray4[1];
        dArray2[2 + n2] = dArray4[2];
    }

    public void swi_polcart_sp(double[] dArray, double[] dArray2) {
        this.swi_polcart_sp(dArray, 0, dArray2, 0);
    }

    public void swi_polcart_sp(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[6];
        if (dArray[3 + n] == 0.0 && dArray[4 + n] == 0.0 && dArray[5 + n] == 0.0) {
            dArray2[5 + n2] = 0.0;
            dArray2[4 + n2] = 0.0;
            dArray2[3 + n2] = 0.0;
            this.swi_polcart(dArray, n, dArray2, n2);
            return;
        }
        double d = SMath.cos(dArray[0 + n]);
        double d2 = SMath.sin(dArray[0 + n]);
        double d3 = SMath.cos(dArray[1 + n]);
        double d4 = SMath.sin(dArray[1 + n]);
        dArray3[0] = dArray[2 + n] * d3 * d;
        dArray3[1] = dArray[2 + n] * d3 * d2;
        dArray3[2] = dArray[2 + n] * d4;
        double d5 = dArray[2 + n];
        double d6 = SMath.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1]);
        dArray3[5] = dArray[5 + n];
        dArray3[4] = dArray[4 + n] * d5;
        dArray2[5 + n2] = d4 * dArray3[5] + d3 * dArray3[4];
        dArray3[3] = d3 * dArray3[5] - d4 * dArray3[4];
        dArray3[4] = dArray[3 + n] * d6;
        dArray2[3 + n2] = d * dArray3[3] - d2 * dArray3[4];
        dArray2[4 + n2] = d2 * dArray3[3] + d * dArray3[4];
        dArray2[0 + n2] = dArray3[0];
        dArray2[1 + n2] = dArray3[1];
        dArray2[2 + n2] = dArray3[2];
    }

    public double swi_dot_prod_unit(double[] dArray, double[] dArray2) {
        double d = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
        double d2 = SMath.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d3 = SMath.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
        d /= d2;
        if ((d /= d3) > 1.0) {
            d = 1.0;
        }
        if (d < -1.0) {
            d = -1.0;
        }
        return d;
    }

    void swi_ldp_peps(double d, double[] dArray, double[] dArray2) {
        double d2;
        int n;
        int n2 = 4;
        int n3 = 10;
        double d3 = (d - 2451545.0) / 36525.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n = 0; n < n3; ++n) {
            d2 = Math.PI * 2 * d3;
            double d6 = d2 / peper[0][n];
            double d7 = SMath.sin(d6);
            double d8 = SMath.cos(d6);
            d4 += d8 * peper[1][n] + d7 * peper[3][n];
            d5 += d8 * peper[2][n] + d7 * peper[4][n];
        }
        d2 = 1.0;
        for (n = 0; n < n2; ++n) {
            d4 += pepol[n][0] * d2;
            d5 += pepol[n][1] * d2;
            d2 *= d3;
        }
        d4 *= 4.848136811095361E-6;
        d5 *= 4.848136811095361E-6;
        if (dArray != null && dArray.length > 0) {
            dArray[0] = d4;
        }
        if (dArray2 != null && dArray2.length > 0) {
            dArray2[0] = d5;
        }
    }

    private void pre_pecl(double d, double[] dArray) {
        double d2;
        double d3;
        double d4;
        double d5;
        int n;
        int n2 = 4;
        int n3 = 8;
        double d6 = (d - 2451545.0) / 36525.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (n = 0; n < n3; ++n) {
            d5 = Math.PI * 2 * d6;
            double d9 = d5 / pqper[0][n];
            d4 = SMath.sin(d9);
            d3 = SMath.cos(d9);
            d7 += d3 * pqper[1][n] + d4 * pqper[3][n];
            d8 += d3 * pqper[2][n] + d4 * pqper[4][n];
        }
        d5 = 1.0;
        for (n = 0; n < n2; ++n) {
            d7 += pqpol[n][0] * d5;
            d8 += pqpol[n][1] * d5;
            d5 *= d6;
        }
        d2 = (d2 = 1.0 - (d7 *= 4.848136811095361E-6) * d7 - (d8 *= 4.848136811095361E-6) * d8) < 0.0 ? 0.0 : SMath.sqrt(d2);
        d4 = SMath.sin(0.40909260060058295);
        d3 = SMath.cos(0.40909260060058295);
        dArray[0] = d7;
        dArray[1] = -d8 * d3 - d2 * d4;
        dArray[2] = -d8 * d4 + d2 * d3;
    }

    private void pre_pequ(double d, double[] dArray) {
        double d2;
        int n;
        int n2 = 4;
        int n3 = 14;
        double d3 = (d - 2451545.0) / 36525.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n = 0; n < n3; ++n) {
            d2 = Math.PI * 2 * d3;
            double d6 = d2 / xyper[0][n];
            double d7 = SMath.sin(d6);
            double d8 = SMath.cos(d6);
            d4 += d8 * xyper[1][n] + d7 * xyper[3][n];
            d5 += d8 * xyper[2][n] + d7 * xyper[4][n];
        }
        d2 = 1.0;
        for (n = 0; n < n2; ++n) {
            d4 += xypol[n][0] * d2;
            d5 += xypol[n][1] * d2;
            d2 *= d3;
        }
        dArray[0] = d4 *= 4.848136811095361E-6;
        dArray[1] = d5 *= 4.848136811095361E-6;
        d2 = d4 * d4 + d5 * d5;
        dArray[2] = d2 < 1.0 ? SMath.sqrt(1.0 - d2) : 0.0;
    }

    private void pre_pmat(double d, double[] dArray) {
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        this.pre_pequ(d, dArray2);
        this.pre_pecl(d, dArray3);
        this.swi_cross_prod(dArray2, 0, dArray3, 0, dArray4, 0);
        double d2 = SMath.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]);
        dArray5[0] = dArray4[0] / d2;
        dArray5[1] = dArray4[1] / d2;
        dArray5[2] = dArray4[2] / d2;
        this.swi_cross_prod(dArray2, 0, dArray5, 0, dArray4, 0);
        dArray[0] = dArray5[0];
        dArray[1] = dArray5[1];
        dArray[2] = dArray5[2];
        dArray[3] = dArray4[0];
        dArray[4] = dArray4[1];
        dArray[5] = dArray4[2];
        dArray[6] = dArray2[0];
        dArray[7] = dArray2[1];
        dArray[8] = dArray2[2];
    }

    double swi_epsiln(double d, int n) {
        double d2;
        int n2 = this.swed.astro_models[0];
        int n3 = this.swed.astro_models[1];
        int n4 = this.swed.astro_models[5];
        int n5 = this.swed.astro_models[6];
        if (n2 == 0) {
            n2 = 8;
        }
        if (n3 == 0) {
            n3 = 8;
        }
        if (n4 == 0) {
            n4 = 1;
        }
        if (n5 == 0) {
            n5 = 1;
        }
        double d3 = (d - 2451545.0) / 36525.0;
        if ((n & 0x40000) != 0) {
            d2 = (((0.001813 * d3 - 5.9E-4) * d3 - 46.815) * d3 + 84381.448) * 0.0174532925199433 / 3600.0;
        } else if ((n & 0x80000) != 0 && n5 != 1) {
            d2 = (((0.001813 * d3 - 5.9E-4) * d3 - 46.815) * d3 + 84381.448) * 0.0174532925199433 / 3600.0;
        } else if (n3 == 1 && SMath.abs(d3) <= 2.0) {
            d2 = (((0.001813 * d3 - 5.9E-4) * d3 - 46.815) * d3 + 84381.448) * 0.0174532925199433 / 3600.0;
        } else if (n2 == 1) {
            d2 = (((0.001813 * d3 - 5.9E-4) * d3 - 46.815) * d3 + 84381.448) * 0.0174532925199433 / 3600.0;
        } else if (n3 == 2 && SMath.abs(d3) <= 2.0) {
            d2 = (((0.001813 * d3 - 5.9E-4) * d3 - 46.84024) * d3 + 84381.406) * 0.0174532925199433 / 3600.0;
        } else if (n2 == 2) {
            d2 = (((0.001813 * d3 - 5.9E-4) * d3 - 46.84024) * d3 + 84381.406) * 0.0174532925199433 / 3600.0;
        } else if (n3 == 3 && SMath.abs(d3) <= 75.0) {
            d2 = (((((-4.34E-8 * d3 - 5.76E-7) * d3 + 0.0020034) * d3 - 1.831E-4) * d3 - 46.836769) * d3 + 84381.406) * 0.0174532925199433 / 3600.0;
        } else if (n2 == 3) {
            d2 = (((((-4.34E-8 * d3 - 5.76E-7) * d3 + 0.0020034) * d3 - 1.831E-4) * d3 - 46.836769) * d3 + 84381.406) * 0.0174532925199433 / 3600.0;
        } else if (n2 == 4) {
            d2 = ((((((-3.0E-11 * d3 - 2.48E-8) * d3 - 5.23E-7) * d3 + 0.00199911) * d3 - 1.667E-4) * d3 - 46.836051) * d3 + 84381.4088) * 0.0174532925199433 / 3600.0;
        } else if (n2 == 6) {
            d2 = (((((2.5E-8 * d3 - 5.1E-7) * d3 + 0.0019989) * d3 - 1.52E-4) * d3 - 46.80927) * d3 + 84381.412) * 0.0174532925199433 / 3600.0;
        } else if (n2 == 7) {
            d2 = ((((-1.0E-6 * d3 + 0.002) * d3 - 1.74E-4) * d3 - 46.83396) * d3 + 84381.409) * 0.0174532925199433 / 3600.0;
        } else if (n2 == 5) {
            d2 = (((((((((2.45E-10 * (d3 /= 10.0) + 5.79E-9) * d3 + 2.787E-7) * d3 + 7.12E-7) * d3 - 3.905E-5) * d3 - 0.0024967) * d3 - 0.005138) * d3 + 1.99925) * d3 - 0.0155) * d3 - 468.093) * d3 + 84381.448;
            d2 *= 4.848136811095361E-6;
        } else {
            double[] dArray = new double[1];
            this.swi_ldp_peps(d, null, dArray);
            d2 = dArray[0];
            if ((n & 0x80000) != 0 && n5 == 1) {
                double d4 = (d - 2437846.5) / 365.25;
                double d5 = 35.95;
                if (d4 < 0.0) {
                    d4 = 0.0;
                    d5 = this.dcor_eps_jpl[0];
                } else if (d4 >= 50.0) {
                    d4 = 51.0;
                    d5 = this.dcor_eps_jpl[50];
                } else {
                    double d6 = (int)d4;
                    double d7 = d6 + 1.0;
                    d5 = this.dcor_eps_jpl[(int)d6];
                    d5 = (d4 - d6) * (this.dcor_eps_jpl[(int)d6] - this.dcor_eps_jpl[(int)d7]) + this.dcor_eps_jpl[(int)d6];
                }
                d2 += (d5 /= 3600000.0) * 0.0174532925199433;
            }
        }
        return d2;
    }

    private int precess_1(double[] dArray, double d, int n, int n2) {
        return this.precess_1(dArray, 0, d, n, n2);
    }

    private int precess_1(double[] dArray, int n, double d, int n2, int n3) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray2 = new double[3];
        if (d == 2451545.0) {
            return 0;
        }
        double d5 = (d - 2451545.0) / 36525.0;
        if (n3 == 1) {
            d2 = ((0.017998 * d5 + 0.30188) * d5 + 2306.2181) * d5 * 0.0174532925199433 / 3600.0;
            d3 = ((0.018203 * d5 + 1.09468) * d5 + 2306.2181) * d5 * 0.0174532925199433 / 3600.0;
            d4 = ((-0.041833 * d5 - 0.42665) * d5 + 2004.3109) * d5 * 0.0174532925199433 / 3600.0;
        } else if (n3 == 2) {
            d2 = (((((-2.0E-7 * d5 - 3.27E-5) * d5 + 0.0179663) * d5 + 0.3019015) * d5 + 2306.0809506) * d5 + 2.5976176) * 0.0174532925199433 / 3600.0;
            d3 = (((((-3.0E-7 * d5 - 4.7E-5) * d5 + 0.0182237) * d5 + 1.094779) * d5 + 2306.0803226) * d5 - 2.5976176) * 0.0174532925199433 / 3600.0;
            d4 = ((((-1.0E-7 * d5 - 6.01E-5) * d5 - 0.0418251) * d5 - 0.4269353) * d5 + 2004.1917476) * d5 * 0.0174532925199433 / 3600.0;
        } else if (n3 == 3) {
            d5 = (d - 2451545.0) / 36525.0;
            d2 = (((((-3.173E-7 * d5 - 5.971E-6) * d5 + 0.01801828) * d5 + 0.2988499) * d5 + 2306.083227) * d5 + 2.650545) * 0.0174532925199433 / 3600.0;
            d3 = (((((-2.904E-7 * d5 - 2.8596E-5) * d5 + 0.01826837) * d5 + 1.0927348) * d5 + 2306.077181) * d5 - 2.650545) * 0.0174532925199433 / 3600.0;
            d4 = ((((-1.1274E-7 * d5 - 7.089E-6) * d5 - 0.04182264) * d5 - 0.4294934) * d5 + 2004.191903) * d5 * 0.0174532925199433 / 3600.0;
        } else if (n3 == 4) {
            d2 = ((((((-1.3E-10 * d5 - 3.04E-7) * d5 - 5.708E-6) * d5 + 0.01801752) * d5 + 0.3023262) * d5 + 2306.080472) * d5 + 2.72767) * 0.0174532925199433 / 3600.0;
            d3 = ((((((-5.0E-11 * d5 - 2.486E-7) * d5 - 2.8276E-5) * d5 + 0.01826676) * d5 + 1.0956768) * d5 + 2306.07607) * d5 - 2.72767) * 0.0174532925199433 / 3600.0;
            d4 = ((((((9.0E-12 * d5 + 3.6E-10) * d5 - 1.127E-7) * d5 - 7.291E-6) * d5 - 0.04182364) * d5 - 0.426698) * d5 + 2004.190936) * d5 * 0.0174532925199433 / 3600.0;
        } else {
            return 0;
        }
        double d6 = SMath.sin(d4);
        double d7 = SMath.cos(d4);
        double d8 = SMath.sin(d2);
        double d9 = SMath.cos(d2);
        double d10 = SMath.sin(d3);
        double d11 = SMath.cos(d3);
        double d12 = d9 * d7;
        double d13 = d8 * d7;
        if (n2 < 0) {
            dArray2[0] = (d12 * d11 - d8 * d10) * dArray[0 + n] - (d13 * d11 + d9 * d10) * dArray[1 + n] - d6 * d11 * dArray[2 + n];
            dArray2[1] = (d12 * d10 + d8 * d11) * dArray[0 + n] - (d13 * d10 - d9 * d11) * dArray[1 + n] - d6 * d10 * dArray[2 + n];
            dArray2[2] = d9 * d6 * dArray[0 + n] - d8 * d6 * dArray[1 + n] + d7 * dArray[2 + n];
        } else {
            dArray2[0] = (d12 * d11 - d8 * d10) * dArray[0 + n] + (d12 * d10 + d8 * d11) * dArray[1 + n] + d9 * d6 * dArray[2 + n];
            dArray2[1] = -(d13 * d11 + d9 * d10) * dArray[0 + n] - (d13 * d10 - d9 * d11) * dArray[1 + n] - d8 * d6 * dArray[2 + n];
            dArray2[2] = -d6 * d11 * dArray[0 + n] - d6 * d10 * dArray[1 + n] + d7 * dArray[2 + n];
        }
        for (int i = 0; i < 3; ++i) {
            dArray[i + n] = dArray2[i];
        }
        return 0;
    }

    private int precess_2(double[] dArray, double d, int n, int n2, int n3) {
        return this.precess_2(dArray, 0, d, n, n2, n3);
    }

    private int precess_2(double[] dArray, int n, double d, int n2, int n3, int n4) {
        int n5;
        double[] dArray2 = new double[3];
        int n6 = 0;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        if (d == 2451545.0) {
            return 0;
        }
        if (n4 == 5) {
            dArray3 = this.pAcof_laskar;
            dArray5 = this.nodecof_laskar;
            dArray4 = this.inclcof_laskar;
        } else if (n4 == 6) {
            dArray3 = this.pAcof_simon;
            dArray5 = this.nodecof_simon;
            dArray4 = this.inclcof_simon;
        } else if (n4 == 7) {
            dArray3 = this.pAcof_williams;
            dArray5 = this.nodecof_williams;
            dArray4 = this.inclcof_williams;
        } else {
            dArray3 = this.pAcof_laskar;
            dArray5 = this.nodecof_laskar;
            dArray4 = this.inclcof_laskar;
        }
        double d2 = (d - 2451545.0) / 36525.0;
        double d3 = n3 == 1 ? this.swi_epsiln(d, n2) : this.swi_epsiln(2451545.0, n2);
        double d4 = SMath.sin(d3);
        double d5 = SMath.cos(d3);
        dArray2[0] = dArray[0 + n];
        double d6 = d5 * dArray[1 + n] + d4 * dArray[2 + n];
        dArray2[2] = -d4 * dArray[1 + n] + d5 * dArray[2 + n];
        dArray2[1] = d6;
        d2 /= 10.0;
        n6 = 0;
        double d7 = dArray3[n6];
        ++n6;
        for (n5 = 0; n5 < 9; ++n5) {
            d7 = d7 * d2 + dArray3[n6];
            ++n6;
        }
        d7 *= 4.848136811095361E-6 * d2;
        n6 = 0;
        double d8 = dArray5[n6];
        ++n6;
        for (n5 = 0; n5 < 10; ++n5) {
            d8 = d8 * d2 + dArray5[n6];
            ++n6;
        }
        d6 = n3 == 1 ? d8 + d7 : d8;
        double d9 = SMath.cos(d6);
        double d10 = SMath.sin(d6);
        d6 = d9 * dArray2[0] + d10 * dArray2[1];
        dArray2[1] = -d10 * dArray2[0] + d9 * dArray2[1];
        dArray2[0] = d6;
        n6 = 0;
        d6 = dArray4[n6];
        ++n6;
        for (n5 = 0; n5 < 10; ++n5) {
            d6 = d6 * d2 + dArray4[n6];
            ++n6;
        }
        if (n3 == 1) {
            d6 = -d6;
        }
        d9 = SMath.cos(d6);
        d10 = SMath.sin(d6);
        d6 = d9 * dArray2[1] + d10 * dArray2[2];
        dArray2[2] = -d10 * dArray2[1] + d9 * dArray2[2];
        dArray2[1] = d6;
        d6 = n3 == 1 ? -d8 : -d8 - d7;
        d9 = SMath.cos(d6);
        d10 = SMath.sin(d6);
        d6 = d9 * dArray2[0] + d10 * dArray2[1];
        dArray2[1] = -d10 * dArray2[0] + d9 * dArray2[1];
        dArray2[0] = d6;
        d3 = n3 == 1 ? this.swi_epsiln(2451545.0, n2) : this.swi_epsiln(d, n2);
        d4 = SMath.sin(d3);
        d5 = SMath.cos(d3);
        d6 = d5 * dArray2[1] - d4 * dArray2[2];
        dArray2[2] = d4 * dArray2[1] + d5 * dArray2[2];
        dArray2[1] = d6;
        for (n5 = 0; n5 < 3; ++n5) {
            dArray[n5 + n] = dArray2[n5];
        }
        return 0;
    }

    private int precess_3(double[] dArray, double d, int n, int n2) {
        return this.precess_3(dArray, 0, d, n, n2);
    }

    private int precess_3(double[] dArray, int n, double d, int n2, int n3) {
        int n4;
        int n5;
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[9];
        if (d == 2451545.0) {
            return 0;
        }
        double d2 = (d - 2451545.0) / 36525.0;
        this.pre_pmat(d, dArray3);
        if (n2 == -1) {
            n5 = 0;
            n4 = 0;
            while (n5 <= 2) {
                dArray2[n5] = dArray[0 + n] * dArray3[n4 + 0] + dArray[1 + n] * dArray3[n4 + 1] + dArray[2 + n] * dArray3[n4 + 2];
                n4 = ++n5 * 3;
            }
        } else {
            n5 = 0;
            n4 = 0;
            while (n5 <= 2) {
                dArray2[n5] = dArray[0 + n] * dArray3[n5 + 0] + dArray[1 + n] * dArray3[n5 + 3] + dArray[2 + n] * dArray3[n5 + 6];
                n4 = ++n5 * 3;
            }
        }
        for (n5 = 0; n5 < 3; ++n5) {
            dArray[n5 + n] = dArray2[n5];
        }
        return 0;
    }

    int swi_precess(double[] dArray, double d, int n, int n2) {
        return this.swi_precess(dArray, 0, d, n, n2);
    }

    int swi_precess(double[] dArray, int n, double d, int n2, int n3) {
        double d2 = (d - 2451545.0) / 36525.0;
        int n4 = this.swed.astro_models[0];
        int n5 = this.swed.astro_models[1];
        int n6 = this.swed.astro_models[5];
        if (n4 == 0) {
            n4 = 8;
        }
        if (n5 == 0) {
            n5 = 8;
        }
        if (n6 == 0) {
            n6 = 1;
        }
        if ((n2 & 0x40000) != 0) {
            return this.precess_1(dArray, n, d, n3, 1);
        }
        if (n5 == 1 && SMath.abs(d2) <= 2.0) {
            return this.precess_1(dArray, n, d, n3, 1);
        }
        if (n4 == 1) {
            return this.precess_1(dArray, n, d, n3, 1);
        }
        if (n5 == 2 && SMath.abs(d2) <= 2.0) {
            return this.precess_1(dArray, n, d, n3, 2);
        }
        if (n4 == 2) {
            return this.precess_1(dArray, n, d, n3, 2);
        }
        if (n5 == 3 && SMath.abs(d2) <= 75.0) {
            return this.precess_1(dArray, n, d, n3, 3);
        }
        if (n4 == 3) {
            return this.precess_1(dArray, n, d, n3, 3);
        }
        if (n4 == 4) {
            return this.precess_1(dArray, n, d, n3, 4);
        }
        if (n4 == 5) {
            return this.precess_2(dArray, n, d, n2, n3, 5);
        }
        if (n4 == 6) {
            return this.precess_2(dArray, n, d, n2, n3, 6);
        }
        return this.precess_3(dArray, n, d, n3, 8);
    }

    private int swi_nutation_iau1980(double d, double[] dArray) {
        double d2;
        double d3;
        double d4;
        double d5;
        int n;
        double[][] dArray2 = new double[5][8];
        double[][] dArray3 = new double[5][8];
        double[] dArray4 = new double[5];
        int[] nArray = new int[5];
        int n2 = this.swed.astro_models[2];
        if (n2 == 0) {
            n2 = 4;
        }
        double d6 = (d - 2451545.0) / 36525.0;
        double d7 = d6 * d6;
        double d8 = -6962890.539 * d6 + 450160.28 + (0.008 * d6 + 7.455) * d7;
        d8 = this.swe_degnorm(d8 / 3600.0) * 0.0174532925199433;
        double d9 = 1.29596581224E8 * d6 + 1287099.804 - (0.012 * d6 + 0.577) * d7;
        d9 = this.swe_degnorm(d9 / 3600.0) * 0.0174532925199433;
        double d10 = 1.717915922633E9 * d6 + 485866.733 + (0.064 * d6 + 31.31) * d7;
        d10 = this.swe_degnorm(d10 / 3600.0) * 0.0174532925199433;
        double d11 = 1.739527263137E9 * d6 + 335778.877 + (0.011 * d6 - 13.257) * d7;
        d11 = this.swe_degnorm(d11 / 3600.0) * 0.0174532925199433;
        double d12 = 1.602961601328E9 * d6 + 1072261.307 + (0.019 * d6 - 6.891) * d7;
        d12 = this.swe_degnorm(d12 / 3600.0) * 0.0174532925199433;
        dArray4[0] = d10;
        nArray[0] = 3;
        dArray4[1] = d9;
        nArray[1] = 2;
        dArray4[2] = d11;
        nArray[2] = 4;
        dArray4[3] = d12;
        nArray[3] = 4;
        dArray4[4] = d8;
        nArray[4] = 2;
        for (n = 0; n <= 4; ++n) {
            double d13 = dArray4[n];
            int n3 = nArray[n];
            d5 = SMath.sin(d13);
            d4 = SMath.cos(d13);
            dArray2[n][0] = d5;
            dArray3[n][0] = d4;
            d3 = 2.0 * d5 * d4;
            d2 = d4 * d4 - d5 * d5;
            dArray2[n][1] = d3;
            dArray3[n][1] = d2;
            for (int i = 2; i < n3; ++i) {
                double d14 = d5 * d2 + d4 * d3;
                d2 = d4 * d2 - d5 * d3;
                dArray2[n][i] = d3 = d14;
                dArray3[n][i] = d2;
            }
        }
        double d15 = (-0.01742 * d6 - 17.1996) * dArray2[4][0];
        double d16 = (8.9E-4 * d6 + 9.2025) * dArray3[4][0];
        int n4 = 0;
        while (nt[n4] != -99) {
            if (n2 == 2 || nt[n4] != 101 && nt[n4] != 102) {
                boolean bl = false;
                d2 = 0.0;
                d3 = 0.0;
                for (int i = 0; i < 5; ++i) {
                    int n5 = nt[n4 + i];
                    if (n5 > 100) {
                        n5 = 0;
                    }
                    if (n5 == 0) continue;
                    n = n5;
                    if (n5 < 0) {
                        n = -n;
                    }
                    d5 = dArray2[i][n - 1];
                    if (n5 < 0) {
                        d5 = -d5;
                    }
                    d4 = dArray3[i][n - 1];
                    if (!bl) {
                        d3 = d5;
                        d2 = d4;
                        bl = true;
                        continue;
                    }
                    double d17 = d5 * d2 + d4 * d3;
                    d2 = d4 * d2 - d5 * d3;
                    d3 = d17;
                }
                double d18 = (double)nt[n4 + 5] * 1.0E-4;
                if (nt[n4 + 6] != 0) {
                    d18 += 1.0E-5 * d6 * (double)nt[n4 + 6];
                }
                double d19 = (double)nt[n4 + 7] * 1.0E-4;
                if (nt[n4 + 8] != 0) {
                    d19 += 1.0E-5 * d6 * (double)nt[n4 + 8];
                }
                if (nt[n4] >= 100) {
                    d18 *= 0.1;
                    d19 *= 0.1;
                }
                if (nt[n4] != 102) {
                    d15 += d18 * d3;
                    d16 += d19 * d2;
                } else {
                    d15 += d18 * d2;
                    d16 += d19 * d3;
                }
            }
            n4 += 9;
        }
        dArray[0] = 0.0174532925199433 * d15 / 3600.0;
        dArray[1] = 0.0174532925199433 * d16 / 3600.0;
        return 0;
    }

    private int swi_nutation_iau2000ab(double d, double[] dArray) {
        int n;
        double d2;
        double d3;
        double d4;
        int n2;
        int n3;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = (d - 2451545.0) / 36525.0;
        int n4 = this.swed.astro_models[2];
        if (n4 == 0) {
            n4 = 4;
        }
        double d8 = this.swe_degnorm((485868.249036 + d7 * (1.7179159232178E9 + d7 * (31.8792 + d7 * (0.051635 + d7 * -2.447E-4)))) / 3600.0) * 0.0174532925199433;
        double d9 = this.swe_degnorm((1287104.79305 + d7 * (1.295965810481E8 + d7 * (-0.5532 + d7 * (1.36E-4 + d7 * -1.149E-5)))) / 3600.0) * 0.0174532925199433;
        double d10 = this.swe_degnorm((335779.526232 + d7 * (1.7395272628478E9 + d7 * (-12.7512 + d7 * (-0.001037 + d7 * 4.17E-6)))) / 3600.0) * 0.0174532925199433;
        double d11 = this.swe_degnorm((1072260.70369 + d7 * (1.602961601209E9 + d7 * (-6.3706 + d7 * (0.006593 + d7 * -3.169E-5)))) / 3600.0) * 0.0174532925199433;
        double d12 = this.swe_degnorm((450160.398036 + d7 * (-6962890.5431 + d7 * (7.4722 + d7 * (0.007702 + d7 * -5.939E-5)))) / 3600.0) * 0.0174532925199433;
        int n5 = n4 == 4 ? 77 : 678;
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            n2 = n3 * 5;
            d4 = this.swe_radnorm((double)Swenut2000aNls.nls[n2 + 0] * d8 + (double)Swenut2000aNls.nls[n2 + 1] * d9 + (double)Swenut2000aNls.nls[n2 + 2] * d10 + (double)Swenut2000aNls.nls[n2 + 3] * d11 + (double)Swenut2000aNls.nls[n2 + 4] * d12);
            d3 = SMath.sin(d4);
            d2 = SMath.cos(d4);
            n = n3 * 6;
            d5 += ((double)Swenut2000a_cls.cls[n + 0] + (double)Swenut2000a_cls.cls[n + 1] * d7) * d3 + (double)Swenut2000a_cls.cls[n + 2] * d2;
            d6 += ((double)Swenut2000a_cls.cls[n + 3] + (double)Swenut2000a_cls.cls[n + 4] * d7) * d2 + (double)Swenut2000a_cls.cls[n + 5] * d3;
        }
        dArray[0] = d5 * 2.7777777777777777E-11;
        dArray[1] = d6 * 2.7777777777777777E-11;
        if (n4 == 3) {
            double d13 = this.swe_radnorm(2.35555598 + 8328.6914269554 * d7);
            double d14 = this.swe_radnorm(6.24006013 + 628.301955 * d7);
            double d15 = this.swe_radnorm(1.627905234 + 8433.466158131 * d7);
            double d16 = this.swe_radnorm(5.198466741 + 7771.3771468121 * d7);
            double d17 = this.swe_radnorm(2.1824392 - 33.757045 * d7);
            double d18 = this.swe_radnorm(4.402608842 + 2608.7903141574 * d7);
            double d19 = this.swe_radnorm(3.176146697 + 1021.3285546211 * d7);
            double d20 = this.swe_radnorm(1.753470314 + 628.3075849991 * d7);
            double d21 = this.swe_radnorm(6.203480913 + 334.06124267 * d7);
            double d22 = this.swe_radnorm(0.599546497 + 52.9690962641 * d7);
            double d23 = this.swe_radnorm(0.874016757 + 21.329910496 * d7);
            double d24 = this.swe_radnorm(5.481293871 + 7.4781598567 * d7);
            double d25 = this.swe_radnorm(5.321159 + 3.8127774 * d7);
            double d26 = (0.02438175 + 5.38691E-6 * d7) * d7;
            d5 = 0.0;
            d6 = 0.0;
            for (n3 = 686; n3 >= 0; --n3) {
                n2 = n3 * 14;
                d4 = this.swe_radnorm((double)Swenut2000a_npl.npl[n2 + 0] * d13 + (double)Swenut2000a_npl.npl[n2 + 1] * d14 + (double)Swenut2000a_npl.npl[n2 + 2] * d15 + (double)Swenut2000a_npl.npl[n2 + 3] * d16 + (double)Swenut2000a_npl.npl[n2 + 4] * d17 + (double)Swenut2000a_npl.npl[n2 + 5] * d18 + (double)Swenut2000a_npl.npl[n2 + 6] * d19 + (double)Swenut2000a_npl.npl[n2 + 7] * d20 + (double)Swenut2000a_npl.npl[n2 + 8] * d21 + (double)Swenut2000a_npl.npl[n2 + 9] * d22 + (double)Swenut2000a_npl.npl[n2 + 10] * d23 + (double)Swenut2000a_npl.npl[n2 + 11] * d24 + (double)Swenut2000a_npl.npl[n2 + 12] * d25 + (double)Swenut2000a_npl.npl[n2 + 13] * d26);
                n = n3 * 4;
                d3 = SMath.sin(d4);
                d2 = SMath.cos(d4);
                d5 += (double)Swenut2000a.icpl[n + 0] * d3 + (double)Swenut2000a.icpl[n + 1] * d2;
                d6 += (double)Swenut2000a.icpl[n + 2] * d3 + (double)Swenut2000a.icpl[n + 3] * d2;
            }
            dArray[0] = dArray[0] + d5 * 2.7777777777777777E-11;
            dArray[1] = dArray[1] + d6 * 2.7777777777777777E-11;
            d5 = -8.1 * SMath.sin(d12) - 0.6 * SMath.sin(2.0 * d10 - 2.0 * d11 + 2.0 * d12);
            d6 = d7 * (-25.6 * SMath.cos(d12) - 1.6 * SMath.cos(2.0 * d10 - 2.0 * d11 + 2.0 * d12));
            dArray[0] = dArray[0] + (d5 += d7 * (47.8 * SMath.sin(d12) + 3.7 * SMath.sin(2.0 * d10 - 2.0 * d11 + 2.0 * d12) + 0.6 * SMath.sin(2.0 * d10 + 2.0 * d12) - 0.6 * SMath.sin(2.0 * d12))) / 3.6E9;
            dArray[1] = dArray[1] + d6 / 3.6E9;
        }
        dArray[0] = dArray[0] * 0.0174532925199433;
        dArray[1] = dArray[1] * 0.0174532925199433;
        return 0;
    }

    private double bessel(double[] dArray, int n, double d) {
        int n2;
        double[] dArray2 = new double[6];
        if (d <= 0.0) {
            double d2 = dArray[0];
            return d2;
        }
        if (d >= (double)(n - 1)) {
            double d3 = dArray[n - 1];
            return d3;
        }
        double d4 = SMath.floor(d);
        int n3 = (int)d;
        double d5 = dArray[n3];
        int n4 = n3 + 1;
        if (n4 >= n) {
            return d5;
        }
        d4 = d - d4;
        d5 += d4 * (dArray[n4] - dArray[n3]);
        if (n3 - 1 < 0 || n3 + 2 >= n) {
            return d5;
        }
        n4 = n3 - 2;
        for (n2 = 0; n2 < 5; ++n2) {
            dArray2[n2] = n4 < 0 || n4 + 1 >= n ? 0.0 : dArray[n4 + 1] - dArray[n4];
            ++n4;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            dArray2[n2] = dArray2[n2 + 1] - dArray2[n2];
        }
        double d6 = 0.25 * d4 * (d4 - 1.0);
        d5 += d6 * (dArray2[1] + dArray2[2]);
        if (n3 + 2 >= n) {
            return d5;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            dArray2[n2] = dArray2[n2 + 1] - dArray2[n2];
        }
        d6 = 2.0 * d6 / 3.0;
        d5 += (d4 - 0.5) * d6 * dArray2[1];
        if (n3 - 2 < 0 || n3 + 3 > n) {
            return d5;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            dArray2[n2] = dArray2[n2 + 1] - dArray2[n2];
        }
        d6 = 0.125 * d6 * (d4 + 1.0) * (d4 - 2.0);
        return d5 += d6 * (dArray2[0] + dArray2[1]);
    }

    int swi_nutation(double d, int n, double[] dArray) {
        int n2 = this.swed.astro_models[2];
        int n3 = this.swed.astro_models[5];
        int n4 = this.swed.astro_models[6];
        if (n2 == 0) {
            n2 = 4;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        if (n4 == 0) {
            n4 = 1;
        }
        if ((n & 0x40000) != 0) {
            this.swi_nutation_iau1980(d, dArray);
        } else if (n2 == 1 || n2 == 2) {
            this.swi_nutation_iau1980(d, dArray);
        } else if (n2 == 3 || n2 == 4) {
            this.swi_nutation_iau2000ab(d, dArray);
            if ((n & 0x80000) != 0 && n4 != 1) {
                dArray[0] = dArray[0] + -2.0253091528350866E-7;
                dArray[1] = dArray[1] + -3.306041454222148E-8;
            }
        }
        if ((n & 0x40000) != 0) {
            int n5 = (int)(this.swed.eop_tjd_end - this.swed.eop_tjd_beg + 1.0E-6);
            double d2 = d;
            if (d < this.swed.eop_tjd_beg_horizons) {
                d2 = this.swed.eop_tjd_beg_horizons;
            }
            double d3 = this.bessel(this.swed.dpsi, n5 + 1, d2 - this.swed.eop_tjd_beg);
            double d4 = this.bessel(this.swed.deps, n5 + 1, d2 - this.swed.eop_tjd_beg);
            dArray[0] = dArray[0] + d3 / 3600.0 * 0.0174532925199433;
            dArray[1] = dArray[1] + d4 / 3600.0 * 0.0174532925199433;
        }
        return 0;
    }

    private void swi_approx_jplhor(double[] dArray, double d, int n, boolean bl) {
        double d2 = (d - 2437846.5) / 365.25;
        double d3 = -52.3;
        int n2 = this.swed.astro_models[5];
        int n3 = this.swed.astro_models[6];
        if (n2 == 0) {
            n2 = 1;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        if ((n & 0x80000) == 0) {
            return;
        }
        if (n3 != 1) {
            return;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
            d3 = this.dcor_ra_jpl[0];
        } else if (d2 >= 50.0) {
            d2 = 51.0;
            d3 = this.dcor_ra_jpl[50];
        } else {
            double d4 = (int)d2;
            double d5 = d4 + 1.0;
            d3 = this.dcor_ra_jpl[(int)d4];
            d3 = (d2 - d4) * (this.dcor_ra_jpl[(int)d4] - this.dcor_ra_jpl[(int)d5]) + this.dcor_ra_jpl[(int)d4];
        }
        this.swi_cartpol(dArray, dArray);
        dArray[0] = bl ? dArray[0] - d3 * 0.0174532925199433 : dArray[0] + (d3 /= 3600000.0) * 0.0174532925199433;
        this.swi_polcart(dArray, dArray);
    }

    void swi_bias(double[] dArray, double d, int n, boolean bl) {
        int n2;
        double[] dArray2 = new double[6];
        double[][] dArray3 = new double[3][3];
        int n3 = this.swed.astro_models[4];
        int n4 = this.swed.astro_models[5];
        int n5 = this.swed.astro_models[6];
        if (n3 == 0) {
            n3 = 2;
        }
        if (n4 == 0) {
            n4 = 1;
        }
        if (n5 == 0) {
            n5 = 1;
        }
        if ((n & 0x80000) != 0 && n5 != 1) {
            return;
        }
        if (n3 == 2) {
            dArray3[0][0] = 0.9999999999999941;
            dArray3[1][0] = -7.078368961E-8;
            dArray3[2][0] = 8.056213978E-8;
            dArray3[0][1] = 7.078368695E-8;
            dArray3[1][1] = 0.999999999999997;
            dArray3[2][1] = 3.306428553E-8;
            dArray3[0][2] = -8.056214212E-8;
            dArray3[1][2] = -3.306427981E-8;
            dArray3[2][2] = 0.9999999999999963;
        } else {
            dArray3[0][0] = 0.9999999999999942;
            dArray3[1][0] = -7.07827974E-8;
            dArray3[2][0] = 8.05621715E-8;
            dArray3[0][1] = 7.07827948E-8;
            dArray3[1][1] = 0.9999999999999969;
            dArray3[2][1] = 3.30604145E-8;
            dArray3[0][2] = -8.05621738E-8;
            dArray3[1][2] = -3.30604088E-8;
            dArray3[2][2] = 0.9999999999999962;
        }
        if (bl) {
            this.swi_approx_jplhor(dArray, d, n, true);
            for (n2 = 0; n2 <= 2; ++n2) {
                dArray2[n2] = dArray[0] * dArray3[n2][0] + dArray[1] * dArray3[n2][1] + dArray[2] * dArray3[n2][2];
                if ((n & 0x100) == 0) continue;
                dArray2[n2 + 3] = dArray[3] * dArray3[n2][0] + dArray[4] * dArray3[n2][1] + dArray[5] * dArray3[n2][2];
            }
        } else {
            for (n2 = 0; n2 <= 2; ++n2) {
                dArray2[n2] = dArray[0] * dArray3[0][n2] + dArray[1] * dArray3[1][n2] + dArray[2] * dArray3[2][n2];
                if ((n & 0x100) == 0) continue;
                dArray2[n2 + 3] = dArray[3] * dArray3[0][n2] + dArray[4] * dArray3[1][n2] + dArray[5] * dArray3[2][n2];
            }
            this.swi_approx_jplhor(dArray2, d, n, false);
        }
        for (n2 = 0; n2 <= 2; ++n2) {
            dArray[n2] = dArray2[n2];
        }
        if ((n & 0x100) != 0) {
            for (n2 = 3; n2 <= 5; ++n2) {
                dArray[n2] = dArray2[n2];
            }
        }
    }

    void swi_icrs2fk5(double[] dArray, int n, boolean bl) {
        int n2;
        double[] dArray2 = new double[6];
        double[][] dArray3 = new double[3][3];
        dArray3[0][0] = 0.9999999999999928;
        dArray3[0][1] = 1.110223287E-7;
        dArray3[0][2] = 4.41180557E-8;
        dArray3[1][0] = -1.11022333E-7;
        dArray3[1][1] = 0.9999999999999891;
        dArray3[1][2] = 9.64779176E-8;
        dArray3[2][0] = -4.4118045E-8;
        dArray3[2][1] = -9.64779225E-8;
        dArray3[2][2] = 0.9999999999999943;
        if (bl) {
            for (n2 = 0; n2 <= 2; ++n2) {
                dArray2[n2] = dArray[0] * dArray3[n2][0] + dArray[1] * dArray3[n2][1] + dArray[2] * dArray3[n2][2];
                if ((n & 0x100) == 0) continue;
                dArray2[n2 + 3] = dArray[3] * dArray3[n2][0] + dArray[4] * dArray3[n2][1] + dArray[5] * dArray3[n2][2];
            }
        } else {
            for (n2 = 0; n2 <= 2; ++n2) {
                dArray2[n2] = dArray[0] * dArray3[0][n2] + dArray[1] * dArray3[1][n2] + dArray[2] * dArray3[2][n2];
                if ((n & 0x100) == 0) continue;
                dArray2[n2 + 3] = dArray[3] * dArray3[0][n2] + dArray[4] * dArray3[1][n2] + dArray[5] * dArray3[2][n2];
            }
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            dArray[n2] = dArray2[n2];
        }
    }

    private double sidtime_long_term(double d, double d2, double d3) {
        double d4 = 0.0;
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[2];
        double d5 = 0.005775518331089533;
        d2 *= 57.2957795130823;
        d3 *= 57.2957795130823;
        double d6 = d + SweDate.getDeltaT(d);
        double d7 = (d6 - 2451545.0) / 365250.0;
        double d8 = d7 * d7;
        double d9 = d7 * d8;
        double d10 = d7 * d9;
        double d11 = d7 * d10;
        double d12 = d7 * d11;
        double d13 = 100.46645683 + (1.29597742283429E9 * d7 - 2.04411 * d8 - 0.00523 * d9) / 3600.0;
        d13 = this.swe_degnorm(d13 - d5 * 360.0 / 365.2425);
        dArray[0] = d13 * 0.0174532925199433;
        dArray[1] = 0.0;
        dArray[2] = 1.0;
        dArray2[0] = 23.45;
        dArray2[1] = 23.45;
        dArray2[1] = this.swi_epsiln(2451545.0 + SweDate.getDeltaT(2451545.0), 0) * 57.2957795130823;
        this.swi_polcart(dArray, dArray);
        this.swi_coortrf(dArray, dArray, -dArray2[1] * 0.0174532925199433);
        this.swi_precess(dArray, d6, 0, -1);
        dArray2[1] = this.swi_epsiln(d6, 0) * 57.2957795130823;
        this.swi_nutation(d6, 0, dArray3);
        dArray2[0] = dArray2[1] + dArray3[1] * 57.2957795130823;
        dArray2[2] = dArray3[0] * 57.2957795130823;
        this.swi_coortrf(dArray, dArray, dArray2[1] * 0.0174532925199433);
        this.swi_cartpol(dArray, dArray);
        dArray[0] = dArray[0] * 57.2957795130823;
        double d14 = (d - 0.5) % 1.0 * 360.0;
        dArray[0] = d2 == 0.0 ? dArray[0] + dArray2[2] * SMath.cos(dArray2[0] * 0.0174532925199433) : dArray[0] + d3 * SMath.cos(d2 * 0.0174532925199433);
        dArray[0] = this.swe_degnorm(dArray[0] + d14);
        d4 = dArray[0] / 15.0;
        return d4;
    }

    public int swi_cutstr(String string, String string2, String[] stringArray, int n) {
        int n2;
        if (string.indexOf(10) >= 0) {
            string = string.substring(0, string.indexOf(10));
        }
        if (string.indexOf(13) >= 0) {
            string = string.substring(0, string.indexOf(13));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        for (n2 = 0; stringTokenizer.hasMoreTokens() && n2 < 20; ++n2) {
            String string3 = stringTokenizer.nextToken();
            while (string3.endsWith("\\") && stringTokenizer.hasMoreTokens()) {
                string3 = string3.substring(0, string3.length() - 1) + stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                string3 = string3 + stringTokenizer.nextToken();
            }
            stringArray[n2] = string3;
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken();
        }
        stringArray[19] = "";
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[19] = stringArray[19] + stringTokenizer.nextToken();
        }
        if (n2 < n) {
            stringArray[n2] = null;
        }
        return n2;
    }

    private double sidtime_non_polynomial_part(double d) {
        double[] dArray = new double[]{this.swe_radnorm(2.35555598 + 8328.6914269554 * d), this.swe_radnorm(6.24006013 + 628.301955 * d), this.swe_radnorm(1.627905234 + 8433.466158131 * d), this.swe_radnorm(5.198466741 + 7771.3771468121 * d), this.swe_radnorm(2.1824392 - 33.757045 * d), this.swe_radnorm(4.402608842 + 2608.7903141574 * d), this.swe_radnorm(3.176146697 + 1021.3285546211 * d), this.swe_radnorm(1.753470314 + 628.3075849991 * d), this.swe_radnorm(6.203480913 + 334.06124267 * d), this.swe_radnorm(0.599546497 + 52.9690962641 * d), this.swe_radnorm(0.874016757 + 21.329910496 * d), this.swe_radnorm(5.481293871 + 7.4781598567 * d), this.swe_radnorm(5.321159 + 3.8127774 * d), (0.02438175 + 5.38691E-6 * d) * d};
        double d2 = -0.87 * SMath.sin(dArray[4]) * d;
        for (int i = 0; i < 33; ++i) {
            double d3 = 0.0;
            for (int j = 0; j < 14; ++j) {
                d3 += (double)stfarg[i * 14 + j] * dArray[j];
            }
            d2 += this.stcf[i * 2] * SMath.sin(d3) + this.stcf[i * 2 + 1] * SMath.cos(d3);
        }
        return d2 /= 3.6E9;
    }

    public double swe_sidtime0(double d, double d2, double d3) {
        double d4;
        int n = this.swed.astro_models[1];
        int n2 = this.swed.astro_models[3];
        if (n == 0) {
            n = 8;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (n2 == 1 && (d <= 2396758.5 || d >= 2469807.5)) {
            double d5 = this.sidtime_long_term(d, d2, d3);
            if (d <= 2396758.5) {
                d5 -= 0.0021885756666666666;
            } else if (d >= 2469807.5) {
                d5 -= -0.0043595532666666666;
            }
            if (d5 >= 24.0) {
                d5 -= 24.0;
            }
            if (d5 < 0.0) {
                d5 += 24.0;
            }
            return d5;
        }
        double d6 = d;
        double d7 = SMath.floor(d6);
        double d8 = d - d7;
        if (d8 < 0.5) {
            d7 -= 0.5;
            d8 += 0.5;
        } else {
            d7 += 0.5;
            d8 -= 0.5;
        }
        d8 *= 86400.0;
        double d9 = (d7 - 2451545.0) / 36525.0;
        if (n2 == 2) {
            double d10 = d - 2451545.0;
            double d11 = (d + SweDate.getDeltaT(d) - 2451545.0) / 36525.0;
            d4 = this.swe_degnorm((0.779057273264 + 1.0027378119113546 * d10) * 360.0);
            d4 += (0.014506 + d11 * (4612.156534 + d11 * (1.3915817 + d11 * (-4.4E-7 + d11 * (-2.9956E-5 + d11 * -3.68E-8))))) / 3600.0;
            double d12 = this.sidtime_non_polynomial_part(d11);
            d4 = this.swe_degnorm(d4 + d12);
            d4 = d4 / 15.0 * 3600.0;
        } else if (n >= 3) {
            double d13 = (d7 + SweDate.getDeltaT(d7) - 2451545.0) / 36525.0;
            d4 = (((-2.454E-9 * d13 - 1.99708E-6) * d13 - 2.926E-7) * d13 + 0.09277211) * d13 * d13 + 307.4771013 * (d13 - d9) + 8640184.79447825 * d9 + 24110.5493771;
            double d14 = 1.0 + ((((-1.227E-8 * d13 - 7.98832E-6) * d13 - 8.778E-7) * d13 + 0.18554422) * d13 + 8640184.79447825) / 3.15576E9;
            d4 += d14 * d8;
        } else {
            d4 = ((-6.2E-6 * d9 + 0.093104) * d9 + 8640184.812866) * d9 + 24110.54841;
            double d15 = 1.0 + ((-1.86E-5 * d9 + 0.186208) * d9 + 8640184.812866) / 3.15576E9;
            d4 += d15 * d8;
        }
        double d16 = 240.0 * d3 * SMath.cos(d2 * 0.0174532925199433);
        d4 += d16;
        d4 -= 86400.0 * SMath.floor(d4 / 86400.0);
        return d4 /= 3600.0;
    }

    public double swe_sidtime(double d) {
        double[] dArray = new double[2];
        double d2 = d + SweDate.getDeltaT(d);
        double d3 = this.swi_epsiln(d2, 0) * 57.2957795130823;
        this.swi_nutation(d2, 0, dArray);
        int n = 0;
        while (n < 2) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 57.2957795130823;
        }
        double d4 = this.swe_sidtime0(d, d3 + dArray[1], dArray[0]);
        return d4;
    }

    public static String swi_gen_filename(SweDate sweDate, int n) {
        return SwissLib.swi_gen_filename(sweDate.getJulDay(), n);
    }

    public static String swi_gen_filename(double d, int n) {
        String string;
        int n2 = 6;
        switch (n) {
            case 1: {
                string = "semo";
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "sepl";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "seas";
                break;
            }
            default: {
                String string2 = "00000" + (n - 10000);
                string2 = string2.substring(string2.length() - 6);
                String string3 = "s";
                if (n - 10000 <= 99999) {
                    string2 = string2.substring(1);
                    string3 = "se";
                }
                String string4 = "ast" + (n - 10000) / 1000 + SwissData.DIR_GLUE + string3 + string2 + "." + "se1";
                return string4;
            }
        }
        SweDate sweDate = new SweDate(d);
        if (sweDate.getJulDay() >= 2305447.5) {
            sweDate.setCalendarType(true, false);
        } else {
            sweDate.setCalendarType(false, false);
        }
        int n3 = sweDate.getYear();
        int n4 = n3 < 0 ? -1 : 1;
        int n5 = n3 / 100;
        if (n4 < 0 && n3 % 100 != 0) {
            --n5;
        }
        while (n5 % n2 != 0) {
            --n5;
        }
        string = n5 < 0 ? string + "m" : string + "_";
        n5 = SMath.abs(n5);
        string = string + (n5 < 10 ? "0" : "") + n5 + "." + "se1";
        return string;
    }

    public void swe_split_deg(double d, int n, IntObj intObj, IntObj intObj2, IntObj intObj3, DblObj dblObj, IntObj intObj4) {
        double d2 = 0.0;
        intObj4.val = 1;
        if (d < 0.0) {
            intObj4.val = -1;
            d = -d;
        }
        if ((n & 4) != 0) {
            d2 = 0.5;
        } else if ((n & 2) != 0) {
            d2 = 0.008333333333333333;
        } else if ((n & 1) != 0) {
            d2 = 1.388888888888889E-4;
        }
        if ((n & 0x20) != 0) {
            if ((int)(d + d2) - (int)d > 0) {
                d2 = 0.0;
            }
        } else if ((n & 0x10) != 0 && d % 30.0 + d2 >= 30.0) {
            d2 = 0.0;
        }
        d += d2;
        if ((n & 8) != 0) {
            intObj4.val = (int)(d / 30.0);
            d %= 30.0;
        }
        intObj.val = (int)d;
        intObj2.val = (int)((d -= (double)intObj.val) * 60.0);
        intObj3.val = (int)((d -= (double)intObj2.val / 60.0) * 3600.0);
        if ((n & 7) == 0) {
            dblObj.val = d * 3600.0 - (double)intObj3.val;
        }
    }

    public double swi_kepler(double d, double d2, double d3) {
        double d4 = 1.0;
        if (d3 < 0.4) {
            while (d4 > 1.0E-12) {
                double d5 = d;
                d = d2 + d3 * SMath.sin(d5);
                d4 = SMath.abs(d - d5);
            }
        } else {
            while (d4 > 1.0E-12) {
                double d6 = d;
                double d7 = (d2 + d3 * SMath.sin(d6) - d6) / (1.0 - d3 * SMath.cos(d6));
                d4 = SMath.abs(d7);
                if (d4 < 0.01) {
                    d = d6 + d7;
                    continue;
                }
                d = this.swi_mod2PI(d6 + d7);
                d4 = SMath.abs(d - d6);
            }
        }
        return d;
    }

    public void swe_set_astro_models(int[] nArray) {
        this.swed.astro_models = nArray;
    }

    public void swi_FK4_FK5(double[] dArray, double d) {
        if (dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            return;
        }
        this.swi_cartpol(dArray, dArray);
        dArray[0] = dArray[0] + (0.035 + 0.085 * (d - 2433282.42345905) / 36524.2198782) / 3600.0 * 15.0 * 0.0174532925199433;
        dArray[3] = dArray[3] + 1.6924042333443586E-10;
        this.swi_polcart(dArray, dArray);
    }

    public void swi_FK5_FK4(double[] dArray, double d) {
        if (dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            return;
        }
        this.swi_cartpol(dArray, dArray);
        dArray[0] = dArray[0] - (0.035 + 0.085 * (d - 2433282.42345905) / 36524.2198782) / 3600.0 * 15.0 * 0.0174532925199433;
        dArray[3] = dArray[3] - 1.6924042333443586E-10;
        this.swi_polcart(dArray, dArray);
    }

    String swi_strcpy(String string, String string2) {
        return string2;
    }

    String swi_strncpy(String string, String string2, int n) {
        return string2.substring(0, Math.min(string2.length(), n));
    }

    public int swe_d2l(double d) {
        if (d >= 0.0) {
            return (int)(d + 0.5);
        }
        return -((int)(0.5 - d));
    }

    public double swe_difdeg2n(double d, double d2) {
        double d3 = this.swe_degnorm(d - d2);
        if (d3 >= 180.0) {
            return d3 - 360.0;
        }
        return d3;
    }

    public double swe_difrad2n(double d, double d2) {
        double d3 = this.swe_radnorm(d - d2);
        if (d3 >= Math.PI) {
            return d3 - Math.PI * 2;
        }
        return d3;
    }

    public static synchronized double atof(String string) {
        int n;
        string = string.trim();
        for (n = 0; n < string.length() && (Character.isDigit(string.charAt(n)) || string.charAt(n) == '.'); ++n) {
        }
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0 || string2.replace('.', ' ').trim().length() == 0) {
            return 0.0;
        }
        return Double.valueOf(string2);
    }

    public static synchronized int atoi(String string) {
        int n;
        string = string.trim();
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0 || string2.replace('.', ' ').trim().length() == 0) {
            return 0;
        }
        return Integer.valueOf(string2);
    }
}

