/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import swisseph.SMath;
import swisseph.SwissEph;
import swisseph.SwissephException;
import swisseph.TransitBase;
import swisseph.TransitCalculator;

public class TCHouses
extends TransitCalculator
implements Serializable {
    private int houseObject;
    private double geolon;
    private double geolat;
    private int hsys;
    private int idx = 0;
    private int tflags = 0;
    private int flags = 0;
    private double min = 0.0;
    private double max = 0.0;
    private double offset = 0.0;
    double minVal = 0.0;
    double maxVal = 0.0;

    public TCHouses(SwissEph swissEph, int n, int n2, double d, double d2, int n3, double d3) {
        this.houseObject = n;
        this.geolon = d;
        this.geolat = d2;
        this.tflags = n3;
        int n4 = 229383;
        if ((n3 & ~n4) != 0) {
            throw new IllegalArgumentException("Invalid flag(s): " + (n3 & ~n4));
        }
        int n5 = n3 & 0x20000;
        if (n5 != 131072 && n5 != 0) {
            throw new IllegalArgumentException("Invalid flag '" + n3 + "': specify exactly one of SEFLG_TRANSIT_LONGITUDE (" + 131072 + ").");
        }
        int n6 = n & 0xFFFFFFFF;
        if (n6 != -1 && n6 != -2 && n6 != -3 && n6 != -4 && n6 != -5 && n6 != -6 && n6 != -7 && n6 != -8 && n6 != -9 && n6 != -10 && n6 != -11 && n6 != -12 && n6 != 0 && n6 != 1 && n6 != 2 && n6 != 3 && n6 != 4 && n6 != 5 && n6 != 6 && n6 != 7) {
            throw new IllegalArgumentException("Invalid or multiple objects given: " + n6);
        }
        if (n2 != 80 && n2 != 75 && n2 != 79 && n2 != 82 && n2 != 67 && n2 != 69 && n2 != 86 && n2 != 88 && n2 != 72 && n2 != 84 && n2 != 66 && n2 != 77 && n2 != 85 && n2 != 87) {
            throw new IllegalArgumentException("Unsupported house system '" + n2 + "'.");
        }
        this.hsys = n2;
        this.sw = swissEph;
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        this.flags = n3 &= 0xFFFDFFFF;
        this.rollover = true;
        this.offset = this.checkOffset(d3);
        this.max = TransitBase.getHouseSpeed(false, n2, n6, d2);
        this.min = TransitBase.getHouseSpeed(true, n2, n6, d2);
        if (Double.isInfinite(this.max) || Double.isInfinite(this.min)) {
            throw new IllegalArgumentException(((n3 & 0x8000) != 0 ? "Topo" : ((n3 & 8) != 0 ? "Helio" : "Geo")) + "centric transit calculations of " + SwissEph.getHouseobjectname(n) + " not possible: extreme speeds of the object not available.");
        }
        if (this.max == 0.0 && this.min == 0.0) {
            throw new IllegalArgumentException("Transit calculation of " + SwissEph.getHouseobjectname(n) + " on latitude of " + d2 + " with house system '" + n2 + "' not possible.");
        }
    }

    @Override
    public boolean getRollover() {
        return this.rollover;
    }

    @Override
    public void setOffset(double d) {
        this.offset = this.checkOffset(d);
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    public void setGeopos(double d, double d2) {
        this.geolon = d;
        this.geolat = d2;
    }

    public double getLongitude() {
        return this.geolon;
    }

    public double getLatitude() {
        return this.geolat;
    }

    @Override
    public Object[] getObjectIdentifiers() {
        return new Integer[]{this.houseObject};
    }

    @Override
    protected double calc(double d) {
        double[] dArray = new double[this.hsys == 71 ? 37 : 13];
        double[] dArray2 = new double[10];
        this.sw.swe_set_topo(this.geolon, this.geolat, 0.0);
        int n = this.sw.swe_houses(d, this.flags, this.geolat, this.geolon, this.hsys, dArray, dArray2);
        if (n < 0) {
            throw new SwissephException(d, 0, "Calculation failed with return code " + n + ".");
        }
        if (this.houseObject < 0) {
            return dArray[Math.abs(this.houseObject)];
        }
        return dArray2[this.houseObject];
    }

    @Override
    protected double getMaxSpeed() {
        return this.max;
    }

    @Override
    protected double getMinSpeed() {
        return this.min;
    }

    @Override
    protected double getTimePrecision(double d) {
        double d2 = SMath.max(SMath.abs(this.min), SMath.abs(this.max));
        if (d2 != 0.0) {
            return d / d2;
        }
        return 1.0E-9;
    }

    @Override
    protected double getDegreePrecision(double d) {
        double d2 = 0.5;
        d2 /= 3600.0;
        return d2 *= 0.5;
    }

    private double checkOffset(double d) {
        if (this.rollover) {
            while (d < 0.0) {
                d += 360.0;
            }
            d %= 360.0;
            this.minVal = 0.0;
            this.maxVal = 360.0;
        } else if (this.idx == 1) {
            while (d < -90.0) {
                d += 180.0;
            }
            while (d > 90.0) {
                d -= 180.0;
            }
            this.minVal = -90.0;
            this.maxVal = 90.0;
        }
        return d;
    }

    public String toString() {
        return "TCHouses [Object:" + this.houseObject + "];Offset:" + this.getOffset();
    }
}

