/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import swisseph.SMath;
import swisseph.SwissEph;
import swisseph.SwissephException;

public abstract class TransitCalculator
implements Serializable {
    SwissEph sw;
    protected boolean rollover = false;
    protected double rolloverVal = 360.0;

    public abstract boolean getRollover();

    public double getRolloverVal() {
        return this.rolloverVal;
    }

    public double getMinOffset() {
        return 0.0;
    }

    public double getMaxOffset() {
        return 360.0;
    }

    public abstract void setOffset(double var1);

    public abstract double getOffset();

    public Object[] getObjectIdentifiers() {
        return null;
    }

    protected abstract double getMaxSpeed();

    protected abstract double getMinSpeed();

    protected abstract double getDegreePrecision(double var1);

    protected abstract double getTimePrecision(double var1);

    protected abstract double calc(double var1);

    double preprocessDate(double d, boolean bl) {
        return d;
    }

    protected boolean checkIdenticalResult(double d, double d2) {
        return d2 == d;
    }

    protected boolean checkResult(double d, double d2, double d3, boolean bl, boolean bl2) {
        return bl && d3 <= d && !bl2 || !bl && d3 >= d && bl2 || this.rollover && (d < d2 && d3 > 0.9 * this.rolloverVal && d2 < 20.0 && !bl2 || d > d2 && d3 < 20.0 && d2 > 0.9 * this.rolloverVal && bl2 || d > d3 && d3 > 0.9 * this.rolloverVal && d2 < 20.0 && !bl2 || d < d3 && d3 < 20.0 && d2 > 0.9 * this.rolloverVal && bl2);
    }

    protected double getNextJD(double d, double d2, double d3, double d4, double d5, boolean bl) {
        double d6 = 0.0;
        double d7 = 0.0;
        if (this.rollover) {
            d6 = SMath.min(d2 - d3, this.rolloverVal - d2 + d3) / SMath.abs(d5);
            d7 = SMath.min(d2 - d3, this.rolloverVal - d2 + d3) / SMath.abs(d4);
            d = bl ? (d -= SMath.min(d6, d7)) : (d += SMath.min(d6, d7));
        } else {
            d6 = (d3 - d2) / d5;
            d7 = (d3 - d2) / d4;
            if (bl) {
                if (d6 >= 0.0 && d7 >= 0.0) {
                    throw new SwissephException(d, 3072, -1, "No transit in ephemeris time range.");
                }
                d = d6 >= 0.0 ? (d += d7) : (d += d6);
            } else {
                if (d6 <= 0.0 && d7 <= 0.0) {
                    throw new SwissephException(d, 3072, -1, "No transit in ephemeris time range.");
                }
                d = d6 <= 0.0 ? (d += d7) : (d += d6);
            }
        }
        return d;
    }
}

