/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.datechooser;

import de.jaret.util.date.JaretDate;
import de.jaret.util.date.holidayenumerator.HolidayEnumerator;
import de.jaret.util.ui.datechooser.DateChooserPanel;
import de.jaret.util.ui.datechooser.IAdditionalDayInformationProvider;
import de.jaret.util.ui.datechooser.IDateChooserListener;
import de.jaret.util.ui.datechooser.IFieldIdentifier;
import de.jaret.util.ui.datechooser.TimeChooser;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DateChooser
extends Composite
implements FocusListener,
IDateChooserListener {
    public static final int KEEP_AND_MARK = 0;
    public static final int RESET_TO_LASTVALID = 1;
    public static final int RESET_TO_NULL = 2;
    public static final Color MARKER_COLOR = Display.getCurrent().getSystemColor(3);
    protected static final int MOUSEWHEEL_DIVISOR = 3;
    protected int _invalidInputBehaviour = 0;
    protected boolean _editable = true;
    private boolean _enabled = true;
    private boolean _selectAllOnFocusGained = true;
    private boolean _textfieldMouseWheelEnable = true;
    protected List<IDateChooserListener> _listenerList;
    protected Date _date = new Date();
    protected DateFormat _dateformat;
    protected Locale _locale;
    protected Text _textField;
    protected Button _dropdownButton;
    protected Shell _dropDownShell;
    protected boolean _dropped = false;
    boolean _goingToDropDown = false;
    protected DateChooserPanel _chooserPanel;
    protected HolidayEnumerator _holidayEnumerator;
    protected IAdditionalDayInformationProvider _dayInformationProvider;
    protected IFieldIdentifier _fieldIdentifier;
    private Color _textfieldBGColor;
    private boolean _hasFocus = false;
    protected TimeChooser _timeChooser;
    protected boolean _hasValidInput = true;

    public DateChooser(Composite parent, int style, Locale locale) {
        super(parent, style);
        this._locale = locale;
        this._dateformat = DateFormat.getDateInstance(2, this._locale);
        this._dateformat.setLenient(false);
        this.createControls();
        this.updateTextField(this._date);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DateChooser.this.onDispose();
            }
        });
    }

    public DateChooser(Composite parent, int style) {
        this(parent, style, Locale.getDefault());
    }

    public DateFormat getDateFormat() {
        return this._dateformat;
    }

    public void setDateFormat(DateFormat dateformat) {
        this._dateformat = dateformat;
        this.updateTextField(this._date);
    }

    private void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this._textField = new Text((Composite)this, 133120);
        GridData gd = new GridData(768);
        this._textField.setLayoutData((Object)gd);
        this._textField.addFocusListener((FocusListener)this);
        this._textfieldBGColor = this._textField.getBackground();
        this._textField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if ((keyEvent.stateMask & 0x40000) != 0 && keyEvent.keyCode == 32) {
                    DateChooser.this.setDropped(!DateChooser.this.isDropped());
                    keyEvent.doit = false;
                } else if (keyEvent.keyCode == 13) {
                    DateChooser.this._textField.traverse(16);
                } else if (keyEvent.keyCode == 0x1000001) {
                    DateChooser.this.rollField(1);
                    keyEvent.doit = false;
                } else if (keyEvent.keyCode == 0x1000002) {
                    DateChooser.this.rollField(-1);
                    keyEvent.doit = false;
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 37: {
                        int count = -event.count / 3;
                        if (!DateChooser.this._textfieldMouseWheelEnable) break;
                        DateChooser.this.rollField(count);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported event");
                    }
                }
            }
        };
        this.addListener(37, listener);
        this._dropdownButton = new Button((Composite)this, 1028);
        gd = new GridData();
        this._dropdownButton.setLayoutData((Object)gd);
        this._dropdownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DateChooser.this.setDropped(!DateChooser.this.isDropped());
            }
        });
    }

    public void onDispose() {
        if (this._dropDownShell != null) {
            this._dropDownShell.dispose();
        }
    }

    private void rollField(int delta) {
        if (this._fieldIdentifier != null && this.validateInput()) {
            int caretpos = this._textField.getCaretPosition();
            int field = this._fieldIdentifier.getField(this._textField.getText(), caretpos);
            if (field != -1) {
                GregorianCalendar cal = new GregorianCalendar(this._locale);
                cal.setTime(this._date);
                ((Calendar)cal).roll(field, delta);
                this.setDate(cal.getTime());
            }
        }
    }

    public boolean isDropped() {
        return this._dropped;
    }

    public void setDropped(boolean dropped) {
        if (dropped != this._dropped) {
            this._dropped = dropped;
            if (this._dropped && this._editable && this._enabled) {
                if (this._dropDownShell == null) {
                    this._dropDownShell = this.createDropDown();
                }
                this._goingToDropDown = true;
                this._chooserPanel.setDate(this.getDate());
                Point size = this._dropdownButton.getSize();
                Point dispLocation = this.toDisplay(this._dropdownButton.getLocation());
                Point dropDownSize = this._dropDownShell.computeSize(-1, -1);
                int dsWidth = dropDownSize.x;
                int dsHeight = dropDownSize.y;
                int locx = dispLocation.x + size.x - dsWidth;
                int locy = dispLocation.y + size.y + 3;
                if (locx < 0) {
                    locx = 0;
                } else if (locx + dsWidth > Display.getCurrent().getBounds().width) {
                    locx = Display.getCurrent().getBounds().width - dsWidth;
                }
                if (locy + dsHeight > Display.getCurrent().getBounds().height) {
                    locy = dispLocation.y - dsHeight - 3;
                }
                this._dropDownShell.setLocation(locx, locy);
                this._dropDownShell.setSize(dsWidth, dsHeight);
                this._dropDownShell.pack();
                this._dropDownShell.layout(true);
                this._dropDownShell.setVisible(true);
                this._dropDownShell.setActive();
                this._chooserPanel.forceFocus();
                this.resetMark();
            } else if (this._dropDownShell != null) {
                this._dropDownShell.setVisible(false);
                this._goingToDropDown = false;
                this._textField.setFocus();
            }
        }
    }

    private Shell createDropDown() {
        Shell dropDown = new Shell(this.getShell(), 2056);
        dropDown.setLayout((Layout)new FillLayout());
        this._chooserPanel = new DateChooserPanel((Composite)dropDown, 2048, false, true, this._locale);
        this._chooserPanel.setDate(this.getDate());
        this._chooserPanel.addDateChooserListener(this);
        this._chooserPanel.setHolidayEnumerator(this._holidayEnumerator);
        this._chooserPanel.setAdditionalDayInformationProvider(this._dayInformationProvider);
        this._chooserPanel.setBackground(this.getBackground());
        this._chooserPanel.addFocusListener(this);
        dropDown.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent event) {
                DateChooser.this.setDropped(false);
            }
        });
        return dropDown;
    }

    private Date correctTime(Date date) {
        if (this._timeChooser != null) {
            JaretDate d = new JaretDate(date);
            JaretDate time = new JaretDate(this._timeChooser.getDateInternal());
            d.setHours(time.getHours());
            d.setMinutes(time.getMinutes());
            date = d.getDate();
        }
        return date;
    }

    public Date getDate() {
        this._date = this.correctTime(this._date);
        return this._date;
    }

    protected Date getDateInternal() {
        return this._date;
    }

    public void setDate(Date date) {
        this._date = date;
        this.updateTextField(this._date);
    }

    private void updateTextField(Date date) {
        if (date != null) {
            int caretpos = this._textField.getCaretPosition();
            this._textField.setText(this._dateformat.format(date));
            this._textField.setSelection(caretpos, caretpos);
        } else {
            this._textField.setText("");
        }
    }

    public void setText(String text) {
        this._textField.setText(text);
    }

    public void selectAll() {
        this._textField.selectAll();
    }

    public void setSelection(int pos) {
        this._textField.setSelection(pos);
    }

    public void clearSelection() {
        this._textField.clearSelection();
    }

    public void cut() {
        this._textField.cut();
    }

    public void copy() {
        this._textField.copy();
    }

    public void paste() {
        this._textField.paste();
    }

    public boolean setFocus() {
        super.setFocus();
        return this._textField.setFocus();
    }

    public boolean forceFocus() {
        return this._textField.forceFocus();
    }

    public Text getTextField() {
        return this._textField;
    }

    public HolidayEnumerator getHolidayEnumerator() {
        return this._holidayEnumerator;
    }

    public void setHolidayEnumerator(HolidayEnumerator holidayEnumerator) {
        this._holidayEnumerator = holidayEnumerator;
        if (this._chooserPanel != null) {
            this._chooserPanel.setHolidayEnumerator(this._holidayEnumerator);
        }
    }

    public IAdditionalDayInformationProvider getAdditionalDayInformationProvider() {
        return this._dayInformationProvider;
    }

    public void setAdditionalDayInformationProvider(IAdditionalDayInformationProvider dayInformationProvider) {
        this._dayInformationProvider = dayInformationProvider;
        if (this._chooserPanel != null) {
            this._chooserPanel.setAdditionalDayInformationProvider(dayInformationProvider);
        }
    }

    public void dateChosen(Date date) {
        this.setDate(this._chooserPanel.getDate());
        this.setDropped(false);
        this.fireDateChosen(this.correctTime(date));
    }

    public void choosingCanceled() {
        this.updateTextField(this._date);
        this.setDropped(false);
        this.fireChoosingCanceled();
    }

    public void dateIntermediateChange(Date date) {
        this.updateTextField(date);
        this.fireIntermediateChange(this.correctTime(date));
    }

    public void inputInvalid() {
    }

    public void focusGained(FocusEvent evt) {
        if (evt.widget.equals(this._textField) && this._selectAllOnFocusGained) {
            this._textField.selectAll();
        }
        if (!this._hasFocus) {
            this._hasFocus = true;
            super.notifyListeners(15, new Event());
        }
    }

    public void focusLost(FocusEvent evt) {
        this.validateInput();
        if (Display.getCurrent().getCursorControl() == this._dropdownButton) {
            this._goingToDropDown = true;
        }
        if (this._hasFocus && !this._goingToDropDown) {
            this._hasFocus = false;
            super.notifyListeners(16, new Event());
        }
    }

    public boolean validateInput() {
        boolean valid = false;
        String text = this._textField.getText();
        Date date = null;
        try {
            date = this._dateformat.parse(text);
            valid = true;
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (date != null) {
            this.setDate(date);
            this.resetMark();
        } else {
            switch (this._invalidInputBehaviour) {
                case 0: {
                    this.setMark();
                    break;
                }
                case 1: {
                    this.updateTextField(this._date);
                    break;
                }
                case 2: {
                    this.setDate(null);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid InputBehaviour set");
                }
            }
        }
        if (!valid && this._hasValidInput) {
            this._hasValidInput = valid;
            this.fireInputInvalid();
        }
        this._hasValidInput = valid;
        return valid;
    }

    private void resetMark() {
        this._textField.setBackground(this._textfieldBGColor);
    }

    private void setMark() {
        this._textField.setBackground(MARKER_COLOR);
    }

    public int getInvalidInputBehaviour() {
        return this._invalidInputBehaviour;
    }

    public void setInvalidInputBehaviour(int invalidInputBehaviour) {
        this._invalidInputBehaviour = invalidInputBehaviour;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this._textField.setEditable(editable);
        this.setDropped(false);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._enabled = enabled;
        this._textField.setEnabled(enabled);
        this._dropdownButton.setEnabled(enabled);
        this.setDropped(false);
    }

    public void setOneClickSelection(boolean oneClick) {
        if (this._dropDownShell == null) {
            this._dropDownShell = this.createDropDown();
        }
        this._chooserPanel.setOneClickSelection(oneClick);
    }

    public boolean isOneClickSelection() {
        if (this._dropDownShell == null) {
            this._dropDownShell = this.createDropDown();
        }
        return this._chooserPanel.isOneClickSelection();
    }

    public DateChooserPanel getDateChooserPanel() {
        if (this._dropDownShell == null) {
            this._dropDownShell = this.createDropDown();
        }
        return this._chooserPanel;
    }

    public void addDateChooserListener(IDateChooserListener listener) {
        if (this._listenerList == null) {
            this._listenerList = new ArrayList<IDateChooserListener>();
        }
        this._listenerList.add(listener);
    }

    public void remDateChooserListener(IDateChooserListener listener) {
        if (this._listenerList == null) {
            return;
        }
        this._listenerList.remove(listener);
    }

    protected void fireDateChosen(Date date) {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.dateChosen(date);
            }
        }
    }

    protected void fireIntermediateChange(Date date) {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.dateIntermediateChange(date);
            }
        }
    }

    protected void fireChoosingCanceled() {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.choosingCanceled();
            }
        }
    }

    protected void fireInputInvalid() {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.inputInvalid();
            }
        }
    }

    public boolean isSelectAllOnFocusGained() {
        return this._selectAllOnFocusGained;
    }

    public void setSelectAllOnFocusGained(boolean selectAllOnFocusGained) {
        this._selectAllOnFocusGained = selectAllOnFocusGained;
    }

    public IFieldIdentifier getFieldIdentifier() {
        return this._fieldIdentifier;
    }

    public void setFieldIdentifier(IFieldIdentifier fieldIdentifier) {
        this._fieldIdentifier = fieldIdentifier;
    }

    public boolean isTextfieldMouseWheelEnable() {
        return this._textfieldMouseWheelEnable;
    }

    public void setTextfieldMouseWheelEnable(boolean mouseWheelEnable) {
        this._textfieldMouseWheelEnable = mouseWheelEnable;
    }

    public TimeChooser getTimeChooser() {
        return this._timeChooser;
    }

    public void setTimeChooser(TimeChooser timeChooser) {
        this._timeChooser = timeChooser;
    }
}

