/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.datechooser;

import de.jaret.util.date.JaretDate;
import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.datechooser.IDateChooserListener;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TimeChooserPanel
extends Composite
implements MouseListener {
    protected Date _date;
    protected static final Color MARKERCOLOR = Display.getCurrent().getSystemColor(9);
    protected TimeGrid _timeGrid;
    protected List<IDateChooserListener> _listenerList;
    protected int _columnWidth;
    protected int _rowHeight;

    public TimeChooserPanel(Composite parent, int style) {
        super(parent, style);
        this.createControls();
        this.setDate(new Date());
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                TimeChooserPanel.this.handleKeyPressed(event);
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                block0 : switch (event.type) {
                    case 37: {
                        int count = -event.count / 3;
                        int colIdx = event.x / TimeChooserPanel.this._columnWidth;
                        switch (colIdx) {
                            case 0: {
                                TimeChooserPanel.this.rollAMPM(count);
                                break block0;
                            }
                            case 1: {
                                TimeChooserPanel.this.rollHours(count);
                                break block0;
                            }
                            case 2: {
                                TimeChooserPanel.this.rollMinutes(count);
                                break block0;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported event");
                    }
                }
            }
        };
        this.addListener(37, listener);
    }

    public void dispose() {
        super.dispose();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this._timeGrid.setBackground(color);
    }

    private void handleKeyPressed(KeyEvent event) {
        if ((event.stateMask & 0x20000) != 0) {
            switch (event.keyCode) {
                case 0x1000002: {
                    this.rollMinutes(1);
                    break;
                }
                case 0x1000001: {
                    this.rollMinutes(-1);
                    break;
                }
            }
        } else {
            switch (event.keyCode) {
                case 27: {
                    this.fireChoosingCanceled();
                    break;
                }
                case 13: {
                    this.fireDateChosen(this.getDate());
                    break;
                }
                case 0x1000002: {
                    this.rollHours(1);
                    break;
                }
                case 0x1000001: {
                    this.rollHours(-1);
                    break;
                }
            }
        }
    }

    private void intermediateChange() {
        this.redraw();
        this.fireIntermediateChange(this.getDate());
        this.forceFocus();
    }

    public void setDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        if (!date.equals(this._date)) {
            this._date = date;
            this.redraw();
        }
    }

    public Date getDate() {
        return this._date;
    }

    public void redraw() {
        super.redraw();
        this._timeGrid.redraw();
    }

    private void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this._timeGrid = new TimeGrid(this, 0);
        GridData gd = new GridData(1808);
        this._timeGrid.setLayoutData(gd);
        this._timeGrid.addMouseListener(this);
        this._timeGrid.setBackground(this.getBackground());
    }

    public void mouseDoubleClick(MouseEvent event) {
        boolean success = this.setTimeByLocation(event.x, event.y);
        if (success) {
            this.fireDateChosen(this.getDate());
        }
    }

    private boolean setTimeByLocation(int x, int y) {
        int colIdx = x / this._columnWidth;
        int rowIdx = y / this._rowHeight;
        boolean success = false;
        JaretDate d = new JaretDate(this._date);
        switch (colIdx) {
            case 0: {
                if (rowIdx == 0) {
                    success = true;
                    if (d.getHours() < 12) break;
                    d.setHours(d.getHours() - 12);
                    break;
                }
                if (rowIdx != 1) break;
                success = true;
                if (d.getHours() >= 12) break;
                d.setHours(d.getHours() + 12);
                break;
            }
            case 1: {
                int h = d.getHours() < 12 ? rowIdx : rowIdx + 12;
                d.setHours(h);
                success = true;
                break;
            }
            case 2: {
                int min = rowIdx * 5;
                d.setMinutes(min);
                success = true;
                break;
            }
            default: {
                success = false;
            }
        }
        if (success) {
            this.redraw();
            this._date = d.getDate();
        }
        return success;
    }

    private void rollMinutes(int count) {
        JaretDate d = new JaretDate(this._date);
        if (count < 0 && d.getMinutes() > 0) {
            int m = d.getMinutes() + count * 5;
            m = m < 0 ? 0 : m;
            d.setMinutes(m);
            this._date = d.getDate();
            this.fireIntermediateChange(this._date);
            this.redraw();
        } else if (count > 0 && d.getMinutes() < 59) {
            int m = d.getMinutes() + count * 5;
            m = m > 55 ? 55 : m;
            d.setMinutes(m);
            this._date = d.getDate();
            this.fireIntermediateChange(this._date);
            this.redraw();
        }
    }

    private void rollHours(int count) {
        JaretDate d = new JaretDate(this._date);
        if (count < 0 && d.getHours() > 0) {
            int h = d.getHours() + count;
            h = h < 0 ? 0 : h;
            d.setHours(h);
            this._date = d.getDate();
            this.fireIntermediateChange(this._date);
            this.redraw();
        } else if (count > 0 && d.getHours() < 23) {
            int h = d.getHours() + count;
            h = h > 23 ? 23 : h;
            d.setHours(h);
            this._date = d.getDate();
            this.fireIntermediateChange(this._date);
            this.redraw();
        }
    }

    private void rollAMPM(int count) {
        JaretDate d = new JaretDate(this._date);
        if (count < 0 && d.getHours() >= 12) {
            d.setHours(d.getHours() - 12);
            this._date = d.getDate();
            this.fireIntermediateChange(this._date);
            this.redraw();
        } else if (count > 0 && d.getHours() < 12) {
            d.setHours(d.getHours() + 12);
            this._date = d.getDate();
            this.fireIntermediateChange(this._date);
            this.redraw();
        }
    }

    public void mouseDown(MouseEvent event) {
        boolean success = this.setTimeByLocation(event.x, event.y);
        if (success) {
            this.fireIntermediateChange(this.getDate());
        }
    }

    public void mouseUp(MouseEvent event) {
    }

    public synchronized void addDateChooserListener(IDateChooserListener listener) {
        if (this._listenerList == null) {
            this._listenerList = new Vector<IDateChooserListener>();
        }
        this._listenerList.add(listener);
    }

    public synchronized void remDateChooserListener(IDateChooserListener listener) {
        if (this._listenerList == null) {
            return;
        }
        this._listenerList.remove(listener);
    }

    protected void fireDateChosen(Date date) {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.dateChosen(date);
            }
        }
    }

    protected void fireIntermediateChange(Date date) {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.dateIntermediateChange(date);
            }
        }
    }

    protected void fireChoosingCanceled() {
        if (this._listenerList != null) {
            for (IDateChooserListener listener : this._listenerList) {
                listener.choosingCanceled();
            }
        }
    }

    class TimeGrid
    extends Canvas {
        protected Point _sizeCache;

        public TimeGrid(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    TimeGrid.this.onPaint(event);
                }
            });
        }

        public Point computeSize(int arg0, int arg1, boolean arg2) {
            if (this._sizeCache == null) {
                GC gc = new GC((Drawable)this);
                Point extent = gc.stringExtent(">=12");
                gc.dispose();
                this._sizeCache = new Point(extent.x * 3, extent.y * 12);
            }
            return this._sizeCache;
        }

        public void updateInternals() {
            TimeChooserPanel.this._columnWidth = this.getClientArea().width / 3;
            TimeChooserPanel.this._rowHeight = this.getClientArea().height / 12;
        }

        private void onPaint(PaintEvent event) {
            this.updateInternals();
            GC gc = event.gc;
            this.drawMarks(gc);
            for (int i = 0; i < 12; ++i) {
                int y = i * TimeChooserPanel.this._rowHeight;
                this.drawAMPM(gc, y, i);
                this.drawHour(gc, y, i);
                this.drawMinute(gc, y, i);
            }
        }

        private void drawMarks(GC gc) {
            Color bg = gc.getBackground();
            gc.setBackground(MARKERCOLOR);
            JaretDate date = new JaretDate(TimeChooserPanel.this._date);
            int y = date.getHours() < 12 ? 0 : TimeChooserPanel.this._rowHeight;
            Rectangle mark = new Rectangle(0, y, TimeChooserPanel.this._columnWidth, TimeChooserPanel.this._rowHeight);
            gc.fillRectangle(mark);
            int hour = date.getHours();
            y = (hour -= hour >= 12 ? 12 : 0) * TimeChooserPanel.this._rowHeight;
            mark = new Rectangle(TimeChooserPanel.this._columnWidth, y, TimeChooserPanel.this._columnWidth, TimeChooserPanel.this._rowHeight);
            gc.fillRectangle(mark);
            y = date.getMinutes() * this.getClientArea().height / 60;
            mark = new Rectangle(2 * TimeChooserPanel.this._columnWidth, y, 2 * TimeChooserPanel.this._columnWidth, TimeChooserPanel.this._rowHeight);
            gc.fillRectangle(mark);
            gc.setBackground(bg);
        }

        private void drawAMPM(GC gc, int y, int i) {
            if (i < 2) {
                int x = 0;
                String hour = i == 0 ? "<12" : ">=12";
                SwtGraphicsHelper.drawStringRightAlignedVTop((GC)gc, (String)hour, (int)(x + TimeChooserPanel.this._columnWidth), (int)y);
            }
        }

        private void drawMinute(GC gc, int y, int i) {
            int x = 2 * TimeChooserPanel.this._columnWidth;
            String minute = i * 5 + "";
            SwtGraphicsHelper.drawStringRightAlignedVTop((GC)gc, (String)minute, (int)(x + TimeChooserPanel.this._columnWidth), (int)y);
        }

        private void drawHour(GC gc, int y, int i) {
            JaretDate date = new JaretDate(TimeChooserPanel.this._date);
            int x = TimeChooserPanel.this._columnWidth;
            String hour = date.getHours() < 12 ? i + "" : i + 12 + "";
            SwtGraphicsHelper.drawStringRightAlignedVTop((GC)gc, (String)hour, (int)(x + TimeChooserPanel.this._columnWidth), (int)y);
        }
    }
}

