/*
 * Copyright (c) 2018, 2020, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package sun.security.util;

import java.util.List;
import java.util.function.BiFunction;
import java.security.*;
import jdk.internal.util.Preconditions;


/**
 * This class holds the various utility methods for array range checks.
 */

public final class ArrayUtil {

    private static final BiFunction<String, List<Number>,
            ArrayIndexOutOfBoundsException> AIOOBE_SUPPLIER =
            Preconditions.outOfBoundsExceptionFormatter
            (ArrayIndexOutOfBoundsException::new);

    public static void blockSizeCheck(int len, int blockSize) {
        if ((len % blockSize) != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
    }

    public static void nullAndBoundsCheck(byte[] array, int offset, int len) {
        // NPE is thrown when array is null
        Preconditions.checkFromIndexSize(offset, len, array.length, AIOOBE_SUPPLIER);
    }

    private static void swap(byte[] arr, int i, int j) {
        byte tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void reverse(byte [] arr) {
        int i = 0;
        int j = arr.length - 1;

        while (i < j) {
            swap(arr, i, j);
            i++;
            j--;
        }
    }
}
